/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.student.service.impl;

import com.baijia.tianxiao.biz.student.dto.GuardianDto;
import com.baijia.tianxiao.biz.student.service.OrgStudentGuardianRelevanceService;
import com.baijia.tianxiao.dal.org.dao.OrgStudentGuardianRelevanceDao;
import com.baijia.tianxiao.dal.org.po.OrgStudentGuardianRelevance;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.util.exception.BussinessPreconditions;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgStudentGuardianRelevanceServiceImpl
implements OrgStudentGuardianRelevanceService {
    private static final Logger log = LoggerFactory.getLogger(OrgStudentGuardianRelevanceServiceImpl.class);
    @Autowired
    private OrgStudentGuardianRelevanceDao orgStudentGuardianRelevanceDao;
    @Autowired
    private FansService fansService;
    @Autowired
    private FansDao fansDao;
    private static final String DEFAULT_AVATAR = "https://imgs.genshuixue.com/25278959_twko2nm5.jpeg";

    @Override
    public List<GuardianDto> getGuardiansByStudentId(Long orgId, Long studentId) {
        Collection guardians = this.orgStudentGuardianRelevanceDao.listByStudentId(orgId, studentId);
        Map fansMap = this.fansDao.mapKeyOpenIdValueFans(guardians.stream().filter(orgStudentGuardianRelevance -> StringUtils.isNotBlank((CharSequence)orgStudentGuardianRelevance.getOpenId())).map(orgStudentGuardianRelevance -> orgStudentGuardianRelevance.getOpenId()).collect(Collectors.toList()));
        ArrayList result = Lists.newArrayList();
        for (OrgStudentGuardianRelevance guardian : guardians) {
            GuardianDto dto = new GuardianDto();
            dto.setGuardianId(guardian.getId());
            dto.setStudentId(guardian.getStudentId());
            dto.setMobile(MaskUtil.maskMobile((String)guardian.getMobile()));
            Fans fans = (Fans)fansMap.get(guardian.getOpenId());
            dto.setAvatar(null == fans ? DEFAULT_AVATAR : (String)StringUtils.defaultIfBlank((CharSequence)fans.getHeadImgUrlGsx(), (CharSequence)fans.getHeadImgUrl()));
            dto.setName(null == fans ? dto.getMobile() : fans.getShowName());
            result.add(dto);
        }
        return result;
    }

    @Override
    public OrgStudentGuardianRelevance delGuardianById(Long orgId, Long guardianId) {
        OrgStudentGuardianRelevance relevance = (OrgStudentGuardianRelevance)this.orgStudentGuardianRelevanceDao.getById((Serializable)guardianId, new String[0]);
        BussinessPreconditions.checkArgument((null != relevance && relevance.getOrgId().longValue() == orgId.longValue() ? 1 : 0) != 0, (Object)"can not find OrgStudentGuardianRelevance");
        this.orgStudentGuardianRelevanceDao.delById((Serializable)guardianId);
        return relevance;
    }
}

