/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.student.customStudentField.service.impl;

import com.baijia.tianxiao.biz.student.customStudentField.service.BizCustomFieldService;
import com.baijia.tianxiao.biz.student.dto.DefaultSetInfoCallback;
import com.baijia.tianxiao.biz.student.dto.SetInfoCallback;
import com.baijia.tianxiao.biz.student.dto.response.OrgStudentInfo;
import com.baijia.tianxiao.biz.student.dto.response.OrgStudentResponse;
import com.baijia.tianxiao.biz.student.dto.response.SimpleFieldDto;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.constant.ChargeType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceAccountDao;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.dal.roster.constant.PauseStatus;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.dao.TXCustomOptionDao;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.dal.roster.po.TXCustomOption;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.wechat.po.UnifiedWechatAccount;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.api.StudentKexiaoStatisticsApiService;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStudentStat;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.consult.service.ConsultSourceService;
import com.baijia.tianxiao.sal.organization.constant.CascadeSearchSource;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.dto.AccountSelectionDto;
import com.baijia.tianxiao.sal.organization.org.dto.TxCascadeCredentialSelectionDto;
import com.baijia.tianxiao.sal.organization.org.dto.addressbook.TXAddressBookDto;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.dto.request.StudentBalanceRequestDto;
import com.baijia.tianxiao.sal.signup.dto.response.StudentBalanceResponseDto;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldValueService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFieldValues.OrgUserBaseInfo;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldValueRequest;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldValueResponse;
import com.baijia.tianxiao.sal.student.dto.customFields.FieldOption;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.sal.student.enums.CustomFieldType;
import com.baijia.tianxiao.sal.student.enums.RequireStatus;
import com.baijia.tianxiao.sal.student.enums.SpecialFieldEnum;
import com.baijia.tianxiao.sal.student.enums.SystemFields;
import com.baijia.tianxiao.sal.student.enums.WeixinBindStatusEnum;
import com.baijia.tianxiao.sal.student.pc.StudentUserService;
import com.baijia.tianxiao.sal.wechat.api.UnifiedWechatAccountService;
import com.baijia.tianxiao.sal.wechat.util.EmojiUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizCustomFieldServiceImpl
implements BizCustomFieldService {
    private static final Logger log = LoggerFactory.getLogger(BizCustomFieldServiceImpl.class);
    @Autowired
    private OrgStudentService orgStudentService;
    @Autowired
    private CustomFieldValueService customFieldValueService;
    @Autowired
    private CustomFieldValueDao customFieldValueDao;
    @Autowired
    private TxCascadeCredentialService orgTxCascadeCredentialService;
    @Autowired
    private ConsultSourceService consultSourceService;
    @Autowired
    private TXSaleClueRuleService saleClueRuleService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCommonRuleService txCommonRuleService;
    @Autowired
    private UnifiedWechatAccountService unifiedWechatAccountService;
    @Autowired
    private StudentUserService studentUserService;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private TxStudentFinanceAccountService txStudentFinanceAccountService;
    @Autowired
    private StudentKexiaoStatisticsApiService studentKexiaoStatisticsApiService;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private TxStudentFinanceAccountDao studentFinanceAccountDao;
    @Autowired
    private TxAccountPermissionService permissionService;
    @Autowired
    private TXCustomOptionDao optionDao;
    public static String TIP_STR = "\u5b66\u5458\u90e8\u5206\u73ed\u7ea7\u9700\u8865\u5145\u4fe1\u606f\u540e\u624d\u53ef\u6838\u7b97\u8bfe\u6d88";
    public static String TIP_INFO_URL = "http://bbs.tianxiao100.com/forum.php?mod=viewthread&tid=95";

    @Override
    public Object listCustomFields(Long orgId, Integer customType) {
        return null;
    }

    @Override
    public OrgStudentResponse getOrgStudentInfoForKeXiao(Long studentId, Integer cascadeId, Long orgId, Integer applicationType) {
        OrgStudentResponse orgStudentInfoForKeXiao = this.getOrgStudentInfoForKeXiao(studentId, cascadeId, orgId, applicationType, false);
        this.fillStatistics(studentId, orgId, orgStudentInfoForKeXiao);
        return orgStudentInfoForKeXiao;
    }

    @Override
    @Transactional
    public OrgStudentResponse getOrgStudentInfo(Long studentId, Integer cascadeId, Long orgId, Integer applicationType) {
        OrgStudentResponse orgStudentInfoForKeXiao = this.getOrgStudentInfoForKeXiao(studentId, cascadeId, orgId, applicationType, true);
        if (studentId != -1L) {
            StudentBalanceRequestDto request = new StudentBalanceRequestDto();
            request.setOrgId(orgId);
            request.setStudentId(studentId);
            request.setNeedBanlacneChangeRecords(false);
            boolean hasPermission = this.permissionService.checkPermission(orgId, cascadeId, DeviceType.APP, Long.valueOf(TXPermissionConst.STUDENT_ACCOUNT.getPCode()));
            if (hasPermission) {
                StudentBalanceResponseDto findStudentBalanceInfo = this.findStudentBalanceInfo(request);
                log.info("find findStudentBalanceInfo is:{} ", (Object)findStudentBalanceInfo);
                if (findStudentBalanceInfo != null) {
                    orgStudentInfoForKeXiao.setBalance(findStudentBalanceInfo.getBalance());
                }
            } else {
                orgStudentInfoForKeXiao.setAllowViewBalance(1);
            }
        }
        return orgStudentInfoForKeXiao;
    }

    @Override
    public StudentBalanceResponseDto findStudentBalanceInfo(StudentBalanceRequestDto request) {
        log.info("StudentBalanceRequestDto is :{} ", (Object)request);
        Long orgId = request.getOrgId();
        Long studentId = request.getStudentId();
        List studentByIds = this.orgStudentDao.getStudentByIds(orgId, Arrays.asList(studentId), new String[0]);
        OrgStudent orgStudent = null;
        if (!GenericsUtils.notNullAndEmpty((Object)studentByIds)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NOT_FOUND, String.format("can not find student with id :%s ", studentId));
        }
        orgStudent = (OrgStudent)studentByIds.get(0);
        String mobile = orgStudent.getMobile();
        boolean isShow = this.txCascadeCredentialService.isShowMobile(orgId, request.getCascadeId());
        if (!isShow) {
            mobile = MaskUtil.maskMobile((String)mobile);
        }
        StudentBalanceResponseDto studentBalanceResponseDto = this.txStudentFinanceAccountService.findStudentBalanceResponseDto(request);
        studentBalanceResponseDto.setStudentId(studentId);
        studentBalanceResponseDto.setMobile(mobile);
        studentBalanceResponseDto.setStudentName(orgStudent.getNotEmptyName());
        return studentBalanceResponseDto;
    }

    public OrgStudentResponse getOrgStudentInfoForKeXiao(Long studentId, Integer cascadeId, Long orgId, Integer applicationType, boolean needSetClassHour) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        if (studentId == -1L) {
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId);
        } else {
            StudentCommenRequestDto studentCommenRequestDto = this.buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            studentCommenRequestDto.setNeedSetClassHour(needSetClassHour);
            log.info("studentCommenRequestDto param:{}", (Object)studentCommenRequestDto);
            StudentInfoDto studentInfoDto = this.orgStudentService.getStudentInfo(studentCommenRequestDto, orgId, cascadeId);
            log.info("studentInfoDto param:{}", (Object)studentInfoDto);
            orgStudentInfo = this.buildOrgStudentInfo(studentInfoDto);
            log.info("orgStudentInfo param:{}, city parm:{}", (Object)orgStudentInfo.getProvince());
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId);
        }
        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>(){

            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }
        });
        this.addSpecialFieldForStudent(orgStudentInfo, cascadeId, orgId.intValue(), studentId);
        OrgStudentResponse reponse = this.buildOrgStudentResponse(orgStudentInfo);
        TXCascadeAccount loginer = null;
        if (cascadeId != null && cascadeId > 0) {
            loginer = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
        }
        if (loginer != null && (CampusAccountType.getTypeByCode((int)loginer.getAccountType()) == CampusAccountType.DIRECTOR || CampusAccountType.getTypeByCode((int)loginer.getAccountType()) == CampusAccountType.STAFF)) {
            TXCommonRule txCommonRule = this.txCommonRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
            if (txCommonRule.getStudentMobileRule() == 1) {
                reponse.setAllowToSms(Flag.FALSE.getInt());
            }
        } else {
            reponse.setAllowToSms(Flag.TRUE.getInt());
        }
        return reponse;
    }

    private void addSpecialFieldForStudent(OrgStudentInfo orgStudentInfo, Integer cascadeId, Integer orgId, Long studentId) {
        Long cascadeLong = 0L;
        if (cascadeId != null) {
            cascadeLong = cascadeId.longValue();
        }
        ArrayList<FieldOption> optionList = new ArrayList<FieldOption>();
        List list = this.orgTxCascadeCredentialService.getTxCascadeCredentialList(orgId, Long.valueOf(0L), CascadeSearchSource.STUDENT_FILTER, new AccountSelectionDto());
        log.info("find all list : {} ", (Object)list);
        Integer addCascadeId = orgStudentInfo.getCascadeId();
        log.info("addCascadeSingle is :{} ", (Object)addCascadeId);
        FieldOption cascadeSingle = null;
        cascadeSingle = new FieldOption();
        boolean canEdit = false;
        Integer cascadeForShow = -1;
        if (studentId == -1L) {
            canEdit = true;
            cascadeForShow = cascadeLong.intValue();
        } else {
            cascadeForShow = addCascadeId;
        }
        log.info("fieldOptins is :{} ", (Object)cascadeSingle);
        SpecialFieldEnum sfe = SpecialFieldEnum.STU_ADD_CASCADE_ID;
        CustomFieldValueResponse response = new CustomFieldValueResponse(sfe.getKey(), sfe.getLabel(), sfe.getSectionId(), (Object)cascadeSingle, Integer.valueOf(RequireStatus.NOT_REQUIRE.getStatus()), CustomFieldType.SINGLE_CHOICE.getType());
        if (GenericsUtils.notNullAndEmpty((Object)list)) {
            for (TxCascadeCredentialSelectionDto tcsd : list) {
                String name = tcsd.getName();
                Integer cascadeId2 = tcsd.getCascadeId();
                FieldOption fo = new FieldOption(Long.valueOf(cascadeId2.longValue()), name);
                optionList.add(fo);
                log.info("TxCascadeCredentialSelectionDto is :{} and is Match:{} ", (Object)tcsd, (Object)(tcsd.getCascadeId() == addCascadeId ? 1 : 0));
                if (!cascadeId2.equals(cascadeForShow)) continue;
                log.info("find a match tcsd:{} ", (Object)tcsd);
                cascadeSingle.setId(Long.valueOf(cascadeId2.longValue()));
                cascadeSingle.setValue(tcsd.getName());
            }
            if (canEdit) {
                response.setOptions(optionList);
            }
        }
        log.info("response is :{} ", (Object)response);
        orgStudentInfo.getFields().add(response);
        ArrayList<FieldOption> optionListOfSource = new ArrayList<FieldOption>();
        sfe = SpecialFieldEnum.STU_SOURCE;
        Integer source = orgStudentInfo.getSource();
        FieldOption sectionOption = null;
        if (source != null) {
            Long stuSourceId = Long.parseLong(source + "");
            log.info("source is :{} ", (Object)stuSourceId);
            sectionOption = new FieldOption(stuSourceId, this.consultSourceService.getConsultSourceStr(stuSourceId));
            log.info("FieldOptin is : {} ", (Object)sectionOption);
        }
        CustomFieldValueResponse reponseOfSource = new CustomFieldValueResponse(sfe.getKey(), sfe.getLabel(), sfe.getSectionId(), sectionOption, Integer.valueOf(RequireStatus.NOT_REQUIRE.getStatus()), CustomFieldType.SINGLE_CHOICE.getType());
        List consultCustomSourceDtos = this.consultSourceService.selection(Long.valueOf(orgId.longValue()), this.saleClueRuleService.getByOrgId(Integer.valueOf(orgId)), null, Integer.valueOf(PauseStatus.NOT_PAUSE.getStatus()));
        if (GenericsUtils.notNullAndEmpty((Object)consultCustomSourceDtos)) {
            for (ConsultCustomSourceDto consultCustomSourceDto : consultCustomSourceDtos) {
                FieldOption option = new FieldOption(consultCustomSourceDto.getId(), consultCustomSourceDto.getLabel());
                optionListOfSource.add(option);
            }
        }
        reponseOfSource.setOptions(optionListOfSource);
        orgStudentInfo.getFields().add(reponseOfSource);
    }

    @Override
    public OrgStudentResponse getOrgStudentInfoWithCallback(Long studentId, Integer cascadeId, Long orgId, Integer applicationType, boolean systemOnly, SetInfoCallback<StudentInfoDto> callback) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        if (studentId == -1L) {
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId);
        } else {
            StudentCommenRequestDto studentCommenRequestDto = this.buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            studentCommenRequestDto.setNeedSetClassHour(false);
            log.info("studentCommenRequestDto param:{}", (Object)studentCommenRequestDto);
            StudentInfoDto studentInfoDto = new StudentInfoDto();
            this.orgStudentService.setStudentBaseInfo(studentId, orgId, cascadeId, studentInfoDto);
            if (callback == null) {
                callback = new DefaultSetInfoCallback(this.orgStudentService);
            }
            callback.init(new Object[0]);
            HashMap params = Maps.newHashMap();
            params.put("orgId", orgId);
            params.put("cascadeId", cascadeId);
            params.put("applicationType", applicationType);
            params.put("userId", studentInfoDto.getUserId());
            params.put("studentId", studentId);
            params.put("isShowMobile", studentInfoDto.getIsShowMobile());
            callback.setInfos(studentInfoDto, (Map<String, Object>)params);
            orgStudentInfo = this.buildOrgStudentInfo(studentInfoDto);
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId, systemOnly);
        }
        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>(){

            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }
        });
        this.addSpecialFieldForStudent(orgStudentInfo, cascadeId, orgId.intValue(), studentId);
        OrgStudentResponse reponse = this.buildOrgStudentResponse(orgStudentInfo);
        return reponse;
    }

    @Override
    public void fillStatistics(Long studentId, Long orgId, OrgStudentResponse reponse) {
        TxStudentFinanceAccount account;
        if (studentId == -1L) {
            return;
        }
        StudentBalanceRequestDto request = new StudentBalanceRequestDto();
        request.setOrgId(orgId);
        request.setStudentId(studentId);
        request.setNeedBanlacneChangeRecords(false);
        StudentBalanceResponseDto findStudentBalanceResponseDto = this.txStudentFinanceAccountService.findStudentBalanceResponseDto(request);
        if (findStudentBalanceResponseDto != null) {
            double balance = findStudentBalanceResponseDto.getBalance();
            reponse.setBalance(balance);
        } else {
            reponse.setBalance(0.0);
        }
        List<OrgStudentResponse> studentRequest = Arrays.asList(reponse);
        this.studentKexiaoStatisticsApiService.fillStudentKeXiaoStatistics(orgId, studentRequest, Integer.valueOf(1));
        OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[]{"id", "userId"});
        Map statMap = this.kexiaoApiService.queryUserKexiaoStat(orgId, Arrays.asList(student.getUserId()));
        KexiaoStudentStat stat = (KexiaoStudentStat)statMap.get(student.getUserId());
        if (!reponse.isKexiaoFillOver()) {
            reponse.setTipInfo(TIP_STR);
            reponse.setTipInfoUrl(TIP_INFO_URL);
        }
        String remainTuition = this.kexiaoApiService.getLeftAmountStr((KexiaoStatistics)stat);
        long balance = 0L;
        if (stat != null) {
            log.info(" reponse :{} ,contractAmount={},refundAmount={},transferAmount={}", new Object[]{reponse, stat.getContractAmount(), stat.getRefundAmount(), stat.getTransferAmount()});
            balance += stat.getContractAmount() - stat.getRefundAmount() - stat.getTransferAmount();
        }
        if ((account = this.studentFinanceAccountDao.getFinanceAccount(orgId, studentId)) != null) {
            balance += account.getBalance().longValue();
        }
        double payMoney = Double.parseDouble(NumberUtil.convertFenToYuan((long)balance));
        reponse.setPayMoney(NumberUtil.get2Double((double)payMoney));
        reponse.setRemainTuition(remainTuition);
    }

    @Override
    public OrgStudentResponse getOrgStudentBase1Info(Long studentId, Integer cascadeId, Long orgId, Integer applicationType) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        if (studentId == -1L) {
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId);
        } else {
            StudentCommenRequestDto studentCommenRequestDto = this.buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            log.info("studentCommenRequestDto param:{}", (Object)studentCommenRequestDto);
            StudentInfoDto studentInfoDto = new StudentInfoDto();
            this.orgStudentService.setStudentBaseInfo(studentId, orgId, cascadeId, studentInfoDto);
            this.orgStudentService.setStudentComment(studentInfoDto.getUserId(), orgId, studentInfoDto.getIsShowMobile(), studentInfoDto);
            this.orgStudentService.setFansInfo(studentId, orgId, studentInfoDto);
            this.orgStudentService.setStudentTags(studentInfoDto.getUserId(), orgId, studentInfoDto);
            orgStudentInfo = this.buildOrgStudentInfo(studentInfoDto);
            log.info("orgStudentInfo param:{}, city parm:{}", (Object)orgStudentInfo.getProvince());
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId);
        }
        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>(){

            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }
        });
        this.addSpecialFieldForStudent(orgStudentInfo, cascadeId, orgId.intValue(), studentId);
        OrgStudentResponse reponse = this.buildOrgStudentResponse(orgStudentInfo);
        return reponse;
    }

    private OrgStudentResponse buildOrgStudentResponse(OrgStudentInfo orgStudentInfo) {
        OrgStudentResponse reponse = new OrgStudentResponse();
        BeanUtils.copyProperties((Object)((Object)orgStudentInfo), (Object)((Object)reponse));
        if (StringUtils.isNotBlank((CharSequence)orgStudentInfo.getWeixin())) {
            reponse.setStuCenterBindStatus(WeixinBindStatusEnum.BIND.status);
        } else {
            reponse.setStuCenterBindStatus(WeixinBindStatusEnum.UN_BIND.getStatus());
        }
        return reponse;
    }

    private StudentCommenRequestDto buidStudentCommenRequestDto(Long studentId, Integer cascadeId, Long orgId, Integer applicationType) {
        StudentCommenRequestDto dto = new StudentCommenRequestDto();
        dto.setStudentId(studentId);
        dto.setCasCadeId(cascadeId);
        dto.setOrgId(orgId);
        dto.setIsStudent(Boolean.valueOf(true));
        dto.setApplicationType(applicationType);
        return dto;
    }

    private OrgStudentInfo buildOrgStudentInfo(StudentInfoDto studentInfoDto) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        BeanUtils.copyProperties((Object)studentInfoDto, (Object)((Object)orgStudentInfo));
        orgStudentInfo.setSex(studentInfoDto.getGender());
        orgStudentInfo.setCascadeId(studentInfoDto.getAddCascadeId());
        TXAddressBookDto txAddressBookDto = studentInfoDto.getAddressDetail();
        String addressDetail = JacksonUtil.obj2Str((Object)txAddressBookDto);
        orgStudentInfo.setAddressDetail(addressDetail);
        return orgStudentInfo;
    }

    @Override
    @Transactional
    public Long saveOrgStudentInfo(OrgStudentInfo orgStudentInfo, Long orgId, Integer cascadeId) {
        Long studentId = orgStudentInfo.getStudentId();
        orgStudentInfo.setIsStudent(true);
        orgStudentInfo.setCascadeId(cascadeId);
        List fieldValueIds = this.customFieldValueService.saveOrUpdateCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgStudentInfo.getStudentId(), orgId);
        StudentInfoDto studentInfoDto = this.buildStudentInfoDto(orgStudentInfo);
        this.saveSpecialFieldFoeStudent(orgStudentInfo.getFields(), studentInfoDto);
        List tagList = studentInfoDto.getTagsResp();
        if (studentId != null && studentId > 0L) {
            List<CommentInfoDto> commentDtos = orgStudentInfo.getCommentsResp();
            this.orgStudentService.modStudent(studentInfoDto, commentDtos, tagList, orgId);
        } else {
            List customFieldValues = this.customFieldValueDao.getByIds((Collection)fieldValueIds, new String[0]);
            OrgStudentAddresponseDto response = this.orgStudentService.addStudent(studentInfoDto, null, tagList, orgId);
            log.info("will addUnifiedWechatBindConsulter for orgStudentInfo :{} ", (Object)orgStudentInfo);
            this.addUnifiedWechatBindConsulter(orgStudentInfo, orgId);
            studentId = response.getStudentId();
            if (GenericsUtils.notNullAndEmpty((Object)fieldValueIds)) {
                for (CustomFieldValue fieldValue : customFieldValues) {
                    fieldValue.setStudentId(studentId);
                    this.customFieldValueDao.update((Object)fieldValue, new String[]{"studentId"});
                }
            }
        }
        List allCustomFieldValues = this.customFieldValueDao.searchValuesByConfig(orgId, true, studentId, null);
        String customSearchValue = this.studentUserService.buildCustomSearchValue(allCustomFieldValues, false, false, null, null, null);
        OrgStudent student = new OrgStudent();
        student.setId(studentId);
        student.setCustomSearchValue(customSearchValue);
        this.orgStudentDao.update((Object)student, Boolean.valueOf(true), new String[]{"customSearchValue"});
        return studentId;
    }

    @Override
    @Transactional
    public Long saveOrgStudentInfo2(OrgStudentInfo orgStudentInfo, Long orgId, Integer cascadeId) {
        Long studentId = orgStudentInfo.getStudentId();
        orgStudentInfo.setIsStudent(true);
        orgStudentInfo.setCascadeId(cascadeId);
        List fieldValueIds = this.customFieldValueService.saveOrUpdateCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgStudentInfo.getStudentId(), orgId);
        StudentInfoDto studentInfoDto = this.buildStudentInfoDto(orgStudentInfo);
        TXAddressBookDto txAddressBookDto = studentInfoDto.getAddressDetail();
        if (!GenericsUtils.isNullOrEmpty((Object)txAddressBookDto) && txAddressBookDto.getUnit() != null && EmojiUtil.containsEmoji((String)txAddressBookDto.getUnit())) {
            throw new ParameterException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5730\u5740\u4e0d\u80fd\u542b\u6709\u8868\u60c5\u7b26\u53f7");
        }
        this.saveSpecialFieldFoeStudent(orgStudentInfo.getFields(), studentInfoDto);
        List tagList = studentInfoDto.getTagsResp();
        if (studentId != null && studentId > 0L) {
            List<CommentInfoDto> commentDtos = orgStudentInfo.getCommentsResp();
            this.orgStudentService.modStudent(studentInfoDto, commentDtos, tagList, orgId);
        } else {
            List customFieldValues = this.customFieldValueDao.getByIds((Collection)fieldValueIds, new String[0]);
            OrgStudentAddresponseDto response = this.orgStudentService.addStudent(studentInfoDto, null, tagList, orgId);
            log.info("will addUnifiedWechatBindConsulter for orgStudentInfo :{} ", (Object)orgStudentInfo);
            this.addUnifiedWechatBindConsulter(orgStudentInfo, orgId);
            studentId = response.getStudentId();
            if (GenericsUtils.notNullAndEmpty((Object)fieldValueIds)) {
                for (CustomFieldValue fieldValue : customFieldValues) {
                    fieldValue.setStudentId(studentId);
                    this.customFieldValueDao.update((Object)fieldValue, new String[]{"studentId"});
                }
            }
        }
        List allCustomFieldValues = this.customFieldValueDao.searchValuesByConfig(orgId, true, studentId, null);
        String customSearchValue = this.studentUserService.buildCustomSearchValue(allCustomFieldValues, false, false, null, null, null);
        OrgStudent student = new OrgStudent();
        student.setId(studentId);
        student.setCustomSearchValue(customSearchValue);
        this.orgStudentDao.update((Object)student, Boolean.valueOf(true), new String[]{"customSearchValue"});
        return studentId;
    }

    private void addUnifiedWechatBindConsulter(OrgStudentInfo orgStudentInfo, Long orgId) {
        String mobile = orgStudentInfo.getMobile();
        if (GenericsUtils.isNullOrEmpty((Object)mobile)) {
            return;
        }
        UnifiedWechatAccount findMasterAccountWithAnyCampusOrgId = this.unifiedWechatAccountService.findMasterAccountWithAnyCampusOrgId(Integer.valueOf(orgId.intValue()), Boolean.valueOf(true));
        log.info("orgId :{} findMasterAccount is :{} ", (Object)orgId, (Object)findMasterAccountWithAnyCampusOrgId);
        if (findMasterAccountWithAnyCampusOrgId != null) {
            String weixin = orgStudentInfo.getWeixin();
            if (GenericsUtils.isNullOrEmpty((Object)weixin)) {
                weixin = this.unifiedWechatAccountService.findWeixinFromCampusOrgWithMobile(findMasterAccountWithAnyCampusOrgId.getOrgId(), mobile, true);
            }
            if (GenericsUtils.notNullAndEmpty((Object)mobile)) {
                log.info("find weixin for orgId :{} with mobile:{} ", (Object)orgId, (Object)mobile);
                if (GenericsUtils.notNullAndEmpty((Object)weixin)) {
                    List andUpdateOrgStudentByMobile = this.orgStudentService.getAndUpdateOrgStudentByMobile(orgId, mobile, "", weixin);
                    log.info("auth bind weixin:{} with orgStudetn:{} ", (Object)weixin, (Object)andUpdateOrgStudentByMobile);
                }
            }
        }
    }

    private void saveSpecialFieldFoeStudent(List<CustomFieldDto> fields, StudentInfoDto studentInfoDto) {
        if (GenericsUtils.notNullAndEmpty(fields)) {
            for (CustomFieldDto cf : fields) {
                CustomFieldValueRequest request = (CustomFieldValueRequest)cf;
                SpecialFieldEnum consultFieldEnum = SpecialFieldEnum.getSpecialFieldEnum((String)request.getKey());
                if (consultFieldEnum == null) continue;
                this.setSpecialFieldValueByKey(consultFieldEnum, request.getValues(), studentInfoDto);
            }
        }
    }

    private void setSpecialFieldValueByKey(SpecialFieldEnum consultFieldEnum, Map<String, Object> values, StudentInfoDto studentInfoDto) {
        log.info("[SutdentCustomField] Map<String, Object> values param:{}", values);
        switch (consultFieldEnum) {
            case STU_ADD_CASCADE_ID: {
                if (values == null || values.get("id") == null) break;
                studentInfoDto.setAddCascadeId((Integer)values.get("id"));
                break;
            }
            case STU_SOURCE: {
                if (values == null || values.get("id") == null) break;
                studentInfoDto.setSource((Integer)values.get("id"));
                break;
            }
            default: {
                return;
            }
        }
    }

    private StudentInfoDto buildStudentInfoDto(OrgStudentInfo orgStudentInfo) {
        StudentInfoDto studentInfoDto = new StudentInfoDto();
        BeanUtils.copyProperties((Object)((Object)orgStudentInfo), (Object)studentInfoDto);
        studentInfoDto.setGender(orgStudentInfo.getSex());
        String addressDetailstr = orgStudentInfo.getAddressDetail();
        try {
            if (!GenericsUtils.isNullOrEmpty((Object)addressDetailstr)) {
                TXAddressBookDto txAddressBookDto = (TXAddressBookDto)JacksonUtil.str2Obj((String)addressDetailstr, TXAddressBookDto.class);
                studentInfoDto.setAddressDetail(txAddressBookDto);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return studentInfoDto;
    }

    @Override
    @Transactional
    public void updateOrgStudentInfo(OrgStudentInfo orgStudentInfo, Long orgId) {
        this.customFieldValueService.saveOrUpdateCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgStudentInfo.getStudentId(), orgId);
        StudentInfoDto studentInfoDto = this.buildStudentInfoDto(orgStudentInfo);
        List tagList = orgStudentInfo.getTagsResp();
        List<CommentInfoDto> commentDtos = orgStudentInfo.getCommentsResp();
        this.orgStudentService.modStudent(studentInfoDto, commentDtos, tagList, orgId);
    }

    public Map<Long, Float> findTotalBuyCount(List<OrgSignupInfo> sinupInfos) {
        HashSet signupPurchaseIds = Sets.newHashSet();
        List fieldList = GenericsUtils.toFieldList(sinupInfos, (String)"signupPurchaseId");
        signupPurchaseIds.addAll(fieldList);
        List coursePurchases = this.orgSignupCourseDao.loadByPurchaseIds((Collection)signupPurchaseIds, new String[]{"signupPurchaseId", "orgCourseId"});
        HashSet courseIds = Sets.newHashSet();
        List orgCourses = GenericsUtils.toFieldList((Collection)coursePurchases, (String)"orgCourseId");
        courseIds.addAll(orgCourses);
        List courseList = this.orgCourseDao.getByIds((Collection)courseIds, new String[]{"id", "name", "chargeType", "chargeUnit"});
        Map courseMap = GenericsUtils.toFieldMap((Collection)courseList, (String[])new String[]{"id"});
        HashMap totalCountMap = Maps.newHashMap();
        for (OrgSignupCourse orgSignupCourse : coursePurchases) {
            Long courseId = orgSignupCourse.getOrgCourseId();
            OrgCourse oc = (OrgCourse)courseMap.get(courseId);
            float buyCount = this.findBuyCount(oc, orgSignupCourse);
            totalCountMap.put(courseId, Float.valueOf(totalCountMap.get(courseId) == null ? 0.0f : ((Float)totalCountMap.get(courseId)).floatValue() + buyCount));
        }
        return totalCountMap;
    }

    private float findBuyCount(OrgCourse oc, OrgSignupCourse osc) {
        int chargeType = oc.getChargeType();
        int chargeUnit = oc.getChargeUnit();
        int count = osc.getCount();
        if (ChargeType.chargeByPeriods((int)chargeType, (int)chargeUnit)) {
            int times = count * oc.getFreq();
            return times;
        }
        if (ChargeType.chargeByClassHour((int)chargeType, (int)chargeUnit)) {
            float totalCount = BizCustomFieldServiceImpl.countClassHour(count, chargeUnit);
            return totalCount;
        }
        if (ChargeType.chargeByTimes((int)chargeType, (int)chargeUnit)) {
            return count;
        }
        return 0.0f;
    }

    private static float countClassHour(int count, int chargeUnit) {
        if (chargeUnit == ChargeUnit.BY_HALF_HOUR.getCode()) {
            BigDecimal b1 = new BigDecimal(Float.toString(count * 5));
            BigDecimal b2 = new BigDecimal(Float.toString(10.0f));
            return b1.divide(b2, 1, 4).floatValue();
        }
        if (chargeUnit == ChargeUnit.BY_MINUTE.getCode()) {
            BigDecimal b1 = new BigDecimal(Float.toString(count));
            BigDecimal b2 = new BigDecimal(Float.toString(60.0f));
            return b1.divide(b2, 1, 4).floatValue();
        }
        return count;
    }

    @Override
    public List<SimpleFieldDto> getDateList(Long orgId) {
        ArrayList<SimpleFieldDto> ret = new ArrayList<SimpleFieldDto>();
        List fieldsList = SystemFields.getFilterDateFields();
        for (SystemFields fields : fieldsList) {
            SimpleFieldDto dto = new SimpleFieldDto();
            dto.setLabel(fields.label);
            dto.setValue(fields.nameList);
            ret.add(dto);
        }
        return ret;
    }

    @Override
    public Map<Long, List<TXCustomOption>> getOptions(Collection<Long> customFieldIds) {
        HashMap<Long, List<TXCustomOption>> retMap = new HashMap<Long, List<TXCustomOption>>();
        List options = this.optionDao.getTXCustomOptionList(customFieldIds);
        for (TXCustomOption option : options) {
            if (retMap.get(option.getParentId()) == null) {
                ArrayList list = new ArrayList();
                retMap.put(option.getParentId(), list);
            }
            ((List)retMap.get(option.getParentId())).add(option);
        }
        return retMap;
    }
}

