/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.student.syn.service.impl;

import com.baijia.tianxiao.biz.student.syn.service.StudentKexiaoService;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.org.po.StudentLessonStatistics;
import com.baijia.tianxiao.dal.solr.query.CrmStudentQuery;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.redis.AbstractBaseRedisDao;
import com.baijia.tianxiao.sal.common.api.CourseApiService;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.kexiao.service.KexiaoChangeLogService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.ListUtil;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service
public class StudentKexiaoServiceImpl
extends AbstractBaseRedisDao
implements StudentKexiaoService {
    private static final Logger log = LoggerFactory.getLogger(StudentKexiaoServiceImpl.class);
    @Autowired
    private OrgClassLessonDao classLessonDao;
    @Autowired
    private OrgStudentLessonDao studentLessonDao;
    @Autowired
    private OrgCourseConsumeRuleDao courseConsumeRuleDao;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private OrgCourseDao courseDao;
    @Autowired
    private KexiaoChangeLogService changeLogService;
    @Autowired
    private CourseApiService courseApiService;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private CrmStudentQuery studentQuery;
    private ExecutorService threadPool = Executors.newFixedThreadPool(10);
    private static final Semaphore updateTimePerOneMinuteSemaphore = new Semaphore(1);
    private static final Semaphore updateTimePerFiveMinuteSemaphore = new Semaphore(1);

    private List<OrgStudentCourse> getStudentCourseListBySignUp() {
        return null;
    }

    @Override
    public void refreshKexiaoRule(int beforeMinutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -1 * beforeMinutes);
        List rules = this.courseConsumeRuleDao.queryConsumRuleListByUpdateTime(calendar.getTime());
        if (rules != null) {
            for (OrgCourseConsumeRule rule : rules) {
                Integer oldRule = this.getKexiaoRule(rule.getCourseId());
                if (!rule.getRuleValue().equals(oldRule)) {
                    this.threadPool.submit(new KexiaoRunnable(rule.getOrgId(), rule.getCourseId(), rule.getRuleValue()));
                }
                this.setKexiaoRule(rule.getCourseId(), rule.getRuleValue());
            }
        }
        log.info("[Kexiao] Refresh kexiao rule.");
    }

    @Override
    public void updateClassLessonStatusBySignUp(List<OrgLessonSign> lessonSigns) {
        if (lessonSigns != null && lessonSigns.size() < 1) {
            return;
        }
        List list = ListUtil.toKeyList(lessonSigns, (String)"courseId", OrgLessonSign.class);
        ArrayList<OrgLessonSign> unSignList = new ArrayList<OrgLessonSign>();
        ArrayList<OrgLessonSign> finishedList = new ArrayList<OrgLessonSign>();
        for (OrgLessonSign sign : lessonSigns) {
            Map ruleMap = this.courseApiService.getClassRule(Arrays.asList(sign.getCourseId()));
            OrgCourseConsumeRule rule = (OrgCourseConsumeRule)ruleMap.get(sign.getCourseId());
            if (rule == null || rule.getRuleValue() <= 0) continue;
            LessonStatus status = this.kexiaoApiService.getKexiaoStatus(sign, rule.getRuleValue().intValue());
            if (status == LessonStatus.FINISHED) {
                finishedList.add(sign);
                continue;
            }
            unSignList.add(sign);
        }
        if (unSignList.size() > 0) {
            this.studentLessonDao.batchUpdateKexiaoStatusBySign(unSignList, LessonStatus.UN_START.getStatus());
        }
        if (finishedList.size() > 0) {
            this.studentLessonDao.batchUpdateKexiaoStatusBySign(finishedList, LessonStatus.FINISHED.getStatus());
        }
    }

    private Map<Long, Long> getClassCourseIdMap(Collection<Long> clazzIds) {
        List classList = this.courseDao.getByIds(clazzIds, new String[]{"id", "parentId", "courseType"});
        HashMap<Long, Long> classCourseMap = new HashMap<Long, Long>();
        for (OrgCourse clazz : classList) {
            if (CourseTypeEnum.isOneToOne((Integer)clazz.getCourseType())) {
                classCourseMap.put(clazz.getId(), clazz.getParentId());
                continue;
            }
            classCourseMap.put(clazz.getId(), clazz.getId());
        }
        return classCourseMap;
    }

    public void setKexiaoRule(final long courseId, final int rule) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Integer>(){

            public Integer doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = StudentKexiaoServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)RedisKeyEnums.ERP.TX_ORG_KEXIAO_RULE.getRedisKey());
                byte[] field = serializer.serialize((Object)String.valueOf(courseId));
                byte[] value = serializer.serialize((Object)String.valueOf(rule));
                connection.hSet(key, field, value);
                return null;
            }
        });
    }

    public Integer getKexiaoRule(final long courseId) {
        String ruleStr = (String)this.redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = StudentKexiaoServiceImpl.this.getRedisSerializer();
                byte[] keyBytes = serializer.serialize((Object)RedisKeyEnums.ERP.TX_ORG_KEXIAO_RULE.getRedisKey());
                byte[] field = serializer.serialize((Object)String.valueOf(courseId));
                byte[] value = connection.hGet(keyBytes, field);
                String rule = (String)serializer.deserialize(value);
                log.info("[Kexiao] kexiao rule={},courseId={}", (Object)rule, (Object)courseId);
                return rule;
            }
        });
        if (StringUtils.isNotBlank((String)ruleStr)) {
            return Integer.parseInt(ruleStr);
        }
        return null;
    }

    private void updateClassLessonStatus(List<OrgClassLesson> lessons) {
        List list = ListUtil.toKeyList(lessons, (String)"courseId", OrgClassLesson.class);
        Map<Long, Long> classCourseMap = this.getClassCourseIdMap(list);
        Date now = new Date();
        HashSet<Long> unStartIds = new HashSet<Long>();
        HashSet<Long> finishedIds = new HashSet<Long>();
        log.info("[Kexiao] classCourseMap={},courseId={}", classCourseMap, (Object)list);
        Map ruleMap = this.courseApiService.getClassRule((Collection)list);
        for (OrgClassLesson lesson : lessons) {
            Long courseId = classCourseMap.get(lesson.getCourseId());
            if (courseId == null) {
                log.warn("[Kexiao] classId is {},courseId is null", (Object)lesson.getCourseId());
                continue;
            }
            OrgCourseConsumeRule rule = (OrgCourseConsumeRule)ruleMap.get(lesson.getCourseId());
            if (rule != null && rule.getRuleValue() > 0) {
                log.info("[Kexiao]Kexiao Rule={},courseId={}", (Object)rule, (Object)lesson.getCourseId());
                continue;
            }
            if (lesson.getStartTime().compareTo(now) <= 0) {
                finishedIds.add(lesson.getId());
                continue;
            }
            unStartIds.add(lesson.getId());
        }
        if (unStartIds.size() > 0) {
            this.studentLessonDao.batchUpdateKexiaoStatus(unStartIds, LessonStatus.UN_START.getStatus());
        }
        if (finishedIds.size() > 0) {
            this.studentLessonDao.batchUpdateKexiaoStatus(finishedIds, LessonStatus.FINISHED.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStudentLesson() {
        boolean isAllowed = updateTimePerOneMinuteSemaphore.tryAcquire();
        if (!isAllowed) {
            log.info("[KexiaoStatus] Other thread is execute.");
            return;
        }
        long start = System.currentTimeMillis();
        try {
            Date date = this.getUpdateTime(RedisKeyEnums.ERP.TX_ORG_STU_LESSON_UPDATE_HSET.getRedisKey());
            Date current = new Date();
            if (date == null) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(12, -30);
                date = calendar.getTime();
            }
            this.syncStudentLessonsByLastTime(date, current);
            this.setUpdateTime(String.valueOf(current.getTime()), RedisKeyEnums.ERP.TX_ORG_STU_LESSON_UPDATE_HSET.getRedisKey());
        }
        finally {
            updateTimePerOneMinuteSemaphore.release();
        }
        log.info("[KexiaoStatus] Execute time={}ms", (Object)(System.currentTimeMillis() - start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStudentLessonByTime(int beforeMinute) {
        boolean isAllowed = updateTimePerFiveMinuteSemaphore.tryAcquire();
        if (!isAllowed) {
            log.info("[KexiaoStatus] Other thread is execute.");
            return;
        }
        long start = System.currentTimeMillis();
        try {
            Date date = this.getUpdateTime(RedisKeyEnums.ERP.TX_ORG_STU_LESSON_UPDATE_TIME_FIVE.getRedisKey());
            if (date == null) {
                date = new Date();
            }
            Date current = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(12, -beforeMinute);
            date = calendar.getTime();
            this.syncStudentLessonsByLastTime(date, current);
            this.setUpdateTime(String.valueOf(current.getTime()), RedisKeyEnums.ERP.TX_ORG_STU_LESSON_UPDATE_TIME_FIVE.getRedisKey());
        }
        finally {
            updateTimePerFiveMinuteSemaphore.release();
        }
        log.info("[KexiaoStatus] Execute time={}ms,beforeMinute={}m", (Object)(System.currentTimeMillis() - start), (Object)beforeMinute);
    }

    public void syncStudentLessonsByLastTime(Date startTime, Date endTime) {
        log.info("[KexiaoStatus] Execute startTime={},currentTime={}", (Object)startTime, (Object)new Date());
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(Integer.valueOf(1000));
        List studentLessons = this.studentLessonDao.getStudentLessonsByPage(startTime, endTime, pageDto);
        while (studentLessons != null && studentLessons.size() > 0) {
            HashMap<Long, ArrayList<Long>> map = new HashMap<Long, ArrayList<Long>>();
            for (OrgStudentLesson lesson : studentLessons) {
                ArrayList<Long> userIds = (ArrayList<Long>)map.get(lesson.getLessonId());
                if (userIds == null) {
                    userIds = new ArrayList<Long>();
                    map.put(lesson.getLessonId(), userIds);
                }
                userIds.add(lesson.getUserId());
            }
            log.info("[KexiaoStatus] update lesson and userId={}", map);
            List classLessons = this.classLessonDao.getByIds(map.keySet(), new String[0]);
            if (classLessons != null) {
                this.updateStudentLessons(studentLessons, classLessons);
                for (OrgClassLesson classLesson : classLessons) {
                    List userIds = (List)map.get(classLesson.getId());
                    List statisticsList = this.studentLessonDao.getStudentLessonCounter(classLesson.getOrgId().longValue(), (Collection)userIds, classLesson.getCourseId().longValue());
                    Map studentLessonStatisticsMap = CollectionHelper.toKeyMap((Collection)statisticsList, (String)"userId");
                    if (userIds == null || userIds.size() <= 0) continue;
                    for (Long userId : userIds) {
                        StudentLessonStatistics statistics = (StudentLessonStatistics)studentLessonStatisticsMap.get(userId);
                        if (statistics == null) {
                            statistics = new StudentLessonStatistics();
                            statistics.setOrgId(classLesson.getOrgId().longValue());
                            statistics.setUserId(userId.longValue());
                            statistics.setCourseId(classLesson.getCourseId().longValue());
                        }
                        try {
                            this.studentQuery.add("crm_students", this.toMap(statistics));
                        }
                        catch (SolrServerException e) {
                            log.error("[KexiaoStatus] SolrServerException", (Throwable)e);
                        }
                        catch (IOException e) {
                            log.error("[KexiaoStatus] IOException", (Throwable)e);
                        }
                    }
                }
            }
            pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
            studentLessons = this.studentLessonDao.getStudentLessonsByPage(startTime, endTime, pageDto);
        }
    }

    private void updateStudentLessons(List<OrgStudentLesson> stuLessons, List<OrgClassLesson> classLessons) {
        HashMap<Long, OrgClassLesson> classLessonMap = new HashMap<Long, OrgClassLesson>();
        HashSet<Long> classIds = new HashSet<Long>();
        for (OrgClassLesson classLesson : classLessons) {
            classLessonMap.put(classLesson.getId(), classLesson);
            classIds.add(classLesson.getCourseId());
        }
        HashMap<Long, ArrayList<Long>> retMap = new HashMap<Long, ArrayList<Long>>();
        Map ruleMap = this.courseApiService.getClassRule(classIds);
        HashSet finishedIds = Sets.newHashSet();
        HashSet unStartedIds = Sets.newHashSet();
        Date now = new Date();
        for (OrgStudentLesson studentLesson : stuLessons) {
            OrgCourseConsumeRule rule;
            OrgClassLesson lesson = (OrgClassLesson)classLessonMap.get(studentLesson.getLessonId());
            if (lesson == null || (rule = (OrgCourseConsumeRule)ruleMap.get(lesson.getCourseId())) != null && rule.getRuleValue() != 0) continue;
            if (lesson.getStartTime().compareTo(now) <= 0) {
                if (studentLesson.getKexiaoStatus().intValue() == LessonStatus.FINISHED.getStatus()) continue;
                finishedIds.add(studentLesson.getId());
                continue;
            }
            if (studentLesson.getKexiaoStatus().intValue() == LessonStatus.UN_START.getStatus()) continue;
            unStartedIds.add(studentLesson.getId());
        }
        log.info("[KexiaoStatus] finishedIds={},unStartedIds={}", (Object)finishedIds, (Object)unStartedIds);
        if (!finishedIds.isEmpty()) {
            this.studentLessonDao.batchUpdateKexiaoStatusById((Collection)finishedIds, LessonStatus.FINISHED.getStatus());
        }
        if (!unStartedIds.isEmpty()) {
            this.studentLessonDao.batchUpdateKexiaoStatusById((Collection)unStartedIds, LessonStatus.UN_START.getStatus());
        }
        for (OrgStudentLesson studentLesson : stuLessons) {
            ArrayList<Long> list = (ArrayList<Long>)retMap.get(studentLesson.getOrgId());
            if (list == null) {
                list = new ArrayList<Long>();
                retMap.put(studentLesson.getOrgId(), list);
            }
            list.add(studentLesson.getId());
        }
        Set keySet = retMap.keySet();
        for (Long orgId : keySet) {
            this.changeLogService.addModifyStuLessonsLog(orgId, (Collection)retMap.get(orgId));
        }
    }

    private Map<String, Object> toMap(StudentLessonStatistics counter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", counter.getId());
        map.put("org_id", counter.getOrgId());
        map.put("student_id", counter.getUserId());
        map.put("course_id", counter.getCourseId());
        map.put("total", counter.getTotalCount());
        map.put("finished", counter.getFinishedCount());
        map.put("left_count", counter.getLeftCount());
        map.put("left_time", counter.getLeftTime());
        map.put("finished_time", counter.getFinishedTime());
        map.put("total_time", counter.getTotalTime());
        return map;
    }

    public void setUpdateTime(final String updateTime, final String key) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Integer>(){

            public Integer doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = StudentKexiaoServiceImpl.this.getRedisSerializer();
                byte[] keyBytes = serializer.serialize((Object)key);
                byte[] value = serializer.serialize((Object)updateTime);
                connection.set(keyBytes, value);
                log.info("[Redis] Set student lesson updateTime={}", (Object)updateTime);
                return null;
            }
        });
    }

    public Date getUpdateTime(final String key) {
        String dateStr = (String)this.redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = StudentKexiaoServiceImpl.this.getRedisSerializer();
                byte[] keyBytes = serializer.serialize((Object)key);
                byte[] value = connection.get(keyBytes);
                String updateTime = (String)serializer.deserialize(value);
                return updateTime;
            }
        });
        if (StringUtils.isNotBlank((String)dateStr)) {
            Date date = new Date(Long.parseLong(dateStr));
            log.info("[Redis] Set student lesson updateTime={}", (Object)date);
            return date;
        }
        return null;
    }

    @Override
    public void reviseKexiaoStatus(Date startTime, Date endTime) {
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(Integer.valueOf(1000));
        List signList = this.orgLessonSignDao.listByPage(startTime, endTime, pageDto);
        log.info("[KexiaoStatus] Revise kexiao status.pageDto={}", (Object)pageDto);
        while (signList.size() > 0) {
            log.info("[KexiaoStatus] Revise kexiao status.pageDto={}", (Object)pageDto);
            this.updateClassLessonStatusBySignUp(signList);
            pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
            signList = this.orgLessonSignDao.listByPage(startTime, endTime, pageDto);
        }
    }

    private class KexiaoRunnable
    implements Runnable {
        private long courseId;
        private long orgId;
        private int rule;

        public KexiaoRunnable(long orgId, long courseId, int rule) {
            this.orgId = orgId;
            this.courseId = courseId;
            this.rule = rule;
        }

        @Override
        public void run() {
            log.info("[Kexiao] courseId={},rule={}", (Object)this.courseId, (Object)this.rule);
            List classIds = new ArrayList<Long>();
            OrgCourse course = (OrgCourse)StudentKexiaoServiceImpl.this.courseDao.getById((Serializable)Long.valueOf(this.courseId), new String[]{"id", "parentId", "courseType", "isClass", "isCourse"});
            if (CourseTypeEnum.IS_CLASS_FALSE.getCode() == course.getIsClass() && CourseTypeEnum.IS_COURSE_TRUE.getCode() == course.getIsCourse()) {
                classIds = StudentKexiaoServiceImpl.this.courseDao.getClassIdsByParentId(Long.valueOf(this.courseId));
            } else {
                classIds.add(this.courseId);
            }
            log.info("[Kexiao] classIds is {}", classIds);
            if (classIds == null || classIds.size() < 1) {
                return;
            }
            if (this.rule > 0) {
                List signs = StudentKexiaoServiceImpl.this.orgLessonSignDao.getCourseLessonSignIn(Long.valueOf(this.orgId), classIds);
                ArrayList<OrgLessonSign> finishedSigns = new ArrayList<OrgLessonSign>();
                List lessons = StudentKexiaoServiceImpl.this.studentLessonDao.getOrgStudentLessonsByCourseIds(classIds);
                if (signs != null) {
                    for (OrgLessonSign sign : signs) {
                        LessonStatus status = StudentKexiaoServiceImpl.this.kexiaoApiService.getKexiaoStatus(sign, this.rule);
                        if (status != LessonStatus.FINISHED) continue;
                        finishedSigns.add(sign);
                    }
                }
                this.removeSign(lessons, finishedSigns);
                List<OrgLessonSign> unSigns = this.convertToLessonSigns(lessons);
                log.info("[Kexiao] un_start={},finished={}", unSigns, finishedSigns);
                StudentKexiaoServiceImpl.this.studentLessonDao.batchUpdateKexiaoStatusBySign(unSigns, LessonStatus.UN_START.getStatus());
                StudentKexiaoServiceImpl.this.studentLessonDao.batchUpdateKexiaoStatusBySign(finishedSigns, LessonStatus.FINISHED.getStatus());
            } else {
                List classLessons = StudentKexiaoServiceImpl.this.classLessonDao.getLessonByCourseIds(classIds, null, new String[0]);
                StudentKexiaoServiceImpl.this.updateClassLessonStatus(classLessons);
            }
        }

        private void removeSign(List<OrgStudentLesson> lessons, List<OrgLessonSign> finishedSigns) {
            if (lessons == null || lessons.isEmpty() || finishedSigns == null || finishedSigns.isEmpty()) {
                return;
            }
            HashMap<String, OrgStudentLesson> lessonMap = new HashMap<String, OrgStudentLesson>();
            for (OrgStudentLesson lesson : lessons) {
                lessonMap.put(lesson.getUserId() + "_" + lesson.getLessonId(), lesson);
            }
            for (OrgLessonSign sign : finishedSigns) {
                OrgStudentLesson lessonSign = (OrgStudentLesson)lessonMap.get(sign.getUserId() + "_" + sign.getLessonId());
                if (lessonSign == null) continue;
                lessons.remove(lessonSign);
            }
        }

        private List<OrgLessonSign> convertToLessonSigns(List<OrgStudentLesson> lessons) {
            ArrayList<OrgLessonSign> result = new ArrayList<OrgLessonSign>();
            if (lessons != null) {
                for (OrgStudentLesson lesson : lessons) {
                    OrgLessonSign sign = new OrgLessonSign();
                    sign.setLessonId(lesson.getLessonId());
                    sign.setUserId(lesson.getUserId());
                    result.add(sign);
                }
            }
            return result;
        }
    }
}

