package com.baijia.tianxiao.biz.student.syn.service.impl;

import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;

import javax.annotation.Resource;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.*;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.CourseApiService;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoSignupCourseStat;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseLessonService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ListUtil;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.student.syn.service.SyncDataService;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.sync.dao.TxStudentStatusDao;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;

@Service("syncStudentStatusService")
@Slf4j
public class SyncStudentStatusServiceImpl implements SyncDataService {
    
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private TxStudentStatusDao txStudentStatusDao;
    @Resource
    private TxStudentCommentDao commentDao;
    @Resource
    private OrgSignupCourseDao signupCourseDao;
    @Resource
    private OrgSignupCourseLessonDao signupCourseLessonDao;
    @Resource
    private OrgSignupRefundDao refundDao;
    @Resource
    private OrgStudentLessonDao studentLessonDao;
    @Resource
    private OrgLessonSignDao signDao;
    @Autowired
    private OrgCourseConsumeRuleDao ruleDao;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private CourseApiService courseApiService;
    @Autowired
    private OrgSignupCourseLessonService signupCourseLessonService;

    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;

    private AtomicBoolean flag = new AtomicBoolean(false);

    @Override
    public void sync(List<Integer> orgNumbers) {
        try {
            if (!flag.get()) {
                flag.set(true);
                syncStudentStatusByDay(orgNumbers);
                flag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", e);
        } finally {
            flag.set(false);
        }
    }

    private void syncStudentStatusByDay(List<Integer> orgNumbers) {
        //获得全部天校机构id
        List<OrgAccount> orgAccont = orgAccountDao.getAccountByNumbers(orgNumbers);
        List<Integer> orgIds = Lists.newArrayList();
        for(OrgAccount o: orgAccont){
            orgIds.add(o.getId());
        }
        List<StudentStatusStatisticsByDay> list = Lists.newArrayList();
        Map<Integer, Integer> studying = orgStudentDao.getStatisticsDayByLessonStatus(StudentLessonStatus.STUDYING.getStatus(),orgIds);
        Map<Integer, Integer> past = orgStudentDao.getStatisticsDayByLessonStatus(StudentLessonStatus.PAST.getStatus(),orgIds);
        Map<Integer, Integer> toCharge = orgStudentDao.getStatisticsDayByLessonStatus(StudentLessonStatus.TO_CHARGE.getStatus(),orgIds);
        for(Integer i: orgIds){
            int studyingCount = studying.get(i)!=null?studying.get(i):0;
            int pastCount = past.get(i)!=null?past.get(i):0;
            int toChargeCount = toCharge.get(i)!=null?toCharge.get(i):0;
            StudentStatusStatisticsByDay s = new StudentStatusStatisticsByDay();
            s.setOrgId(i);
            s.setCreateTime(DateUtil.getDiffDateTime(new Date(), -1));
            s.setStudyingCount(studyingCount);
            s.setPastCount(pastCount);
            s.setTochargeCount(toChargeCount);
            s.setAllCount(studyingCount+pastCount+toChargeCount);
            list.add(s);
        }
        //批量同步
        txStudentStatusDao.saveAll(list);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class, BussinessException.class})
    public int sync(Long orgId,PageDto page) {
        List<OrgStudent> list = orgStudentDao.getStudentsByPage(orgId,page,"id","userId","orgId","lastRemindTime");
        log.info("Start================");
        for (OrgStudent student:list){
            TxStudentComment comment = commentDao.getRecentComment(student.getOrgId(),student.getUserId(), StudentType.ORG_STUDENTS.getCode());
            if(comment!=null){
                student.setLastRemindTime(comment.getUpdateTime());
                orgStudentDao.update(student,"lastRemindTime","updateTime");
            }
        }
        log.info("Execute end================ success,size={}",list.size());
        return list.size();
    }

    @Override
    public List<OrgStudentLesson> reviseDeleteOrder(Long orgId,Long userId){
        Map<String,Object> map = new HashMap<>();
        map.put("isDel",1);
        map.put("status", SignupCourseStatus.PAY_SUCCESS);
        map.put("orgId", orgId);
        map.put("userId", userId);
        List<OrgSignupCourse> delOrders = signupCourseDao.queryByCondition(map,null);
        List<Long> ids = ListUtil.toKeyList(delOrders,"id",OrgSignupCourse.class);
        Map<String, OrgSignupCourseLesson> courseLessonMap = signupCourseLessonDao.listBySignupCourseIdAndLessonId(ids,null);
        List<OrgStudentLesson> result = new ArrayList<>();
        for (OrgSignupCourseLesson lesson:courseLessonMap.values()){
            OrgStudentLesson studentLesson = studentLessonDao.getByLessonIdAndUserId(lesson.getLessonId(),lesson.getUserId());
            result.add(studentLesson);
        }
        return result;
    }

    @Override
    public int syncDeleteOrder(PageDto page) {
        Map<String,Object> map = new HashMap<>();
        map.put("isDel",1);
        map.put("status", SignupCourseStatus.PAY_SUCCESS);
        List<OrgSignupCourse> delOrders = signupCourseDao.queryByCondition(map,page);
        List<Long> ids = ListUtil.toKeyList(delOrders,"id",OrgSignupCourse.class);
        Map<String, OrgSignupCourseLesson> courseLessonMap = signupCourseLessonDao.listBySignupCourseIdAndLessonId(ids,null);
        Map<Long,Integer> orgMap = new HashMap<>();
        Map<String,Integer> studentCourseCountMap = new HashMap<>();
        for (OrgSignupCourseLesson lesson:courseLessonMap.values()){
            Integer count = orgMap.get(lesson.getOrgId());
            if(count==null){
                orgMap.put(lesson.getOrgId(),1);
            }else {
                orgMap.put(lesson.getOrgId(),count+1);
            }

            String key = lesson.getOrgId()+"_"+lesson.getUserId()+"_"+lesson.getClassId();
            Integer lessonCount = studentCourseCountMap.get(key);
            if(lessonCount==null){
                studentCourseCountMap.put(key,1);
            }else {
                studentCourseCountMap.put(key,lessonCount+1);
            }
        }

        Set<String> keys = studentCourseCountMap.keySet();
        Map<Long,List<OrgStudentStat>> retMap = new HashMap<>();
        for (String key:keys){
            String[] arrs = key.split("_");
            long orgId = Long.parseLong(arrs[0]);
            long userId = Long.parseLong(arrs[1]);
            long classId = Long.parseLong(arrs[2]);
            List<OrgSignupCourse> courseList = signupCourseDao.searchByUserIdsAndClassId(Arrays.asList(userId),classId,orgId,SignupCourseStatus.PAY_SUCCESS);
            int leftNum = 0;
            if(courseList!=null){
                Map<Long, KexiaoSignupCourseStat> statMap = kexiaoApiService.queryKexiaoStatBySignUpCourseIds(courseList);
                for (Long id:statMap.keySet()){
                    KexiaoSignupCourseStat stat = statMap.get(id);
                    leftNum+=stat.getLeftUnArrangedNumber();
                }
            }
            List<OrgStudentStat> list = retMap.get(orgId);
            if(list==null){
                list = new ArrayList<>();
                retMap.put(orgId,list);
            }
            list.add(new OrgStudentStat(orgId,userId,classId,studentCourseCountMap.get(key),leftNum));
        }

        log.info("[SyncData] Execute end================ success,orgMap={}",orgMap);
        log.info("[SyncData] Execute end================ success,retMap={}",retMap);
        return 0;
    }

    @Data
    class OrgStudentStat{
        private long orgId;
        private long userId;
        private long classId;
        private int delOrgLessonCount;
        private int freeCount;
        private int leftCount;
        private int chargeUnit;
        private int completeStatus;

        public OrgStudentStat(long orgId, long userId, long classId, int delOrgLessonCount, int leftCount) {
            this.orgId = orgId;
            this.userId = userId;
            this.classId = classId;
            this.delOrgLessonCount = delOrgLessonCount;
            this.leftCount = leftCount;
        }

        @Override
        public String toString(){
            return String.format("%10d%10d%10d%10d%10d%10d%10d%10d",orgId,userId,classId,delOrgLessonCount,
                    leftCount,(delOrgLessonCount-leftCount),chargeUnit,completeStatus);
        }
    }

    @Override
    public void syncMultiClass() {
        List<String>  strings = orgStudentCourseDao.listMultiClass();
        Map<Long,Integer> orgMap = new HashMap<>();
        Set<String> result = new HashSet<>();
        for (String str:strings){
            String[] arr = str.split("_");
            long orgId = Long.parseLong(arr[0]);
            long userId = Long.parseLong(arr[1]);
            long courseId = Long.parseLong(arr[2]);
            int count = Integer.parseInt(arr[3]);
            Integer number = orgMap.get(orgId);
            if(number==null){
                number = 0;
            }
            orgMap.put(orgId,number+1);

            List<OrgSignupCourse> courses = signupCourseDao.getByCourseIdAndStudentId(orgId,userId,courseId,SignupCourseStatus.PAY_SUCCESS);

            Set<Long> signupClassIds = new HashSet<>();
            Map<String,OrgSignupCourse> courseMap = new HashMap<>();
            for (OrgSignupCourse course:courses){
                signupClassIds.add(course.getClassId());
                courseMap.put(course.getUserId()+"_"+course.getClassId(),course);
            }

            List<OrgSignupRefund> refunds = refundDao.listOrderByUserIdsAndCourseId(orgId, Arrays.asList(userId),courseId);
            Set<Long> refundClassIds = new HashSet<>();

            for (OrgSignupRefund refund:refunds){
                refundClassIds.add(refund.getClassId());
                OrgSignupCourse course = courseMap.get(refund.getUserId()+"_"+refund.getClassId());
                if(course==null){
                    log.info("[SyncData]no signup course.refund={}",refund);
                    result.add(refund.getOrgId()+"_"+refund.getClassId()+"_"+refund.getUserId()+"_0");
                }else {
                    if(!refund.getSignupPurchaseId().equals(course.getSignupPurchaseId())){
                        log.info("[SyncData] signup course id is not same.signupcourse={},refund={}",course,refund);
                        result.add(refund.getOrgId()+"_"+refund.getClassId()+"_"+refund.getUserId()+"_1");
                    }
                }
            }
            log.info("[SyncData] userId={},courseId={},signupClassIds={},refundClassIds={}",userId,courseId,signupClassIds,refundClassIds);
        }
        log.info("[SyncData] org static={}",orgMap);
        log.info("[SyncData] org result={}",result);
    }

    @Override
    public void syncCancelLesson() {
        Map<String,Object> param = new HashMap<>();
        param.put("lessonType",3);
        param.put("delStatus",0);
        PageDto pageDto = new PageDto();
        List<OrgStudentLesson> lessons = studentLessonDao.queryByCondition(param,pageDto);
        Map<Long,Set<Long>> orgStudentMap = new HashMap<>();
        Map<Long,Integer> lessonCountMap = new HashMap<>();
        Map<Long,OrgCourseConsumeRule> ruleMap = new HashMap<>();
        while (lessons.size()>0){
            for (OrgStudentLesson lesson:lessons){
                OrgLessonSign sign = signDao.getStudentLessonSign(lesson.getOrgId(),lesson.getCourseId(),
                        lesson.getLessonId(),lesson.getUserId(), UserRole.STUDENT.getRole());
                Set<Long> studentIds = orgStudentMap.get(sign.getOrgId());
                Integer count = lessonCountMap.get(lesson.getOrgId());
                if(studentIds==null){
                    studentIds = new HashSet<>();
                }
                if(count==null){
                    count=0;
                    lessonCountMap.put(lesson.getOrgId(),count);
                }
                if(sign==null){
                    studentIds.add(lesson.getUserId());
                    count++;
                    lessonCountMap.put(lesson.getOrgId(),count);
                    log.info("[SyncData] lesson status error,no sign.studentLessonId={}",lesson.getId());
                    continue;
                }

                long realCourseId = courseApiService.getCourseIdByClassId(sign.getCourseId());

                OrgCourseConsumeRule rule = ruleMap.get(realCourseId);
                if(rule==null) {
                    count++;
                    rule = ruleDao.getRuleByCourseId(lesson.getOrgId(), realCourseId);
                    ruleMap.put(realCourseId,rule);
                }
                if(rule!=null){
                    LessonStatus lessonStatus = kexiaoApiService.getKexiaoStatus(sign, rule.getRuleValue());
                    if (lessonStatus == LessonStatus.FINISHED) {
                        studentIds.add(lesson.getUserId());
                        count++;
                        log.info("[SyncData] lesson status error.studentLessonId={}",lesson.getId());
                    }
                }else {
                    studentIds.add(lesson.getUserId());
                    count++;
                    log.info("[SyncData] lesson status error,no rule.studentLessonId={}",lesson.getId());
                }
                lessonCountMap.put(lesson.getOrgId(),count);
            }
            pageDto.setPageNum(pageDto.getPageNum()+1);
            lessons = studentLessonDao.queryByCondition(param,pageDto);
        }
        log.info("[SyncData] orgStudent={},lessonCount={}",orgStudentMap,lessonCountMap);
    }

    @Override
    public List<OrgStudentLesson> reviseMixArrange(Long org){
        List<String> stringList = studentLessonDao.getMixArrangeLessonByOrgId(org);
        List<OrgStudentLesson> allLessons = new ArrayList<>();
        for (String str:stringList){
            String[] arr = str.split("_");
            long orgId = Long.parseLong(arr[0]);
            long userId = Long.parseLong(arr[1]);
            long courseId = Long.parseLong(arr[2]);
            List<OrgStudentLesson> lessons = studentLessonDao.getByUserIdAndClassId(orgId,userId,courseId,null);
            allLessons.addAll(lessons);
        }
        return allLessons;
    }

    @Override
    public void syncMixArrange() {
        List<String> stringList = studentLessonDao.getMixArrangeLesson();
        Map<Long,Integer> lessonCountMap = new HashMap<>();
        List<OrgStudentStat> statList = new ArrayList<>();
        for (String str:stringList){
            String[] arr = str.split("_");
            long orgId = Long.parseLong(arr[0]);
            long userId = Long.parseLong(arr[1]);
            long courseId = Long.parseLong(arr[2]);
            int unknowCount = Integer.parseInt(arr[3]);
            Integer number = lessonCountMap.get(orgId);
            if(number==null){
                number = 0;
            }
            lessonCountMap.put(orgId,number+1);

            List<OrgSignupCourse> courseList = signupCourseDao.searchByUserIdsAndClassId(Arrays.asList(userId),courseId,orgId,SignupCourseStatus.PAY_SUCCESS);

            if(courseList!=null){
                boolean isComplete = true;
                for (OrgSignupCourse course:courseList){
                    if(course.getLessonCount()<1){
                        OrgStudentStat stat = new OrgStudentStat(orgId,userId,course.getClassId(),0,0);
                        stat.setChargeUnit(course.getChargeUnit());
                        stat.setCompleteStatus(1);
                        isComplete = false;
                        statList.add(stat);
                        log.info("[SyncData] stat={}",stat);
                    }
                }
                if(!isComplete){
                    continue;
                }

                int leftNum = 0;
                Map<Long, KexiaoSignupCourseStat> statMap = kexiaoApiService.queryKexiaoStatBySignUpCourseIds(courseList);
                for (Long id:statMap.keySet()){
                    KexiaoSignupCourseStat stat = statMap.get(id);
                    leftNum+=stat.getLeftUnArrangedNumber();
                }
                OrgStudentStat stat = new OrgStudentStat(orgId,userId,courseId,unknowCount,leftNum);
                statList.add(stat);
                log.info("[SyncData] stat={}",stat);
            }
        }
        log.info("[SyncData]lessonCount={}",lessonCountMap);
        log.info("[SyncData] OrgStudentStatList1111={}",statList);
    }
}
