package com.baijia.tianxiao.biz.student.service.impl;

import com.baijia.tianxiao.biz.student.service.BizOrgStudentService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dto.smstoken.StudentSmsTokenDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;

import com.baijia.tianxiao.sal.student.dto.response.StudentCourseInfoReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentCourseListResponse;
import com.baijia.tianxiao.util.ListUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * Created by liuxp on 16/9/23.
 */
@Service
@Slf4j
public class BizOrgStudentServiceImpl implements BizOrgStudentService {

    @Autowired
    private OrgStudentService studentService;
    @Autowired
    private CourseStudentService courseStudentService;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgStudentCourseService studentCourseService;
    @Autowired
    private CourseTeacherService courseTeacherService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delStudent(StudentCommenRequestDto requestDto, Long orgId) {
        studentService.delStudent(requestDto, orgId);
        courseStudentService.deleteOrgCourseStudentForDelStudent(orgId, requestDto.getStudentId());
    }

    @Override
    @Transactional(rollbackFor = {Exception.class, BussinessException.class})
    public void batchDelStudent(Long orgId, Set<Long> studentIds) {
        if (CollectionUtils.isEmpty(studentIds)) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        if (CollectionUtils.isNotEmpty(studentIds)) {
            for (Long studentId : studentIds) {
                StudentCommenRequestDto requestDto = new StudentCommenRequestDto();
                requestDto.setStudentId(studentId);
                this.delStudent(requestDto, orgId);
            }
        }
    }

    @Override
    public void unbindWechat(String smsToken) {
        if (StringUtils.isBlank(smsToken)) {
            log.warn("wrong param dto:{}", smsToken);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        try {
            StudentSmsTokenDto token = StudentSmsTokenDto.fromTokenStr(smsToken);
            if (token == null || token.getStudentId() == null) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR);
            }

            OrgStudent orgStudent = orgStudentDao.getById(token.getStudentId().longValue());
            if (orgStudent == null) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR);
            }
            log.debug("unbind wechat weixin=={}", orgStudent.getWeixin());
            if (!StringUtils.isEmpty(orgStudent.getWeixin())) {
                orgStudentDao.unbindStudentWechat(orgStudent.getWeixin());
                Fans fans = fansDao.getByOpenId(orgStudent.getWeixin());
                if (fans!=null){
                    fans.setIsDel(DataStatus.DELETE.getValue());
                    fansDao.update(fans,"isDel");
                }
            }
        } catch (Exception e) {
            log.warn("wrong param dto:{}", smsToken);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
    }

    @Override
    public List<StudentCourseInfoReponseDto> getStudentCurrentClass(Long orgId, StudentCommenRequestDto requestDto) {
        List<StudentCourseInfoReponseDto> response = studentCourseService.getCurrentStudnetCourseInfos(requestDto,orgId);
        List<Long> classIds = ListUtil.toKeyList(response,"courseId",StudentCourseInfoReponseDto.class);
        Map<Long,String> teacherMap = getTeachersName(orgId,classIds);
        for (StudentCourseInfoReponseDto dto:response){
            dto.setTeacher(teacherMap.get(dto.getCourseId()));
        }
        return response;
    }

    @Override
    public List<StudentCourseInfoReponseDto> getStudentHistoryClass(Long orgId, StudentCommenRequestDto requestDto) {
        List<StudentCourseInfoReponseDto> response = studentCourseService.getHistoryStudnetCourseInfos(requestDto,orgId);
        List<Long> classIds = ListUtil.toKeyList(response,"courseId",StudentCourseInfoReponseDto.class);
        Map<Long,String> teacherMap = getTeachersName(orgId,classIds);
        for (StudentCourseInfoReponseDto dto:response){
            dto.setTeacher(teacherMap.get(dto.getCourseId()));
        }
        return response;
    }

    private Map<Long,String> getTeachersName(Long orgId, Collection<Long> classIds){
        Map<Long,String> ret = new HashMap<>();
        if(classIds==null || classIds.size()<1){
            return ret;
        }
        Map<Long,List<Teacher>> courseTeachersMap = courseTeacherService.listCourseTeacher(orgId,classIds);

        Set<Long> keySet = courseTeachersMap.keySet();
        for (Long classId:keySet){
            List<Teacher> teachers = courseTeachersMap.get(classId);
            if(teachers!=null && teachers.size()>0){
                StringBuilder sb = new StringBuilder();
                for (Teacher teacher:teachers){
                    sb.append(",").append(teacher.getRealName());
                }
                ret.put(classId,sb.substring(1));
            }
        }
        return ret;
    }
}
