/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.student.service.impl;

import com.baijia.tianxiao.biz.student.service.BizOrgStudentService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.smstoken.StudentSmsTokenDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentCourseInfoReponseDto;
import com.baijia.tianxiao.util.ListUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizOrgStudentServiceImpl
implements BizOrgStudentService {
    private static final Logger log = LoggerFactory.getLogger(BizOrgStudentServiceImpl.class);
    @Autowired
    private OrgStudentService studentService;
    @Autowired
    private CourseStudentService courseStudentService;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgStudentCourseService studentCourseService;
    @Autowired
    private CourseTeacherService courseTeacherService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delStudent(StudentCommenRequestDto requestDto, Long orgId) {
        this.studentService.delStudent(requestDto, orgId);
        this.courseStudentService.deleteOrgCourseStudentForDelStudent(orgId, requestDto.getStudentId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void batchDelStudent(Long orgId, Set<Long> studentIds) {
        if (CollectionUtils.isEmpty(studentIds)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        if (CollectionUtils.isNotEmpty(studentIds)) {
            for (Long studentId : studentIds) {
                StudentCommenRequestDto requestDto = new StudentCommenRequestDto();
                requestDto.setStudentId(studentId);
                this.delStudent(requestDto, orgId);
            }
        }
    }

    @Override
    public void unbindWechat(String smsToken) {
        if (StringUtils.isBlank((CharSequence)smsToken)) {
            log.warn("wrong param dto:{}", (Object)smsToken);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        try {
            StudentSmsTokenDto token = StudentSmsTokenDto.fromTokenStr((String)smsToken);
            if (token == null || token.getStudentId() == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
            }
            OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)token.getStudentId(), new String[0]);
            if (orgStudent == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
            }
            log.debug("unbind wechat weixin=={}", (Object)orgStudent.getWeixin());
            if (!StringUtils.isEmpty((CharSequence)orgStudent.getWeixin())) {
                this.orgStudentDao.unbindStudentWechat(orgStudent.getWeixin());
                Fans fans = this.fansDao.getByOpenId(orgStudent.getWeixin());
                if (fans != null) {
                    fans.setIsDel(Integer.valueOf(DataStatus.DELETE.getValue()));
                    this.fansDao.update((Object)fans, new String[]{"isDel"});
                }
            }
        }
        catch (Exception e) {
            log.warn("wrong param dto:{}", (Object)smsToken);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
    }

    @Override
    public List<StudentCourseInfoReponseDto> getStudentCurrentClass(Long orgId, StudentCommenRequestDto requestDto) {
        List response = this.studentCourseService.getCurrentStudnetCourseInfos(requestDto, orgId);
        List classIds = ListUtil.toKeyList((Collection)response, (String)"courseId", StudentCourseInfoReponseDto.class);
        Map<Long, String> teacherMap = this.getTeachersName(orgId, classIds);
        for (StudentCourseInfoReponseDto dto : response) {
            dto.setTeacher(teacherMap.get(dto.getCourseId()));
        }
        return response;
    }

    @Override
    public List<StudentCourseInfoReponseDto> getStudentHistoryClass(Long orgId, StudentCommenRequestDto requestDto) {
        List response = this.studentCourseService.getHistoryStudnetCourseInfos(requestDto, orgId);
        List classIds = ListUtil.toKeyList((Collection)response, (String)"courseId", StudentCourseInfoReponseDto.class);
        Map<Long, String> teacherMap = this.getTeachersName(orgId, classIds);
        for (StudentCourseInfoReponseDto dto : response) {
            dto.setTeacher(teacherMap.get(dto.getCourseId()));
        }
        return response;
    }

    private Map<Long, String> getTeachersName(Long orgId, Collection<Long> classIds) {
        HashMap<Long, String> ret = new HashMap<Long, String>();
        if (classIds == null || classIds.size() < 1) {
            return ret;
        }
        Map courseTeachersMap = this.courseTeacherService.listCourseTeacher(orgId, classIds);
        Set keySet = courseTeachersMap.keySet();
        for (Long classId : keySet) {
            List teachers = (List)courseTeachersMap.get(classId);
            if (teachers == null || teachers.size() <= 0) continue;
            StringBuilder sb = new StringBuilder();
            for (Teacher teacher : teachers) {
                sb.append(",").append(teacher.getRealName());
            }
            ret.put(classId, sb.substring(1));
        }
        return ret;
    }
}

