package com.baijia.tianxiao.biz.student.service.impl;

import com.baijia.tianxiao.biz.student.dto.GuardianDto;
import com.baijia.tianxiao.biz.student.service.OrgStudentGuardianRelevanceService;
import com.baijia.tianxiao.dal.org.dao.OrgStudentGuardianRelevanceDao;
import com.baijia.tianxiao.dal.org.po.OrgStudentGuardianRelevance;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.util.exception.BussinessPreconditions;
import com.baijia.tianxiao.util.mobile.MaskUtil;

import com.google.common.collect.Lists;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import lombok.extern.slf4j.Slf4j;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 29/08/2017 2:56 PM
 */
@Slf4j
@Service
public class OrgStudentGuardianRelevanceServiceImpl implements OrgStudentGuardianRelevanceService {

    @Autowired
    private OrgStudentGuardianRelevanceDao orgStudentGuardianRelevanceDao;

    @Autowired
    private FansService fansService;

    @Autowired
    private FansDao fansDao;

    private static final String DEFAULT_AVATAR = "https://imgs.genshuixue.com/25278959_twko2nm5.jpeg";

    public List<GuardianDto> getGuardiansByStudentId(Long orgId, Long studentId) {
        Collection<OrgStudentGuardianRelevance> guardians =
            orgStudentGuardianRelevanceDao.listByStudentId(orgId, studentId);

        Map<String, Fans> fansMap = fansDao.mapKeyOpenIdValueFans(guardians.stream()
            .filter(orgStudentGuardianRelevance -> StringUtils.isNotBlank(orgStudentGuardianRelevance.getOpenId()))
            .map(orgStudentGuardianRelevance -> orgStudentGuardianRelevance.getOpenId()).collect(Collectors.toList()));

        List<GuardianDto> result = Lists.newArrayList();
        for (OrgStudentGuardianRelevance guardian : guardians) {
            GuardianDto dto = new GuardianDto();
            dto.setGuardianId(guardian.getId());
            dto.setStudentId(guardian.getStudentId());
            dto.setMobile(MaskUtil.maskMobile(guardian.getMobile()));
            Fans fans = fansMap.get(guardian.getOpenId());
            dto.setAvatar(null == fans ? DEFAULT_AVATAR
                : StringUtils.defaultIfBlank(fans.getHeadImgUrlGsx(), fans.getHeadImgUrl()));
            dto.setName(null == fans ? dto.getMobile() : fans.getShowName());
            result.add(dto);
        }
        return result;
    }

    public OrgStudentGuardianRelevance delGuardianById(Long orgId, Long guardianId) {
        OrgStudentGuardianRelevance relevance = orgStudentGuardianRelevanceDao.getById(guardianId);
        BussinessPreconditions.checkArgument(null != relevance && relevance.getOrgId().longValue() == orgId,
            "can not find OrgStudentGuardianRelevance");
        orgStudentGuardianRelevanceDao.delById(guardianId);
        return relevance;
    }

}
