package com.baijia.tianxiao.biz.student.syn.service.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;

import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.google.common.collect.Sets;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.student.syn.service.StudentKexiaoService;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.org.po.StudentLessonStatistics;
import com.baijia.tianxiao.dal.solr.constant.SolrConstant;
import com.baijia.tianxiao.dal.solr.query.CrmStudentQuery;
import com.baijia.tianxiao.redis.AbstractBaseRedisDao;
import com.baijia.tianxiao.sal.common.api.CourseApiService;
import com.baijia.tianxiao.sal.kexiao.service.KexiaoChangeLogService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.ListUtil;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/7/22.
 */
@Service
@Slf4j
public class StudentKexiaoServiceImpl extends AbstractBaseRedisDao implements StudentKexiaoService {

//    private static final String TX_ORG_KEXIAO_RULE = "#TX#ORG#KEXIAO#RULE";
//    private static final String TX_ORG_STU_LESSON_UPDATE_HSET = "#tx_org_stu_lesson_update_hset";
//    private static final String TX_ORG_STU_LESSON_UPDATE_TIME_FIVE = "#TX#ORG#STU#LESSON#KEXIAO#FIVE";

    @Autowired
    private OrgClassLessonDao classLessonDao;
    @Autowired
    private OrgStudentLessonDao studentLessonDao;
    @Autowired
    private OrgCourseConsumeRuleDao courseConsumeRuleDao;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private OrgCourseDao courseDao;
    @Autowired
    private KexiaoChangeLogService changeLogService;
    @Autowired
    private CourseApiService courseApiService;
    @Autowired
    private KexiaoApiService kexiaoApiService;

    @Autowired
    private CrmStudentQuery studentQuery;

    private ExecutorService threadPool = Executors.newFixedThreadPool(10);

    private static final Semaphore updateTimePerOneMinuteSemaphore = new Semaphore(1);
    private static final Semaphore updateTimePerFiveMinuteSemaphore = new Semaphore(1);
    /**
     * 监控签到变化 获取最新签到变更的学生和课程
     * 
     * @return
     */
    private List<OrgStudentCourse> getStudentCourseListBySignUp() {
        return null;
    }

    @Override
    public void refreshKexiaoRule(int beforeMinutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.MINUTE, -1 * beforeMinutes);
        List<OrgCourseConsumeRule> rules = courseConsumeRuleDao.queryConsumRuleListByUpdateTime(calendar.getTime());
        if (rules != null) {
            for (OrgCourseConsumeRule rule : rules) {
                Integer oldRule = getKexiaoRule(rule.getCourseId());
                if (!rule.getRuleValue().equals(oldRule)) {
                    //课消规则如果发生了改变，需要重新计算该门课下所有学生的课消
                    threadPool.submit(new KexiaoRunnable(rule.getCourseId(),rule.getRuleValue()));
                }
                setKexiaoRule(rule.getCourseId(), rule.getRuleValue());
            }
        }
        log.info("[Kexiao] Refresh kexiao rule.");
    }

    /**
     * 按签到算课消
     */
    public void updateClassLessonStatusBySignUp(List<OrgLessonSign> lessonSigns) {
        if (lessonSigns != null && lessonSigns.size() < 1) {
            return;
        }

        List<Long> list = ListUtil.toKeyList(lessonSigns, "courseId", OrgLessonSign.class);
        List<OrgLessonSign> unSignList = new ArrayList<>();
        List<OrgLessonSign> finishedList = new ArrayList<>();
        for (OrgLessonSign sign : lessonSigns) {
            Map<Long,OrgCourseConsumeRule> ruleMap = courseApiService.getClassRule(Arrays.asList(sign.getCourseId()));
            OrgCourseConsumeRule rule = ruleMap.get(sign.getCourseId());
            if (rule != null && rule.getRuleValue()>0) {
                LessonStatus status = kexiaoApiService.getKexiaoStatus(sign, rule.getRuleValue());
                if (status == LessonStatus.FINISHED) {
                    finishedList.add(sign);
                } else {
                    unSignList.add(sign);
                }
            }
        }

        if (unSignList.size() > 0) {
            studentLessonDao.batchUpdateKexiaoStatusBySign(unSignList, LessonStatus.UN_START.getStatus());
        }
        if (finishedList.size() > 0) {
            studentLessonDao.batchUpdateKexiaoStatusBySign(finishedList, LessonStatus.FINISHED.getStatus());
        }

    }

    private Map<Long,Long> getClassCourseIdMap(Collection<Long> clazzIds){
        List<OrgCourse> classList = courseDao.getByIds(clazzIds, "id", "parentId", "courseType");
        Map<Long,Long> classCourseMap = new HashMap<>();
        for (OrgCourse clazz:classList){
            if(CourseTypeEnum.isOneToOne(clazz.getCourseType())){
                classCourseMap.put(clazz.getId(),clazz.getParentId());
            }else {
                classCourseMap.put(clazz.getId(),clazz.getId());
            }
        }
        return classCourseMap;
    }

    public void setKexiaoRule(final long courseId, final int rule) {
        redisTemplate.execute(new RedisCallback<Integer>() {
            @Override
            public Integer doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(TianXiaoConstant.TX_PV_REDIS_DB);
                RedisSerializer<String> serializer = getRedisSerializer();
                byte[] key = serializer.serialize(RedisKeyEnums.ERP.TX_ORG_KEXIAO_RULE.getRedisKey());
                byte[] field = serializer.serialize(String.valueOf(courseId));
                byte[] value = serializer.serialize(String.valueOf(rule));
                connection.hSet(key, field, value);
                return null;
            }
        });
    }

    public Integer getKexiaoRule(final long courseId) {
        String ruleStr = redisTemplate.execute(new RedisCallback<String>() {
            @Override
            public String doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(TianXiaoConstant.TX_PV_REDIS_DB);
                RedisSerializer<String> serializer = getRedisSerializer();
                byte[] keyBytes = serializer.serialize(RedisKeyEnums.ERP.TX_ORG_KEXIAO_RULE.getRedisKey());
                byte[] field = serializer.serialize(String.valueOf(courseId));
                byte[] value = connection.hGet(keyBytes, field);
                String rule = serializer.deserialize(value);
                log.info("[Kexiao] kexiao rule={},courseId={}", rule, courseId);
                return rule;
            }
        });
        if (StringUtils.isNotBlank(ruleStr)) {
            return Integer.parseInt(ruleStr);
        } else {
            return null;
        }
    }

    private void updateClassLessonStatus(List<OrgClassLesson> lessons) {

        List<Long> list = ListUtil.toKeyList(lessons, "courseId", OrgClassLesson.class);
        Map<Long,Long> classCourseMap = getClassCourseIdMap(list);

        Date now = new Date();
        Set<Long> unStartIds = new HashSet<>();
        Set<Long> finishedIds = new HashSet<>();
        log.info("[Kexiao] classCourseMap={},courseId={}", classCourseMap, list);
        Map<Long,OrgCourseConsumeRule> ruleMap = courseApiService.getClassRule(list);
        for (OrgClassLesson lesson : lessons) {
            Long courseId = classCourseMap.get(lesson.getCourseId());
            if(courseId==null){
                log.warn("[Kexiao] classId is {},courseId is null",lesson.getCourseId());
                continue;
            }
            OrgCourseConsumeRule rule = ruleMap.get(lesson.getCourseId());
            if (rule != null && rule.getRuleValue() > 0) {//>0为按签到算课消
                log.info("[Kexiao]Kexiao Rule={},courseId={}", rule, lesson.getCourseId());
                continue;
            }

            if (lesson.getStartTime().compareTo(now) <= 0) {
                finishedIds.add(lesson.getId());
            } else {
                unStartIds.add(lesson.getId());
            }
        }
        if (unStartIds.size() > 0) {
            studentLessonDao.batchUpdateKexiaoStatus(unStartIds, LessonStatus.UN_START.getStatus());
        }
        if (finishedIds.size() > 0) {
            studentLessonDao.batchUpdateKexiaoStatus(finishedIds, LessonStatus.FINISHED.getStatus());
        }
    }

    private class KexiaoRunnable implements Runnable{
        private long courseId;
        private int rule;

        public KexiaoRunnable(long courseId, int rule) {
            this.courseId = courseId;
            this.rule = rule;
        }

        @Override
        public void run() {
            log.info("[Kexiao] courseId={},rule={}", courseId, rule);
            List<Long> classIds = new ArrayList<>();
            OrgCourse course = courseDao.getById(courseId, "id", "parentId", "courseType","isClass","isCourse");
            if(CourseTypeEnum.IS_CLASS_FALSE.getCode()==course.getIsClass()
                    && CourseTypeEnum.IS_COURSE_TRUE.getCode()==course.getIsCourse()){
                classIds = courseDao.getClassIdsByParentId(courseId);
            }else {
                classIds.add(courseId);
            }

            log.info("[Kexiao] classIds is {}",classIds);

            if(classIds==null || classIds.size()<1){
                return;
            }

            if(rule>0){//按签到算课消
                List<OrgLessonSign> signs = orgLessonSignDao.getCourseLessonSignIn(classIds);
                List<OrgLessonSign> finishedSigns = new ArrayList<>();
                List<OrgStudentLesson> lessons = studentLessonDao.getOrgStudentLessonsByCourseIds(classIds);
                if(signs!=null){
                    for (Iterator<OrgLessonSign> iterator = signs.iterator();iterator.hasNext();){
                        OrgLessonSign sign = iterator.next();
                        LessonStatus status = kexiaoApiService.getKexiaoStatus(sign,rule);
                        if(status==LessonStatus.FINISHED){
                            finishedSigns.add(sign);
                        }
                    }
                }
                removeSign(lessons, finishedSigns);
                List<OrgLessonSign> unSigns = convertToLessonSigns(lessons);
                log.info("[Kexiao] un_start={},finished={}",unSigns,finishedSigns);
                studentLessonDao.batchUpdateKexiaoStatusBySign(unSigns, LessonStatus.UN_START.getStatus());
                studentLessonDao.batchUpdateKexiaoStatusBySign(finishedSigns, LessonStatus.FINISHED.getStatus());
            }else {//按开课时间算课消
                List<OrgClassLesson> classLessons = classLessonDao.getLessonByCourseIds(classIds,null);
                updateClassLessonStatus(classLessons);
            }
        }

        /**
         * 从学生课节中移除已计算课消的课节
         * @param lessons
         * @param finishedSigns
         */
        private void removeSign(List<OrgStudentLesson> lessons,List<OrgLessonSign> finishedSigns){
            if(lessons==null || lessons.isEmpty() || finishedSigns==null || finishedSigns.isEmpty()){
                return;
            }
            Map<String,OrgStudentLesson> lessonMap = new HashMap<>();
            for (OrgStudentLesson lesson:lessons){
                lessonMap.put(lesson.getUserId()+"_"+lesson.getLessonId(),lesson);
            }
            for (OrgLessonSign sign:finishedSigns){
                OrgStudentLesson lessonSign = lessonMap.get(sign.getUserId()+"_"+sign.getLessonId());
                if(lessonSign!=null){
                    lessons.remove(lessonSign);
                }
            }
        }

        private List<OrgLessonSign> convertToLessonSigns(List<OrgStudentLesson> lessons){
            List<OrgLessonSign> result = new ArrayList<>();
            if(lessons!=null) {
                for (OrgStudentLesson lesson : lessons) {
                    OrgLessonSign sign = new OrgLessonSign();
                    sign.setLessonId(lesson.getLessonId());
                    sign.setUserId(lesson.getUserId());
                    result.add(sign);
                }
            }
            return result;
        }

    }

    @Override
    public void updateStudentLesson() {
        boolean isAllowed = updateTimePerOneMinuteSemaphore.tryAcquire();
        if (!isAllowed) {
            log.info("[KexiaoStatus] Other thread is execute.");
            return;
        }
        long start = System.currentTimeMillis();
        try {
            Date date = getUpdateTime(RedisKeyEnums.ERP.TX_ORG_STU_LESSON_UPDATE_HSET.getRedisKey());
            Date current = new Date();
            if (date == null) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(Calendar.MINUTE, -30);
                date = calendar.getTime();
            }
            syncStudentLessonsByLastTime(date,current);
            setUpdateTime(String.valueOf(current.getTime()),RedisKeyEnums.ERP.TX_ORG_STU_LESSON_UPDATE_HSET.getRedisKey());
        } finally {
            updateTimePerOneMinuteSemaphore.release();
        }
        log.info("[KexiaoStatus] Execute time={}ms",(System.currentTimeMillis()-start));
    }

    @Override
    public void updateStudentLessonByTime(int beforeMinute) {
        boolean isAllowed = updateTimePerFiveMinuteSemaphore.tryAcquire();
        if (!isAllowed) {
            log.info("[KexiaoStatus] Other thread is execute.");
            return;
        }
        long start = System.currentTimeMillis();
        try {
            Date date = getUpdateTime(RedisKeyEnums.ERP.TX_ORG_STU_LESSON_UPDATE_TIME_FIVE.getRedisKey());
            if(date==null){
                date = new Date();
            }
            Date current = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(Calendar.MINUTE, -beforeMinute);
            date = calendar.getTime();
            syncStudentLessonsByLastTime(date,current);
            setUpdateTime(String.valueOf(current.getTime()),RedisKeyEnums.ERP.TX_ORG_STU_LESSON_UPDATE_TIME_FIVE.getRedisKey());
        } finally {
            updateTimePerFiveMinuteSemaphore.release();
        }
        log.info("[KexiaoStatus] Execute time={}ms,beforeMinute={}m",(System.currentTimeMillis()-start),beforeMinute);
    }


    public void syncStudentLessonsByLastTime(Date startTime,Date endTime){
        log.info("[KexiaoStatus] Execute startTime={},currentTime={}", startTime, new Date());
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(1000);
        List<OrgStudentLesson> studentLessons = studentLessonDao.getStudentLessonsByPage(startTime,endTime,pageDto);
        while (studentLessons != null && studentLessons.size() > 0) {
            Map<Long, List<Long>> map = new HashMap<>();
            for (OrgStudentLesson lesson : studentLessons) {
                List<Long> userIds = map.get(lesson.getLessonId());
                if (userIds == null) {
                    userIds = new ArrayList<>();
                    map.put(lesson.getLessonId(), userIds);
                }
                userIds.add(lesson.getUserId());
            }
            log.info("[KexiaoStatus] update lesson and userId={}", map);
            List<OrgClassLesson> classLessons = classLessonDao.getByIds(map.keySet());
            if (classLessons != null) {
                updateStudentLessons(studentLessons,classLessons);
                for (OrgClassLesson classLesson : classLessons) {
                    List<Long> userIds = map.get(classLesson.getId());
                    List<StudentLessonStatistics> statisticsList = studentLessonDao.getStudentLessonCounter(
                            classLesson.getOrgId().longValue(), userIds, classLesson.getCourseId());
                    Map<Long,StudentLessonStatistics> studentLessonStatisticsMap = CollectionHelper.toKeyMap(statisticsList,"userId");
                    if (userIds != null && userIds.size() > 0) {
                        for (Long userId : userIds) {
                            StudentLessonStatistics statistics = studentLessonStatisticsMap.get(userId);
                            if (statistics == null) {
                                statistics = new StudentLessonStatistics();
                                statistics.setOrgId(classLesson.getOrgId());
                                statistics.setUserId(userId);
                                statistics.setCourseId(classLesson.getCourseId());
                            }
                            try {
                                studentQuery.add(SolrConstant.CRM_STUDENT_COLLECTION, toMap(statistics));
                            } catch (SolrServerException e) {
                                log.error("[KexiaoStatus] SolrServerException", e);
                            } catch (IOException e) {
                                log.error("[KexiaoStatus] IOException", e);
                            }
                        }
                    }
                }
            }
            pageDto.setPageNum(pageDto.getPageNum() + 1);
            studentLessons = studentLessonDao.getStudentLessonsByPage(startTime,endTime,pageDto);
        }
    }

    private void updateStudentLessons(List<OrgStudentLesson> stuLessons,List<OrgClassLesson> classLessons){
        Map<Long,OrgClassLesson> classLessonMap = new HashMap<>();
        Set<Long> classIds = new HashSet<>();
        for(OrgClassLesson classLesson:classLessons){
            classLessonMap.put(classLesson.getId(),classLesson);
            classIds.add(classLesson.getCourseId());
        }
        Map<Long,List<Long>> retMap = new HashMap<>();
        Map<Long,OrgCourseConsumeRule> ruleMap = courseApiService.getClassRule(classIds);

        Set<Long> finishedIds = Sets.newHashSet();
        Set<Long> unStartedIds = Sets.newHashSet();

        Date now = new Date();
        for (OrgStudentLesson studentLesson:stuLessons){
            OrgClassLesson lesson = classLessonMap.get(studentLesson.getLessonId());
            if(lesson!=null){
                OrgCourseConsumeRule rule = ruleMap.get(lesson.getCourseId());
                if(rule==null || rule.getRuleValue()==0){//只有课消规则为时间到算课消的才需要处理
                    if(lesson.getStartTime().compareTo(now)<=0 ){
                        if(studentLesson.getKexiaoStatus()!=LessonStatus.FINISHED.getStatus()) {
                            finishedIds.add(studentLesson.getId());
                        }
                    }else {
                        if(studentLesson.getKexiaoStatus()!=LessonStatus.UN_START.getStatus()) {
                            unStartedIds.add(studentLesson.getId());
                        }
                    }
                }
            }
        }
        log.info("[KexiaoStatus] finishedIds={},unStartedIds={}", finishedIds,unStartedIds);
        if(!finishedIds.isEmpty()){
            studentLessonDao.batchUpdateKexiaoStatusById(finishedIds, LessonStatus.FINISHED.getStatus());
        }

        if(!unStartedIds.isEmpty()){
            studentLessonDao.batchUpdateKexiaoStatusById(unStartedIds, LessonStatus.UN_START.getStatus());
        }

        for (OrgStudentLesson studentLesson:stuLessons){
            List<Long> list = retMap.get(studentLesson.getOrgId());
            if(list==null){
                list = new ArrayList<>();
                retMap.put(studentLesson.getOrgId(), list);
            }
            list.add(studentLesson.getId());
        }

        Set<Long> keySet = retMap.keySet();

        for (Long orgId:keySet){
            changeLogService.addModifyStuLessonsLog(orgId,retMap.get(orgId));
        }

    }

    private Map<String, Object> toMap(StudentLessonStatistics counter) {
        Map<String, Object> map = new HashMap<>();
        map.put("id", counter.getId());
        map.put("org_id", counter.getOrgId());
        map.put("student_id", counter.getUserId());
        map.put("course_id", counter.getCourseId());
        map.put("total", counter.getTotalCount());
        map.put("finished", counter.getFinishedCount());
        map.put("left_count", counter.getLeftCount());
        map.put("left_time", counter.getLeftTime());
        map.put("finished_time", counter.getFinishedTime());
        map.put("total_time", counter.getTotalTime());
        return map;
    }

    public void setUpdateTime(final String updateTime,final String key) {
        redisTemplate.execute(new RedisCallback<Integer>() {
            @Override
            public Integer doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(TianXiaoConstant.TX_PV_REDIS_DB);
                RedisSerializer<String> serializer = getRedisSerializer();
                byte[] keyBytes = serializer.serialize(key);
                byte[] value = serializer.serialize(updateTime);
                connection.set(keyBytes, value);
                log.info("[Redis] Set student lesson updateTime={}", updateTime);
                return null;
            }
        });
    }

    public Date getUpdateTime(final String key) {
        String dateStr = redisTemplate.execute(new RedisCallback<String>() {
            @Override
            public String doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(TianXiaoConstant.TX_PV_REDIS_DB);
                RedisSerializer<String> serializer = getRedisSerializer();
                byte[] keyBytes = serializer.serialize(key);
                byte[] value = connection.get(keyBytes);
                String updateTime = serializer.deserialize(value);
                return updateTime;
            }
        });
        if (StringUtils.isNotBlank(dateStr)) {
            Date date = new Date(Long.parseLong(dateStr));
            log.info("[Redis] Set student lesson updateTime={}", date);
            return date;
        } else {
            return null;
        }
    }

    @Override
    public void reviseKexiaoStatus(Date startTime,Date endTime) {
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(1000);
        List<OrgLessonSign> signList = orgLessonSignDao.listByPage(startTime,endTime,pageDto);
        log.info("[KexiaoStatus] Revise kexiao status.pageDto={}",pageDto);
        while (signList.size()>0){
            log.info("[KexiaoStatus] Revise kexiao status.pageDto={}",pageDto);
            updateClassLessonStatusBySignUp(signList);
            pageDto.setPageNum(pageDto.getPageNum() + 1);
            signList = orgLessonSignDao.listByPage(startTime,endTime,pageDto);
        }
    }

}