/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.student.dto.response;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldSection;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author gaodan
 * @createdate 2016年8月9日
 * @desc 自定义字段，添加学员详情时，只返回前端需要的字段 从orgStudentInfo抽取而来
 */
@Data
@EqualsAndHashCode(callSuper=true)
public class OrgStudentResponse extends KexiaoStatisticsSuper {
    private Long consultUserId;

    private String consultUserIds;

    private Long studentId;

    private Integer status;

    private Date lastFollowDate;
    
    private Long studentNumber;

    private Double payMoney; // 消费总额

    private Integer totalClassTime; // 总课次

    private Integer finishClassTime; // 已完成课次

    private Integer sumClasses;// 已报班级

    private List<CommentInfoDto> commentsResp;

    // 机构是否可以与学员进行微信聊天
    private int chat = 0;

    private String province; // 省份

    private String city; // 市

    private String county; // 区

    private Long areaId; // 地域id

    private String weixin;

    private List<CustomFieldSection> sections;
    private List<CustomFieldDto> fields = new ArrayList<>();

    private String headTeacher;

    private String cascadeIdStr;

    private Integer allowToSms;

    private Integer allowViewBalance;

    // 课消2.0新接口 begin ----
    private String tipInfo; // 学员详情页展示的提示语
    private String tipInfoUrl;// 跳转链接
    // private List<String> kexiaoRecord; // 课次消费展示
    // private Double remainTuition; // 剩余学费
    private Double balance; // 学员账户余额
    // 课消2.0新接口 end ----
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
        
    @Override
    public String toString() {
        return "OrgStudentResponse [consultUserId=" + consultUserId + ", consultUserIds=" + consultUserIds
            + ", studentId=" + studentId + ", studentNumber=" + studentNumber + ", payMoney=" + payMoney
            + ", totalClassTime=" + totalClassTime + ", finishClassTime=" + finishClassTime + ", sumClasses="
            + sumClasses + ", commentsResp=" + commentsResp + ", chat=" + chat + ", province=" + province + ", city="
            + city + ", county=" + county + ", areaId=" + areaId + ", weixin=" + weixin + ", sections=" + sections
            + ", fields=" + fields + ", headTeacher=" + headTeacher + ", allowToSms=" + allowToSms + ", tipInfo="
            + tipInfo + ", tipInfoUrl=" + tipInfoUrl + ", balance=" + balance + ", toString()=" + super.toString()
            + "]";
    }
    
    

}
