package com.baijia.tianxiao.biz.student.syn.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.student.syn.service.SyncDataService;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.StudentStatusStatisticsByDay;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.sync.dao.TxStudentStatusDao;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;

import lombok.extern.slf4j.Slf4j;

@Service("syncStudentStatusService")
@Slf4j
public class SyncStudentStatusServiceImpl implements SyncDataService {
    
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private TxStudentStatusDao txStudentStatusDao;
    
    private AtomicBoolean flag = new AtomicBoolean(false);

    @Override
    public void sync(List<Integer> orgNumbers) {
        try {
            if (!flag.get()) {
                flag.set(true);
                syncStudentStatusByDay(orgNumbers);
                flag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", e);
        } finally {
            flag.set(false);
        }
    }

    private void syncStudentStatusByDay(List<Integer> orgNumbers) {
        //获得全部天校机构id
        List<OrgAccount> orgAccont = orgAccountDao.getAccountByNumbers(orgNumbers);
        List<Integer> orgIds = Lists.newArrayList();
        for(OrgAccount o: orgAccont){
            orgIds.add(o.getId());
        }
        List<StudentStatusStatisticsByDay> list = Lists.newArrayList();
        Map<Integer, Integer> studying = orgStudentDao.getStatisticsDayByLessonStatus(StudentLessonStatus.STUDYING.getStatus(),orgIds);
        Map<Integer, Integer> past = orgStudentDao.getStatisticsDayByLessonStatus(StudentLessonStatus.PAST.getStatus(),orgIds);
        Map<Integer, Integer> toCharge = orgStudentDao.getStatisticsDayByLessonStatus(StudentLessonStatus.TO_CHARGE.getStatus(),orgIds);
        for(Integer i: orgIds){
            int studyingCount = studying.get(i)!=null?studying.get(i):0;
            int pastCount = past.get(i)!=null?past.get(i):0;
            int toChargeCount = toCharge.get(i)!=null?toCharge.get(i):0;
            StudentStatusStatisticsByDay s = new StudentStatusStatisticsByDay();
            s.setOrgId(i);
            s.setCreateTime(DateUtil.getDiffDateTime(new Date(), -1));
            s.setStudyingCount(studyingCount);
            s.setPastCount(pastCount);
            s.setTochargeCount(toChargeCount);
            s.setAllCount(studyingCount+pastCount+toChargeCount);
            list.add(s);
        }
        //批量同步
        txStudentStatusDao.saveAll(list);
    }

}
