/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.student.msg.service.impl;

import com.baijia.tianxiao.biz.student.msg.MessageType;
import com.baijia.tianxiao.biz.student.msg.service.OrgStudentMessageConsumeService;
import com.baijia.tianxiao.dal.callservice.constant.CallServiceCdrStatus;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceInfoDao;
import com.baijia.tianxiao.dal.callservice.po.CallServiceInfo;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.constant.DownLoadStatus;
import com.baijia.tianxiao.dal.roster.constant.MobileStatus;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sal.student.util.JsonUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

import lombok.extern.slf4j.Slf4j;

/**
 * @title OrgStudentMessageConsumeServiceImpl
 * @desc TODO
 * @author shanyu
 * @date 2015年12月9日
 * @version 1.0
 */
@Slf4j
@Service
public class OrgCallServiceConsumeServiceImpl implements OrgStudentMessageConsumeService {

    @Autowired
    private OrgAccountDao orgAccountDao;

    @Autowired
    private UserDao userDao;

    @Autowired
    private TxConsultUserDao txConsultUserDao;

    @Autowired
    private CallServiceInfoDao callServiceInfoDao;

    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    
    @Override
    public int getMessageType() {
        return MessageType.CALL.getValue();
    }

    @Override
    public boolean consumeMessage(String messageBody) {
    	CallServiceInfo callServiceInfo = null;
    	try{
    		callServiceInfo = JacksonUtil.str2Obj(messageBody, CallServiceInfo.class);
    	}catch(Exception e){
    		 Long callId = getCallId(messageBody);//兼容20161017之前的本的消息体(消息体中只包含id)  20161018之后此处代码可下线
    		 if(callId>0){
    			 callServiceInfo = this.callServiceInfoDao.getById(callId);
    		 }
    	}
        
        if (callServiceInfo == null) {
        	log.error("consume - return false by callServiceInfo is null - messageBody:{}",messageBody);
            return false;
        }
        return consume(callServiceInfo);
    }

    private Long getCallId(String messageBody) {
        try {
            Long callId = Long.parseLong(messageBody);
            return callId;
        } catch (Exception e) {
            log.info("student call message format error! messageBody={}", messageBody);
            return -1l;
        }
    }

    public boolean consume(CallServiceInfo callServiceInfo) {
        Long callId = callServiceInfo.getId();
        TxStudentComment comment = new TxStudentComment();
        Long orgId = callServiceInfo.getCallSubscriber();// 主叫方id
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue());
        if (orgAccount == null) {
        	log.error("consume - return false by org account is null callId:{}",callId);
            return false;
        }
        comment.setOrgId(orgId);
        Long studentId = callServiceInfo.getCalledParty(); // 被叫方id
        String mobile = callServiceInfo.getCalledPartyNum(); // 被叫方电话
        if (studentId > 0) {
            User user = this.userDao.getById(studentId);
            if (user != null) {
                List<TxConsultUser> list = this.txConsultUserDao.lookByUserId(orgId, studentId);
                if(CollectionUtils.isNotEmpty(list)) {
                    comment.setConsultUserId(list.get(0).getId()); 
                }else{
                	OrgStudent student = orgStudentDao.getStudent(orgId, mobile, studentId);
                	if(student!=null){
                		list = txConsultUserDao.lookByStudentId(orgId, student.getId());
                		if(CollectionUtils.isNotEmpty(list)){
                			comment.setConsultUserId(list.get(0).getId());
                		}
                	}
                }        
                comment.setUserId(studentId);
            } else {
            	log.info("consume - RETUEN FALSE callId:{}, studentId:{}, mobile:{}",callId, studentId, mobile);
                return false;
            }
        } else {
                List<TxConsultUser> consultUsers = this.txConsultUserDao.lookByMobile(orgId, mobile);
                if (CollectionUtils.isNotEmpty(consultUsers)) {
                    comment.setConsultUserId(consultUsers.get(0).getId());
                } else {
                	log.info("consume - RETUEN FALSE callId:{}, studentId:{}, mobile:{}",callId, studentId, mobile);
                    return false;
                }
        }
        
        log.info("consume - callId:{}, studentId:{}, mobile:{}, consultUserId:{}, callServiceInfo:{}",callId, studentId, mobile, comment.getConsultUserId(),callServiceInfo);
        		
        if (callServiceInfo.getCdrStatus() != null) {
            if (callServiceInfo.getCdrStatus().intValue() == CallServiceCdrStatus.CONNECTED.getCode()) {
                comment.setContent("机构回拨电话，已接通");
                if (callServiceInfo.getStorageId() > 0) {
                    comment.setSoundId(callServiceInfo.getStorageId());
                } else {
                    comment.setSoundId(callId);
                    comment.setDownStatus(DownLoadStatus.UNFINISH.getCode());
                }
                comment.setSeconds(callServiceInfo.getDuration());
                if(comment.getConsultUserId()!=null && comment.getConsultUserId().longValue()>0){
                	Date now = new Date();
                	TxConsultUser txConsultUser = txConsultUserDao.getById(comment.getConsultUserId());
                	txConsultUser.setLastRemindTime(now);
                	txConsultUser.setUpdateTime(now);
                	txConsultUserDao.update(txConsultUser);
                }
            } else if (callServiceInfo.getCdrStatus().intValue() == CallServiceCdrStatus.CALL_UNCONNECT.getCode()) {
                comment.setContent("机构回拨电话，已取消");
            } else if (callServiceInfo.getCdrStatus().intValue() == CallServiceCdrStatus.LISTENER_UNCONNECT.getCode()) {
                comment.setContent("机构回拨电话，未接通");
            } else {
            	log.info("consume - RETUEN FALSE");
                return false;
            }
            comment.setCallStatus(callServiceInfo.getCdrStatus().intValue());
            comment.setIsMobile(MobileStatus.IS_CALL.getCode());
            comment.setIsSystem(AddType.SYSTEM.getCode());
            comment.setOrigin(MessageSource.TELEPHONE.getValue());
        } else {
        	log.info("consume - RETUEN FALSE");
            return false;
        }
        this.txStudentCommentDao.save(comment, false);
        log.info("consume - SUCCESS - callId:{}",callId);
        return true;
    }
}
