
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.student.dto;

import java.util.Map;

import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Sep 19, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
public class DefaultSetInfoCallback extends AbstractSetInfoCallback<StudentInfoDto> {

    protected OrgStudentService orgStudentService;

    public DefaultSetInfoCallback(OrgStudentService orgStudentService) {
        this.orgStudentService = orgStudentService;
        this.init();
    }

    @Override
    public void setInfos(StudentInfoDto studentInfoDto, Map<String, Object> params) {
        log.info("params is : {} ", params);
        Long orgId = this.getParams(params, "orgId");
        Long studentId = this.getParams(params, "studentId");
        Integer cascadeId = this.getParams(params, "cascadeId");
        Integer applicationType = this.getParams(params, "applicationType");
        // 设置跟进记录
        this.orgStudentService.setStudentComment(studentInfoDto.getUserId(), orgId, studentInfoDto.getIsShowMobile(),
            studentInfoDto);
        // 机构是否可以与学员进行微信聊天
        this.orgStudentService.setFansInfo(studentId, orgId, studentInfoDto);
        // 设置学员标签信息
        this.orgStudentService.setStudentTags(studentInfoDto.getUserId(), orgId, studentInfoDto);
        // 设置课程数量及班主任信息
        this.orgStudentService.setHeaderAndClassNum(studentInfoDto.getUserId(), orgId, cascadeId, applicationType,
            studentInfoDto);
        // 设置课次消费信息
        this.orgStudentService.setClassHour(studentInfoDto.getUserId(), orgId, studentInfoDto);
        // 设置学员课程消费信息
        this.orgStudentService.setPayMoneyAndTimes(studentInfoDto.getUserId(), studentInfoDto.getOrgNumber(), orgId,
            studentInfoDto);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * com.baijia.tianxiao.biz.student.customStudentField.service.impl.AbstractSetInfoCallback#setInfosInSub(java.lang.
     * Object, java.util.Map)
     */

    @Override
    protected void setInfosInSub(StudentInfoDto instance, Map<String, Object> params) {

    }

}
