
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.student.dto;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

import com.google.common.collect.Maps;
import org.apache.commons.beanutils.BeanUtils;

import com.baijia.tianxiao.util.GenericsUtils;


import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Sep 19, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
public abstract class AbstractSetInfoCallback<T> implements SetInfoCallback<T> {

    private Map<Class<?>, String> fieldTypes = Maps.newHashMap();
    private boolean needFieldInit;

    private AtomicBoolean isInit = new AtomicBoolean(false);

    public AbstractSetInfoCallback() {
        this(false);
    }

    public AbstractSetInfoCallback(boolean needFieldInit) {
        this.needFieldInit = needFieldInit;
        if (needFieldInit) {
            Field[] declaredFields = this.getClass().getDeclaredFields();
            for (Field field : declaredFields) {
                if (field.getModifiers() != Modifier.STATIC) {
                    Type type = field.getType();
                    fieldTypes.put(type.getClass(), field.getName());
                }
            }
        }
    }

    @Override
    public void init(Object...injects) {
        if (this.needFieldInit) {
            if (isInit.compareAndSet(false, true)) {
                if (GenericsUtils.notNullAndEmpty(injects)) {
                    for (Object obj : injects) {
                        Class<?> objType = obj.getClass();
                        for (Class<?> fieldType : fieldTypes.keySet()) {
                            if (fieldType.isAssignableFrom(objType)) {
                                invokeSetField(obj, fieldTypes.get(fieldType));
                            }
                        }
                    }
                } else if (GenericsUtils.notNullAndEmpty(fieldTypes)) {
                    throw new RuntimeException(
                        String.format("un init for : %s for class:%s", fieldTypes.values(), this.getClass().getName()));
                }
            }
        }
        this.isInit.compareAndSet(false, true);
    }

    /**
     * @param obj
     * @param string
     */
    private void invokeSetField(Object obj, String fieldName) {
        try {
            BeanUtils.setProperty(this, fieldName, obj);
        } catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @SuppressWarnings("unchecked")
    public <V> V getParams(Map<String, Object> params, String key) {
        return (V) params.get(key);
    }

    public void setInfos(T instance, Map<String, Object> params) {
        log.info("current setter whether init : {} ", this.isInit.get());
        if (this.isInit.get()) {
            this.setInfosInSub(instance, params);
        } else if (GenericsUtils.notNullAndEmpty(fieldTypes)) {
            throw new IllegalArgumentException(
                String.format("un init for : %s for class:%s", fieldTypes.values(), this.getClass().getName()));
        }
    }

    protected abstract void setInfosInSub(T instance, Map<String, Object> params);

}
