/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.student.syn.service.impl;

import com.baijia.tianxiao.biz.student.syn.service.SyncDataService;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.StudentStatusStatisticsByDay;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.sync.dao.TxStudentStatusDao;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="syncStudentStatusService")
public class SyncStudentStatusServiceImpl
implements SyncDataService {
    private static final Logger log = LoggerFactory.getLogger(SyncStudentStatusServiceImpl.class);
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private TxStudentStatusDao txStudentStatusDao;
    private AtomicBoolean flag = new AtomicBoolean(false);

    @Override
    public void sync(List<Integer> orgNumbers) {
        try {
            if (!this.flag.get()) {
                this.flag.set(true);
                this.syncStudentStatusByDay(orgNumbers);
                this.flag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", (Throwable)e);
        }
        finally {
            this.flag.set(false);
        }
    }

    private void syncStudentStatusByDay(List<Integer> orgNumbers) {
        List orgAccont = this.orgAccountDao.getAccountByNumbers(orgNumbers, new String[0]);
        ArrayList orgIds = Lists.newArrayList();
        for (OrgAccount o : orgAccont) {
            orgIds.add(o.getId());
        }
        ArrayList list = Lists.newArrayList();
        Map studying = this.orgStudentDao.getStatisticsDayByLessonStatus(StudentLessonStatus.STUDYING.getStatus(), (List)orgIds);
        Map past = this.orgStudentDao.getStatisticsDayByLessonStatus(StudentLessonStatus.PAST.getStatus(), (List)orgIds);
        Map toCharge = this.orgStudentDao.getStatisticsDayByLessonStatus(StudentLessonStatus.TO_CHARGE.getStatus(), (List)orgIds);
        for (Integer i : orgIds) {
            int studyingCount = studying.get(i) != null ? (Integer)studying.get(i) : 0;
            int pastCount = past.get(i) != null ? (Integer)past.get(i) : 0;
            int toChargeCount = toCharge.get(i) != null ? (Integer)toCharge.get(i) : 0;
            StudentStatusStatisticsByDay s = new StudentStatusStatisticsByDay();
            s.setOrgId(i);
            s.setCreateTime(DateUtil.getDiffDateTime((Date)new Date(), (int)-1));
            s.setStudyingCount(Integer.valueOf(studyingCount));
            s.setPastCount(Integer.valueOf(pastCount));
            s.setTochargeCount(Integer.valueOf(toChargeCount));
            s.setAllCount(Integer.valueOf(studyingCount + pastCount + toChargeCount));
            list.add(s);
        }
        this.txStudentStatusDao.saveAll((List)list, new String[0]);
    }
}

