/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.student.syn.service.impl;

import com.baijia.tianxiao.biz.student.syn.service.StudentKexiaoService;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.redis.AbstractBaseRedisDao;
import com.baijia.tianxiao.sal.student.enums.LessonStatus;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ListUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StudentKexiaoServiceImpl
extends AbstractBaseRedisDao<String, Object>
implements StudentKexiaoService {
    private static final Logger log = LoggerFactory.getLogger(StudentKexiaoServiceImpl.class);
    private static final int PAGE_SIZE = 1000;
    private static final int UPDATE_TIME_TYPE = 1;
    private static final int START_TIME_TYPE = 2;
    private static final String TX_ORG_KEXIAO_RULE = "#TX#ORG#KEXIAO#RULE";
    @Autowired
    private OrgClassLessonDao classLessonDao;
    @Autowired
    private OrgStudentLessonDao studentLessonDao;
    @Autowired
    private OrgCourseConsumeRuleDao courseConsumeRuleDao;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private OrgCourseDao courseDao;
    private ExecutorService threadPool = Executors.newFixedThreadPool(10);
    private static final Semaphore updateTimeStuLessonStatusSemaphore = new Semaphore(1);
    private static final Semaphore startTimeStuLessonStatusSemaphore = new Semaphore(1);

    private List<OrgStudentCourse> getStudentCourseListBySignUp() {
        return null;
    }

    @Override
    public void refreshKexiaoRule(int beforeMinutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -1 * beforeMinutes);
        List rules = this.courseConsumeRuleDao.queryConsumRuleListByUpdateTime(calendar.getTime());
        if (rules != null) {
            for (OrgCourseConsumeRule rule : rules) {
                Integer oldRule = this.getKexiaoRule(rule.getCourseId());
                if (!rule.getRuleValue().equals(oldRule)) {
                    this.threadPool.submit(new KexiaoRunnable(rule.getCourseId(), rule.getRuleValue()));
                }
                this.setKexiaoRule(rule.getCourseId(), rule.getRuleValue());
            }
        }
        log.info("[Kexiao] Refresh kexiao rule.");
    }

    @Override
    public void updateClassLessonStatusBySignUp(List<OrgLessonSign> lessonSigns) {
        if (lessonSigns != null && lessonSigns.size() < 1) {
            return;
        }
        List list = ListUtil.toKeyList(lessonSigns, (String)"courseId", OrgLessonSign.class);
        Map<Long, Long> classCourseMap = this.getClassCourseIdMap(list);
        ArrayList<OrgLessonSign> unSignList = new ArrayList<OrgLessonSign>();
        ArrayList<OrgLessonSign> finishedList = new ArrayList<OrgLessonSign>();
        for (OrgLessonSign sign : lessonSigns) {
            Integer rule = this.getKexiaoRule(classCourseMap.get(sign.getCourseId()));
            if (rule == null || rule <= 0) continue;
            LessonStatus status = this.getKexiaoStatus(sign, rule);
            if (status == LessonStatus.FINISHED) {
                finishedList.add(sign);
                continue;
            }
            unSignList.add(sign);
        }
        if (unSignList.size() > 0) {
            this.studentLessonDao.batchUpdateKexiaoStatusBySign(unSignList, LessonStatus.UN_START.getStatus());
        }
        if (finishedList.size() > 0) {
            this.studentLessonDao.batchUpdateKexiaoStatusBySign(finishedList, LessonStatus.FINISHED.getStatus());
        }
    }

    private Map<Long, Long> getClassCourseIdMap(Collection<Long> clazzIds) {
        List classList = this.courseDao.getByIds(clazzIds, new String[]{"id", "parentId", "courseType"});
        HashMap<Long, Long> classCourseMap = new HashMap<Long, Long>();
        for (OrgCourse clazz : classList) {
            if (CourseTypeEnum.isOneToOne((Integer)clazz.getCourseType())) {
                classCourseMap.put(clazz.getId(), clazz.getParentId());
                continue;
            }
            classCourseMap.put(clazz.getId(), clazz.getId());
        }
        return classCourseMap;
    }

    private LessonStatus getKexiaoStatus(OrgLessonSign sign, int rule) {
        int byteCode = 0;
        if (sign.getStatus().intValue() == SignStatus.SIGNED.getCode()) {
            byteCode = 1;
        } else if (sign.getStatus().intValue() == SignStatus.LEAVE.getCode()) {
            byteCode = 2;
        } else if (sign.getStatus().intValue() == SignStatus.ABSENT.getCode()) {
            byteCode = 4;
        } else {
            log.info("[Kexiao] UnSign.sign={}", (Object)sign);
        }
        int result = byteCode & rule;
        if (result > 0) {
            return LessonStatus.FINISHED;
        }
        return LessonStatus.UN_START;
    }

    public void setKexiaoRule(final long courseId, final int rule) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Integer>(){

            public Integer doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = StudentKexiaoServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)StudentKexiaoServiceImpl.TX_ORG_KEXIAO_RULE);
                byte[] field = serializer.serialize((Object)String.valueOf(courseId));
                byte[] value = serializer.serialize((Object)String.valueOf(rule));
                connection.hSet(key, field, value);
                return null;
            }
        });
    }

    public Integer getKexiaoRule(final long courseId) {
        String ruleStr = (String)this.redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = StudentKexiaoServiceImpl.this.getRedisSerializer();
                byte[] keyBytes = serializer.serialize((Object)StudentKexiaoServiceImpl.TX_ORG_KEXIAO_RULE);
                byte[] field = serializer.serialize((Object)String.valueOf(courseId));
                byte[] value = connection.hGet(keyBytes, field);
                String rule = (String)serializer.deserialize(value);
                log.info("[Kexiao] kexiao rule={},courseId={}", (Object)rule, (Object)courseId);
                return rule;
            }
        });
        if (StringUtils.isNotBlank((String)ruleStr)) {
            return Integer.parseInt(ruleStr);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void syncClassLessonStatus(int beforeMinutes, int type) {
        log.info("[Kexiao] Start===============");
        long begin = System.currentTimeMillis();
        if (type == 1) {
            boolean isUpdateTimeAllowed = updateTimeStuLessonStatusSemaphore.tryAcquire();
            if (!isUpdateTimeAllowed) {
                log.info("[Kexiao] Other thread is execute.");
                return;
            }
        } else {
            boolean isStartTimeAllowed = startTimeStuLessonStatusSemaphore.tryAcquire();
            if (!isStartTimeAllowed) {
                log.info("[Kexiao] Other thread is execute.");
                return;
            }
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.add(12, -1 * beforeMinutes);
            PageDto pageDto = new PageDto();
            pageDto.setPageSize(Integer.valueOf(1000));
            Date now = new Date();
            List lessons = null;
            lessons = type == 1 ? this.classLessonDao.getOrgClassLessonsByUpdateTime(calendar.getTime(), now, pageDto) : this.classLessonDao.getOrgClassLessonsByStartTime(calendar.getTime(), now, pageDto);
            log.info("[Kexiao]Executing===============");
            while (lessons != null && lessons.size() > 0) {
                this.updateClassLessonStatus(lessons);
                pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
                if (type == 1) {
                    lessons = this.classLessonDao.getOrgClassLessonsByUpdateTime(calendar.getTime(), now, pageDto);
                    continue;
                }
                lessons = this.classLessonDao.getOrgClassLessonsByStartTime(calendar.getTime(), now, pageDto);
            }
        }
        finally {
            if (type == 1) {
                updateTimeStuLessonStatusSemaphore.release();
            } else {
                startTimeStuLessonStatusSemaphore.release();
            }
        }
        log.info("[Kexiao] cost={}", (Object)(System.currentTimeMillis() - begin));
    }

    private void updateClassLessonStatus(List<OrgClassLesson> lessons) {
        List list = ListUtil.toKeyList(lessons, (String)"courseId", OrgClassLesson.class);
        Map<Long, Long> classCourseMap = this.getClassCourseIdMap(list);
        Date now = new Date();
        HashSet<Long> unStartIds = new HashSet<Long>();
        HashSet<Long> finishedIds = new HashSet<Long>();
        log.info("[Kexiao] classCourseMap={},courseId={}", classCourseMap, (Object)list);
        for (OrgClassLesson lesson : lessons) {
            Long courseId = classCourseMap.get(lesson.getCourseId());
            if (courseId == null) {
                log.warn("[Kexiao] classId is {},courseId is null", (Object)lesson.getCourseId());
                continue;
            }
            Integer rule = this.getKexiaoRule(courseId);
            if (rule != null && rule > 0) {
                log.info("[Kexiao]Kexiao Rule={},courseId={}", (Object)rule, (Object)lesson.getCourseId());
                continue;
            }
            if (lesson.getStartTime().compareTo(now) <= 0) {
                finishedIds.add(lesson.getId());
                continue;
            }
            unStartIds.add(lesson.getId());
        }
        if (unStartIds.size() > 0) {
            this.studentLessonDao.batchUpdateKexiaoStatus(unStartIds, LessonStatus.UN_START.getStatus());
        }
        if (finishedIds.size() > 0) {
            this.studentLessonDao.batchUpdateKexiaoStatus(finishedIds, LessonStatus.FINISHED.getStatus());
        }
    }

    private class KexiaoRunnable
    implements Runnable {
        private long courseId;
        private int rule;

        public KexiaoRunnable(long courseId, int rule) {
            this.courseId = courseId;
            this.rule = rule;
        }

        @Override
        public void run() {
            log.info("[Kexiao] courseId={},rule={}", (Object)this.courseId, (Object)this.rule);
            List classIds = new ArrayList<Long>();
            OrgCourse course = (OrgCourse)StudentKexiaoServiceImpl.this.courseDao.getById((Serializable)Long.valueOf(this.courseId), new String[]{"id", "parentId", "courseType", "isClass", "isCourse"});
            if (CourseTypeEnum.IS_CLASS_FALSE.getCode() == course.getIsClass() && CourseTypeEnum.IS_COURSE_TRUE.getCode() == course.getIsCourse()) {
                classIds = StudentKexiaoServiceImpl.this.courseDao.getClassIdsByParentId(Long.valueOf(this.courseId));
            } else {
                classIds.add(this.courseId);
            }
            log.info("[Kexiao] classIds is {}", classIds);
            if (classIds == null || classIds.size() < 1) {
                return;
            }
            if (this.rule > 0) {
                List signs = StudentKexiaoServiceImpl.this.orgLessonSignDao.getCourseLessonSignIn(classIds);
                ArrayList<OrgLessonSign> finishedSigns = new ArrayList<OrgLessonSign>();
                List lessons = StudentKexiaoServiceImpl.this.studentLessonDao.getOrgStudentLessonsByCourseIds(classIds);
                if (signs != null) {
                    for (OrgLessonSign sign : signs) {
                        LessonStatus status = StudentKexiaoServiceImpl.this.getKexiaoStatus(sign, this.rule);
                        if (status != LessonStatus.FINISHED) continue;
                        finishedSigns.add(sign);
                    }
                }
                this.removeSign(lessons, finishedSigns);
                List<OrgLessonSign> unSigns = this.convertToLessonSigns(lessons);
                log.info("[Kexiao] un_start={},finished={}", unSigns, finishedSigns);
                StudentKexiaoServiceImpl.this.studentLessonDao.batchUpdateKexiaoStatusBySign(unSigns, LessonStatus.UN_START.getStatus());
                StudentKexiaoServiceImpl.this.studentLessonDao.batchUpdateKexiaoStatusBySign(finishedSigns, LessonStatus.FINISHED.getStatus());
            } else {
                List classLessons = StudentKexiaoServiceImpl.this.classLessonDao.getLessonByCourseIds(classIds);
                StudentKexiaoServiceImpl.this.updateClassLessonStatus(classLessons);
            }
        }

        private void removeSign(List<OrgStudentLesson> lessons, List<OrgLessonSign> finishedSigns) {
            if (lessons == null || lessons.isEmpty() || finishedSigns == null || finishedSigns.isEmpty()) {
                return;
            }
            HashMap<String, OrgStudentLesson> lessonMap = new HashMap<String, OrgStudentLesson>();
            for (OrgStudentLesson lesson : lessons) {
                lessonMap.put(lesson.getUserId() + "_" + lesson.getLessonId(), lesson);
            }
            for (OrgLessonSign sign : finishedSigns) {
                OrgStudentLesson lessonSign = (OrgStudentLesson)lessonMap.get(sign.getUserId() + "_" + sign.getLessonId());
                if (lessonSign == null) continue;
                lessons.remove(lessonSign);
            }
        }

        private List<OrgLessonSign> convertToLessonSigns(List<OrgStudentLesson> lessons) {
            ArrayList<OrgLessonSign> result = new ArrayList<OrgLessonSign>();
            if (lessons != null) {
                for (OrgStudentLesson lesson : lessons) {
                    OrgLessonSign sign = new OrgLessonSign();
                    sign.setLessonId(lesson.getLessonId());
                    sign.setUserId(lesson.getUserId());
                    result.add(sign);
                }
            }
            return result;
        }
    }
}

