/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.student.customStudentField.service.impl;

import com.baijia.tianxiao.biz.student.customStudentField.service.BizCustomFieldService;
import com.baijia.tianxiao.biz.student.dto.DefaultSetInfoCallback;
import com.baijia.tianxiao.biz.student.dto.SetInfoCallback;
import com.baijia.tianxiao.biz.student.dto.response.OrgStudentInfo;
import com.baijia.tianxiao.biz.student.dto.response.OrgStudentResponse;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.dal.roster.constant.PauseStatus;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.consult.service.ConsultSourceService;
import com.baijia.tianxiao.sal.organization.constant.CascadeSearchSource;
import com.baijia.tianxiao.sal.organization.org.dto.AccountSelectionDto;
import com.baijia.tianxiao.sal.organization.org.dto.TxCascadeCredentialSelectionDto;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldValueService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFieldValues.OrgUserBaseInfo;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldValueRequest;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldValueResponse;
import com.baijia.tianxiao.sal.student.dto.customFields.FieldOption;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.sal.student.enums.CustomFieldType;
import com.baijia.tianxiao.sal.student.enums.RequireStatus;
import com.baijia.tianxiao.sal.student.enums.SpecialFieldEnum;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizCustomFieldServiceImpl
implements BizCustomFieldService {
    private static final Logger log = LoggerFactory.getLogger(BizCustomFieldServiceImpl.class);
    @Autowired
    private OrgStudentService orgStudentService;
    @Autowired
    private CustomFieldValueService customFieldValueService;
    @Autowired
    private CustomFieldValueDao customFieldValueDao;
    @Autowired
    private TxCascadeCredentialService orgTxCascadeCredentialService;
    @Autowired
    private ConsultSourceService consultSourceService;
    @Autowired
    private TXSaleClueRuleService saleClueRuleService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCommonRuleService txCommonRuleService;

    @Override
    public Object listCustomFields(Long orgId, Integer customType) {
        return null;
    }

    @Override
    public OrgStudentResponse getOrgStudentInfo(Long studentId, Integer cascadeId, Long orgId, Integer applicationType) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        if (studentId == -1L) {
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId);
        } else {
            StudentCommenRequestDto studentCommenRequestDto = this.buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            log.info("studentCommenRequestDto param:{}", (Object)studentCommenRequestDto);
            StudentInfoDto studentInfoDto = this.orgStudentService.getStudentInfo(studentCommenRequestDto, orgId, cascadeId);
            log.info("studentInfoDto param:{}", (Object)studentInfoDto);
            orgStudentInfo = this.buildOrgStudentInfo(studentInfoDto);
            log.info("orgStudentInfo param:{}, city parm:{}", (Object)orgStudentInfo.getProvince());
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId);
        }
        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>(){

            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }
        });
        this.addSpecialFieldForStudent(orgStudentInfo, cascadeId, orgId.intValue(), studentId);
        OrgStudentResponse reponse = this.buildOrgStudentResponse(orgStudentInfo);
        TXCascadeAccount loginer = null;
        if (cascadeId != null && cascadeId > 0) {
            loginer = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
        }
        if (loginer != null && (CampusAccountType.getTypeByCode((int)loginer.getAccountType()) == CampusAccountType.DIRECTOR || CampusAccountType.getTypeByCode((int)loginer.getAccountType()) == CampusAccountType.STAFF)) {
            TXCommonRule txCommonRule = this.txCommonRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
            if (txCommonRule.getStudentMobileRule() == 1) {
                reponse.setAllowToSms(Flag.FALSE.getInt());
            }
        } else {
            reponse.setAllowToSms(Flag.TRUE.getInt());
        }
        return reponse;
    }

    private void addSpecialFieldForStudent(OrgStudentInfo orgStudentInfo, Integer cascadeId, Integer orgId, Long studentId) {
        Long cascadeLong = 0L;
        if (cascadeId != null) {
            cascadeLong = cascadeId.longValue();
        }
        ArrayList<FieldOption> optionList = new ArrayList<FieldOption>();
        List list = this.orgTxCascadeCredentialService.getTxCascadeCredentialList(orgId, cascadeLong, CascadeSearchSource.STUDENT_FILTER, new AccountSelectionDto());
        log.info("find all list : {} ", (Object)list);
        Integer addCascadeId = orgStudentInfo.getAddCascadeId();
        log.info("addCascadeSingle is :{} ", (Object)addCascadeId);
        FieldOption cascadeSingle = null;
        cascadeSingle = new FieldOption();
        boolean canEdit = false;
        Integer cascadeForShow = -1;
        if (studentId == -1L) {
            canEdit = true;
            cascadeForShow = cascadeLong.intValue();
        } else {
            cascadeForShow = addCascadeId;
        }
        log.info("fieldOptins is :{} ", (Object)cascadeSingle);
        SpecialFieldEnum sfe = SpecialFieldEnum.STU_ADD_CASCADE_ID;
        CustomFieldValueResponse response = new CustomFieldValueResponse(sfe.getKey(), sfe.getLabel(), sfe.getSectionId(), (Object)cascadeSingle, Integer.valueOf(RequireStatus.NOT_REQUIRE.getStatus()), CustomFieldType.SINGLE_CHOICE.getType());
        if (GenericsUtils.notNullAndEmpty((Object)list)) {
            for (TxCascadeCredentialSelectionDto tcsd : list) {
                String name = tcsd.getName();
                Integer cascadeId2 = tcsd.getCascadeId();
                FieldOption fo = new FieldOption(Long.valueOf(cascadeId2.longValue()), name);
                optionList.add(fo);
                log.info("TxCascadeCredentialSelectionDto is :{} and is Match:{} ", (Object)tcsd, (Object)(tcsd.getCascadeId() == addCascadeId ? 1 : 0));
                if (!cascadeId2.equals(cascadeForShow)) continue;
                log.info("find a match tcsd:{} ", (Object)tcsd);
                cascadeSingle.setId(Long.valueOf(cascadeId2.longValue()));
                cascadeSingle.setValue(tcsd.getName());
            }
            if (canEdit) {
                response.setOptions(optionList);
            }
        }
        log.info("response is :{} ", (Object)response);
        orgStudentInfo.getFields().add(response);
        ArrayList<FieldOption> optionListOfSource = new ArrayList<FieldOption>();
        sfe = SpecialFieldEnum.STU_SOURCE;
        Integer source = orgStudentInfo.getSource();
        FieldOption sectionOption = null;
        if (source != null) {
            Long stuSourceId = Long.parseLong(source + "");
            log.info("source is :{} ", (Object)stuSourceId);
            sectionOption = new FieldOption(stuSourceId, this.consultSourceService.getConsultSourceStr(stuSourceId));
            log.info("FieldOptin is : {} ", (Object)sectionOption);
        }
        CustomFieldValueResponse reponseOfSource = new CustomFieldValueResponse(sfe.getKey(), sfe.getLabel(), sfe.getSectionId(), sectionOption, Integer.valueOf(RequireStatus.NOT_REQUIRE.getStatus()), CustomFieldType.SINGLE_CHOICE.getType());
        List consultCustomSourceDtos = this.consultSourceService.selection(Long.valueOf(orgId.longValue()), this.saleClueRuleService.getByOrgId(Integer.valueOf(orgId)), null, Integer.valueOf(PauseStatus.NOT_PAUSE.getStatus()));
        if (GenericsUtils.notNullAndEmpty((Object)consultCustomSourceDtos)) {
            for (ConsultCustomSourceDto consultCustomSourceDto : consultCustomSourceDtos) {
                FieldOption option = new FieldOption(consultCustomSourceDto.getId(), consultCustomSourceDto.getLabel());
                optionListOfSource.add(option);
            }
        }
        reponseOfSource.setOptions(optionListOfSource);
        orgStudentInfo.getFields().add(reponseOfSource);
    }

    @Override
    public OrgStudentResponse getOrgStudentInfoWithCallback(Long studentId, Integer cascadeId, Long orgId, Integer applicationType, boolean systemOnly, SetInfoCallback<StudentInfoDto> callback) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        if (studentId == -1L) {
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId);
        } else {
            StudentCommenRequestDto studentCommenRequestDto = this.buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            log.info("studentCommenRequestDto param:{}", (Object)studentCommenRequestDto);
            StudentInfoDto studentInfoDto = new StudentInfoDto();
            this.orgStudentService.setStudentBaseInfo(studentId, orgId, cascadeId, studentInfoDto);
            if (callback == null) {
                callback = new DefaultSetInfoCallback(this.orgStudentService);
            }
            callback.init(new Object[0]);
            HashMap params = Maps.newHashMap();
            params.put("orgId", orgId);
            params.put("cascadeId", cascadeId);
            params.put("applicationType", applicationType);
            params.put("userId", studentInfoDto.getUserId());
            params.put("studentId", studentId);
            params.put("isShowMobile", studentInfoDto.getIsShowMobile());
            callback.setInfos(studentInfoDto, (Map<String, Object>)params);
            orgStudentInfo = this.buildOrgStudentInfo(studentInfoDto);
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId, systemOnly);
        }
        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>(){

            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }
        });
        this.addSpecialFieldForStudent(orgStudentInfo, cascadeId, orgId.intValue(), studentId);
        OrgStudentResponse reponse = this.buildOrgStudentResponse(orgStudentInfo);
        return reponse;
    }

    @Override
    public OrgStudentResponse getOrgStudentBase1Info(Long studentId, Integer cascadeId, Long orgId, Integer applicationType) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        if (studentId == -1L) {
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId);
        } else {
            StudentCommenRequestDto studentCommenRequestDto = this.buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            log.info("studentCommenRequestDto param:{}", (Object)studentCommenRequestDto);
            StudentInfoDto studentInfoDto = new StudentInfoDto();
            this.orgStudentService.setStudentBaseInfo(studentId, orgId, cascadeId, studentInfoDto);
            this.orgStudentService.setStudentComment(studentInfoDto.getUserId(), orgId, studentInfoDto.getIsShowMobile(), studentInfoDto);
            this.orgStudentService.setFansInfo(studentId, orgId, studentInfoDto);
            this.orgStudentService.setStudentTags(studentInfoDto.getUserId(), orgId, studentInfoDto);
            orgStudentInfo = this.buildOrgStudentInfo(studentInfoDto);
            log.info("orgStudentInfo param:{}, city parm:{}", (Object)orgStudentInfo.getProvince());
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId);
        }
        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>(){

            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }
        });
        this.addSpecialFieldForStudent(orgStudentInfo, cascadeId, orgId.intValue(), studentId);
        OrgStudentResponse reponse = this.buildOrgStudentResponse(orgStudentInfo);
        return reponse;
    }

    private OrgStudentResponse buildOrgStudentResponse(OrgStudentInfo orgStudentInfo) {
        OrgStudentResponse reponse = new OrgStudentResponse();
        BeanUtils.copyProperties((Object)((Object)orgStudentInfo), (Object)reponse);
        return reponse;
    }

    private StudentCommenRequestDto buidStudentCommenRequestDto(Long studentId, Integer cascadeId, Long orgId, Integer applicationType) {
        StudentCommenRequestDto dto = new StudentCommenRequestDto();
        dto.setStudentId(studentId);
        dto.setCasCadeId(cascadeId);
        dto.setOrgId(orgId);
        dto.setIsStudent(Boolean.valueOf(true));
        dto.setApplicationType(applicationType);
        return dto;
    }

    private OrgStudentInfo buildOrgStudentInfo(StudentInfoDto studentInfoDto) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        BeanUtils.copyProperties((Object)studentInfoDto, (Object)((Object)orgStudentInfo));
        orgStudentInfo.setSex(studentInfoDto.getGender());
        return orgStudentInfo;
    }

    @Override
    @Transactional
    public Long saveOrgStudentInfo(OrgStudentInfo orgStudentInfo, Long orgId, Integer cascadeId) {
        Long studentId = orgStudentInfo.getStudentId();
        orgStudentInfo.setIsStudent(true);
        orgStudentInfo.setAddCascadeId(cascadeId);
        List fieldValueIds = this.customFieldValueService.saveOrUpdateCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgStudentInfo.getStudentId(), orgId);
        StudentInfoDto studentInfoDto = this.buildStudentInfoDto(orgStudentInfo);
        this.saveSpecialFieldFoeStudent(orgStudentInfo.getFields(), studentInfoDto);
        List tagList = studentInfoDto.getTagsResp();
        if (studentId != null && studentId > 0L) {
            List<CommentInfoDto> commentDtos = orgStudentInfo.getCommentsResp();
            this.orgStudentService.modStudent(studentInfoDto, commentDtos, tagList, orgId);
        } else {
            OrgStudentAddresponseDto response = this.orgStudentService.addStudent(studentInfoDto, null, tagList, orgId);
            studentId = response.getStudentId();
            if (GenericsUtils.notNullAndEmpty((Object)fieldValueIds)) {
                List customFieldValues = this.customFieldValueDao.getByIds((Collection)fieldValueIds, new String[0]);
                for (CustomFieldValue fieldValue : customFieldValues) {
                    fieldValue.setStudentId(studentId);
                    this.customFieldValueDao.update((Object)fieldValue, new String[]{"studentId"});
                }
            }
        }
        return studentId;
    }

    private void saveSpecialFieldFoeStudent(List<CustomFieldDto> fields, StudentInfoDto studentInfoDto) {
        if (GenericsUtils.notNullAndEmpty(fields)) {
            for (CustomFieldDto cf : fields) {
                CustomFieldValueRequest request = (CustomFieldValueRequest)cf;
                SpecialFieldEnum consultFieldEnum = SpecialFieldEnum.getSpecialFieldEnum((String)request.getKey());
                if (consultFieldEnum == null) continue;
                this.setSpecialFieldValueByKey(consultFieldEnum, request.getValues(), studentInfoDto);
            }
        }
    }

    private void setSpecialFieldValueByKey(SpecialFieldEnum consultFieldEnum, Map<String, Object> values, StudentInfoDto studentInfoDto) {
        log.info("[SutdentCustomField] Map<String, Object> values param:{}", values);
        switch (consultFieldEnum) {
            case STU_ADD_CASCADE_ID: {
                if (values == null || values.get("id") == null) break;
                studentInfoDto.setAddCascadeId((Integer)values.get("id"));
                break;
            }
            case STU_SOURCE: {
                if (values == null || values.get("id") == null) break;
                studentInfoDto.setSource((Integer)values.get("id"));
                break;
            }
            default: {
                return;
            }
        }
    }

    private StudentInfoDto buildStudentInfoDto(OrgStudentInfo orgStudentInfo) {
        StudentInfoDto studentInfoDto = new StudentInfoDto();
        BeanUtils.copyProperties((Object)((Object)orgStudentInfo), (Object)studentInfoDto);
        studentInfoDto.setGender(orgStudentInfo.getSex());
        return studentInfoDto;
    }

    @Override
    @Transactional
    public void updateOrgStudentInfo(OrgStudentInfo orgStudentInfo, Long orgId) {
        this.customFieldValueService.saveOrUpdateCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgStudentInfo.getStudentId(), orgId);
        StudentInfoDto studentInfoDto = this.buildStudentInfoDto(orgStudentInfo);
        List tagList = orgStudentInfo.getTagsResp();
        List<CommentInfoDto> commentDtos = orgStudentInfo.getCommentsResp();
        this.orgStudentService.modStudent(studentInfoDto, commentDtos, tagList, orgId);
    }
}

