/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.student.msg.service.impl;

import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.model.Message;
import com.baijia.tianxiao.biz.student.msg.service.OrgStudentMessageConsumeService;
import com.baijia.tianxiao.biz.student.msg.service.RosterMessageConsumeService;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class RosterMessageConsumeServiceImp
implements InitializingBean,
ApplicationContextAware,
RosterMessageConsumeService {
    private static final Logger log = LoggerFactory.getLogger(RosterMessageConsumeServiceImp.class);
    private ApplicationContext context;
    public static Map<Integer, OrgStudentMessageConsumeService> messageServiceMap = Maps.newHashMap();

    @Override
    public void consumeMessage(CloudQueue queue) {
        log.info("start pop msg from queue:{}", (Object)queue.getQueueURL());
        block7: while (true) {
            try {
                while (true) {
                    Message message = queue.popMessage(5);
                    log.info("[Message] content = " + ToStringBuilder.reflectionToString((Object)message));
                    if (message != null) {
                        log.info("get msg:{}", (Object)message.getMessageId());
                        if (!this.consumeMessage(message)) continue;
                        log.info("msg:{} is success consume", (Object)message.getMessageId());
                        queue.deleteMessage(message.getReceiptHandle());
                        continue;
                    }
                    log.info("no message sleep 5 s");
                    try {
                        Thread.sleep(5000L);
                        continue block7;
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
            catch (ClientException e) {
                log.error("catch msn client exception:", (Throwable)e);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (Exception e) {
                log.error("pop msg from consult msg queue catch  exception:", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private boolean consumeMessage(Message message) {
        try {
            Integer msgType = this.getConsultMsgTypeFromMsgBody(message);
            return messageServiceMap.get(msgType).consumeMessage(message.getMessageBodyAsString().substring(2));
        }
        catch (IllegalArgumentException e) {
            log.error("illegal message:{}", (Throwable)e);
        }
        catch (Exception e) {
            log.error("consume message catch error:{},body str:{}", (Object)e, (Object)message.getMessageBodyAsString());
            log.error("consume message catch error:{}", (Throwable)e);
        }
        return false;
    }

    private Integer getConsultMsgTypeFromMsgBody(Message message) {
        String messageBody = message.getMessageBodyAsString();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{messageBody}) && messageBody.length() > 2) {
            String head = messageBody.substring(0, 2);
            if (head.endsWith("$")) {
                try {
                    return Integer.parseInt(head.substring(0, 1));
                }
                catch (NumberFormatException e) {
                    log.error("message head is illeagl format type$");
                    throw new IllegalArgumentException("message format is illegal");
                }
            }
            log.error("message head is illeagl format type$");
            throw new IllegalArgumentException("message format is illegal");
        }
        log.error("message body is illegal:{}", (Object)messageBody);
        throw new IllegalArgumentException("message format is illegal");
    }

    public void afterPropertiesSet() throws Exception {
        Map serviceMap = this.context.getBeansOfType(OrgStudentMessageConsumeService.class);
        for (OrgStudentMessageConsumeService service : serviceMap.values()) {
            messageServiceMap.put(service.getMessageType(), service);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

