/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.student.msg.service.impl;

import com.baijia.tianxiao.biz.student.msg.MessageType;
import com.baijia.tianxiao.biz.student.msg.service.OrgStudentMessageConsumeService;
import com.baijia.tianxiao.dal.callservice.constant.CallServiceCdrStatus;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceInfoDao;
import com.baijia.tianxiao.dal.callservice.po.CallServiceInfo;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.constant.DownLoadStatus;
import com.baijia.tianxiao.dal.roster.constant.MobileStatus;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgCallServiceConsumeServiceImpl
implements OrgStudentMessageConsumeService {
    private static final Logger log = LoggerFactory.getLogger(OrgCallServiceConsumeServiceImpl.class);
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private CallServiceInfoDao callServiceInfoDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private OrgStudentDao orgStudentDao;

    @Override
    public int getMessageType() {
        return MessageType.CALL.getValue();
    }

    @Override
    public boolean consumeMessage(String messageBody) {
        Long callId = this.getCallId(messageBody);
        if (callId < 0L) {
            return false;
        }
        return this.consume(callId);
    }

    private Long getCallId(String messageBody) {
        try {
            Long callId = Long.parseLong(messageBody);
            return callId;
        }
        catch (Exception e) {
            log.info("student call message format error! messageBody={}", (Object)messageBody);
            return -1L;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean consume(Long callId) {
        CallServiceInfo callServiceInfo = (CallServiceInfo)this.callServiceInfoDao.getById((Serializable)callId, new String[0]);
        if (callServiceInfo == null) {
            return false;
        }
        TxStudentComment comment = new TxStudentComment();
        Long orgId = callServiceInfo.getCallSubscriber();
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        if (orgAccount == null) {
            return false;
        }
        comment.setOrgId(orgId);
        Long studentId = callServiceInfo.getCalledParty();
        String mobile = callServiceInfo.getCalledPartyNum();
        if (studentId > 0L) {
            User user = (User)this.userDao.getById((Serializable)studentId, new String[0]);
            if (user == null) {
                log.info("consume - RETUEN FALSE callId:{}, studentId:{}, mobile:{}", new Object[]{callId, studentId, mobile});
                return false;
            }
            List list = this.txConsultUserDao.lookByUserId(orgId, studentId, new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                comment.setConsultUserId(((TxConsultUser)list.get(0)).getId());
            } else {
                OrgStudent student = this.orgStudentDao.getStudent(orgId, mobile, studentId);
                if (student != null && CollectionUtils.isNotEmpty((Collection)(list = this.txConsultUserDao.lookByStudentId(orgId, student.getId(), new String[0])))) {
                    comment.setConsultUserId(((TxConsultUser)list.get(0)).getId());
                }
            }
            comment.setUserId(studentId);
        } else {
            List consultUsers = this.txConsultUserDao.lookByMobile(orgId, mobile, new String[0]);
            if (!CollectionUtils.isNotEmpty((Collection)consultUsers)) {
                log.info("consume - RETUEN FALSE callId:{}, studentId:{}, mobile:{}", new Object[]{callId, studentId, mobile});
                return false;
            }
            comment.setConsultUserId(((TxConsultUser)consultUsers.get(0)).getId());
        }
        log.info("consume - callId:{}, studentId:{}, mobile:{}, consultUserId:{}", new Object[]{callId, studentId, mobile, comment.getConsultUserId()});
        if (callServiceInfo.getCdrStatus() == null) {
            return false;
        }
        if (callServiceInfo.getCdrStatus().intValue() == CallServiceCdrStatus.CONNECTED.getCode().intValue()) {
            comment.setContent("\u673a\u6784\u56de\u62e8\u7535\u8bdd\uff0c\u5df2\u63a5\u901a");
            if (callServiceInfo.getStorageId() > 0L) {
                comment.setSoundId(callServiceInfo.getStorageId());
            } else {
                comment.setSoundId(callId);
                comment.setDownStatus(Integer.valueOf(DownLoadStatus.UNFINISH.getCode()));
            }
            comment.setSeconds(Integer.valueOf(callServiceInfo.getDuration()));
            if (comment.getConsultUserId() != null && comment.getConsultUserId() > 0L) {
                Date now = new Date();
                TxConsultUser txConsultUser = (TxConsultUser)this.txConsultUserDao.getById((Serializable)comment.getConsultUserId(), new String[0]);
                txConsultUser.setLastRemindTime(now);
                txConsultUser.setUpdateTime(now);
                this.txConsultUserDao.update((Object)txConsultUser, new String[0]);
            }
        } else if (callServiceInfo.getCdrStatus().intValue() == CallServiceCdrStatus.CALL_UNCONNECT.getCode().intValue()) {
            comment.setContent("\u673a\u6784\u56de\u62e8\u7535\u8bdd\uff0c\u5df2\u53d6\u6d88");
        } else {
            if (callServiceInfo.getCdrStatus().intValue() != CallServiceCdrStatus.LISTENER_UNCONNECT.getCode().intValue()) {
                return false;
            }
            comment.setContent("\u673a\u6784\u56de\u62e8\u7535\u8bdd\uff0c\u672a\u63a5\u901a");
        }
        comment.setCallStatus(Integer.valueOf(callServiceInfo.getCdrStatus()));
        comment.setIsMobile(Integer.valueOf(MobileStatus.IS_CALL.getCode()));
        comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        comment.setOrigin(MessageSource.TELEPHONE.getValue());
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
        return true;
    }
}

