
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.message.service;

import com.baijia.tianxiao.biz.message.dto.request.GroupMsgSendRequestDto;
import com.baijia.tianxiao.biz.message.dto.response.GroupMsgSendResponseDto;
import com.baijia.tianxiao.dal.org.po.OrgGroupMsg;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.List;

/**
 * @title OrgGroupMsgService
 * @desc 群发消息服务
 * @author shanyu
 * @date 2016年2月24日
 * @version 1.0
 */

public interface OrgGroupMsgService {

    /**
     * 发送群消息
     * 
     * @param oGroupMsgSendRequestDto
     * @param orgId
     */
    public OrgGroupMsg sendGroupMsg(GroupMsgSendRequestDto groupMsgSendRequestDto, Long orgId, String url);
    
    /**
     * @Description  : 
     * @Author       : zhenyujian
     * @Date         : 2016年7月22日 下午5:46:08 
     *
     * @Return       : void
     */
    public void sendGroupMsg(Long msgId, Long orgId, String url);

    /**
     * 群消息列表
     * 
     * @param orgId
     * @param pageDto
     * @return
     */
    public List<GroupMsgSendResponseDto> groupMsgList(Long orgId, PageDto pageDto, String url);

    /**
     * 消息详情
     * 
     * @param orgId
     * @param msgId
     * @param reveiverId
     * @return
     */
    public GroupMsgSendResponseDto groupMsgDetail(Long orgId, Long msgId, Long reveiverId, Integer receiverType);

    /**
     * 获取微信二维码图片url
     * 
     * @param orgId
     * @return
     */
    public String getWechatUrl(Long orgId);
    
}
