
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.message.dto.request;

import java.util.Date;

import com.baijia.tianxiao.consants.UserRole;

import lombok.Data;

/**
 * @title SendMessageRequestDto
 * @desc TODO
 * @author cxm
 * @date 2016年1月18日
 * @version 1.0
 */
@Data
public class SendMessageRequestDto {

    private Long orgId;

    /**
     * 接收人的openId
     */
    private String weixinOpenId;

    /**
     * 消息接收方的角色类型
     */
    private UserRole userRole;

    private String url;

    /**
     * 机构分机号
     */
    private String extension;

    /**
     * 短信的内容
     */
    private String smsContent;

    /**
     * 绝大部分模板都需要
     */
    private String orgName;

    /**
     * 学生相关推送都要
     */
    private String userName;

    private String courseName;

    private CourseInfoDto courseInfo;

    private LessonInfoDto lessonInfo;

    @Data
    public static class CourseInfoDto {

        private String courseTeacherName;

        private Date courseStartTime;

        private Date courseEndTime;

    }

    @Data
    public static class LessonInfoDto {

        private int lessonNumber;

        private Date lessonStartTime;

        private Date lessonEndTime;

        private String classRoom;

        private String teacherName;

        /**
         * 学生出勤人数
         */
        private int presentStudentCount;
    }

    @Data
    public static class CommentInfoDto {
        private int noCommentCount;
    }

}
