
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.message.dto.request;

import com.google.common.collect.Lists;

import org.apache.commons.lang3.StringUtils;

import java.util.List;

import lombok.Data;

/**
 * @title GroupMsgSendRequestDto
 * @desc 群消息发送请求
 * @author shanyu
 * @date 2016年2月24日
 * @version 1.0
 */
@Data
public class GroupMsgSendRequestDto {

    private List<Long> studentIdList;

    private List<Integer> fanIdList;

    private List<Long> courseIdList;

    private List<Integer> groupIdList;

    private String studentIds;

    private String fanIds;

    private String courseIds;

    private String groupIds;

    private Integer msgType;

    private String subject;// 主题

    private String content;// 内容

    public List<Long> getStudentIdList() {
        studentIdList = Lists.newArrayList();
        if (StringUtils.isNotBlank(studentIds)) {
            String[] idArr = studentIds.split(",");
            for (String str : idArr) {
                studentIdList.add(Long.parseLong(str));
            }
        }
        return studentIdList;
    }

    public List<Long> getCourseIdList() {
        courseIdList = Lists.newArrayList();
        if (StringUtils.isNotBlank(courseIds)) {
            String[] idArr = courseIds.split(",");
            for (String str : idArr) {
                courseIdList.add(Long.parseLong(str));
            }
        }
        return courseIdList;
    }

    public List<Integer> getFanIdList() {
        fanIdList = Lists.newArrayList();
        if (StringUtils.isNotBlank(fanIds)) {
            String[] idArr = fanIds.split(",");
            for (String str : idArr) {
                fanIdList.add(Integer.parseInt(str));
            }
        }
        return fanIdList;
    }

    public List<Integer> getGroupIdList() {
        groupIdList = Lists.newArrayList();
        if (StringUtils.isNotBlank(groupIds)) {
            String[] idArr = groupIds.split(",");
            for (String str : idArr) {
                groupIdList.add(Integer.parseInt(str));
            }
        }
        return groupIdList;
    }
}
