/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.message.service.impl;

import com.baijia.tianxiao.biz.message.dto.request.GroupMsgSendRequestDto;
import com.baijia.tianxiao.biz.message.dto.response.GroupMsgSendResponseDto;
import com.baijia.tianxiao.biz.message.service.OrgGroupMsgService;
import com.baijia.tianxiao.constant.GroupMessageReveiverType;
import com.baijia.tianxiao.dal.org.dao.OrgGroupMsgDao;
import com.baijia.tianxiao.dal.org.dao.OrgGroupMsgReceiverDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgGroupMsg;
import com.baijia.tianxiao.dal.org.po.OrgGroupMsgReceiver;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.constant.CourseErrorCode;
import com.baijia.tianxiao.sal.wechat.api.SubscribeQRCodeService;
import com.baijia.tianxiao.sal.wechat.api.TemplateMsgService;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.batch.BatchMsg;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.CourseSmsTokenUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgGroupMsgServiceImpl
implements OrgGroupMsgService {
    private static final Logger log = LoggerFactory.getLogger(OrgGroupMsgServiceImpl.class);
    private static String suffix = "...";
    private static String first = "\u60a8\u6536\u5230\u4e00\u6761\u6d88\u606f\uff0c/n";
    private static String remark = "/n\u8bf7\u70b9\u51fb\u67e5\u770b";
    private static String picRegex = "\\[img[^\\[\\]]*\\]";
    private static String picReplacement = "[\u56fe\u7247]";
    private static String auditRegex = "\\[audio[^\\[\\]]*\\]";
    private static String auditReplacement = "[\u8bed\u97f3]";
    @Resource
    private FansDao fansDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgGroupMsgDao orgGroupMsgDao;
    @Resource
    private OrgGroupMsgReceiverDao orgGroupMsgReceiverDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private TemplateMsgService templateMsgService;
    @Resource
    private SubscribeQRCodeService subscribeQRCodeService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    private ExecutorService threadPool = Executors.newCachedThreadPool();

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OrgGroupMsg sendGroupMsg(GroupMsgSendRequestDto groupMsgSendRequestDto, final Long orgId, final String url) {
        log.info("send group wechat message params={},orgId={},url={}", new Object[]{groupMsgSendRequestDto, orgId, url});
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        int receiverSize = 0;
        final List fans = this.fansDao.getByIds(groupMsgSendRequestDto.getFanIdList(), new String[0]);
        receiverSize += fans.size();
        log.info("fans size={}", (Object)fans.size());
        List userIds = this.orgStudentCourseDao.getStudentIdsByCourseIds(orgId, groupMsgSendRequestDto.getCourseIdList());
        final List students = this.orgStudentDao.getStudentByUserIds(orgId, (Collection)userIds, new String[0]);
        HashSet receiverUserIds = Sets.newHashSet();
        receiverUserIds.addAll(userIds);
        students.addAll(this.orgStudentDao.getByIds(groupMsgSendRequestDto.getStudentIdList(), new String[0]));
        log.info("receiver size ={}", (Object)(receiverSize += students.size()));
        if (receiverSize == 0) {
            throw new BussinessException((UniverseErrorCode)CourseErrorCode.RECEIVER_NOT_EXIST);
        }
        final OrgGroupMsg msg = new OrgGroupMsg();
        msg.setContent(groupMsgSendRequestDto.getContent());
        msg.setMsgType(groupMsgSendRequestDto.getMsgType());
        msg.setOrgId(orgId);
        msg.setSubject(groupMsgSendRequestDto.getSubject());
        msg.setStudentIds(groupMsgSendRequestDto.getStudentIds());
        msg.setFanIds(groupMsgSendRequestDto.getFanIds());
        msg.setCourseIds(groupMsgSendRequestDto.getCourseIds());
        msg.setReceiverSize(Integer.valueOf(receiverSize));
        this.orgGroupMsgDao.save((Object)msg, Boolean.valueOf(false), new String[0]);
        log.info("msgId={}", (Object)msg.getId());
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                List receivers = Lists.newArrayList();
                for (Object fan : fans) {
                    receivers.add(OrgGroupMsgServiceImpl.this.buildReceiver((Fans)fan, msg.getId(), orgId));
                }
                Map studentMap = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty((Collection)students)) {
                    studentMap = CollectorUtil.collectMap((Collection)students, (Function)new Function<OrgStudent, Long>(){

                        public Long apply(OrgStudent arg0) {
                            return arg0.getUserId();
                        }
                    });
                    log.info("student's size={}", (Object)studentMap.size());
                }
                for (OrgStudent student : studentMap.values()) {
                    receivers.add(OrgGroupMsgServiceImpl.this.buildReceiver(student, msg.getId(), orgId));
                }
                OrgGroupMsgServiceImpl.this.orgGroupMsgReceiverDao.saveAll(receivers, new String[]{"msgId", "openId", "orgId", "type", "receiverId"});
                long begin = System.currentTimeMillis();
                for (OrgGroupMsgReceiver receiver : receivers) {
                    OrgGroupMsgServiceImpl.this.sendMsg(receiver, msg, url);
                }
                log.info("the time cost of create msg is:{},msgId={}", (Object)(System.currentTimeMillis() - begin), (Object)msg.getId());
            }
        });
        return msg;
    }

    private void sendMsg(OrgGroupMsgReceiver receiver, OrgGroupMsg msg, String url) {
        log.info("receiver={},msg={}", (Object)receiver, (Object)msg);
        BatchMsg batchMsg = new BatchMsg();
        batchMsg.setOrgId(Integer.valueOf(receiver.getOrgId().intValue()));
        batchMsg.setOpenId(receiver.getOpenId());
        batchMsg.setFirst(first);
        batchMsg.setRemark(remark);
        batchMsg.setUrl(String.format(url, this.getSmsToken(receiver.getMsgId(), receiver.getOrgId())));
        String content = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg.getContent()})) {
            content = msg.getContent().replaceAll(picRegex, picReplacement).replaceAll(auditRegex, auditReplacement);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{content}) && content.length() > 19) {
            batchMsg.setNoticeDesc(content.substring(0, 19) + suffix);
        } else {
            batchMsg.setNoticeDesc(content + suffix);
        }
        batchMsg.setNoticeNo(String.valueOf(msg.getId()));
        batchMsg.setNoticeName(msg.getSubject());
        try {
            this.templateMsgService.sendTemplateMsg(batchMsg.toJsonStr());
        }
        catch (Exception e) {
            log.warn("send message faild", (Throwable)e);
        }
    }

    private String getSmsToken(Long msgId, Long orgId) {
        Map params = Maps.newHashMap();
        params.put("msgId", msgId);
        try {
            return CourseSmsTokenUtil.encodeExpireToken((Map)params, (Long)orgId, null);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private OrgGroupMsgReceiver buildReceiver(Fans fans, Long msgId, Long orgId) {
        OrgGroupMsgReceiver reciever = new OrgGroupMsgReceiver();
        reciever.setMsgId(msgId);
        reciever.setOpenId(fans.getOpenId());
        reciever.setOrgId(orgId);
        reciever.setType(Integer.valueOf(GroupMessageReveiverType.FANS.getType()));
        reciever.setReceiverId(Long.valueOf(fans.getId().longValue()));
        return reciever;
    }

    private OrgGroupMsgReceiver buildReceiver(OrgStudent orgStudent, Long msgId, Long orgId) {
        OrgGroupMsgReceiver reciever = new OrgGroupMsgReceiver();
        reciever.setMsgId(msgId);
        reciever.setOpenId(orgStudent.getWeixin());
        reciever.setOrgId(orgId);
        reciever.setType(Integer.valueOf(GroupMessageReveiverType.FANS.getType()));
        reciever.setReceiverId(orgStudent.getUserId());
        return reciever;
    }

    @Override
    public List<GroupMsgSendResponseDto> groupMsgList(Long orgId, PageDto pageDto, String url) {
        List orgGroupMsgList = this.orgGroupMsgDao.getByOrgId(orgId, pageDto, new String[0]);
        List result = Lists.newArrayList();
        for (OrgGroupMsg orgGroupMsg : orgGroupMsgList) {
            result.add(this.buildGroupMsgSendResponseDto(orgGroupMsg, url));
        }
        return result;
    }

    private GroupMsgSendResponseDto buildGroupMsgSendResponseDto(OrgGroupMsg orgGroupMsg, String url) {
        GroupMsgSendResponseDto dto = new GroupMsgSendResponseDto();
        dto.setMsgId(orgGroupMsg.getId());
        dto.setContent(orgGroupMsg.getContent());
        dto.setSubject(orgGroupMsg.getSubject());
        dto.setSendTimeStamp(orgGroupMsg.getCreateTime().getTime());
        dto.setReceiverSize(orgGroupMsg.getReceiverSize());
        dto.setSendTime(DateUtil.getStrByDateFormate((Date)orgGroupMsg.getCreateTime(), (String)"yyyy-MM-dd"));
        if (url != null) {
            dto.setUrl(String.format(url, this.getSmsToken(orgGroupMsg.getId(), orgGroupMsg.getOrgId())));
        }
        return dto;
    }

    @Override
    public GroupMsgSendResponseDto groupMsgDetail(Long orgId, Long msgId, Long reveiverId, Integer receiverType) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        Preconditions.checkArgument((msgId != null ? 1 : 0) != 0, (Object)"msgId is null!");
        OrgGroupMsg msg = (OrgGroupMsg)this.orgGroupMsgDao.getById((Serializable)msgId, new String[0]);
        if (msg.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d88\u606f\u4e0d\u5b58\u5728\uff01");
        }
        return this.buildGroupMsgSendResponseDto(msg, null);
    }

    @Override
    public String getWechatUrl(Long orgId) {
        return this.subscribeQRCodeService.getQRCodeUrl(Integer.valueOf(orgId.intValue()));
    }

    @Override
    public void sendGroupMsg(final Long msgId, final Long orgId, final String url) {
        log.info("sendGroupMsg - msgId:{}, orgId:{}, url:{}", new Object[]{msgId, orgId, url});
        List receivers = this.orgGroupMsgReceiverDao.queryReceivers(orgId, msgId, null);
        OrgGroupMsg orgGroupMsg = (OrgGroupMsg)this.orgGroupMsgDao.getById((Serializable)msgId, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)receivers) && orgGroupMsg != null) {
            long begin = System.currentTimeMillis();
            for (OrgGroupMsgReceiver receiver : receivers) {
                this.sendMsg(receiver, orgGroupMsg, url);
            }
            log.info("[sendGroupMsg] the time cost of sendGroupMsg msg is:{},msgId={}", (Object)(System.currentTimeMillis() - begin), (Object)msgId);
        } else {
            log.warn("[sendGroupMsg] msgId is invalidate.msgId={}", (Object)msgId);
            if (CollectionUtils.isEmpty((Collection)receivers)) {
                log.warn("[sendGroupMsg] Receivers is null!");
            }
            if (orgGroupMsg == null) {
                log.warn("[sendGroupMsg] OrgGroupMsg is null!");
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        try {
                            log.info("[sendGroupMsg] repeat count={},msgId={}", (Object)(i + 1), (Object)msgId);
                            Thread.sleep(5000 * (i + 1));
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        List receivers = OrgGroupMsgServiceImpl.this.orgGroupMsgReceiverDao.queryReceivers(orgId, msgId, null);
                        OrgGroupMsg orgGroupMsg = (OrgGroupMsg)OrgGroupMsgServiceImpl.this.orgGroupMsgDao.getById((Serializable)msgId, new String[0]);
                        if (!CollectionUtils.isNotEmpty((Collection)receivers) || orgGroupMsg == null) continue;
                        for (OrgGroupMsgReceiver receiver : receivers) {
                            OrgGroupMsgServiceImpl.this.sendMsg(receiver, orgGroupMsg, url);
                        }
                        log.info("[sendGroupMsg] the time cost of sendGroupMsg msgId={}", (Object)msgId);
                        break;
                    }
                }
            }).start();
        }
    }
}

