/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.index.service.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.biz.index.dto.AppConfigDto;
import com.baijia.tianxiao.biz.index.dto.AppConfigListDto;
import com.baijia.tianxiao.biz.index.dto.IndexStatistics;
import com.baijia.tianxiao.biz.index.service.AppConfigCacheService;
import com.baijia.tianxiao.biz.index.service.IndexConfigService;
import com.baijia.tianxiao.dal.commons.dao.CommonDictDao;
import com.baijia.tianxiao.dal.index.dao.AppConfigDao;
import com.baijia.tianxiao.dal.index.dao.YunyingInfoDao;
import com.baijia.tianxiao.dal.index.po.AppConfig;
import com.baijia.tianxiao.dal.index.po.YunyingInfo;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.roster.constant.EncrollmentTypeEnum;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.statistics.impl.TxConsultStatMonthServiceImpl;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.yunying.hag.service.HagService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IndexConfigServiceImpl
implements IndexConfigService {
    private static final Logger log = LoggerFactory.getLogger(IndexConfigServiceImpl.class);
    @Autowired
    private AppConfigDao appConfigDao;
    @Autowired
    private CommonDictDao dictDao;
    @Autowired
    private AppConfigCacheService cacheService;
    @Autowired
    private YunyingInfoDao yunyingInfoDao;
    @Autowired
    private TxAccountPermissionService permissionService;
    @Autowired
    private TxFinanceRecordDayDao financeRecordDayDao;
    @Autowired
    private OrgSubAccountDao subAccountDao;
    @Autowired
    private TxConsultStatMonthServiceImpl txConsultStatMonthServiceImpl;
    @Autowired
    private HagService hagService;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXAccountService txAccountService;
    private static final String COMMON_DICT_MY_APP_KEY = "index_my_app_sort";
    private static final Date ACCOUNT_CREATE_TIME = new Date(1485878400000L);

    @Override
    public List<AppConfigListDto> getAppConfigs(Long orgId, Integer cascadeId, String version) {
        List configs = null;
        try {
            configs = this.cacheService.getAllConfigs();
        }
        catch (Exception e) {
            log.error("[Index] redis exception.", (Throwable)e);
        }
        if (configs == null || configs.size() < 1) {
            configs = this.appConfigDao.getAll(new String[0]);
            try {
                this.cacheService.setAllConfigs(configs);
            }
            catch (Exception e) {
                log.error("[Index] redis exception.", (Throwable)e);
            }
        }
        this.filterByPermission(orgId, cascadeId, version, configs);
        List<List<AppConfig>> list = this.group(configs);
        log.debug("app config group {},{}", (Object)configs, list);
        ArrayList<AppConfigListDto> ret = new ArrayList<AppConfigListDto>();
        for (List<AppConfig> configList : list) {
            ret.add(AppConfigListDto.getInstance(configList));
        }
        return ret;
    }

    public List<List<AppConfig>> group(List<AppConfig> configs) {
        HashMap<Integer, ArrayList<AppConfig>> map = new HashMap<Integer, ArrayList<AppConfig>>();
        for (AppConfig config : configs) {
            ArrayList<AppConfig> list = (ArrayList<AppConfig>)map.get(config.getGroupId());
            if (list == null) {
                list = new ArrayList<AppConfig>();
                map.put(config.getGroupId(), list);
            }
            list.add(config);
        }
        ArrayList groupIds = new ArrayList(map.keySet());
        Collections.sort(groupIds);
        ArrayList<List<AppConfig>> result = new ArrayList<List<AppConfig>>();
        for (Integer groupId : groupIds) {
            List groupConfigs = (List)map.get(groupId);
            Collections.sort(groupConfigs, new Comparator<AppConfig>(){

                @Override
                public int compare(AppConfig o1, AppConfig o2) {
                    return (int)(o1.getId() - o2.getId());
                }
            });
            result.add(groupConfigs);
        }
        return result;
    }

    @Override
    public List<AppConfigDto> getMyAppConfigs(Long orgId, Integer cascadeId, String version) {
        String appIdStr = this.cacheService.getMyApp();
        if (appIdStr == null || appIdStr.trim().equals("")) {
            log.info("[Index] Query my app ids from redis fail.orgId={},cascadeId={}", (Object)orgId, (Object)cascadeId);
            appIdStr = this.dictDao.getValueByKey(COMMON_DICT_MY_APP_KEY);
            this.cacheService.setMyApps(appIdStr);
        }
        String[] myAppIds = appIdStr.split(",");
        List configs = null;
        try {
            configs = this.cacheService.getAllConfigs();
            if (configs == null || configs.size() < 1) {
                log.info("[Index] Query all apps from redis fail.orgId={},cascadeId={}", (Object)orgId, (Object)cascadeId);
                configs = this.appConfigDao.getAll(new String[0]);
            }
        }
        catch (Exception e) {
            log.error("[Index] redis exception.", (Throwable)e);
            configs = this.appConfigDao.getAll(new String[0]);
        }
        this.filterByPermission(orgId, cascadeId, version, configs);
        Map configMap = CollectionUtils.extractMap((Collection)configs, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, AppConfig>(){

            public Long extract(AppConfig config) {
                return config.getId();
            }
        });
        ArrayList<AppConfigDto> dtos = new ArrayList<AppConfigDto>(myAppIds.length);
        HashSet<Long> ids = new HashSet<Long>();
        for (String appId : myAppIds) {
            long id = Long.parseLong(appId);
            AppConfig config = (AppConfig)configMap.get(id);
            if (ids.contains(id) || config == null) continue;
            dtos.add(AppConfigDto.getInstance(config));
            ids.add(id);
        }
        return dtos;
    }

    @Override
    public void refreshCache() {
        List configs = this.appConfigDao.getAll(new String[0]);
        this.cacheService.setAllConfigs(configs);
        String myAppIds = this.dictDao.getValueByKey(COMMON_DICT_MY_APP_KEY);
        this.cacheService.setMyApps(myAppIds);
    }

    private void filterByPermission(Long orgId, Integer cascadeId, String version, List<AppConfig> configs) {
        TxAccountPermissionsDto permissions = null;
        try {
            permissions = this.permissionService.universalGetPermissions(orgId.intValue(), cascadeId);
        }
        catch (Exception e) {
            log.error("[Index] Exception e {}", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PERMISSION_DENY);
        }
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        long headerOrgNumber = orgAccount.getNumber().intValue();
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        if (permissions != null && permissions.getAPPps() != null && permissions.getAPPps().size() > 0) {
            for (TxAccountPermissionsDto.AccountPermissionDto permissionDto : permissions.getAPPps()) {
                map.put(permissionDto.getPCode(), permissionDto.getPType());
            }
        }
        log.debug("index config app org_id={},cascadeid={},permission ={}", new Object[]{orgId, cascadeId, map});
        Iterator<AppConfig> iter = configs.iterator();
        while (iter.hasNext()) {
            AppConfig config = iter.next();
            if (map.get(config.getPermissionCode()) != null && (Integer)map.get(config.getPermissionCode()) == 1) {
                iter.remove();
                continue;
            }
            if (version.compareTo(config.getVersion()) < 0) {
                iter.remove();
                continue;
            }
            if ((Integer)map.get(TXPermissionConst.ADD_MARKETING_ACTIVITY.getPCode()) == 1 && config.getGroupId() == 3) {
                iter.remove();
                continue;
            }
            if (TXPermissionConst.FEE_APP_RANKIND.getPCode() == config.getPermissionCode().longValue() && (Integer)map.get(TXPermissionConst.FEE_APP_RANKIND.getPCode()) == 1) {
                iter.remove();
                continue;
            }
            if (TXPermissionConst.VZHIBO.getPCode() != config.getPermissionCode().longValue()) continue;
            OrgSubAccount account = this.subAccountDao.getByOrgId(Integer.valueOf(orgId.intValue()), new String[0]);
            if (account != null) {
                TXAccount txAccount;
                log.info("[Index] acocount={},config={}", (Object)account, (Object)config);
                if (account.getPid() != 0 && (account = this.subAccountDao.getByOrgId(account.getPid(), new String[0])) != null) {
                    OrgAccount header = (OrgAccount)this.orgAccountDao.getById((Serializable)account.getOrgId(), new String[0]);
                    headerOrgNumber = header.getNumber().intValue();
                }
                if (account != null && account.getCreateTime().compareTo(ACCOUNT_CREATE_TIME) >= 0 && (txAccount = this.txAccountService.getByOrgId(Integer.valueOf(account.getOrgId()), new String[0])) != null && this.isPermission(txAccount.getVipLevel())) continue;
            }
            log.info("[Index] acocount={},config={}", (Object)account, (Object)config);
            if (this.hagService.hasPermission((Object)headerOrgNumber, 0, "live_tianxiao_orgNumber", new Object[0])) continue;
            log.info("[Index] headerOrgNumber={}", (Object)headerOrgNumber);
            iter.remove();
        }
        log.debug("index config app org_id={},cascadeid={},configs ={}", new Object[]{orgId, cascadeId, configs});
    }

    private boolean isPermission(int vipLevel) {
        return vipLevel == TXAccountType.BAIJIN.getCode() || vipLevel == TXAccountType.BAIJIN_UPDATE.getCode();
    }

    @Override
    public List<YunyingInfo> getYunyingInfos() {
        return this.yunyingInfoDao.getAll(new String[0]);
    }

    @Override
    public IndexStatistics getIndexStatistics(Long orgId, Integer cascadeId) {
        IndexStatistics statistics = new IndexStatistics();
        Date start = DateUtil.getStartOfMonth();
        Date endTime = DateUtil.getEndOfMonth();
        List consultIds = this.txConsultStatMonthServiceImpl.getEnrollConsultIdsByStatus(orgId, EncrollmentTypeEnum.BAOMING.getValue(), start, endTime, null);
        int enrollCount = 0;
        if (consultIds != null && consultIds.size() > 0) {
            enrollCount = consultIds.size();
        }
        statistics.setEnrollCount(StringUtils.formatNumber((Number)enrollCount, (int)0));
        Double income = this.financeRecordDayDao.getIncome(orgId, start, new Date());
        statistics.setIncomeAmount(StringUtils.formatNumber((Number)income, (int)2));
        return statistics;
    }
}

