/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.index.service.impl;

import com.baijia.tianxiao.biz.index.service.AppConfigCacheService;
import com.baijia.tianxiao.dal.index.po.AppConfig;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.redis.AbstractBaseRedisDao;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service
public class AppConfigCacheServiceImpl
extends AbstractBaseRedisDao
implements AppConfigCacheService {
    private static final Logger log = LoggerFactory.getLogger(AppConfigCacheServiceImpl.class);
    private static final Gson gson = new Gson();

    @Override
    public List<AppConfig> getAllConfigs() {
        List configs = (List)this.redisTemplate.execute((RedisCallback)new RedisCallback<List<AppConfig>>(){

            public List<AppConfig> doInRedis(RedisConnection connection) throws DataAccessException {
                ArrayList<AppConfig> configs = new ArrayList<AppConfig>();
                connection.select(6);
                RedisSerializer serializer = AppConfigCacheServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)RedisKeyEnums.CRM.APP_CONFIG_LIST_KEY.getRedisKey());
                List values = connection.lRange(key, 0L, -1L);
                if (values != null) {
                    for (byte[] value : values) {
                        String result = (String)serializer.deserialize(value);
                        AppConfig config = (AppConfig)gson.fromJson(result, AppConfig.class);
                        configs.add(config);
                    }
                }
                return configs;
            }
        });
        HashSet<Long> ids = new HashSet<Long>();
        Iterator iterator = configs.iterator();
        while (iterator.hasNext()) {
            AppConfig config = (AppConfig)iterator.next();
            if (ids.contains(config.getId())) {
                iterator.remove();
                continue;
            }
            ids.add(config.getId());
        }
        return configs;
    }

    @Override
    public void setAllConfigs(final List<AppConfig> configs) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = AppConfigCacheServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)RedisKeyEnums.CRM.APP_CONFIG_LIST_KEY.getRedisKey());
                ArrayList<byte[]> values = new ArrayList<byte[]>();
                if (configs != null) {
                    connection.del((byte[][])new byte[][]{key});
                    for (AppConfig value : configs) {
                        byte[] result = serializer.serialize((Object)gson.toJson((Object)value));
                        values.add(result);
                        connection.lPush(key, (byte[][])new byte[][]{result});
                    }
                }
                return null;
            }
        });
    }

    @Override
    public String getMyApp() {
        return (String)this.redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = AppConfigCacheServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)RedisKeyEnums.CRM.MY_APP_CONFIG_IDS_KEY.getRedisKey());
                byte[] values = connection.get(key);
                String result = "";
                if (values != null) {
                    result = (String)serializer.deserialize(values);
                }
                return result;
            }
        });
    }

    @Override
    public void setMyApps(final String myAppIds) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = AppConfigCacheServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)RedisKeyEnums.CRM.MY_APP_CONFIG_IDS_KEY.getRedisKey());
                connection.del((byte[][])new byte[][]{key});
                byte[] result = serializer.serialize((Object)myAppIds);
                connection.set(key, result);
                return null;
            }
        });
    }
}

