package com.baijia.tianxiao.biz.index.service.impl;

import com.baijia.tianxiao.biz.index.service.AppConfigCacheService;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dal.index.po.AppConfig;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.redis.AbstractBaseRedisDao;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * Created by liuxp on 16/10/10.
 */
@Slf4j
@Service
public class AppConfigCacheServiceImpl extends AbstractBaseRedisDao implements AppConfigCacheService {

//    private final static String APP_CONFIG_LIST_KEY = "TX#APP#CONFIG#LIST";
//    private final static String MY_APP_CONFIG_IDS_KEY = "TX#MY#APP#CONFIG#IDS#LIST";

    private final static Gson gson = new Gson();

    @Override
    public List<AppConfig> getAllConfigs() {
        List<AppConfig> configs = redisTemplate.execute(new RedisCallback<List<AppConfig>>() {
            @Override
            public List<AppConfig> doInRedis(RedisConnection connection) throws DataAccessException {
                List<AppConfig> configs = new ArrayList<AppConfig>();
                connection.select(TianXiaoConstant.TX_PV_REDIS_DB);
                RedisSerializer<String> serializer = getRedisSerializer();
                byte[] key = serializer.serialize(RedisKeyEnums.CRM.APP_CONFIG_LIST_KEY.getRedisKey());
                List<byte[]> values = connection.lRange(key, 0, -1);
                if(values!=null){
                    for (byte[] value:values){
                        String result = serializer.deserialize(value);
                        AppConfig config = gson.fromJson(result,AppConfig.class);
                        configs.add(config);
                    }
                }
                return configs;
            }
        });

        Set<Long> ids = new HashSet<>();
        for (Iterator<AppConfig> iterator = configs.iterator();iterator.hasNext();){
            AppConfig config = iterator.next();
            if(ids.contains(config.getId())){
                iterator.remove();
            }else {
                ids.add(config.getId());
            }
        }

        return configs;
    }

    @Override
    public void setAllConfigs(final List<AppConfig> configs) {
        redisTemplate.execute(new RedisCallback<Object>() {
            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(TianXiaoConstant.TX_PV_REDIS_DB);
                RedisSerializer<String> serializer = getRedisSerializer();
                byte[] key = serializer.serialize(RedisKeyEnums.CRM.APP_CONFIG_LIST_KEY.getRedisKey());
                List<byte[]> values = new ArrayList<byte[]>();
                if(configs!=null){
                    connection.del(key);
                    for (AppConfig value:configs){
                        byte[] result = serializer.serialize(gson.toJson(value));
                        values.add(result);
                        connection.lPush(key,result);
                    }
                }
                return null;
            }
        });
    }

    @Override
    public String getMyApp() {
        return redisTemplate.execute(new RedisCallback<String>() {
            @Override
            public String doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(TianXiaoConstant.TX_PV_REDIS_DB);
                RedisSerializer<String> serializer = getRedisSerializer();
                byte[] key = serializer.serialize(RedisKeyEnums.CRM.MY_APP_CONFIG_IDS_KEY.getRedisKey());
                byte[] values = connection.get(key);
                String result = "";
                if(values!=null){
                    result = serializer.deserialize(values);
                }
                return result;
            }
        });
    }

    @Override
    public void setMyApps(final String myAppIds) {
        redisTemplate.execute(new RedisCallback<Object>() {
            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(TianXiaoConstant.TX_PV_REDIS_DB);
                RedisSerializer<String> serializer = getRedisSerializer();
                byte[] key = serializer.serialize(RedisKeyEnums.CRM.MY_APP_CONFIG_IDS_KEY.getRedisKey());
                connection.del(key);
                byte[] result = serializer.serialize(myAppIds);
                connection.set(key,result);
                return null;
            }
        });
    }
}
