package com.baijia.tianxiao.biz.index.dto;

import com.baijia.tianxiao.dal.index.po.AppConfig;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by liuxp on 16/10/11.
 */
@Data
public class AppConfigListDto {
    private String groupName;
    private int groupId;
    private List<AppConfigDto> apps = new ArrayList<>();

    public static AppConfigListDto getInstance(List<AppConfig> configs) {
        AppConfigListDto dto = new AppConfigListDto();
        if (configs != null && configs.size() > 0) {
            dto.setGroupName(configs.get(0).getGroupName());
            dto.setGroupId(configs.get(0).getGroupId());
            for (AppConfig config : configs) {
                dto.getApps().add(AppConfigDto.getInstance(config));
            }
        }
        return dto;
    }
}
