package com.baijia.tianxiao.biz.index.service.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.biz.index.dto.AppConfigDto;
import com.baijia.tianxiao.biz.index.dto.AppConfigListDto;
import com.baijia.tianxiao.biz.index.dto.IndexStatistics;
import com.baijia.tianxiao.biz.index.service.AppConfigCacheService;
import com.baijia.tianxiao.biz.index.service.IndexConfigService;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.commons.dao.CommonDictDao;
import com.baijia.tianxiao.dal.index.dao.AppConfigDao;
import com.baijia.tianxiao.dal.index.dao.YunyingInfoDao;
import com.baijia.tianxiao.dal.index.po.AppConfig;
import com.baijia.tianxiao.dal.index.po.YunyingInfo;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.roster.constant.EncrollmentTypeEnum;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.sync.dao.TxConsultUserStatMonthDao;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.statistics.impl.TxConsultStatMonthServiceImpl;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.yunying.hag.service.HagService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/10/10.
 */
@Service
@Slf4j
public class IndexConfigServiceImpl implements IndexConfigService {

    @Autowired
    private AppConfigDao appConfigDao;
    @Autowired
    private CommonDictDao dictDao;
    @Autowired
    private AppConfigCacheService cacheService;
    @Autowired
    private YunyingInfoDao yunyingInfoDao;
    @Autowired
    private TxAccountPermissionService permissionService;
    @Autowired
    private TxFinanceRecordDayDao financeRecordDayDao;
    @Autowired
    private OrgSubAccountDao subAccountDao;
    @Autowired
    private TxConsultStatMonthServiceImpl txConsultStatMonthServiceImpl;
    @Autowired
    private HagService hagService;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXAccountService txAccountService;

    private static final String COMMON_DICT_MY_APP_KEY = "index_my_app_sort";

    //2017-02-01 00:00:00
    private static final Date ACCOUNT_CREATE_TIME = new Date(1485878400000L);

    @Override
    public List<AppConfigListDto> getAppConfigs(Long orgId, Integer cascadeId, String version) {
        List<AppConfig> configs = null;
        try {
            configs = cacheService.getAllConfigs();
        } catch (Exception e) {
            log.error("[Index] redis exception.", e);
        }
        if (configs == null || configs.size() < 1) {
            configs = appConfigDao.getAll();
            try {
                cacheService.setAllConfigs(configs);
            } catch (Exception e) {
                log.error("[Index] redis exception.", e);
            }
        }
        filterByPermission(orgId, cascadeId, version, configs);
        List<List<AppConfig>> list = group(configs);

        List<AppConfigListDto> ret = new ArrayList<>();

        for (List<AppConfig> configList : list) {
            ret.add(AppConfigListDto.getInstance(configList));
        }

        return ret;
    }

    public List<List<AppConfig>> group(List<AppConfig> configs) {
        Map<Integer, List<AppConfig>> map = new HashMap<>();
        for (AppConfig config : configs) {
            List<AppConfig> list = map.get(config.getGroupId());
            if (list == null) {
                list = new ArrayList<>();
                map.put(config.getGroupId(), list);
            }
            list.add(config);
        }

        List<Integer> groupIds = new ArrayList<>(map.keySet());
        Collections.sort(groupIds);

        List<List<AppConfig>> result = new ArrayList<>();

        for (Integer groupId : groupIds) {
            List<AppConfig> groupConfigs = map.get(groupId);
            Collections.sort(groupConfigs, new Comparator<AppConfig>() {
                @Override
                public int compare(AppConfig o1, AppConfig o2) {
                    return (int) (o1.getId() - o2.getId());
                }
            });
            result.add(groupConfigs);
        }
        return result;
    }

    @Override
    public List<AppConfigDto> getMyAppConfigs(Long orgId, Integer cascadeId, String version) {
        String appIdStr = cacheService.getMyApp();
        if (appIdStr == null || appIdStr.trim().equals("")) {
            log.info("[Index] Query my app ids from redis fail.orgId={},cascadeId={}", orgId, cascadeId);
            appIdStr = dictDao.getValueByKey(COMMON_DICT_MY_APP_KEY);
            cacheService.setMyApps(appIdStr);
        }
        String[] myAppIds = appIdStr.split(",");
        List<AppConfig> configs = null;
        try {
            configs = cacheService.getAllConfigs();
            if (configs == null || configs.size() < 1) {
                log.info("[Index] Query all apps from redis fail.orgId={},cascadeId={}", orgId, cascadeId);
                configs = appConfigDao.getAll();
            }
        } catch (Exception e) {
            log.error("[Index] redis exception.", e);
            configs = appConfigDao.getAll();
        }

        filterByPermission(orgId, cascadeId, version, configs);

        Map<Long, AppConfig> configMap = CollectionUtils.extractMap(configs, new CollectionUtils.Extracter<Long, AppConfig>() {
            @Override
            public Long extract(AppConfig config) {
                return config.getId();
            }
        });

        List<AppConfigDto> dtos = new ArrayList<>(myAppIds.length);
        for (String appId : myAppIds) {
            AppConfig config = configMap.get(Long.parseLong(appId));
            if (config != null) {
                dtos.add(AppConfigDto.getInstance(config));
            }
        }

        return dtos;
    }

    @Override
    public void refreshCache() {
        List<AppConfig> configs = appConfigDao.getAll();
        cacheService.setAllConfigs(configs);
        String myAppIds = dictDao.getValueByKey(COMMON_DICT_MY_APP_KEY);
        ;
        cacheService.setMyApps(myAppIds);
    }

    private void filterByPermission(Long orgId, Integer cascadeId, String version, List<AppConfig> configs) {
        TxAccountPermissionsDto permissions = null;
        try {
            permissions = permissionService.universalGetPermissions(orgId.intValue(), cascadeId);
        } catch (Exception e) {
            log.error("[Index] Exception e {}", e);
            throw new BussinessException(CommonErrorCode.PERMISSION_DENY);
        }
        OrgAccount orgAccount = orgAccountDao.getAccountById(orgId.intValue());
        Map<Long, Integer> map = new HashMap<>();
        if (permissions != null && permissions.getAPPps() != null && permissions.getAPPps().size() > 0) {
            for (TxAccountPermissionsDto.AccountPermissionDto permissionDto : permissions.getAPPps()) {
                map.put(permissionDto.getPCode(), permissionDto.getPType());
            }
        }
        for (Iterator<AppConfig> iter = configs.iterator(); iter.hasNext(); ) {
            AppConfig config = iter.next();
            if (map.get(config.getPermissionCode()) != null && map.get(config.getPermissionCode()) == 1) {
                iter.remove();
                continue;
            }
            if (version.compareTo(config.getVersion()) < 0) {
                iter.remove();
                continue;
            }
            //营销入口统一控制
            if (map.get(TXPermissionConst.ADD_MARKETING_ACTIVITY.getpCode()) == 1 && config.getGroupId() == 3) {
                iter.remove();
                continue;
            }

            if (TXPermissionConst.VZHIBO.getpCode().longValue() == config.getPermissionCode()) {

                /**
                 * 浩斌需求:
                    需要调整为：
                    名单新增为两部分，一部分是之前的白名单（因为里面有些老客户手动申请的还需要保留）
                    另一部分是白金升级版（白金版 ∧ 购买时间>=2017-02-01）
                 */
                OrgSubAccount account = subAccountDao.getByOrgId(orgId.intValue());
                if (account != null) {
                    if (account.getPid() != 0) {
                        account = subAccountDao.getById(account.getPid());
                    }
                    if (account != null && account.getCreateTime().compareTo(ACCOUNT_CREATE_TIME) >= 0) {
                        TXAccount txAccount = txAccountService.getByOrgId(orgId.intValue());
                        if (txAccount.getVipLevel().intValue() == TXAccountType.BAIJIN.getCode()) {
                            continue;
                        }
                    }
                }
                if (!hagService.hasPermission(orgAccount.getNumber(), BizConf.DEFAULT_TYPE,
                        BizConf.LIVE_TIANXIAO_ORGNUMBER)) {
                    iter.remove();
                }
            }
        }
    }

    @Override
    public List<YunyingInfo> getYunyingInfos() {
        return yunyingInfoDao.getAll();
    }

    @Override
    public IndexStatistics getIndexStatistics(Long orgId, Integer cascadeId) {
        IndexStatistics statistics = new IndexStatistics();
        Date start = DateUtil.getStartOfMonth();
        Date endTime = DateUtil.getEndOfMonth();
        List<Long> consultIds = txConsultStatMonthServiceImpl.getEnrollConsultIdsByStatus(orgId, EncrollmentTypeEnum.BAOMING.getValue(), start, endTime, null);
        int enrollCount = 0;
        if (consultIds != null && consultIds.size() > 0) {
            enrollCount = consultIds.size();
        }
        statistics.setEnrollCount(StringUtils.formatNumber(enrollCount, 0));
        Double income = financeRecordDayDao.getIncome(orgId, start, new Date());
        statistics.setIncomeAmount(StringUtils.formatNumber(income, 2));
        return statistics;
    }
}