/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.sync.impl;

import com.baijia.tianxiao.biz.sync.SyncPayService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseTimescardRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescardRefund;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.dao.TxSignupRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.dal.statistic.po.TxSignupRecordDay;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.sal.common.api.PointsMsgService;
import com.baijia.tianxiao.sal.common.constant.PointsType;
import com.baijia.tianxiao.sal.common.constant.ProducePointType;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpType;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.sal.signup.constants.SignupRefundType;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="syncTimesCardRefundRecordService")
public class SyncTimesCardRefundRecordServiceImpl
implements SyncPayService {
    private static final Logger log = LoggerFactory.getLogger(SyncTimesCardRefundRecordServiceImpl.class);
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private TxPurchaseTimescardRefundDao timescardRefundDao;
    @Resource
    private TxSignupRecordDayDao txSignupRecordDayDao;
    @Resource
    private OrgFinanceAccountService orgFinanceAccountService;
    @Resource
    private TxFinanceInfoDao txFinanceInfoDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private TxFinanceRecordDayDao txFinanceRecordDayDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private TxStudentFinanceAccountService txStudentFinanceAccountService;
    @Autowired
    private PointsMsgService pointsMsgService;
    private AtomicBoolean timesCardRefundRecordFlag = new AtomicBoolean(false);

    @Override
    public void sync() {
        TxMsgSyncTimestamp syncInfo = this.getSyncInfo(MsgSyncType.SYNC_TIMESCARD_REFUND);
        try {
            if (!this.timesCardRefundRecordFlag.get()) {
                log.info("sync cw syncTimesCardRefundRecordService refund info :{}", (Object)syncInfo);
                this.timesCardRefundRecordFlag.set(true);
                this.syncTimesCardRefundRecordDay(syncInfo);
                this.timesCardRefundRecordFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", (Throwable)e);
        }
        finally {
            this.timesCardRefundRecordFlag.set(false);
        }
        log.info("save sync syncTimesCardRefundRecordService info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncTimesCardRefundRecordDay(TxMsgSyncTimestamp syncInfo) {
        List timescardRefunds = this.timescardRefundDao.getOrgSignupRefundListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("save syncTimesCardRefundRecordDay:{} success", (Object)timescardRefunds.size());
        if (CollectionUtils.isNotEmpty((Collection)timescardRefunds)) {
            for (TxPurchaseTimescardRefund timescardRefund : timescardRefunds) {
                try {
                    OrgStudent orgStudent;
                    OrgSignupInfo orgSignupInfo;
                    if (timescardRefund.getId() > syncInfo.getSyncId()) {
                        syncInfo.setSyncId(Long.valueOf(timescardRefund.getId()));
                    }
                    if (timescardRefund.getSignupPurchaseId() != null && timescardRefund.getSignupPurchaseId() > 0L && (orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(timescardRefund.getSignupPurchaseId(), new String[0])) != null) {
                        this.saveSignupRecordDay(orgSignupInfo, timescardRefund);
                    }
                    if (timescardRefund.getRefundType().intValue() == SignupRefundType.BY_ORG_CASH.getCode().intValue() && timescardRefund.getRefundPrice() > 0L) {
                        this.saveFinanceInfo(timescardRefund);
                        this.saveFinanceRecordDay(timescardRefund);
                        this.pointsMsgService.pointsMessage(ProducePointType.TIMESCARD_REFUND, Long.valueOf(timescardRefund.getId()), timescardRefund.getOrgId(), timescardRefund.getUserId(), timescardRefund.getRefundPrice(), Integer.valueOf(PointsType.DEDUCT.getType()));
                    }
                    if (timescardRefund.getRefundType().intValue() != SignupRefundType.BY_STUDENT_ACCOUNT.getCode().intValue() || (orgStudent = this.orgStudentDao.getStudent(timescardRefund.getOrgId(), timescardRefund.getUserId(), Integer.valueOf(DataStatus.NORMAL.getValue()), new String[0])) == null) continue;
                    String opInfo = "\u9000\u5361";
                    if (timescardRefund.getRefundPrice() <= 0L) continue;
                    this.txStudentFinanceAccountService.changeStudentFiannceAccount(timescardRefund.getOrgId(), timescardRefund.getCascadeId(), orgStudent.getId(), timescardRefund.getSignupPurchaseId(), StudentFiannceOpType.TIMECARD_CASH, timescardRefund.getRefundPrice(), opInfo, timescardRefund.getSignupPurchaseId().toString());
                }
                catch (Exception e) {
                    log.warn("sync finance record fail {}", (Throwable)e);
                }
            }
        }
    }

    private void saveFinanceInfo(TxPurchaseTimescardRefund txPurchaseTimescardRefund) {
        int opTo = 2;
        OrgFinanceAccountRecord orgFinanceAccountRecord = this.orgFinanceAccountService.getAccountRecordInfo(txPurchaseTimescardRefund.getOrgId(), txPurchaseTimescardRefund.getCreateTime());
        TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
        txFinanceInfo.setOrgId(txPurchaseTimescardRefund.getOrgId());
        txFinanceInfo.setCreateTime(txPurchaseTimescardRefund.getCreateTime());
        txFinanceInfo.setCurrBalance(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrBalance()));
        txFinanceInfo.setCurrFreezeMoney(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrFreezeMoney()));
        txFinanceInfo.setExpectedEarning(Double.valueOf(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrExpectedEarning()));
        txFinanceInfo.setOpMoney(Double.valueOf(txPurchaseTimescardRefund.getRefundPrice().doubleValue() / 100.0));
        txFinanceInfo.setOpType(FinanceOpType.DRAWBACK.getCode());
        txFinanceInfo.setPayType(Integer.valueOf(PayType.CASH.getCode()));
        txFinanceInfo.setPurchaseId(txPurchaseTimescardRefund.getSignupPurchaseId() + "");
        txFinanceInfo.setCourseId(Long.valueOf(0L));
        OrgStudent orgStudent = this.orgStudentDao.getStudent(txPurchaseTimescardRefund.getOrgId(), txPurchaseTimescardRefund.getUserId(), Integer.valueOf(DataStatus.NORMAL.getValue()), new String[0]);
        StringBuffer opinfo = new StringBuffer();
        if (orgStudent != null) {
            opinfo.append("\u5b66\u751f:").append(orgStudent.getName()).append("\u9000\u5361");
        }
        txFinanceInfo.setOpInfo(opinfo.toString());
        txFinanceInfo.setOpTo(Integer.valueOf(opTo));
        log.debug("saveFinanceInfo={}", (Object)txFinanceInfo);
        this.txFinanceInfoDao.save((Object)txFinanceInfo, new String[0]);
    }

    private void saveFinanceRecordDay(TxPurchaseTimescardRefund txPurchaseTimescardRefund) {
        int opType = PayType.CASH.getCode();
        int opTo = 2;
        String mdate = DateUtil.getStrByDate((Date)txPurchaseTimescardRefund.getCreateTime());
        TxFinanceRecordDay txFinanceRecordDay = this.txFinanceRecordDayDao.getByDayType(txPurchaseTimescardRefund.getOrgId(), mdate, opType, opTo, new String[0]);
        if (txFinanceRecordDay == null) {
            txFinanceRecordDay = new TxFinanceRecordDay();
            txFinanceRecordDay.setOrgId(txPurchaseTimescardRefund.getOrgId());
            txFinanceRecordDay.setMdate(txPurchaseTimescardRefund.getCreateTime());
            txFinanceRecordDay.setOpCount(Integer.valueOf(1));
            txFinanceRecordDay.setOpPrice(Double.valueOf(txPurchaseTimescardRefund.getRefundPrice().doubleValue() / 100.0));
            txFinanceRecordDay.setOpType(Integer.valueOf(opType));
            txFinanceRecordDay.setOpTo(Integer.valueOf(opTo));
        } else {
            txFinanceRecordDay.setOpPrice(Double.valueOf(txFinanceRecordDay.getOpPrice() + txPurchaseTimescardRefund.getRefundPrice().doubleValue() / 100.0));
            txFinanceRecordDay.setOpCount(Integer.valueOf(txFinanceRecordDay.getOpCount() + 1));
        }
        log.debug("saveFinanceRecordDay={}", (Object)txFinanceRecordDay);
        this.txFinanceRecordDayDao.saveOrUpdate((Object)txFinanceRecordDay, new String[0]);
    }

    private void saveSignupRecordDay(OrgSignupInfo orgSignupInfo, TxPurchaseTimescardRefund timescardRefund) {
        int opType = orgSignupInfo.getSourceType();
        int opTo = 2;
        String mdate = DateUtil.getStrByDate((Date)timescardRefund.getCreateTime());
        TxSignupRecordDay txSignupRecordDay = this.txSignupRecordDayDao.getByDayType(timescardRefund.getOrgId(), mdate, opType, opTo, new String[0]);
        if (txSignupRecordDay == null) {
            txSignupRecordDay = new TxSignupRecordDay();
            txSignupRecordDay.setOrgId(timescardRefund.getOrgId());
            txSignupRecordDay.setMdate(timescardRefund.getCreateTime());
            txSignupRecordDay.setOpCount(Integer.valueOf(1));
            txSignupRecordDay.setOpPrice(Double.valueOf(timescardRefund.getRefundPrice().doubleValue() / 100.0));
            txSignupRecordDay.setOpType(Integer.valueOf(opType));
            txSignupRecordDay.setOpTo(Integer.valueOf(opTo));
        } else {
            txSignupRecordDay.setOpPrice(Double.valueOf(txSignupRecordDay.getOpPrice() + timescardRefund.getRefundPrice().doubleValue() / 100.0));
            txSignupRecordDay.setOpCount(Integer.valueOf(txSignupRecordDay.getOpCount() + 1));
        }
        log.debug("saveSignupRecordDay={}", (Object)txSignupRecordDay);
        this.txSignupRecordDayDao.saveOrUpdate((Object)txSignupRecordDay, new String[0]);
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }
}

