/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.service.impl;

import com.baijia.tianxiao.biz.service.TxSignupService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.constant.finance.PurchaseRechargeStatus;
import com.baijia.tianxiao.constant.finance.PurchaseTimescardStatus;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassInfo;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseRechargeDao;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseTimescardDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescard;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.sal.common.api.PointsMsgService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.common.constant.PointsType;
import com.baijia.tianxiao.sal.common.constant.ProducePointType;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sal.signup.constants.SignupSourceType;
import com.baijia.tianxiao.sal.signup.service.TransferClassInfoService;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TxSignupServiceImpl
implements TxSignupService {
    private static final Logger log = LoggerFactory.getLogger(TxSignupServiceImpl.class);
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private TXSaleClueRuleService tXSaleClueRuleService;
    @Resource
    private TransferClassInfoService transferClassInfoService;
    @Autowired
    private TXStudentCommentAPIService txStudentCommentAPIService;
    @Resource
    private TxStudentFinanceAccountService txStudentFinanceAccountService;
    @Resource
    private CommonMsgService commonMsgService;
    @Autowired
    private TxPurchaseRechargeDao txPurchaseRechargeDao;
    @Autowired
    private TxPurchaseTimescardDao txPurchaseTimescardDao;
    @Autowired
    private PointsMsgService pointsMsgService;
    @Autowired
    private TxTransferClassInfoDao txTransferClassinfoDao;

    @Override
    public void syncSuccessSignup(OrgSignupInfo signupInfo) {
        ProducePointType producePointType = null;
        if (signupInfo.getOrderType().intValue() == TransferClassOrder.NORMAL_ORDER.getCode() || signupInfo.getOrderType().intValue() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
            this.normalOrder(signupInfo);
            producePointType = ProducePointType.SIGNUP;
        } else if (signupInfo.getOrderType().intValue() == TransferClassOrder.RECHARGE_ORDER.getCode()) {
            this.rechargeOrder(signupInfo);
            producePointType = ProducePointType.RECHARGE;
        } else if (signupInfo.getOrderType().intValue() == TransferClassOrder.TIMESCARD_ORDER.getCode()) {
            this.timescardOrder(signupInfo);
            producePointType = ProducePointType.TIMECARD;
        }
        this.pointsMsgService.pointsMessage(producePointType, signupInfo.getId(), signupInfo.getOrgId(), signupInfo.getUserId(), signupInfo.getTotalPrices(), Integer.valueOf(PointsType.PRODUCT.getType()));
    }

    public void rechargeOrder(OrgSignupInfo signupInfo) {
        OrgStudent orgStudent = this.orgStudentDao.getStudent(Long.valueOf(signupInfo.getOrgId()), signupInfo.getUserId(), Integer.valueOf(DataStatus.NORMAL.getValue()), new String[0]);
        if (signupInfo.getTotalPrices() > 0L && orgStudent != null) {
            this.txStudentFinanceAccountService.changeStudentFiannceAccount(Long.valueOf(signupInfo.getOrgId()), signupInfo.getCascadeId(), orgStudent.getId(), signupInfo.getSignupPurchaseId(), StudentFiannceOpType.RECHARGE, signupInfo.getTotalPrices(), "\u5145\u503c\u6210\u529f", signupInfo.getSignupPurchaseId().toString());
        }
        this.txPurchaseRechargeDao.updateStatusByPurchaseId(signupInfo.getSignupPurchaseId(), PurchaseRechargeStatus.SUCCESS.getCode());
        OrgInfo orginfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(signupInfo.getOrgId().intValue()), new String[]{"shortname"});
        TXSaleClueRule txSaleClueRule = this.tXSaleClueRuleService.getByOrgId(Integer.valueOf(signupInfo.getOrgId().intValue()));
        if (txSaleClueRule != null && txSaleClueRule.getSignupMsg() != null && txSaleClueRule.getSignupMsg() == 0) {
            String content = SmsContentHelper.createRechargeSms((String)signupInfo.getStudentName(), (long)signupInfo.getPayTime().getTime(), (Double)(signupInfo.getTotalPrices().doubleValue() / 100.0), (String)orginfo.getShortName());
            this.commonMsgService.sendTxSms(Long.valueOf(signupInfo.getOrgId()), Long.valueOf(signupInfo.getOrgId()), Integer.valueOf(UserRole.ORGANIZATION.getRole()), Long.valueOf(orgStudent == null ? 0L : orgStudent.getId()), Integer.valueOf(UserRole.STUDENT.getRole()), TxSmsCodeType.RECHARGE_SMS_CODE, null, signupInfo.getMobile(), content);
        }
        if (signupInfo != null) {
            signupInfo.setSmsSend(Integer.valueOf(1));
            log.info("sms before orgsignupinfo = {},result={}", (Object)signupInfo, (Object)(signupInfo.getSourceType().intValue() != SignupSourceType.TUIGUANG.getCode().intValue() ? 1 : 0));
            this.orgSignupInfoDao.update((Object)signupInfo, new String[]{"smsSend"});
        }
    }

    public void timescardOrder(OrgSignupInfo signupInfo) {
        TxPurchaseTimescard txPurchaseTimescard;
        OrgStudent orgStudent = this.orgStudentDao.getStudent(Long.valueOf(signupInfo.getOrgId()), signupInfo.getUserId(), Integer.valueOf(DataStatus.NORMAL.getValue()), new String[0]);
        this.txPurchaseTimescardDao.updateStatusByPurchaseId(signupInfo.getSignupPurchaseId(), PurchaseTimescardStatus.SUCCESS.getCode());
        OrgInfo orginfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(signupInfo.getOrgId().intValue()), new String[]{"shortname"});
        TXSaleClueRule txSaleClueRule = this.tXSaleClueRuleService.getByOrgId(Integer.valueOf(signupInfo.getOrgId().intValue()));
        if (txSaleClueRule != null && txSaleClueRule.getSignupMsg() != null && txSaleClueRule.getSignupMsg() == 0 && (txPurchaseTimescard = this.txPurchaseTimescardDao.getBySignupPurchase(signupInfo.getOrgId(), signupInfo.getSignupPurchaseId())) != null) {
            String content = SmsContentHelper.createTimescardSms((long)txPurchaseTimescard.getCreateTime().getTime(), (int)txPurchaseTimescard.getLessonCount(), (Date)txPurchaseTimescard.getEndTime(), (String)orginfo.getShortName());
            this.commonMsgService.sendTxSms(Long.valueOf(signupInfo.getOrgId()), Long.valueOf(signupInfo.getOrgId()), Integer.valueOf(UserRole.ORGANIZATION.getRole()), Long.valueOf(orgStudent == null ? 0L : orgStudent.getId()), Integer.valueOf(UserRole.STUDENT.getRole()), TxSmsCodeType.TIMECARD_SMS_CODE_COUNT, null, signupInfo.getMobile(), content);
        }
        if (signupInfo != null) {
            signupInfo.setSmsSend(Integer.valueOf(1));
            log.info("sms before orgsignupinfo = {},result={}", (Object)signupInfo, (Object)(signupInfo.getSourceType().intValue() != SignupSourceType.TUIGUANG.getCode().intValue() ? 1 : 0));
            this.orgSignupInfoDao.update((Object)signupInfo, new String[]{"smsSend"});
        }
    }

    public void normalOrder(OrgSignupInfo signupInfo) {
        List signupCourses = this.orgSignupCourseDao.loadByPurchaseId(signupInfo.getSignupPurchaseId(), new String[0]);
        if (CollectionUtils.isEmpty((Collection)signupCourses)) {
            return;
        }
        signupInfo.setOrgSignupCourses(signupCourses);
        if (signupInfo.getOrderType().intValue() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
            TxTransferClassInfo txTransferClassInfo = this.txTransferClassinfoDao.getByInPurchaseId(signupInfo.getSignupPurchaseId());
            if (txTransferClassInfo == null) {
                return;
            }
            this.transferClassInfoService.confirmTransferClass(signupInfo.getSignupPurchaseId());
        }
        Map courseMap = CollectorUtil.collectMap((Collection)signupCourses, (Function)new Function<OrgSignupCourse, Long>(){

            public Long apply(OrgSignupCourse orgSignupCourse) {
                return orgSignupCourse.getOrgCourseId();
            }
        });
        StringBuilder sb = new StringBuilder();
        ArrayList names = Lists.newArrayList();
        List courseList = this.orgCourseDao.getByIds(courseMap.keySet(), new String[0]);
        int courseCount = courseList.size();
        String courseName = "";
        StringBuilder allCourseNameStr = new StringBuilder();
        for (int i = 0; i < courseList.size(); ++i) {
            OrgCourse tempCourse = (OrgCourse)courseList.get(i);
            if (GenericsUtils.isNullOrEmpty((Object)courseName)) {
                courseName = tempCourse.getName();
            }
            allCourseNameStr.append(tempCourse.getName());
            sb.append("\u201c" + tempCourse.getName() + "\u201c");
            names.add(tempCourse.getName());
            if (i < courseList.size() - 1) {
                sb.append("\u3001");
                allCourseNameStr.append("\u3001");
            }
            if (tempCourse.getCourseType().intValue() != CourseTypeEnum.COURSE_TYPE_1v1.getCode().intValue()) continue;
            this.orgSignupCourseDao.updateLessonCountByPurchaseId(signupInfo.getSignupPurchaseId(), tempCourse.getId());
        }
        this.updateSignupCourseCharge(courseList, courseMap);
        Map courseMap_ = GenericsUtils.toFieldMap((Collection)courseList, (String[])new String[]{"id"});
        log.info("courseMap_ is :{} ", (Object)courseMap_);
        OrgSignupInfo orgSignupInfo = signupInfo;
        HashMap orgSignupCourseMap = Maps.newHashMap();
        HashMap orgCourseMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)signupCourses)) {
            for (OrgSignupCourse orgSignupCourse : signupCourses) {
                orgCourseMap.put(orgSignupCourse.getOrgCourseId(), courseMap_.get(orgSignupCourse.getOrgCourseId()));
                orgSignupCourseMap.put(orgSignupCourse.getOrgCourseId(), orgSignupCourse);
            }
        }
        this.txStudentCommentAPIService.saveBySignUpPurchase(orgSignupInfo, (Map)orgSignupCourseMap, (Map)orgCourseMap);
        Integer orgId = signupInfo.getOrgId().intValue();
        OrgInfo orginfo = this.orgInfoDao.getOrgInfo(orgId, new String[]{"shortname"});
        log.info("SignupInfoSmsProcessor :orgsignupInfo={}", (Object)signupInfo);
        this.orgSignupCourseDao.updateStatusByPurchaseId(signupInfo.getSignupPurchaseId(), Integer.valueOf(SignupCourseStatus.HAS_PAY.getCode()));
        OrgStudent orgStudent = this.orgStudentDao.getStudent(Long.valueOf(orgId.longValue()), signupInfo.getUserId(), Integer.valueOf(DataStatus.NORMAL.getValue()), new String[0]);
        if (signupInfo.getStudentPayPrice() > 0L && orgStudent != null) {
            this.txStudentFinanceAccountService.changeStudentFiannceAccount(Long.valueOf(orgId.longValue()), Integer.valueOf(-1), orgStudent.getId(), signupInfo.getSignupPurchaseId(), StudentFiannceOpType.PAY_SUCCESS, signupInfo.getStudentPayPrice(), allCourseNameStr.toString(), "");
        }
        log.info("courseCount > 0 :{} ", (Object)(courseCount > 0 ? 1 : 0));
        TXSaleClueRule txSaleClueRule = this.tXSaleClueRuleService.getByOrgId(orgId);
        if (txSaleClueRule != null && txSaleClueRule.getSignupMsg() != null && txSaleClueRule.getSignupMsg() == 0 && courseCount > 0) {
            String content = SmsContentHelper.createSignupCourseSmsMsg((String)courseName, (int)courseCount, (String)orginfo.getShortName());
            this.commonMsgService.sendTxSms(Long.valueOf(orgId.longValue()), Long.valueOf(orgId.longValue()), Integer.valueOf(UserRole.ORGANIZATION.getRole()), Long.valueOf(orgStudent == null ? 0L : orgStudent.getId()), Integer.valueOf(UserRole.STUDENT.getRole()), TxSmsCodeType.SIGNUP_NOTIFY_WITH_MANY, null, signupInfo.getMobile(), content);
        }
        if (signupInfo != null) {
            signupInfo.setSmsSend(Integer.valueOf(1));
            log.info("sms before orgsignupinfo = {},result={}", (Object)signupInfo, (Object)(signupInfo.getSourceType().intValue() != SignupSourceType.TUIGUANG.getCode().intValue() ? 1 : 0));
            this.orgSignupInfoDao.update((Object)signupInfo, new String[]{"smsSend"});
        }
    }

    private void updateSignupCourseCharge(List<OrgCourse> courseList, Map<Long, OrgSignupCourse> signupCourseMap) {
        for (OrgCourse orgCourse : courseList) {
            OrgSignupCourse orgSignupCourse = signupCourseMap.get(orgCourse.getId());
            if (orgSignupCourse.getChargeUnit().intValue() != ChargeUnit.BY_OTHER.getCode() || orgCourse.getChargeUnit().intValue() == ChargeUnit.BY_OTHER.getCode()) continue;
            this.orgSignupCourseDao.update((Object)orgSignupCourse, new String[]{"chargeUnit"});
        }
    }

    public static void main(String[] args) {
        ArrayList dd = Lists.newArrayList();
        dd.add("sdfdsfds");
        dd.add("sdfds");
        System.out.println(((Object)dd).toString());
    }
}

