/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.service.impl;

import com.baijia.tianxiao.biz.constants.BindCardOpType;
import com.baijia.tianxiao.biz.service.BankCardService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.finance.po.OrgBankCard;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxWithdrawBankDto;
import com.baijia.tianxiao.sal.organization.finance.service.TxBankCardService;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BankCardServiceImpl
implements BankCardService {
    private static final Logger log = LoggerFactory.getLogger(BankCardServiceImpl.class);
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private CommonMsgService commonMsgService;
    @Autowired
    private TxBankCardService txBankCardService;
    private Map<Long, Object> lockMap = new HashMap<Long, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindCorBank(Long orgId, OrgBankCard bankCard) throws IOException {
        log.info("bind core bank params={},{}", (Object)orgId, (Object)bankCard);
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bankCard.getCardOwnerName()), (Object)"\u94f6\u884c\u5f00\u6237\u59d3\u540d\u4e3a\u7a7a!");
        Preconditions.checkArgument((bankCard.getCardOwnerName().length() < 30 ? 1 : 0) != 0, (Object)"\u4f01\u4e1a\u5f00\u6237\u540d\u79f0\u8fc7\u957f!");
        bankCard.setCardOwnerName(bankCard.getCardOwnerName().trim());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bankCard.getBankNo()), (Object)"\u6240\u5728\u94f6\u884c\u4e3a\u7a7a!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bankCard.getRegion()), (Object)"\u5f00\u6237\u884c\u5730\u533a\u4fe1\u606f\u4e3a\u7a7a!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bankCard.getCardNum()), (Object)"\u5361\u53f7\u4e3a\u7a7a!");
        bankCard.setRegion(bankCard.getRegion().trim());
        if (bankCard.getCardOpenLocation() == null) {
            bankCard.setCardOpenLocation("");
        } else {
            bankCard.setCardOpenLocation(bankCard.getCardOpenLocation().trim());
        }
        bankCard.setCardNum(bankCard.getCardNum().trim());
        bankCard.setOrgId(orgId);
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountById(Integer.valueOf(orgId.intValue()));
        if (orgAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784\u4e0d\u5b58\u5728");
        }
        Object objLock = null;
        Object object = this;
        synchronized (object) {
            objLock = this.lockMap.get(orgId);
            if (objLock == null) {
                objLock = new Object();
                this.lockMap.put(orgId, objLock);
            }
        }
        object = objLock;
        synchronized (object) {
            TxWithdrawBankDto withdrawBankDto = this.txBankCardService.getOrgBankInfo(orgId);
            if (withdrawBankDto != null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u7ecf\u7ed1\u8fc7\u5361\u4e86");
            }
            bankCard.setCreatTime(new Date());
            this.txBankCardService.bindCotCard(bankCard);
            this.sendBindCardSms((long)orgId, BindCardOpType.BIND_CARD, orgAccount.getMobile(), bankCard.getCardNum());
        }
    }

    @Override
    public boolean sendBindCardSms(Long orgId, BindCardOpType bindCardOpType, String mobile, String cardNo) {
        log.info("Bankcard service send message== {},{},{},{}", new Object[]{orgId, bindCardOpType, mobile, cardNo});
        OrgInfo orgInfo = this.orgInfoService.getOrgInfoByOrgId(Integer.valueOf(orgId.intValue()));
        if (orgInfo == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784\u4e0d\u5b58\u5728");
        }
        String content = "";
        cardNo = cardNo.substring(cardNo.length() - 4);
        TxSmsCodeType txSmsCodeType = null;
        if (bindCardOpType == BindCardOpType.BIND_CARD) {
            txSmsCodeType = TxSmsCodeType.ORG_BANK_BIND_CARD;
            content = SmsContentHelper.createBindBankCard((String)orgInfo.getShortName(), (String)cardNo);
        } else if (bindCardOpType == BindCardOpType.UNBIND_CARD) {
            txSmsCodeType = TxSmsCodeType.ORG_BANK_UNBIND_CARD;
            content = SmsContentHelper.createUnBindBankCard((String)orgInfo.getShortName(), (String)cardNo);
        } else {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u7ed1\u5361\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
        }
        return this.commonMsgService.sendTxSms(orgId, orgId, Integer.valueOf(UserRole.ORGANIZATION.getRole()), null, null, txSmsCodeType, null, mobile, content);
    }
}

