package com.baijia.tianxiao.biz.sync.impl;

import com.baijia.tianxiao.biz.sync.SyncPayService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseTimescardRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescardRefund;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.dao.TxSignupRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.dal.statistic.po.TxSignupRecordDay;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.sal.common.api.PointsMsgService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.common.constant.PointsType;
import com.baijia.tianxiao.sal.common.constant.ProducePointType;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpType;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.sal.signup.constants.SignupRefundType;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.util.date.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/6/30 Time: 下午4:45 To change this template use File | Settings
 * | File Templates.
 */
@Service("syncTimesCardRefundRecordService")
@Slf4j
public class SyncTimesCardRefundRecordServiceImpl implements SyncPayService {
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;

    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;

    @Resource
    private TxPurchaseTimescardRefundDao timescardRefundDao;

    @Resource
    private TxSignupRecordDayDao txSignupRecordDayDao;

    @Resource
    private OrgFinanceAccountService orgFinanceAccountService;

    @Resource
    private TxFinanceInfoDao txFinanceInfoDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private TxFinanceRecordDayDao txFinanceRecordDayDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private TxStudentFinanceAccountService txStudentFinanceAccountService;

    @Autowired
    private PointsMsgService pointsMsgService;

    private AtomicBoolean timesCardRefundRecordFlag = new AtomicBoolean(false);

    @Override
    public void sync() {

        TxMsgSyncTimestamp syncInfo = getSyncInfo(MsgSyncType.SYNC_TIMESCARD_REFUND);
        try {
            if (!timesCardRefundRecordFlag.get()) {
                log.info("sync cw syncTimesCardRefundRecordService refund info :{}", syncInfo);
                timesCardRefundRecordFlag.set(true);
                syncTimesCardRefundRecordDay(syncInfo);
                timesCardRefundRecordFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", e);
        } finally {
            timesCardRefundRecordFlag.set(false);
        }
        log.info("save sync syncTimesCardRefundRecordService info:{}", syncInfo);
        txMsgSyncTimestampDao.saveOrUpdate(syncInfo);
    }

    private void syncTimesCardRefundRecordDay(TxMsgSyncTimestamp syncInfo) {
        List<TxPurchaseTimescardRefund> timescardRefunds =
                timescardRefundDao.getOrgSignupRefundListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100);

        log.info("save syncTimesCardRefundRecordDay:{} success", timescardRefunds.size());

        if (CollectionUtils.isNotEmpty(timescardRefunds)) {
            for (TxPurchaseTimescardRefund timescardRefund : timescardRefunds) {
                try {
                    if (timescardRefund.getId() > syncInfo.getSyncId()) {
                        syncInfo.setSyncId(Long.valueOf(timescardRefund.getId()));
                    }
                    if (timescardRefund.getSignupPurchaseId() != null
                            && timescardRefund.getSignupPurchaseId().longValue() > 0) {
                        OrgSignupInfo orgSignupInfo =
                                orgSignupInfoDao.searchByPurchaseId(timescardRefund.getSignupPurchaseId());
                        if (orgSignupInfo != null) {
                            saveSignupRecordDay(orgSignupInfo, timescardRefund);
                        }
                    }
                    /**
                     * 直接机构退现金的才同步收支
                     */
                    if (timescardRefund.getRefundType().intValue() == SignupRefundType.BY_ORG_CASH.getCode()) {
                        if (timescardRefund.getRefundPrice().longValue() > 0) {
                            saveFinanceInfo(timescardRefund);
                            saveFinanceRecordDay(timescardRefund);

                            pointsMsgService.pointsMessage(ProducePointType.TIMESCARD_REFUND, (long) timescardRefund.getId(), timescardRefund.getOrgId(), timescardRefund.getUserId(), timescardRefund.getRefundPrice(), PointsType.DEDUCT.getType());

                        }
                    }

                    /**
                     * 同步到学生储蓄账户的同步学生的记录
                     */
                    if (timescardRefund.getRefundType().intValue() == SignupRefundType.BY_STUDENT_ACCOUNT.getCode()) {
                        OrgStudent orgStudent = orgStudentDao.getStudent(timescardRefund.getOrgId(),
                                timescardRefund.getUserId(), DataStatus.NORMAL.getValue());
                        if (orgStudent != null) {
                            String opInfo = "退卡";
                            if (timescardRefund.getRefundPrice().longValue() > 0) {
                                txStudentFinanceAccountService.changeStudentFiannceAccount(timescardRefund.getOrgId(),
                                        timescardRefund.getCascadeId(), orgStudent.getId(), timescardRefund.getSignupPurchaseId(), StudentFiannceOpType.TIMECARD_CASH,
                                        timescardRefund.getRefundPrice(), opInfo, timescardRefund.getSignupPurchaseId().toString());
                            }
                           /* this.tXStudentCommentAPIService.saveByStudentFinanceRecord(orgStudent.getId(),
                                    timescardRefund.getRefundPrice(), null, orgCourseName,
                                    StudentFiannceOpType.QUIT_CLASS.getCode(), FinanceOpTo.INCOME.getCode());*/
                        }
                    }
                } catch (Exception e) {
                    log.warn("sync finance record fail {}", e);
                }
            }
        }
    }

    private void saveFinanceInfo(TxPurchaseTimescardRefund txPurchaseTimescardRefund) {
        int opTo = 2;// 退款

        OrgFinanceAccountRecord orgFinanceAccountRecord =
                orgFinanceAccountService.getAccountRecordInfo(txPurchaseTimescardRefund.getOrgId(), txPurchaseTimescardRefund.getCreateTime());

        TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
        txFinanceInfo.setOrgId(txPurchaseTimescardRefund.getOrgId());
        txFinanceInfo.setCreateTime(txPurchaseTimescardRefund.getCreateTime());
        txFinanceInfo.setCurrBalance(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrBalance());
        txFinanceInfo
                .setCurrFreezeMoney(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrFreezeMoney());
        txFinanceInfo.setExpectedEarning(
                orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrExpectedEarning());
        txFinanceInfo.setOpMoney(txPurchaseTimescardRefund.getRefundPrice().doubleValue() / 100);
        txFinanceInfo.setOpType(FinanceOpType.DRAWBACK.getCode());
        txFinanceInfo.setPayType(PayType.CASH.getCode());
        txFinanceInfo.setPurchaseId(txPurchaseTimescardRefund.getSignupPurchaseId() + "");
        txFinanceInfo.setCourseId(0l);

        OrgStudent orgStudent = orgStudentDao.getStudent(txPurchaseTimescardRefund.getOrgId(), txPurchaseTimescardRefund.getUserId(),
                DataStatus.NORMAL.getValue());

        StringBuffer opinfo = new StringBuffer();
        if (orgStudent != null) {
            opinfo.append("学生:").append(orgStudent.getName()).append("退卡");
        }
        txFinanceInfo.setOpInfo(opinfo.toString());
        txFinanceInfo.setOpTo(opTo);

        log.debug("saveFinanceInfo={}", txFinanceInfo);
        txFinanceInfoDao.save(txFinanceInfo);
    }

    private void saveFinanceRecordDay(TxPurchaseTimescardRefund txPurchaseTimescardRefund) {
        int opType = PayType.CASH.getCode();
        int opTo = 2;// 退款
        String mdate = DateUtil.getStrByDate(txPurchaseTimescardRefund.getCreateTime());

        TxFinanceRecordDay txFinanceRecordDay =
                txFinanceRecordDayDao.getByDayType(txPurchaseTimescardRefund.getOrgId(), mdate, opType, opTo);
        if (txFinanceRecordDay == null) {
            txFinanceRecordDay = new TxFinanceRecordDay();
            txFinanceRecordDay.setOrgId(txPurchaseTimescardRefund.getOrgId());
            txFinanceRecordDay.setMdate(txPurchaseTimescardRefund.getCreateTime());
            txFinanceRecordDay.setOpCount(1);
            txFinanceRecordDay.setOpPrice(txPurchaseTimescardRefund.getRefundPrice().doubleValue() / 100);
            txFinanceRecordDay.setOpType(opType);
            txFinanceRecordDay.setOpTo(opTo);
        } else {
            txFinanceRecordDay
                    .setOpPrice(txFinanceRecordDay.getOpPrice() + txPurchaseTimescardRefund.getRefundPrice().doubleValue() / 100);
            txFinanceRecordDay.setOpCount(txFinanceRecordDay.getOpCount() + 1);
        }

        log.debug("saveFinanceRecordDay={}", txFinanceRecordDay);
        txFinanceRecordDayDao.saveOrUpdate(txFinanceRecordDay);
    }

    private void saveSignupRecordDay(OrgSignupInfo orgSignupInfo, TxPurchaseTimescardRefund timescardRefund) {
        int opType = orgSignupInfo.getSourceType();
        int opTo = 2;// 退款
        String mdate = DateUtil.getStrByDate(timescardRefund.getCreateTime());

        TxSignupRecordDay txSignupRecordDay =
                txSignupRecordDayDao.getByDayType(timescardRefund.getOrgId(), mdate, opType, opTo);
        if (txSignupRecordDay == null) {
            txSignupRecordDay = new TxSignupRecordDay();
            txSignupRecordDay.setOrgId(timescardRefund.getOrgId());
            txSignupRecordDay.setMdate(timescardRefund.getCreateTime());
            txSignupRecordDay.setOpCount(1);
            txSignupRecordDay.setOpPrice(timescardRefund.getRefundPrice().doubleValue() / 100);
            txSignupRecordDay.setOpType(opType);
            txSignupRecordDay.setOpTo(opTo);
        } else {
            txSignupRecordDay
                    .setOpPrice(txSignupRecordDay.getOpPrice() + timescardRefund.getRefundPrice().doubleValue() / 100);
            txSignupRecordDay.setOpCount(txSignupRecordDay.getOpCount() + 1);
        }
        log.debug("saveSignupRecordDay={}", txSignupRecordDay);
        txSignupRecordDayDao.saveOrUpdate(txSignupRecordDay);
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(0l);
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(syncType.getSyncType());
        }
        return syncInfo;
    }

}
