package com.baijia.tianxiao.biz.dto.request;

import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescard;
import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import lombok.Data;
import org.apache.http.Header;

import java.util.Collection;
import java.util.Date;

/**
 * Created by wengshengli on 2017/7/17.
 */
@Data
public class TimesCardRequest extends BaseDto {

    private Long orgId;
    private Integer cascadeId;
    private Long studentId;
    private String studentName;
    private String studentMobile;
    private Long totalPrice;
    private Integer totalTimes;
    private Date startTime;
    private Date endTime;
    private Long signupPurchaseId;
    private Collection<Header> headers;


    public FillCourseInfoRequestDto buildSignupInfo() {
        FillCourseInfoRequestDto result = new FillCourseInfoRequestDto();
        result.setOrgId(orgId);
        result.setCascadeId(cascadeId);
        result.setStudentId(studentId);
        result.setStudentName(studentName);
        result.setStudentMobile(studentMobile);
        result.setTotalPrice(totalPrice.doubleValue()/100);
        result.setSignupPurchaseId(signupPurchaseId);

        TxPurchaseTimescard txPurchaseTimescard = new TxPurchaseTimescard();
        txPurchaseTimescard.setStartTime(startTime);
        txPurchaseTimescard.setEndTime(endTime);
        txPurchaseTimescard.setLessonCount(totalTimes);
        result.setTxPurchaseTimescard(txPurchaseTimescard);

        if (signupPurchaseId == null) {
            result.setSignupType(SignupType.FRONTED.getCode());
        } else {
            result.setSignupType(SignupType.POS_CARD.getCode());
        }
        result.setHeaders(headers);
        return result;
    }
}
