/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.sync.impl;

import com.baijia.tianxiao.biz.sync.SyncPayService;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="syncSignupFailPurchase")
public class SyncSignupFailPurchaseServiceImpl
implements SyncPayService {
    private static final Logger log = LoggerFactory.getLogger(SyncSignupFailPurchaseServiceImpl.class);
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgStudentDao orgStudentDao;

    @Override
    public void sync() {
        List purchaseIds = this.orgSignupInfoDao.getSignupFailPurchaseId();
        if (purchaseIds != null && purchaseIds.size() > 0) {
            log.info("sync signup fail purchaseIds=={} ", (Object)purchaseIds);
            List signupInfos = this.orgSignupInfoDao.searchByPurchaseIds((Collection)purchaseIds, new String[0]);
            for (OrgSignupInfo signupInfo : signupInfos) {
                List orgSignupCourses = this.orgSignupCourseDao.loadByPurchaseId(signupInfo.getSignupPurchaseId(), new String[0]);
                try {
                    OrgStudent orgStudent;
                    OrgSignupCourse oneSignCourse;
                    if (orgSignupCourses == null || orgSignupCourses.size() <= 0 || (oneSignCourse = (OrgSignupCourse)orgSignupCourses.get(0)) == null || (orgStudent = this.orgStudentDao.getStudent(oneSignCourse.getOrgId(), oneSignCourse.getUserId(), Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[0])) == null) continue;
                    signupInfo.setUserId(orgStudent.getUserId());
                    signupInfo.setMobile(orgStudent.getMobile());
                    signupInfo.setStudentName(orgStudent.getName());
                    signupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.PENDING.getCode()));
                    signupInfo.setUpdateTime(signupInfo.getUpdateTime());
                    log.info("sync signup fail save signupinfo ", (Object)signupInfo);
                    this.orgSignupInfoDao.saveOrUpdateSignupInfo(signupInfo);
                }
                catch (Exception e) {
                    log.error("sync signup fail", (Throwable)e);
                }
            }
        }
    }
}

