/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.sync.impl;

import com.baijia.tianxiao.biz.sync.SyncPayService;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseService;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="syncCancelSignupService")
public class SyncCancelSignupServiceImpl
implements SyncPayService {
    private static final Logger log = LoggerFactory.getLogger(SyncCancelSignupServiceImpl.class);
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgSignupCourseService orgSignupCourseService;
    @Resource
    private SignupService signupService;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private TxStudentFinanceAccountService txStudentFinanceAccountService;

    @Override
    public void sync() {
        Date last7Day = DateUtil.getDayDiff((int)-7);
        List signupInfos = this.orgSignupInfoDao.getNeedCannelPurchases(TransferClassOrder.NORMAL_ORDER, last7Day, new String[0]);
        log.info("SyncCancelSignupServiceImpl: signupInfos=={} success", (Object)signupInfos);
        if (CollectionUtils.isNotEmpty((Collection)signupInfos)) {
            for (OrgSignupInfo orgSignupInfo : signupInfos) {
                this.signupService.cancelSignupInfo(orgSignupInfo.getSignupPurchaseId(), orgSignupInfo.getOrgId());
                if (orgSignupInfo.getStudentPayPrice() == null || orgSignupInfo.getStudentPayPrice() <= 0L) continue;
                OrgStudent orgStudent = this.orgStudentDao.getStudentByUserId(orgSignupInfo.getOrgId(), orgSignupInfo.getUserId(), new String[0]);
                if (orgStudent == null) {
                    log.error("SyncCancelSignupServiceImpl  not find student =={}", (Object)orgSignupInfo);
                }
                String opInfo = this.orgSignupCourseService.getSignupCourseName(orgSignupInfo.getOrgId(), orgSignupInfo.getSignupPurchaseId());
                this.txStudentFinanceAccountService.changeStudentFiannceAccount(orgSignupInfo.getOrgId(), Integer.valueOf(-1), orgStudent.getId(), orgSignupInfo.getSignupPurchaseId(), StudentFiannceOpType.PAY_CANCEL, orgSignupInfo.getStudentPayPrice(), opInfo, "");
            }
        }
    }
}

