package com.baijia.tianxiao.biz.sync.impl;

import com.baijia.tianxiao.biz.sync.SyncPayService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.dao.TxSignupRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.dal.statistic.po.TxSignupRecordDay;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.sal.common.api.PointsMsgService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.common.constant.PointsType;
import com.baijia.tianxiao.sal.common.constant.ProducePointType;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpTo;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpType;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.sal.signup.constants.SignupRefundType;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.util.date.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/6/30 Time: 下午4:45 To change this template use File | Settings
 * | File Templates.
 */
@Service("syncSignupRefundRecordService")
@Slf4j
public class SyncSignupRefundRecordServiceImpl implements SyncPayService {
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;

    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;

    @Resource
    private OrgSignupRefundDao orgSignupRefundDao;

    @Resource
    private TxSignupRecordDayDao txSignupRecordDayDao;

    @Resource
    private OrgFinanceAccountService orgFinanceAccountService;

    @Resource
    private TxFinanceInfoDao txFinanceInfoDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private TxFinanceRecordDayDao txFinanceRecordDayDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private TxStudentFinanceAccountService txStudentFinanceAccountService;

    @Autowired
    private TXStudentCommentAPIService tXStudentCommentAPIService;

    @Autowired
    private PointsMsgService pointsMsgService;

    private AtomicBoolean signupRefundRecordFlag = new AtomicBoolean(false);

    @Override
    public void sync() {

        TxMsgSyncTimestamp syncInfo = getSyncInfo(MsgSyncType.CW_SIGNUP_REFUND_RECORD);
        try {
            if (!signupRefundRecordFlag.get()) {
                log.info("sync cw signuprecord refund info :{}", syncInfo);
                signupRefundRecordFlag.set(true);
                syncSignupRefundRecordDay(syncInfo);
                signupRefundRecordFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", e);
        } finally {
            signupRefundRecordFlag.set(false);
        }
        log.info("save sync signuprefund info:{}", syncInfo);
        txMsgSyncTimestampDao.saveOrUpdate(syncInfo);
    }

    private void syncSignupRefundRecordDay(TxMsgSyncTimestamp syncInfo) {
        List<OrgSignupRefund> signupRefunds =
                orgSignupRefundDao.getOrgSignupRefundListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100);

        log.info("save syncSignupRefundRecordDay:{} success", signupRefunds.size());

        if (CollectionUtils.isNotEmpty(signupRefunds)) {
            for (OrgSignupRefund orgSignupRefund : signupRefunds) {
                try {
                    if (orgSignupRefund.getId() > syncInfo.getSyncId()) {
                        syncInfo.setSyncId(Long.valueOf(orgSignupRefund.getId()));
                    }
                    if (orgSignupRefund.getSignupPurchaseId() != null
                            && orgSignupRefund.getSignupPurchaseId().longValue() > 0) {
                        OrgSignupInfo orgSignupInfo =
                                orgSignupInfoDao.searchByPurchaseId(orgSignupRefund.getSignupPurchaseId());
                        if (orgSignupInfo != null) {
                            saveSignupRecordDay(orgSignupInfo, orgSignupRefund);
                        }
                    }
                    /**
                     * 直接机构退现金的才同步收支
                     */
                    if ((orgSignupRefund.getRefundType().intValue() == SignupRefundType.BY_ORG_CASH.getCode() ||
                            orgSignupRefund.getRefundType().intValue() == SignupRefundType.BY_OLD_PURCHASE_CASH.getCode())) {
                        if (orgSignupRefund.getRefundPrice().longValue() > 0) {
                            saveFinanceInfo(orgSignupRefund);
                            saveFinanceRecordDay(orgSignupRefund);
                            pointsMsgService.pointsMessage(ProducePointType.CLASS_REFUND, (long) orgSignupRefund.getId(), orgSignupRefund.getOrgId(), orgSignupRefund.getUserId(), orgSignupRefund.getRefundPrice(), PointsType.DEDUCT.getType());
                        } else {
                            appendQuitCashComment(orgSignupRefund);//记录跟进记录
                        }
                    }

                    /**
                     * 同步到学生储蓄账户的同步学生的记录
                     */
                    if (orgSignupRefund.getRefundType().intValue() == SignupRefundType.BY_STUDENT_ACCOUNT.getCode()) {
                        OrgStudent orgStudent = orgStudentDao.getStudent(orgSignupRefund.getOrgId(),
                                orgSignupRefund.getUserId(), DataStatus.NORMAL.getValue());
                        if (orgStudent != null) {
                            String orgCourseName = orgCourseDao.getCourseNameById(orgSignupRefund.getCourseId());
                            String opInfo = "从" + orgCourseName + "退班";
                            if (orgSignupRefund.getRefundPrice().longValue() > 0) {
                                txStudentFinanceAccountService.changeStudentFiannceAccount(orgSignupRefund.getOrgId(),
                                        orgSignupRefund.getCascadeId(), orgStudent.getId(), orgSignupRefund.getSignupPurchaseId(), StudentFiannceOpType.QUIT_CLASS,
                                        orgSignupRefund.getRefundPrice(), opInfo, orgSignupRefund.getSignupPurchaseId() + "_" + orgSignupRefund.getUserId() + "_" + orgSignupRefund.getCourseId());
                            }
                            this.tXStudentCommentAPIService.saveByStudentFinanceRecord(orgStudent.getId(),
                                    orgSignupRefund.getRefundPrice(), null, orgCourseName,
                                    StudentFiannceOpType.QUIT_CLASS.getCode(), FinanceOpTo.INCOME.getCode());
                        }
                    }
                } catch (Exception e) {
                    log.warn("sync finance record fail {}", e.getMessage());
                }
            }
        }
    }

    private void saveFinanceInfo(OrgSignupRefund orgSignupRefund) {
        int opTo = 2;// 退款

        OrgCourse orgCourse = orgCourseDao.getByCourseId(orgSignupRefund.getCourseId());
        // 由访问数据表改为调用支付
        // OrgFinanceAccountRecord orgFinanceAccountRecord =
        // orgFinanceAccountRecordDao.currentAccount(orgSignupInfo.getOrgId(), orgSignupInfo.getCreateTime());
        OrgFinanceAccountRecord orgFinanceAccountRecord =
                orgFinanceAccountService.getAccountRecordInfo(orgSignupRefund.getOrgId(), orgSignupRefund.getCreateTime());

        TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
        txFinanceInfo.setOrgId(orgSignupRefund.getOrgId());
        txFinanceInfo.setCreateTime(orgSignupRefund.getCreateTime());
        txFinanceInfo.setCurrBalance(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrBalance());
        txFinanceInfo
                .setCurrFreezeMoney(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrFreezeMoney());
        txFinanceInfo.setExpectedEarning(
                orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrExpectedEarning());
        txFinanceInfo.setOpMoney(orgSignupRefund.getRefundPrice().doubleValue() / 100);
        txFinanceInfo.setOpType(FinanceOpType.DRAWBACK.getCode());
        txFinanceInfo.setPayType(PayType.CASH.getCode());
        txFinanceInfo.setPurchaseId(orgSignupRefund.getSignupPurchaseId() + "");
        txFinanceInfo.setCourseId(orgCourse.getId());

        OrgStudent orgStudent = orgStudentDao.getStudent(orgSignupRefund.getOrgId(), orgSignupRefund.getUserId(),
                DataStatus.NORMAL.getValue());

        StringBuffer opinfo = new StringBuffer();
        opinfo.append(orgCourse != null ? orgCourse.getName() : "").append(" ");
        if (orgStudent != null) {
            opinfo.append("学生:").append(orgStudent.getName()).append(" ");
        }
        txFinanceInfo.setOpInfo(opinfo.toString());
        txFinanceInfo.setOpTo(opTo);

        log.debug("saveFinanceInfo={}", txFinanceInfo);
        txFinanceInfoDao.save(txFinanceInfo);
    }

    private void saveFinanceRecordDay(OrgSignupRefund orgSignupRefund) {
        int opType = PayType.CASH.getCode();
        int opTo = 2;// 退款
        String mdate = DateUtil.getStrByDate(orgSignupRefund.getCreateTime());

        TxFinanceRecordDay txFinanceRecordDay =
                txFinanceRecordDayDao.getByDayType(orgSignupRefund.getOrgId(), mdate, opType, opTo);
        if (txFinanceRecordDay == null) {
            txFinanceRecordDay = new TxFinanceRecordDay();
            txFinanceRecordDay.setOrgId(orgSignupRefund.getOrgId());
            txFinanceRecordDay.setMdate(orgSignupRefund.getCreateTime());
            txFinanceRecordDay.setOpCount(1);
            txFinanceRecordDay.setOpPrice(orgSignupRefund.getRefundPrice().doubleValue() / 100);
            txFinanceRecordDay.setOpType(opType);
            txFinanceRecordDay.setOpTo(opTo);
        } else {
            txFinanceRecordDay
                    .setOpPrice(txFinanceRecordDay.getOpPrice() + orgSignupRefund.getRefundPrice().doubleValue() / 100);
            txFinanceRecordDay.setOpCount(txFinanceRecordDay.getOpCount() + 1);
        }
        // 逻辑单独开了,其它跟进记录的变更仍然监听yunying.tx_student_finance_record(保持对充值的处理)
        appendQuitCashComment(orgSignupRefund);

        log.debug("saveFinanceRecordDay={}", txFinanceRecordDay);
        txFinanceRecordDayDao.saveOrUpdate(txFinanceRecordDay);
    }

    /**
     * @param orgSignupRefund
     * @param
     */

    private void appendQuitCashComment(OrgSignupRefund orgSignupRefund) {
        Long userId = orgSignupRefund.getUserId();
        OrgStudent studentByUserId = this.orgStudentDao.getStudentByUserId(orgSignupRefund.getOrgId(), userId, "id");
        if (studentByUserId != null) {
            Long opMoney = orgSignupRefund.getRefundPrice();
            String orgCourseName = orgCourseDao.getCourseNameById(orgSignupRefund.getCourseId());
            String opInfo = orgCourseName;
            this.tXStudentCommentAPIService.saveByStudentFinanceRecord(studentByUserId.getId(), opMoney, null, opInfo,
                    StudentFiannceOpType.QUIT_CLASS.getCode(), 2); // opTo=2 代表机构支出
        } else {
            log.info("can not find any student with userId:{} ", orgSignupRefund.getUserId());
        }
    }

    private void saveSignupRecordDay(OrgSignupInfo orgSignupInfo, OrgSignupRefund orgSignupRefund) {
        int opType = orgSignupInfo.getSourceType();
        int opTo = 2;// 退款
        String mdate = DateUtil.getStrByDate(orgSignupRefund.getCreateTime());

        TxSignupRecordDay txSignupRecordDay =
                txSignupRecordDayDao.getByDayType(orgSignupRefund.getOrgId(), mdate, opType, opTo);
        if (txSignupRecordDay == null) {
            txSignupRecordDay = new TxSignupRecordDay();
            txSignupRecordDay.setOrgId(orgSignupRefund.getOrgId());
            txSignupRecordDay.setMdate(orgSignupRefund.getCreateTime());
            txSignupRecordDay.setOpCount(1);
            txSignupRecordDay.setOpPrice(orgSignupRefund.getRefundPrice().doubleValue() / 100);
            txSignupRecordDay.setOpType(opType);
            txSignupRecordDay.setOpTo(opTo);
        } else {
            txSignupRecordDay
                    .setOpPrice(txSignupRecordDay.getOpPrice() + orgSignupRefund.getRefundPrice().doubleValue() / 100);
            txSignupRecordDay.setOpCount(txSignupRecordDay.getOpCount() + 1);
        }
        log.debug("saveSignupRecordDay={}", txSignupRecordDay);
        txSignupRecordDayDao.saveOrUpdate(txSignupRecordDay);
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(0l);
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(syncType.getSyncType());
        }
        return syncInfo;
    }

}
