package com.baijia.tianxiao.biz.sync.impl;

import com.baijia.tianxiao.biz.sync.SyncPayService;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/9/19 Time: 下午9:01 To change this template use File | Settings
 * | File Templates.
 *
 * 解决报名系统中有报名错误的单子
 */
@Service("syncSignupFailPurchase")
@Slf4j
public class SyncSignupFailPurchaseServiceImpl implements SyncPayService {

    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;

    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;

    @Autowired
    private OrgStudentDao orgStudentDao;

    @Override
    public void sync() {
        List<Long> purchaseIds = orgSignupInfoDao.getSignupFailPurchaseId();
        if (purchaseIds != null && purchaseIds.size() > 0) {
            log.info("sync signup fail purchaseIds=={} ", purchaseIds);
            List<OrgSignupInfo> signupInfos = orgSignupInfoDao.searchByPurchaseIds(purchaseIds);

            for (OrgSignupInfo signupInfo : signupInfos) {
                List<OrgSignupCourse> orgSignupCourses =
                    orgSignupCourseDao.loadByPurchaseId(signupInfo.getSignupPurchaseId());

                try {
                    if (orgSignupCourses != null && orgSignupCourses.size() > 0) {
                        OrgSignupCourse oneSignCourse = orgSignupCourses.get(0);
                        if (oneSignCourse != null) {
                            OrgStudent orgStudent = orgStudentDao.getStudent(oneSignCourse.getOrgId(),
                                oneSignCourse.getUserId(), DeleteStatus.NORMAL.getValue());
                            if (orgStudent != null) {
                                signupInfo.setUserId(orgStudent.getUserId());
                                signupInfo.setMobile(orgStudent.getMobile());
                                signupInfo.setStudentName(orgStudent.getName());
                                signupInfo.setSplitResult(SplitCourseResult.PENDING.getCode());
                                signupInfo.setUpdateTime(signupInfo.getUpdateTime());

                                log.info("sync signup fail save signupinfo ", signupInfo);
                                orgSignupInfoDao.saveOrUpdateSignupInfo(signupInfo);
                            }
                        }
                    }
                } catch (Exception e) {
                    log.error("sync signup fail", e);
                }
            }
        }
    }
}
