package com.baijia.tianxiao.biz.service.impl;

import com.baijia.tianxiao.biz.service.TxSignupService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.constant.finance.PurchaseRechargeStatus;
import com.baijia.tianxiao.constant.finance.PurchaseTimescardStatus;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassInfo;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseRechargeDao;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseTimescardDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescard;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.sal.common.api.PointsMsgService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.common.constant.PointsType;
import com.baijia.tianxiao.sal.common.constant.ProducePointType;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sal.signup.constants.SignupSourceType;
import com.baijia.tianxiao.sal.signup.service.TransferClassInfoService;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by wengshengli on 2017/5/24.
 */
@Service
@Slf4j
public class TxSignupServiceImpl implements TxSignupService {

    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;

    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgInfoDao orgInfoDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private TXSaleClueRuleService tXSaleClueRuleService;

    @Resource
    private TransferClassInfoService transferClassInfoService;

    @Autowired
    private TXStudentCommentAPIService txStudentCommentAPIService;

    @Resource
    private TxStudentFinanceAccountService txStudentFinanceAccountService;

    @Resource
    private CommonMsgService commonMsgService;

    @Autowired
    private TxPurchaseRechargeDao txPurchaseRechargeDao;

    @Autowired
    private TxPurchaseTimescardDao txPurchaseTimescardDao;

    @Autowired
    private PointsMsgService pointsMsgService;

    @Autowired
    private TxTransferClassInfoDao txTransferClassinfoDao;


    @Override
    public void syncSuccessSignup(OrgSignupInfo signupInfo) {
        ProducePointType producePointType = null;
        if (signupInfo.getOrderType().intValue() == TransferClassOrder.NORMAL_ORDER.getCode()
                || signupInfo.getOrderType().intValue() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
            normalOrder(signupInfo);
            producePointType = ProducePointType.SIGNUP;
        } else if (signupInfo.getOrderType().intValue() == TransferClassOrder.RECHARGE_ORDER.getCode()) {
            rechargeOrder(signupInfo);
            producePointType = ProducePointType.RECHARGE;
        } else if (signupInfo.getOrderType().intValue() == TransferClassOrder.TIMESCARD_ORDER.getCode()) {
            timescardOrder(signupInfo);
            producePointType = ProducePointType.TIMECARD;
        }

        pointsMsgService.pointsMessage(producePointType, signupInfo.getId(), signupInfo.getOrgId(), signupInfo.getUserId(), signupInfo.getTotalPrices(), PointsType.PRODUCT.getType());
    }

    public void rechargeOrder(OrgSignupInfo signupInfo) {
        OrgStudent orgStudent = orgStudentDao.getStudent(signupInfo.getOrgId().longValue(), signupInfo.getUserId(),
                DataStatus.NORMAL.getValue());
        if (signupInfo.getTotalPrices().longValue() > 0) {
            if (orgStudent != null) {
                txStudentFinanceAccountService.changeStudentFiannceAccount(signupInfo.getOrgId().longValue(), signupInfo.getCascadeId(),
                        orgStudent.getId(), signupInfo.getSignupPurchaseId(), StudentFiannceOpType.RECHARGE, signupInfo.getTotalPrices(),
                        "充值成功", signupInfo.getSignupPurchaseId().toString());
            }
        }

        /**
         * 修改为支付成功
         */
        txPurchaseRechargeDao.updateStatusByPurchaseId(signupInfo.getSignupPurchaseId(),
                PurchaseRechargeStatus.SUCCESS.getCode());

        OrgInfo orginfo = orgInfoDao.getOrgInfo(signupInfo.getOrgId().intValue(), "shortname");
        TXSaleClueRule txSaleClueRule = tXSaleClueRuleService.getByOrgId(signupInfo.getOrgId().intValue());
        // 机构是否报名发短信设置设置
        if (txSaleClueRule != null && txSaleClueRule.getSignupMsg() != null
                && txSaleClueRule.getSignupMsg().intValue() == 0) {
            String content =
                    SmsContentHelper.createRechargeSms(signupInfo.getStudentName(), signupInfo.getPayTime().getTime(), signupInfo.getTotalPrices().doubleValue() / 100, orginfo.getShortName());
            commonMsgService.sendTxSms(signupInfo.getOrgId().longValue(), signupInfo.getOrgId().longValue(), UserRole.ORGANIZATION.getRole(), orgStudent == null ? 0 : orgStudent.getId(), UserRole.STUDENT.getRole(), TxSmsCodeType.RECHARGE_SMS_CODE, null, signupInfo.getMobile(), content);
        }

        if (signupInfo != null) {
            signupInfo.setSmsSend(1);// 已发送
            log.info("sms before orgsignupinfo = {},result={}", signupInfo,
                    signupInfo.getSourceType().intValue() != SignupSourceType.TUIGUANG.getCode());

            orgSignupInfoDao.update(signupInfo, "smsSend");

        }
    }

    public void timescardOrder(OrgSignupInfo signupInfo) {
        OrgStudent orgStudent = orgStudentDao.getStudent(signupInfo.getOrgId().longValue(), signupInfo.getUserId(),
                DataStatus.NORMAL.getValue());
        /**
         * 修改为支付成功
         */
        txPurchaseTimescardDao.updateStatusByPurchaseId(signupInfo.getSignupPurchaseId(),
                PurchaseTimescardStatus.SUCCESS.getCode());

        OrgInfo orginfo = orgInfoDao.getOrgInfo(signupInfo.getOrgId().intValue(), "shortname");
        TXSaleClueRule txSaleClueRule = tXSaleClueRuleService.getByOrgId(signupInfo.getOrgId().intValue());
        // 机构是否报名发短信设置设置
        if (txSaleClueRule != null && txSaleClueRule.getSignupMsg() != null
                && txSaleClueRule.getSignupMsg().intValue() == 0) {
            TxPurchaseTimescard txPurchaseTimescard = txPurchaseTimescardDao.getBySignupPurchase(signupInfo.getOrgId(), signupInfo.getSignupPurchaseId());
            if (txPurchaseTimescard != null) {
                String content =
                        SmsContentHelper.createTimescardSms(txPurchaseTimescard.getCreateTime().getTime(), txPurchaseTimescard.getLessonCount(), txPurchaseTimescard.getEndTime(), orginfo.getShortName());
                commonMsgService.sendTxSms(signupInfo.getOrgId().longValue(), signupInfo.getOrgId().longValue(), UserRole.ORGANIZATION.getRole(), orgStudent == null ? 0 : orgStudent.getId(), UserRole.STUDENT.getRole(), TxSmsCodeType.TIMECARD_SMS_CODE_COUNT, null, signupInfo.getMobile(), content);
            }
        }

        if (signupInfo != null) {
            signupInfo.setSmsSend(1);// 已发送
            log.info("sms before orgsignupinfo = {},result={}", signupInfo,
                    signupInfo.getSourceType().intValue() != SignupSourceType.TUIGUANG.getCode());

            orgSignupInfoDao.update(signupInfo, "smsSend");

        }
    }

    public void normalOrder(OrgSignupInfo signupInfo) {
        List<OrgSignupCourse> signupCourses =
                orgSignupCourseDao.loadByPurchaseId(signupInfo.getSignupPurchaseId());
        if (CollectionUtils.isEmpty(signupCourses)) {
            return;
        }
        signupInfo.setOrgSignupCourses(signupCourses);


        if (signupInfo.getOrderType().intValue() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
            TxTransferClassInfo txTransferClassInfo = txTransferClassinfoDao.getByInPurchaseId(signupInfo.getSignupPurchaseId());
            if (txTransferClassInfo == null) {
                return;//主从延迟问题
            }
            transferClassInfoService.confirmTransferClass(signupInfo.getSignupPurchaseId());
        }

        Map<Long, OrgSignupCourse> courseMap =
                CollectorUtil.collectMap(signupCourses, new Function<OrgSignupCourse, Long>() {
                    @Override
                    public Long apply(OrgSignupCourse orgSignupCourse) {
                        return orgSignupCourse.getOrgCourseId();
                    }
                });
        StringBuilder sb = new StringBuilder();
        List<String> names = Lists.newArrayList();

        List<OrgCourse> courseList = orgCourseDao.getByIds(courseMap.keySet());
        int courseCount = courseList.size();
        String courseName = "";
        for (int i = 0; i < courseList.size(); i++) {
            OrgCourse tempCourse = courseList.get(i);
            if (GenericsUtils.isNullOrEmpty(courseName)) {
                courseName = tempCourse.getName();
            }
            sb.append("“" + tempCourse.getName() + "“");
            names.add(tempCourse.getName());
            if (i < courseList.size() - 1) {
                sb.append("、");
            }

            //课消预发布版本兼容线上，修改合同课次lesson_count = count where lesson_count=0
            if (tempCourse.getCourseType().intValue() == CourseTypeEnum.COURSE_TYPE_1v1.getCode().intValue()) {
                orgSignupCourseDao.updateLessonCountByPurchaseId(signupInfo.getSignupPurchaseId(), tempCourse.getId());
            }
        }

        // 如果课程已经修改收费方式，支付完成后自动补信息
        updateSignupCourseCharge(courseList, courseMap);

        Map<Long, OrgCourse> courseMap_ = GenericsUtils.toFieldMap(courseList, "id");
        log.info("courseMap_ is :{} ", courseMap_);
        OrgSignupInfo orgSignupInfo = signupInfo;
        Map<Long, OrgSignupCourse> orgSignupCourseMap = Maps.newHashMap();
        Map<Long, OrgCourse> orgCourseMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(signupCourses)) {
            for (OrgSignupCourse orgSignupCourse : signupCourses) {
                orgCourseMap.put(orgSignupCourse.getOrgCourseId(),
                        courseMap_.get(orgSignupCourse.getOrgCourseId()));
                orgSignupCourseMap.put(orgSignupCourse.getOrgCourseId(), orgSignupCourse);
            }
        }
        // 记录跟进记录
        txStudentCommentAPIService.saveBySignUpPurchase(orgSignupInfo, orgSignupCourseMap, orgCourseMap);

        Integer orgId = signupInfo.getOrgId().intValue();
        OrgInfo orginfo = orgInfoDao.getOrgInfo(orgId, "shortname");
        log.info("SignupInfoSmsProcessor :orgsignupInfo={}", signupInfo);

        /**
         * 修改为支付成功
         */
        orgSignupCourseDao.updateStatusByPurchaseId(signupInfo.getSignupPurchaseId(),
                SignupCourseStatus.HAS_PAY.getCode());

        OrgStudent orgStudent = orgStudentDao.getStudent(orgId.longValue(), signupInfo.getUserId(),
                DataStatus.NORMAL.getValue());
        if (signupInfo.getStudentPayPrice().longValue() > 0) {
            if (orgStudent != null) {
                txStudentFinanceAccountService.changeStudentFiannceAccount(orgId.longValue(), -1,
                        orgStudent.getId(), signupInfo.getSignupPurchaseId(), StudentFiannceOpType.PAY_SUCCESS, signupInfo.getStudentPayPrice(),
                        "支付成功", "");
            }
        }

        log.info("courseCount > 0 :{} ", courseCount > 0);
        TXSaleClueRule txSaleClueRule = tXSaleClueRuleService.getByOrgId(orgId);
        // 机构是否报名发短信设置设置
        if (txSaleClueRule != null && txSaleClueRule.getSignupMsg() != null
                && txSaleClueRule.getSignupMsg().intValue() == 0 && courseCount > 0) {
            String content =
                    SmsContentHelper.createSignupCourseSmsMsg(courseName, courseCount, orginfo.getShortName());
            commonMsgService.sendTxSms(orgId.longValue(), orgId.longValue(), UserRole.ORGANIZATION.getRole(), orgStudent == null ? 0 : orgStudent.getId(), UserRole.STUDENT.getRole(), TxSmsCodeType.SIGNUP_NOTIFY_WITH_MANY, null, signupInfo.getMobile(), content);
        }

        if (signupInfo != null) {
            signupInfo.setSmsSend(1);// 已发送
            log.info("sms before orgsignupinfo = {},result={}", signupInfo,
                    signupInfo.getSourceType().intValue() != SignupSourceType.TUIGUANG.getCode());

            orgSignupInfoDao.update(signupInfo, "smsSend");

        }
    }

    private void updateSignupCourseCharge(List<OrgCourse> courseList, Map<Long, OrgSignupCourse> signupCourseMap) {
        for (OrgCourse orgCourse : courseList) {
            OrgSignupCourse orgSignupCourse = signupCourseMap.get(orgCourse.getId());
            if (orgSignupCourse.getChargeUnit() == ChargeUnit.BY_OTHER.getCode()
                    && orgCourse.getChargeUnit() != ChargeUnit.BY_OTHER.getCode()) {
                orgSignupCourseDao.update(orgSignupCourse, "chargeUnit");
            }
        }
    }

}
