package com.baijia.tianxiao.biz.service.impl;

import com.baijia.tianxiao.biz.dto.response.SignupStudentDto;
import com.baijia.tianxiao.biz.service.RechargeService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceAccountDao;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.constant.SignupStatus;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseRechargeDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.SignupErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.image.AvatarUtil;
import com.baijia.tianxiao.sal.organization.constant.OrgSinupPurchaseStatus;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.constants.SignupSourceType;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.signup.service.TxPurchaseRechargeService;
import com.baijia.tianxiao.sal.signup.service.TxPurchaseTimescardService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.api.OrgStudentTagService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgTagListResopnseDto;
import com.baijia.tianxiao.util.DigitUppercaseUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.rest.RestUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

import static com.baijia.tianxiao.sal.signup.service.SignupService.HUNDRED;


/**
 * Created by wengshengli on 2017/7/12.
 */
@Service
@Slf4j
public class RechargeServiceImpl implements RechargeService {

    @Autowired
    private OrgAccountDao orgAccountDao;

    @Autowired
    private SignupService signupService;

    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;

    @Autowired
    private TxPurchaseRechargeDao txPurchaseRechargeDao;

    @Autowired
    private OrgStudentService orgStudentService;

    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;

    @Autowired
    private TxPurchaseRechargeService txPurchaseRechargeService;

    @Autowired
    private TxPurchaseTimescardService txPurchaseTimescardService;

    @Autowired
    private OrgStudentDao orgStudentDao;

    @Autowired
    private OrgStudentTagService orgStudentTagService;

    @Autowired
    private OrgStorageDao orgStorageDao;

    @Autowired
    private TxStudentFinanceAccountDao txStudentFinanceAccountDao;

    @Override
    public SignupStudentDto updateStudent(FillCourseInfoRequestDto signupInfo) {
        Long userId = signupService.getStudent(signupInfo);

        SignupStudentDto result = new SignupStudentDto();
        if (userId != null && userId.intValue() > 0) {
            OrgStudent orgStudent = orgStudentDao.getStudentByUserId(signupInfo.getOrgId(), userId);
            result = SignupStudentDto.buildByStudnet(orgStudent);
            if (orgStudent != null && orgStudent.getAvatar() != null) {
                OrgStorage storage = orgStorageDao.getById(orgStudent.getAvatar().intValue());
                if (storage != null) {
                    String url = StorageUtil.constructUrl(storage.getFid(), storage.getSn(), storage.getMimeType());
                    result.setStudentAvatar(url);
                }
            }
            if (result.getStudentAvatar() == null) {
                result.setStudentAvatar(AvatarUtil.getUserAvatar(orgStudent == null ? 0 : orgStudent.getId()));
            }

            if (orgStudent != null) {
                TxStudentFinanceAccount txStudentFinanceAccount =
                        txStudentFinanceAccountDao.getFinanceAccount(signupInfo.getOrgId(), orgStudent.getId());
                if (txStudentFinanceAccount != null) {
                    result.setStudentBalance(txStudentFinanceAccount.getBalance().doubleValue() / 100);
                }
            }
        }
        return result;
    }

    @Override
    public OrgSingupInfoDto rechargePurchase(FillCourseInfoRequestDto fillCourseInfoRequestDto) {
        Preconditions.checkNotNull(fillCourseInfoRequestDto.getOrgId(), "orgId may not be null");
        fillCourseInfoRequestDto.setOrgNumber(getOrgNumber(fillCourseInfoRequestDto.getOrgId()));
        Preconditions.checkNotNull(fillCourseInfoRequestDto.getOrgNumber(), "orgNumber may not be null");
        Long orgId = fillCourseInfoRequestDto.getOrgId();
        Long orgNumber = fillCourseInfoRequestDto.getOrgNumber();
        log.info("signUp--> orgId {}, signupPurchaseId {}", orgId, fillCourseInfoRequestDto.getSignupPurchaseId());

        if (fillCourseInfoRequestDto.getTxPurchaseTimescard() != null && fillCourseInfoRequestDto.getTxPurchaseTimescard().getLessonCount() != null) {
            if (fillCourseInfoRequestDto.getTxPurchaseTimescard().getLessonCount() > 10000
                    || fillCourseInfoRequestDto.getTxPurchaseTimescard().getLessonCount() < -1) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "合同次数过大");
            }
        }

        OrgSingupInfoDto dto = null;
        if (fillCourseInfoRequestDto.getSignupType() == SignupType.POS_CARD.getCode()) {// 刷卡报名
            if (!signupService.isPurchaseSucce(fillCourseInfoRequestDto.getSignupPurchaseId(), orgId,
                    fillCourseInfoRequestDto.getCascadeId())) {
                throw new BussinessException(SignupErrorCode.PURCHASE_NOT_SUCCEED);
            }
            dto = rechargeAfterPay(fillCourseInfoRequestDto, orgId, orgNumber);
            return dto;
        } else if (fillCourseInfoRequestDto.getSignupType() == SignupType.FRONTED.getCode()) {// 前端报名
            dto = rechargeBeforePay(fillCourseInfoRequestDto, orgId, orgNumber);
            return dto;
        } else {
            throw new BussinessException(SignupErrorCode.UNKNOWN_PURCHASE_STATUS);
        }
    }

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), "number");
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? number.longValue() : null;
    }


    private OrgSingupInfoDto rechargeBeforePay(FillCourseInfoRequestDto fillCourseInfoRequestDto, Long orgId,
                                               Long orgNumber) throws BussinessException {
        double totalPrice = fillCourseInfoRequestDto.getTotalPrice();
        totalPrice = new BigDecimal(totalPrice).setScale(2, RoundingMode.HALF_UP).doubleValue();
        if (totalPrice > MAX_SIGNUP_MONEY || totalPrice <= 0) {
            throw new BussinessException(SignupErrorCode.TOTALPRICE_ERROR,
                    SignupErrorCode.TOTALPRICE_ERROR.getMessage());
        }

        long begin = System.currentTimeMillis();
        Long purchaseId = RestUtils.getPurchaseId(orgId, totalPrice, fillCourseInfoRequestDto.getHeaders());
        String tradeNo = RestUtils.getTradeNo(orgId, purchaseId, totalPrice, fillCourseInfoRequestDto.getHeaders());
        long end = System.currentTimeMillis();
        log.info("getPurchaseId--> {}，cost time={}", purchaseId, end - begin);
        OrgSignupInfo orgSignupInfo = new OrgSignupInfo();
        orgSignupInfo.setStudentPayPrice(0l);
        orgSignupInfo.setStatus(DataStatus.NORMAL.getValue());
        orgSignupInfo.setCreateTime(new Date());
        orgSignupInfo.setSplitResult(SplitCourseResult.PENDING.getCode());
        fillOrgSignupInfo(fillCourseInfoRequestDto, orgSignupInfo, orgId, orgNumber);
        orgSignupInfo.setSignupPurchaseId(purchaseId);
        orgSignupInfo.setPayPurchaseId(purchaseId);
        orgSignupInfo.setTradeNo(Long.parseLong(tradeNo));
        orgSignupInfo
                .setTotalPrices(NumberUtil.multiply(fillCourseInfoRequestDto.getTotalPrice(), HUNDRED, 0).longValue());

        orgSignupInfo.setHeaders(fillCourseInfoRequestDto.getHeaders());
        orgSignupInfo.setSourceType(fillCourseInfoRequestDto.getSourceType());
        orgSignupInfo.setOrderType(fillCourseInfoRequestDto.getTransferClassOrder());
        orgSignupInfo.setTxPurchaseTimescard(fillCourseInfoRequestDto.getTxPurchaseTimescard());

        this.saveOrUpdateSignupInfo(orgSignupInfo, true);

        boolean isShowMobile =
                txCascadeCredentialService.isShowMobile(orgId, fillCourseInfoRequestDto.getCascadeId());

        return buildOrgSignupInfoDto(orgSignupInfo, isShowMobile);

    }


    private OrgSingupInfoDto rechargeAfterPay(FillCourseInfoRequestDto fillCourseInfoRequestDto, Long orgId,
                                              Long orgNumber) throws BussinessException {
        OrgSignupInfo orgSignupInfo = null;
        /**
         * 获取报名信息
         */
        if (fillCourseInfoRequestDto.getSignupPurchaseId() != null) {
            orgSignupInfo = orgSignupInfoDao.searchByPurchaseId(fillCourseInfoRequestDto.getSignupPurchaseId(), true);
        }

        if (orgSignupInfo == null || orgSignupInfo.getSignupType().intValue() != 0) {
            throw new BussinessException(SignupErrorCode.PURCHASEID_ERROR);
        }
        // 添加如果订单已经拆分完成,那么直接出提示
        if (orgSignupInfo != null && orgSignupInfo.getSplitResult().intValue() == SplitCourseResult.SUCCESS.getCode()) {
            throw new BussinessException(SignupErrorCode.COURCE_CHANGE);
        }

        // 如果已经报名成功，返回错误
        if (orgSignupInfo.getSplitResult().intValue() >= SplitCourseResult.PENDING.getCode()) {
            throw new BussinessException(SignupErrorCode.REPEAT_SUBMIT);
        }

        fillOrgSignupInfo(fillCourseInfoRequestDto, orgSignupInfo, orgId, orgNumber);
        orgSignupInfo.setSplitResult(SplitCourseResult.PENDING.getCode());

        if (orgSignupInfo.getPayType().intValue() == PayType.CASH.getCode()) {
            orgSignupInfo.setSplitResult(SplitCourseResult.SUCCESS.getCode());
        } else {
            orgSignupInfo.setSplitResult(SplitCourseResult.PENDING.getCode());
        }
        orgSignupInfo.setSourceType(fillCourseInfoRequestDto.getSourceType());
        this.saveOrUpdateSignupInfo(orgSignupInfo, true);
        orgSignupInfo.setPurchaseStatus(PayResult.SUCCESS.getCode());

        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, fillCourseInfoRequestDto.getCascadeId());

        return buildOrgSignupInfoDto(orgSignupInfo, isShowMobile);
    }


    private void fillOrgSignupInfo(FillCourseInfoRequestDto fillCourseInfoRequestDto, OrgSignupInfo orgSignupInfo,
                                   Long orgId, Long orgNumber) throws BussinessException {
        long begin = System.currentTimeMillis();
        Long stuUserId = signupService.getStudent(fillCourseInfoRequestDto);
        long end = System.currentTimeMillis();
        log.debug("-->    getStudent cost{}", end - begin);
        orgSignupInfo.setUserId(stuUserId);
        orgSignupInfo.setStudentId(fillCourseInfoRequestDto.getStudentId());
        orgSignupInfo.setOrgId(orgId);
        orgSignupInfo.setOrgNumber(orgNumber);
        orgSignupInfo.setMobile(fillCourseInfoRequestDto.getStudentMobile());
        orgSignupInfo.setStudentName(fillCourseInfoRequestDto.getStudentName());
        orgSignupInfo.setOrderType(fillCourseInfoRequestDto.getTransferClassOrder());
        if (orgSignupInfo.getPayType() == null) {
            orgSignupInfo.setPayType(PayType.PAY_POS_CARD.getCode());
        }

        orgSignupInfo.setRemark(StringUtils.isEmpty(fillCourseInfoRequestDto.getRemark()) ? orgSignupInfo.getRemark()
                : fillCourseInfoRequestDto.getRemark());
        orgSignupInfo.setRemark(orgSignupInfo.getRemark() == null ? "" : orgSignupInfo.getRemark());
        orgSignupInfo.setOperator("");
        orgSignupInfo.setUpdateTime(new Date());
        orgSignupInfo.setSignupType(fillCourseInfoRequestDto.getSignupType());
        if (orgSignupInfo.getCascadeId() == null || orgSignupInfo.getCascadeId().intValue() == 0) {
            orgSignupInfo.setCascadeId(
                    fillCourseInfoRequestDto.getCascadeId() == null ? 0 : fillCourseInfoRequestDto.getCascadeId());
        }
    }

    private void fillSignupStudentInfo(OrgSingupInfoDto dto, OrgSignupInfo orgSignupInfo) {

        if (orgSignupInfo.getUserId() != null && orgSignupInfo.getUserId().longValue() > 0) {
            OrgStudent orgStudent = orgStudentDao.getStudent(orgSignupInfo.getOrgId(), orgSignupInfo.getUserId(),
                    DataStatus.NORMAL.getValue());
            if (orgStudent != null) {
                TxStudentFinanceAccount txStudentFinanceAccount =
                        txStudentFinanceAccountDao.getFinanceAccount(orgSignupInfo.getOrgId(), orgStudent.getId());
                if (txStudentFinanceAccount != null) {
                    dto.setStudentAccountBalance(txStudentFinanceAccount.getBalance().doubleValue() / 100);
                }
            }
        }
    }


    private void saveOrUpdateSignupInfo(@NonNull OrgSignupInfo signupInfo, boolean saveRechargeInfo) {
        // 设置默认天校报名
        if (signupInfo.getSourceType() == null || signupInfo.getSourceType().intValue() == 0) {
            signupInfo.setSourceType(SignupSourceType.TX_SIANGUP.getCode());
        }

        if (signupInfo.getId() != null && signupInfo.getId() > 0) {
            this.orgSignupInfoDao.update(signupInfo);
        } else {
            this.orgSignupInfoDao.save(signupInfo);
        }
        if (saveRechargeInfo) {
            try {
                if (signupInfo.getOrderType().intValue() == TransferClassOrder.RECHARGE_ORDER.getCode()) {
                    txPurchaseRechargeService.saveRechargeBySignupinfo(signupInfo);
                }
                if (signupInfo.getOrderType().intValue() == TransferClassOrder.TIMESCARD_ORDER.getCode()) {
                    txPurchaseTimescardService.saveTimesCardBySignupinfo(signupInfo);
                }
            } catch (Exception e) {
                log.warn("数据重复。e = {}", e);
            }
        }

    }


    private OrgSingupInfoDto buildOrgSignupInfoDto(OrgSignupInfo orgSignupInfo, boolean isShowMobile) {
        Map<Long, String> cascadeMap = txCascadeCredentialService.getByTxCasCadeIds(orgSignupInfo.getOrgId());

        OrgSingupInfoDto dto = new OrgSingupInfoDto();
        if (orgSignupInfo != null) {
            dto.setTotalPrice(orgSignupInfo.getTotalPrices().doubleValue() / 100);

            fillPayType(dto, orgSignupInfo);// 填充支付类型

            fillSignupStudentInfo(dto,orgSignupInfo);//填充学生账户余额

            dto.setStudentPayPrice(orgSignupInfo.getStudentPayPrice().doubleValue() / 100);// 学生账户付款金额
            dto.setRealTotalMoney(dto.getTotalPrice());

            dto.setOrgId(orgSignupInfo.getOrgId());
            if (dto.getSignupType().intValue() == SignupType.FRONTED.getCode()) {
                dto.setSignUpTime(orgSignupInfo.getCreateTime());
            } else {
                dto.setSignUpTime(orgSignupInfo.getUpdateTime());
            }
            if (orgSignupInfo.getPurchaseStatus().intValue() == OrgSinupPurchaseStatus.DEAL_DONE.getCode()) {
                dto.setPayTime(orgSignupInfo.getPayTime());
                // 设置经办人
                String cascadeIdStr =
                        cascadeMap.get(orgSignupInfo.getCascadeId() == null ? 0 : orgSignupInfo.getCascadeId().longValue());
                dto.setCascadeIdStr(cascadeIdStr == null ? "" : cascadeIdStr);
            } else {
                dto.setCascadeIdStr("--");
            }

            log.info("orgSignupInfo is:{} ", orgSignupInfo);
            int signupStatus = 0; // 0:正常 1:转班补款 2:转班退款 3:不退不补
            dto.setTransferClassOrder(orgSignupInfo.getOrderType());
            dto.setOrderType(orgSignupInfo.getOrderType());
            if (dto.getOrderType() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
            } else {
                dto.setShowTotalPrice((orgSignupInfo.getTotalPrices() + orgSignupInfo.getStudentPayPrice()) / 100d);
                dto.setChinesePrice(DigitUppercaseUtils.digitUppercase(dto.getShowTotalPrice()));
                dto.setPurchaseEndTime(orgSignupInfo.getCreateTime() == null ? null : DateUtil.getDiffDateTime(orgSignupInfo.getCreateTime(), 7));
                dto.setOpType(OrgSingupInfoDto.NORMAT_SIGNUP);
            }
            if (dto.getPayResult() == PayResult.SUCCESS.getCode()) {
                dto.setOpType(OrgSingupInfoDto.NORMAT_SIGNUP);
            }
            log.info("signupStatus is:{} ", signupStatus);

            dto.setSignupPurchaseId(orgSignupInfo.getSignupPurchaseId());
            dto.setPayPurchaseId(orgSignupInfo.getPayPurchaseId() == 0 ? orgSignupInfo.getSignupPurchaseId()
                    : orgSignupInfo.getPayPurchaseId());
            dto.setCreateTime(orgSignupInfo.getCreateTime());
            dto.setUpdateTime(orgSignupInfo.getUpdateTime());
            dto.setCourseInfos(Lists.<SignupCourseInfoDto>newArrayList());
            dto.setId(orgSignupInfo.getId());
            if (orgSignupInfo.getStatus() == DeleteStatus.DELETED.getValue()) {// 取消状态
                dto.setStatus(SignupStatus.CANCEL.getCode());
                dto.setOpType(OrgSingupInfoDto.NORMAT_SIGNUP); // 根据opType展示正常订单的取消状态
            } else {
                dto.setStatus(orgSignupInfo.getPurchaseStatus().intValue(), orgSignupInfo.getSplitResult().intValue());
            }
            String remark = "无";
            if (StringUtils.isNotBlank(orgSignupInfo.getRemark())) {
                remark = orgSignupInfo.getRemark();
            }
            if (orgSignupInfo.getTradeNo() != null && orgSignupInfo.getTradeNo().longValue() != 0l) {
                dto.setTradeNo(orgSignupInfo.getTradeNo().toString());
            } else {
                dto.setTradeNo(orgSignupInfo.getSignupPurchaseId().toString());
            }
            if (CollectionUtils.isNotEmpty(orgSignupInfo.getHeaders())
                    && orgSignupInfo.getTotalPrices().doubleValue() > 0) {
                String payUrlWinxin =
                        RestUtils.getWeiXinPurchaseUrl(orgSignupInfo.getSignupPurchaseId(), orgSignupInfo.getOrgId(),
                                orgSignupInfo.getTotalPrices().doubleValue() / 100, orgSignupInfo.getHeaders());
                dto.setPayUrlWinxin(payUrlWinxin);
            }
            dto.setRemark(remark);

            dto.setOperator(orgSignupInfo.getOperator());

        }
        return dto;
    }


    /**
     * 填充支付类型
     *
     * @param dto,orgSignupInfo
     */
    private void fillPayType(OrgSingupInfoDto dto, OrgSignupInfo orgSignupInfo) {
        int payType = PayType.getCodeByPayType(orgSignupInfo.getPayType());
        if (payType == PayType.CASH.getCode()) {
            dto.setCashPayPrice(dto.getTotalPrice());
        } else if (payType == PayType.PAY_POS_CARD.getCode()) {
            dto.setPosPayPrice(dto.getTotalPrice());
        } else {
            dto.setOnlinePayPrice(dto.getTotalPrice());
        }

        dto.setSourceType(orgSignupInfo.getSourceType().intValue() == SignupSourceType.TX_SIANGUP.getCode()
                ? SignupSourceType.SIGNUP.getCode() : orgSignupInfo.getSourceType());
        dto.setPayResultEnum(PayResult.getPayResultByCode(orgSignupInfo.getPurchaseStatus().intValue()));
        dto.setPayTypeEnum(PayType.getPayTypeByCode(orgSignupInfo.getPayType().intValue()));
        dto.setSignupTypeEnum(SignupType.getTypeByCode(orgSignupInfo.getSignupType().intValue()));
    }


}
