package com.baijia.tianxiao.biz.service;

import com.baijia.tianxiao.sal.course.dto.SupplementCourseInfoDto;
import com.baijia.tianxiao.sal.course.dto.request.StudentKexiaoInfoReq;
import com.baijia.tianxiao.sal.course.dto.response.AddInfoResponseDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseSignupInfoDto;
import com.baijia.tianxiao.sal.course.dto.response.StudentSignupInfoDto;
import com.baijia.tianxiao.sal.signup.dto.AddSignupInfoDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.Collection;
import java.util.List;

/**
 * Author: hanlaijin
 * Date: 16/12/6 下午4:04
 */
public interface StudentSignupCourseService {

    List<StudentSignupInfoDto> checkInfo(Long orgId, Long studentId, List<Long> courseIds);

    List<AddInfoResponseDto> saveOrUpdateSignupCourse(Long orgId, Long cascadeId, List<AddSignupInfoDto> list);

    List<AddInfoResponseDto> addCourseInfo(Long orgId, Integer cascadeId, List<SupplementCourseInfoDto> courseInfos);

    /**
     * 获取学生维度的报名信息列表
     *
     * @param orgId
     * @param courseIds
     * @param supplement 是否待补充
     * @param pageDto
     * @return
     */
    List<StudentSignupInfoDto> getStudentSignupInfoDtoList(Long orgId, Collection<Long> courseIds,
                                                           Collection<Long> userIds, Integer supplement, PageDto pageDto);

    /**
     * 获取班级维度的报名信息列表
     *
     * @param orgId
     * @param pageDto
     * @return
     */
    List<CourseSignupInfoDto> getCourseSignupInfoDtoList(Long orgId, Collection<Long> courseNameClassIds, PageDto pageDto);

    /**
     * 批量补充学员报名信息
     *
     * @param list
     */
    void batchSaveKexiaoInfo(Long orgId, Integer cascadeId, List<StudentKexiaoInfoReq> list);
}
