package com.baijia.tianxiao.biz.service.impl;

import com.baijia.tianxiao.biz.dto.request.QuitClassRequest;
import com.baijia.tianxiao.biz.dto.response.ApplyQuitClassDto;
import com.baijia.tianxiao.biz.dto.response.OrgSignupRefundDto;
import com.baijia.tianxiao.biz.dto.response.RefundSignupCourseDto;
import com.baijia.tianxiao.biz.dto.response.StudentFinanceAccountDto;
import com.baijia.tianxiao.biz.dto.response.StudentFinanceRecordDto;
import com.baijia.tianxiao.biz.dto.response.StudentSignupFinanceDto;
import com.baijia.tianxiao.biz.service.StudentPayService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceAccountDao;
import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceRecordDao;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassRecordDao;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceRecord;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseStudentOpDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dto.StudentCourseKexiaoDocument;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.SignupErrorCode;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.course.service.OrgLessonConflictService;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseService;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.finance.dto.SignupRefundResponse;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.constants.SignupRefundType;
import com.baijia.tianxiao.sal.signup.dto.SignupRefundStorageDto;
import com.baijia.tianxiao.sal.signup.service.OrgSignupRefundService;
import com.baijia.tianxiao.sal.signup.service.SignupRefundStorageService;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;

/**
 * Created by wengshengli on 2016/12/5.
 */
@Slf4j
@Service
public class StudentPayServiceImpl implements StudentPayService {

    @Resource
    private TxStudentFinanceAccountService txStudentFinanceAccountService;

    @Resource
    private TxStudentFinanceAccountDao txStudentFinanceAccountDao;

    @Resource
    private TxStudentFinanceRecordDao txStudentFinanceRecordDao;

    @Resource
    private OrgStudentDao orgStudentsDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;

    @Resource
    private OrgSignupRefundService orgSignupRefundService;

    @Resource
    private OrgSignupRefundDao orgSignupRefundDao;

    @Resource
    private TxCascadeCredentialService txCascadeCredentialService;

    @Resource
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;

    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;

    @Resource
    private SignupService signupService;

    @Resource
    private OrgSignupCourseService orgSignupCourseService;

    @Resource
    private OrgClassLessonDao orgClassLessonDao;

    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;

    @Resource
    private OrgCourseStudentOpDao orgCourseStudentOpDao;

    @Resource
    private OrgCourseSmsDao orgCourseSmsDao;

    @Resource
    private OrgLessonSignDao orgLessonSignDao;

    @Resource
    private OrgLessonConflictService orgLessonConflictService;

    @Resource
    private SignupRefundStorageService signupRefundStorageService;

    @Resource
    private TxTransferClassRecordDao txTransferClassRecordDao;

    @Autowired
    private KexiaoApiService kexiaoApiService;

    @Resource
    private OrgAccountService orgAccountService;


    @Override
    public OrgSignupInfo payByStudentFiannce(Long orgId, Integer cascadeId, Long signupPurchaseId, Integer opType, Double payMoney) throws BussinessException {
        Preconditions.checkNotNull(opType == StudentFiannceOpType.SIGNUP_PAY.getCode() || opType == StudentFiannceOpType.PAY_CANCEL.getCode(), "orgId may not be null");
        Preconditions.checkNotNull(payMoney != null && payMoney.doubleValue() > 0, "payMoney can not be null");
        payMoney = NumberUtil.get2Double(payMoney);

        OrgSignupInfo orgSignupInfo = signupService.getByPurchaseId(orgId, signupPurchaseId);
        if (orgSignupInfo == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "报名订单号错误" + signupPurchaseId);
        }
        if (orgSignupInfo.getStudentPayPrice().longValue() != 0) {
            if (orgSignupInfo.getStudentPayPrice().doubleValue() / 100 != payMoney.doubleValue()) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "报名学生余额支付金额错误" + signupPurchaseId + "=" + payMoney);
            } else {
                return orgSignupInfo;
            }
        }

        OrgStudent orgStudent = orgStudentDao.getStudent(orgId, orgSignupInfo.getUserId(), DataStatus.NORMAL.getValue());
        if (orgStudent == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "报名学生不存在" + orgSignupInfo.getUserId());
        }

        TxStudentFinanceAccount txStudentFinanceAccount = txStudentFinanceAccountDao.getFinanceAccount(orgId, orgStudent.getId());
        if (orgStudent == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生储值账户不存在");
        }
        if (opType == StudentFiannceOpType.SIGNUP_PAY.getCode() && payMoney.doubleValue() > txStudentFinanceAccount.getBalance().doubleValue() / 100) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "报名支付金额大于学生储值账号金额");
        }
        if (opType == StudentFiannceOpType.PAY_CANCEL.getCode() && payMoney.doubleValue() > txStudentFinanceAccount.getFreezeMoney().doubleValue() / 100) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "取消报名支付金额大于学生冻结账号金额");
        }

        /**
         * 变动报名的学生金额
         */
        OrgSignupInfo result = signupService.changeSignupStudentPrice(orgId, signupPurchaseId, opType, Long.valueOf((long) (payMoney.doubleValue() * 100.0D)));

        /**
         * 变动学生储值账号
         */
        String opInfo = orgSignupCourseService.getSignupCourseName(result.getOrgId(), result.getSignupPurchaseId());
        txStudentFinanceAccountService.changeStudentFiannceAccount(orgId, cascadeId, orgStudent.getId(),signupPurchaseId, StudentFiannceOpType.getByCode(opType), Long.valueOf((long) (payMoney.doubleValue() * 100.0D)), opInfo, "");

        return result;
    }


    @Override
    public StudentSignupFinanceDto getStudentFiannce(Long orgId, Long signupPurchaseId) throws BussinessException {
        StudentSignupFinanceDto result = new StudentSignupFinanceDto();
        OrgSignupInfo orgSignupInfo = signupService.getByPurchaseId(orgId, signupPurchaseId);
        log.debug("getStudentFiannce signupinfo={}", orgSignupInfo);
        if (orgSignupInfo != null) {
            OrgStudent orgStudent = orgStudentDao.getStudent(orgId, orgSignupInfo.getUserId(), DataStatus.NORMAL.getValue());
            log.debug("getStudentFiannce orgStudent={}", orgStudent);
            if (orgStudent != null) {
                TxStudentFinanceAccount txStudentFinanceAccount = txStudentFinanceAccountDao.getFinanceAccount(orgId, orgStudent.getId());
                log.debug("getStudentFiannce txStudentFinanceAccount={}", txStudentFinanceAccount);
                if (txStudentFinanceAccount != null) {
                    result.setStudentBalance(NumberUtil.get2Double(txStudentFinanceAccount.getBalance().doubleValue() / 100));
                }
            }
            result.setSignupFreezeMoney(NumberUtil.get2Double(orgSignupInfo.getStudentPayPrice().doubleValue() / 100));
        }
        return result;
    }


    @Override
    public void cancelSignupInfo(Long orgId, Integer cascadeId, Long signupPurchaseId) {

        OrgSignupInfo orgSignupInfo = signupService.getByPurchaseId(orgId, signupPurchaseId);
        if (orgSignupInfo == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "报名订单号错误" + signupPurchaseId);
        }

        OrgStudent orgStudent = orgStudentDao.getStudent(orgId, orgSignupInfo.getUserId(), DataStatus.NORMAL.getValue());
        if (orgStudent == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "报名学生不存在" + orgSignupInfo.getUserId());
        }

        signupService.cancelSignupInfo(signupPurchaseId, orgId);

        /**
         * 有通过储值账户支付的需要回退金额
         */
        if (orgSignupInfo.getStudentPayPrice().intValue() > 0) {
            String opInfo = orgSignupCourseService.getSignupCourseName(orgId, signupPurchaseId);
            txStudentFinanceAccountService.changeStudentFiannceAccount(orgId, cascadeId, orgStudent.getId(),signupPurchaseId, StudentFiannceOpType.PAY_CANCEL, orgSignupInfo.getStudentPayPrice(), opInfo, "");
        }
    }

    @Override
    public List<StudentFinanceAccountDto> getStudentAccoutByOrgId(Long orgId, String key, PageDto pageDto) {
        List<TxStudentFinanceAccount> studentFinanceAccounts = txStudentFinanceAccountDao.getFinanceAccount(orgId, pageDto);
        if (studentFinanceAccounts.isEmpty()) {
            return Collections.emptyList();
        }
        Map<Long, TxStudentFinanceAccount> studentFinanceAccountMap = CollectorUtil.collectMap(studentFinanceAccounts, new Function<TxStudentFinanceAccount, Long>() {
            @Override
            public Long apply(TxStudentFinanceAccount txStudentFinanceAccount) {
                return txStudentFinanceAccount.getStudentId();
            }
        });

        List<OrgStudent> students = orgStudentsDao.getByIds(studentFinanceAccountMap.keySet(), "id", "name", "mobile");
        Map<Long, OrgStudent> studentMap = CollectorUtil.collectMap(students, new Function<OrgStudent, Long>() {
            @Override
            public Long apply(OrgStudent orgStudent) {
                return orgStudent.getId();
            }
        });

        List<StudentFinanceAccountDto> result = Lists.newArrayList();
        for (TxStudentFinanceAccount txStudentFinanceAccount : studentFinanceAccounts) {
            result.add(buildStudentAccountDto(txStudentFinanceAccount, studentMap));
        }
        return result;
    }

    @Override
    public List<StudentFinanceRecordDto> getStudentRecordByStudentId(Long orgId, Long studentId, PageDto pageDto) {
        List<TxStudentFinanceRecord> studentFinanceRecords = txStudentFinanceRecordDao.findTxStudentFinanceRecords(orgId, studentId, pageDto);
        if (studentFinanceRecords.isEmpty()) {
            return Collections.emptyList();
        }

        Map<Long, String> cascadeMap = txCascadeCredentialService.getByTxCasCadeIds(orgId);

        List<StudentFinanceRecordDto> result = Lists.newArrayList();
        for (TxStudentFinanceRecord txStudentFinanceRecord : studentFinanceRecords) {
            result.add(buildStudentRecordDto(txStudentFinanceRecord, cascadeMap));
        }
        return result;
    }

    @Override
    public ApplyQuitClassDto getSignupCourseByPurchase(Long orgId, Long signupPurchaseId, Long courseId) {
        return changeApplyQuitDto(orgId, signupPurchaseId, null, courseId, SignupCourseStatus.inClassStatus);
    }

    @Override
    public ApplyQuitClassDto getSignupCourseByStudent(Long orgId, Long userId, Long courseId) {
        return changeApplyQuitDto(orgId, null, userId, courseId, SignupCourseStatus.inClassStatus);
    }


    private ApplyQuitClassDto changeApplyQuitDto(Long orgId, Long signupPurchaseId, Long userId, Long courseId, List<Integer> status) {
        log.info("apply quit class params={},{},{},{}", orgId, signupPurchaseId, userId, courseId);

        ApplyQuitClassDto applyQuitClassDto = new ApplyQuitClassDto();
        applyQuitClassDto.setSignupPurchaseId(signupPurchaseId);

        /**
         * 判断课程
         */
        OrgCourse orgCourse = orgCourseDao.getByCourseId(courseId);
        if (orgCourse == null) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "课程不存在" + courseId);
        }
        if (orgCourse != null && orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode() &&
                orgCourse.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode()) {
            orgCourse = orgCourseDao.getByCourseId(orgCourse.getParentId());
        }
        if (orgCourse != null) {
            applyQuitClassDto.setCourseName(orgCourse.getName());
            applyQuitClassDto.setCourseType(orgCourse.getCourseType());
            applyQuitClassDto.setChargeType(orgCourse.getChargeType());
            applyQuitClassDto.setFreq(orgCourse.getFreq());
            applyQuitClassDto.setPrice(orgCourse.getPrice());
            applyQuitClassDto.setCourseId(orgCourse.getId());
        }
        applyQuitClassDto.setCourseId(orgCourse.getId());
        log.debug("apply quit class orgCourse={}", orgCourse);
        /**
         * 获取报名
         */
        Long signupCourseId = null;//是否特定的退单字
        List<OrgSignupCourse> signupCourseList = Lists.newArrayList();
        if (signupPurchaseId != null && signupPurchaseId.longValue() > 0) {
            OrgSignupCourse signupCourse = orgSignupCourseDao.getByCourseId(orgId, signupPurchaseId, courseId);
            userId = signupCourse.getUserId();
            signupCourseId = signupCourse.getId();
            signupCourseList.add(signupCourse);
        } else {
            List<Long> courseIds = Lists.newArrayList();
            courseIds.add(orgCourse.getId());
            signupCourseList = orgSignupCourseDao.getByCourseIdsAndStudentId(orgId, userId, courseIds, status);
        }
        log.debug("apply quit class signupCourseList={}", signupCourseList);

        /**
         * 判断用户
         */
        OrgStudent orgStudent = orgStudentDao.getStudentByUserId(orgId, userId);
        if (orgStudent == null) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "学员不存在" + userId);
        }
        applyQuitClassDto.setUserId(userId);
        log.debug("apply quit class userId={}", userId);

        Map<String, Long> signupRefundMap = orgSignupRefundService.mapSignupRefund(orgId, signupPurchaseId, userId, courseId);
        log.debug("apply quit class signupRefundMap={}", signupRefundMap);

        /**
         * 课消完成
         */
        StudentCourseKexiaoDocument financed = kexiaoApiService.finishCountMoney(orgId, orgCourse.getId(), userId, signupCourseId, SignupCourseStatus.inClassStatus);
        log.debug("apply quit class financed={}", financed);

        if (CollectionUtils.isNotEmpty(signupCourseList) && financed != null) {
            Integer allLessonCount = 0;
            Long allPayMoney = 0l;
            Long allHasQuitMoney = 0l;
            boolean canKexiao = true;
            int tempChargeUnit = -1;
            for (OrgSignupCourse orgSignupCourse : signupCourseList) {
                tempChargeUnit = orgSignupCourse.getChargeUnit();
                if (ChargeUnit.isByTime(tempChargeUnit)) {
                    tempChargeUnit = ChargeUnit.BY_MINUTE.getCode();
                }
                if (orgSignupCourse.getChargeUnit() == ChargeUnit.BY_HOUR.getCode()) {
                    allLessonCount += orgSignupCourse.getLessonCount() * 60;
                } else if (orgSignupCourse.getChargeUnit() == ChargeUnit.BY_HALF_HOUR.getCode()) {
                    allLessonCount += orgSignupCourse.getLessonCount() * 30;
                } else {
                    allLessonCount += orgSignupCourse.getLessonCount();
                }

                allPayMoney += orgSignupCourse.getStudentPayPrice();
                allPayMoney += orgSignupCourse.getPayPrice();
                allPayMoney += orgSignupCourse.getTransferPurchaseMoney();
                applyQuitClassDto.setChargeUnit(orgCourse.getChargeUnit());
                applyQuitClassDto.setChargeMode(orgCourse.getChargeUnit());
                applyQuitClassDto.setStatus(orgSignupCourse.getStatus());
                applyQuitClassDto.setSignupTime(orgSignupCourse.getCreateTime());
                applyQuitClassDto.setCount(orgSignupCourse.getCount());
                if (orgSignupCourse.getLessonCount() == 0) {
                    canKexiao = false;
                }

                Long refundMoney = signupRefundMap.get(orgSignupCourse.getSignupPurchaseId() + "_" + orgSignupCourse.getOrgCourseId());
                allHasQuitMoney += refundMoney == null ? 0l : refundMoney.longValue();
            }

            //报名金额减去已经退过的金额
            log.debug("[all]={},[quit]={}", allPayMoney, allHasQuitMoney);
            allPayMoney = allPayMoney - allHasQuitMoney;

            applyQuitClassDto.setFinishLessonCount(financed.getFinishCount().intValue());

            if (tempChargeUnit == ChargeUnit.BY_HOUR.getCode()) {
                applyQuitClassDto.setFinishLessonCount(financed.getFinishTime().intValue());
                applyQuitClassDto.setLeftLessonCount((allLessonCount * 60 - financed.getFinishTime().intValue()));
            } else if (tempChargeUnit == ChargeUnit.BY_HALF_HOUR.getCode()) {
                applyQuitClassDto.setFinishLessonCount(financed.getFinishTime().intValue());
                applyQuitClassDto.setLeftLessonCount((allLessonCount * 30 - financed.getFinishTime().intValue()));
            } else if (tempChargeUnit == ChargeUnit.BY_MINUTE.getCode()) {
                applyQuitClassDto.setFinishLessonCount(financed.getFinishTime().intValue());
                applyQuitClassDto.setLeftLessonCount((allLessonCount - financed.getFinishTime().intValue()));
            } else if (tempChargeUnit == ChargeUnit.BY_TIMES.getCode()) {
                applyQuitClassDto.setFinishLessonCount(financed.getFinishCount().intValue());
                applyQuitClassDto.setLeftLessonCount((allLessonCount - financed.getFinishCount().intValue()));
            } else {
                applyQuitClassDto.setFinishLessonCount(0);
                applyQuitClassDto.setLeftLessonCount(-1);
                applyQuitClassDto.setLeftLessonMoney(-1d);
            }

            if (!canKexiao) {
                applyQuitClassDto.setFinishLessonCount(0);
                applyQuitClassDto.setLeftLessonMoney(-1d);
                applyQuitClassDto.setLeftLessonCount(-1);
                if (allPayMoney.doubleValue() > 0) {
                    applyQuitClassDto.setCanRefundMoney(allPayMoney.doubleValue() / 100);
                } else {
                    applyQuitClassDto.setCanRefundMoney(1000000d);
                }
            } else {
                applyQuitClassDto.setLeftLessonMoney(NumberUtil.get2Double(allPayMoney.doubleValue() - financed.getFinishMoney()) / 100);
                applyQuitClassDto.setCanRefundMoney(applyQuitClassDto.getLeftLessonMoney());
            }

            if (applyQuitClassDto.getCanRefundMoney().doubleValue() <= 0) {
                applyQuitClassDto.setCanRefundMoney(0d);
            }

            if (applyQuitClassDto.getLeftLessonCount() < 0 || applyQuitClassDto.getLeftLessonMoney() < 0) {
                applyQuitClassDto.setLeftLessonCount(-1);
                applyQuitClassDto.setLeftLessonMoney(-1d);
            }
        } else {
            applyQuitClassDto.setChargeType(orgCourse.getChargeType());
            applyQuitClassDto.setChargeUnit(orgCourse.getChargeUnit());
            applyQuitClassDto.setChargeMode(orgCourse.getChargeUnit());
            applyQuitClassDto.setFinishLessonCount(0);
            applyQuitClassDto.setLeftLessonMoney(0d);
            applyQuitClassDto.setLeftLessonCount(0);
            applyQuitClassDto.setCanRefundMoney(0d);
        }

        applyQuitClassDto.setSignupCourseList(buildSignupCourseList(signupCourseList, orgCourse));

        log.debug("apply quit class result={}", applyQuitClassDto);

        return applyQuitClassDto;
    }


    @Override
    @Transactional
    public OrgSignupRefundDto confirmQuitClass(Long orgId, QuitClassRequest quitClassRequest) {
        log.info("confirmQuitClass={},{}", orgId, quitClassRequest);
        quitClassRequest.setRefundMoney(NumberUtil.get2Double(quitClassRequest.getRefundMoney()));
        if (SignupRefundType.getByCode(quitClassRequest.getRefundType()) == null) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "退款类型错误" + quitClassRequest.getRefundType());
        }

        List<TxTransferClassRecord> transferClassRecords = txTransferClassRecordDao.listByUserClass(quitClassRequest.getUserId(), quitClassRequest.getCourseId(), quitClassRequest.getSignupPurchaseId(), DataStatus.NORMAL.getValue());
        if (transferClassRecords != null && transferClassRecords.size() > 0 &&
                quitClassRequest.getConfirmRefund() != null && quitClassRequest.getConfirmRefund().intValue() == 0) {
            throw new BussinessException(SignupErrorCode.TRANSFER_CLASS_ERROR, SignupErrorCode.TOTALPRICE_ERROR.getMessage());
        }

        OrgCourse orgCourse = orgCourseDao.getByCourseId(quitClassRequest.getCourseId());
        if (orgCourse != null && orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()
                && orgCourse.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode()) {
            orgCourse = orgCourseDao.getByCourseId(orgCourse.getParentId());
        }
        if (orgCourse == null) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "课程不存在" + quitClassRequest.getCourseId());
        }
        Long realCourseId = orgCourse.getId();

        OrgStudent orgStudent = orgStudentDao.getStudentByUserId(orgId, quitClassRequest.getUserId());
        if (orgStudent == null) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "学员不存在" + quitClassRequest.getUserId());
        }

        List<Long> courseIds = Lists.newArrayList();
        courseIds.add(realCourseId);
        List<OrgSignupCourse> signupCourses = orgSignupCourseDao.getByCourseIdsAndStudentId(orgId, orgStudent.getUserId(), courseIds, SignupCourseStatus.inClassStatus);

        if (CollectionUtils.isEmpty(signupCourses)) {
            //throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "已经退班");
        }
        Long signupPurchaseId = quitClassRequest.getSignupPurchaseId() == null ? 0l : quitClassRequest.getSignupPurchaseId();

        /**
         * 维护订单和学生在班级的退班状态
         */
        int quitType = changeQuitClassStatus(orgId, realCourseId, quitClassRequest.getCourseId(), orgStudent.getUserId(), quitClassRequest.getSignupPurchaseId(), signupCourses);

        List<OrgSignupRefund> orgSignupRefundList = orgSignupRefundService.saveRefund(signupCourses, orgId, signupPurchaseId,
                realCourseId, orgStudent.getUserId(), new Double(quitClassRequest.getRefundMoney() * 100).longValue(), quitClassRequest.getRefundType(), quitClassRequest.getCascadeId());


        return buildSignupRefund(signupCourses, orgCourse, quitType, quitClassRequest, orgSignupRefundList);
    }

    @Override
    public boolean batchQuitClassByClassId(Long orgNumber, Long classId, Integer refundType) {
        log.info("Batch quiet class by classi is params = {},{}", orgNumber, classId);
        OrgAccount orgAccount = orgAccountService.getOrgAccountByNumber(orgNumber.intValue());
        if (orgAccount == null) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "机构Number错误" + orgNumber);
        }
        OrgCourse orgCourse = orgCourseDao.getByCourseId(classId);
        if (orgCourse == null || orgCourse.getIsClass().intValue() == CourseTypeEnum.IS_CLASS_FALSE.getCode()) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "不是班级id" + classId);
        }
        if (orgCourse.getOrgNumber().longValue() != orgAccount.getNumber().longValue()) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "班级id" + classId + "不是该机构的" + orgNumber);
        }
        List<Long> studentUserIds = orgStudentCourseDao.getStudents(orgAccount.getId().longValue(), classId, StudentCourseStatus.NORMAL.getCode());
        if (CollectionUtils.isEmpty(studentUserIds)) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "该班级没有学生");
        }
        log.info("Batch quiet class by classi is params = {}", studentUserIds);
        for (Long userId : studentUserIds) {
            ApplyQuitClassDto applyQuitClassDto = getSignupCourseByStudent(orgAccount.getId().longValue(), userId, classId);
            log.info("Batch quiet class by classi is params = {}", applyQuitClassDto);
            confirmQuitClass(orgAccount.getId().longValue(), QuitClassRequest.buildByClassId(classId, userId, refundType, applyQuitClassDto.getLeftLessonMoney()));
        }
        return true;
    }

    @Override
    public OrgSignupRefundDto detailQuitClass(Long orgId, QuitClassRequest quitClassRequest) {

        OrgCourse orgCourse = orgCourseDao.getByCourseId(quitClassRequest.getCourseId());
        if (orgCourse != null && orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()
                && orgCourse.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode()) {
            orgCourse = orgCourseDao.getByCourseId(orgCourse.getParentId());
        }
        if (orgCourse == null) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "课程不存在" + quitClassRequest.getCourseId());
        }
        OrgStudent orgStudent = orgStudentDao.getStudentByUserId(orgId, quitClassRequest.getUserId());
        if (orgStudent == null) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "学员不存在" + quitClassRequest.getUserId());
        }

        List<OrgSignupRefund> signupRefunds = orgSignupRefundDao.getOrgSignupRefundByStudent(orgId, quitClassRequest.getSignupPurchaseId(), orgStudent.getUserId(), orgCourse.getId());
        if (signupRefunds.isEmpty()) {
            signupRefunds = orgSignupRefundDao.getOrgSignupRefundByStudent(orgId, null, orgStudent.getUserId(), orgCourse.getId());
        }
        Map<Long, String> cascadeMap = txCascadeCredentialService.getByTxCasCadeIds(orgId);

        OrgSignupRefundDto signupRefundDto = new OrgSignupRefundDto();
        if (!signupRefunds.isEmpty()) {
            OrgSignupRefund orgSignupRefund = signupRefunds.get(0);
            signupRefundDto.setRefundType(orgSignupRefund.getRefundType());
            signupRefundDto.setRefundTypeStr(SignupRefundType.getByCode(orgSignupRefund.getRefundType()).getName());
            signupRefundDto.setRefundMoney(NumberUtil.get2Double(orgSignupRefund.getRefundPrice().doubleValue() / 100));
            signupRefundDto.setRefundTime(orgSignupRefund.getCreateTime());
            signupRefundDto.setCascadeIdStr(cascadeMap.get(orgSignupRefund.getCascadeId().longValue()));
        }

        ApplyQuitClassDto applyQuitClassDto = null;
        if (quitClassRequest.getSignupPurchaseId() != null && quitClassRequest.getSignupPurchaseId().longValue() > 0) {
            applyQuitClassDto = changeApplyQuitDto(orgId.longValue(), quitClassRequest.getSignupPurchaseId(), null, quitClassRequest.getCourseId(), SignupCourseStatus.inStudentCourseStatus);
        } else {
            applyQuitClassDto = changeApplyQuitDto(orgId.longValue(), null, quitClassRequest.getUserId(), quitClassRequest.getCourseId(), SignupCourseStatus.inStudentCourseStatus);
        }
        List<RefundSignupCourseDto> refundSignupCourseDtos = applyQuitClassDto.getSignupCourseList();

        Map<Long, OrgSignupRefund> signupRefundMap = Maps.newHashMap();

        for (OrgSignupRefund orgSignupRefund : signupRefunds) {
            if (signupRefundMap.get(orgSignupRefund.getSignupPurchaseId().longValue()) == null) {
                signupRefundMap.put(orgSignupRefund.getSignupPurchaseId(), orgSignupRefund);
            }
        }

        Long refundMoney = 0l;
        for (RefundSignupCourseDto refundSignupCourseDto : refundSignupCourseDtos) {
            OrgSignupRefund signupRefund = signupRefundMap.get(refundSignupCourseDto.getSignupPurchaseId());
            if (signupRefund != null) {
                refundMoney = refundMoney + signupRefund.getRefundPrice();
                refundSignupCourseDto.setRefundMoney(signupRefund.getRefundPrice().doubleValue() / 100);
            }

        }
        signupRefundDto.setRefundMoney(refundMoney.doubleValue() / 100);
        signupRefundDto.setSignupCourseList(refundSignupCourseDtos);
        log.info("OrgSignupRefundDto==>detailQuitClass=={}", signupRefundDto);
        return signupRefundDto;
    }

    private int changeQuitClassStatus(Long orgId, Long courseId, Long classId, Long userId, Long signPurchaseId, List<OrgSignupCourse> signupCourses) {
        log.info("studentPayServie  changeQuitClassStatus = {},{},{},{},{}", orgId, courseId, userId, signPurchaseId, signupCourses);

        int defaultStatus = SignupCourseStatus.QUIT_PURCHASE.getCode();
        if (signPurchaseId == null || signPurchaseId.intValue() == 0) {
            defaultStatus = SignupCourseStatus.QUIT_CLASS.getCode();
        } else {
            List<OrgSignupCourse> leftSignCourse = orgSignupCourseDao.getLeftQuitClassSignupCourse(orgId, courseId, userId, signPurchaseId);
            if (CollectionUtils.isEmpty(leftSignCourse)) {
                defaultStatus = SignupCourseStatus.QUIT_CLASS.getCode();
            }
        }

        log.info("studentPayServie  changeQuitClassStatus defaultStatus= {}", defaultStatus);
        if (defaultStatus == SignupCourseStatus.QUIT_CLASS.getCode()) {
            OrgStudentCourse orgStudentCourse = orgStudentCourseDao.getStudentCourseByRealCourseId(orgId, courseId, userId);
            if (orgStudentCourse != null) {
                if (orgStudentCourse.getStatus().intValue()==StudentCourseStatus.WITHDRAW.getCode()){
                    throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "已经退班");
                }
                // 从未上完课节删除(解绑状态,逻辑删除
                this.deleteStudentFromCourseLesson(orgId, classId, userId);
                this.orgStudentCourseDao.deleteOrgCourseStudent(orgId, classId, userId, StudentCourseStatus.WITHDRAW.getCode());
            }
            // 从未上完课节删除
            this.orgCourseSmsDao.delCourseSmsRecord(orgId, classId, UserRole.STUDENT.getRole(),
                    Lists.newArrayList(userId));
        }

        if (CollectionUtils.isNotEmpty(signupCourses)) {
            for (OrgSignupCourse orgSignupCourse : signupCourses) {
                if (signPurchaseId != null && signPurchaseId.longValue() > 0) {
                    if (orgSignupCourse.getSignupPurchaseId().longValue() == signPurchaseId.longValue()) {
                        int result = orgSignupCourseDao.updateStatusByPurchaseId(signPurchaseId, courseId, userId, defaultStatus);
                        if (result == 0) {
                            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "已经退订单");
                        }
                    }
                } else {
                    int result = orgSignupCourseDao.updateStatusByPurchaseId(null, courseId, userId, defaultStatus);
                    if (result == 0) {
                        throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "已经退班");
                    }
                    break;
                }
            }
        } else {
            orgStudentCourseDao.deleteOrgCourseStudent(orgId, classId, userId, StudentCourseStatus.WITHDRAW.getCode());
        }
        return defaultStatus;
    }


    private OrgSignupRefundDto buildSignupRefund(List<OrgSignupCourse> signupCourses, OrgCourse orgCourse, Integer quitType, QuitClassRequest quitClassRequest, List<OrgSignupRefund> refundList) {
        OrgSignupRefundDto result = new OrgSignupRefundDto();
        result.setRefundType(quitClassRequest.getRefundType());
        result.setRefundTypeStr(SignupRefundType.getByCode(quitClassRequest.getRefundType()).getName());
        result.setRefundMoney(quitClassRequest.getRefundMoney());
        result.setRefundTime(refundList.isEmpty() ? new Date() : refundList.get(0).getCreateTime());
        List<ApplyQuitClassDto> dtoList = Lists.newArrayList();
        if (quitType == SignupCourseStatus.QUIT_PURCHASE.getCode()) {
            for (OrgSignupCourse signupCourse : signupCourses) {
                if (SignupCourseStatus.statusInClass(signupCourse.getStatus().intValue())) {
                    if (signupCourse.getSignupPurchaseId().longValue() != quitClassRequest.getSignupPurchaseId().longValue()) {
                        dtoList.add(getSignupCourseByPurchase(signupCourse.getOrgId(), signupCourse.getSignupPurchaseId(), signupCourse.getOrgCourseId()));
                    }
                }
            }
        }
        result.setOtherPurchase(dtoList);
        result.setSignupCourseList(buildSignupCourseList(signupCourses, orgCourse));
        return result;
    }


    private StudentFinanceAccountDto buildStudentAccountDto(TxStudentFinanceAccount txStudentFinanceAccount, Map<Long, OrgStudent> studentMap) {
        StudentFinanceAccountDto accountDto = new StudentFinanceAccountDto();
        accountDto.setStudentId(txStudentFinanceAccount.getStudentId());
        accountDto.setBanlance(NumberUtil.get2Double(txStudentFinanceAccount.getBalance().doubleValue() / 100));
        OrgStudent orgStudent = studentMap.get(txStudentFinanceAccount.getStudentId().longValue());

        if (orgStudent != null) {
            accountDto.setStudentName(orgStudent.getName());
            accountDto.setStudentMobile(orgStudent.getStudentMobile());
        }
        return accountDto;
    }

    private StudentFinanceRecordDto buildStudentRecordDto(TxStudentFinanceRecord txStudentFinanceRecord, Map<Long, String> cascadeMap) {
        StudentFinanceRecordDto recordDto = new StudentFinanceRecordDto();
        recordDto.setCreateTime(txStudentFinanceRecord.getCreateTime());
        recordDto.setOpInfo(txStudentFinanceRecord.getOpInfo());
        recordDto.setOpTo(txStudentFinanceRecord.getOpTo());
        recordDto.setOpMoney(NumberUtil.get2Double(txStudentFinanceRecord.getOpMoney().doubleValue() / 100));
        recordDto.setCurrentMoney(NumberUtil.get2Double(txStudentFinanceRecord.getCurrBalance().doubleValue() / 100));
        recordDto.setOpTypeStr(StudentFiannceOpType.getByCode(txStudentFinanceRecord.getOpType()).getName());
        String cascadeName = cascadeMap.get(txStudentFinanceRecord.getCascadeId().longValue());
        recordDto.setCascadeName(cascadeName == null ? "系统设置" : cascadeName);
        recordDto.setRemark(txStudentFinanceRecord.getRemark());
        if (txStudentFinanceRecord.getOpType().intValue() == StudentFiannceOpType.QUIT_CLASS.getCode()) {
            if (!StringUtils.isEmpty(recordDto.getRemark())) {
                changeQuitClassRemark(recordDto, txStudentFinanceRecord.getOrgId());
            }
        }
        return recordDto;
    }

    private void changeQuitClassRemark(StudentFinanceRecordDto recordDto, Long orgId) {
        try {
            String[] params = recordDto.getRemark().split("_");
            List<SignupRefundStorageDto> result = signupRefundStorageService.getSignupRefundStorages(orgId,
                    Long.parseLong(params[0]), Long.parseLong(params[2]), Long.parseLong(params[1]));
            recordDto.setRemarkImages(result);
            if (!result.isEmpty()) {
                recordDto.setRemark(result.get(0).getRemark());
                if (result.get(0).getStorageId().longValue() == 0) {
                    recordDto.setRemarkImages(Lists.<SignupRefundStorageDto>newArrayList());
                }
            } else {
                recordDto.setRemark("");
            }
        } catch (Exception e) {
            recordDto.setRemark("");
        }
    }


    private List<RefundSignupCourseDto> buildSignupCourseList(List<OrgSignupCourse> orgSignupCourseList, OrgCourse orgCourse) {
        List<RefundSignupCourseDto> result = Lists.newArrayList();
        for (OrgSignupCourse orgSignupCourse : orgSignupCourseList) {
            result.add(buildOrgSignupCourseDto(orgSignupCourse, orgCourse));
        }
        return result;
    }

    private RefundSignupCourseDto buildOrgSignupCourseDto(OrgSignupCourse orgSignupCourse, OrgCourse orgCourse) {
        OrgSignupInfo orgSignupInfo = signupService.getByPurchaseId(orgSignupCourse.getOrgId(), orgSignupCourse.getSignupPurchaseId());

        RefundSignupCourseDto dto = new RefundSignupCourseDto();
        dto.setSignupPurchaseId(orgSignupCourse.getSignupPurchaseId());
        dto.setFreq(orgCourse.getFreq());
        dto.setCount(orgSignupCourse.getCount());
        dto.setChargeUnit(orgSignupCourse.getChargeUnit());
        if (dto.getChargeUnit().intValue() != ChargeUnit.BY_OTHER.getCode()) {
            dto.setChargeType(orgCourse.getChargeType());
        }
        // 优惠金额＝(原优惠金额＋原价*count＊(1-折扣百分数))/100
        double preferential = ((100d - orgSignupCourse.getCourseDiscount().doubleValue()) / 100
                * orgSignupCourse.getOriginPrice() * orgSignupCourse.getCount() + orgSignupCourse.getPreferential()) / 100;
        dto.setPreferential(preferential);
        dto.setPayPrice(NumberUtil.get2Double((orgSignupCourse.getPayPrice().doubleValue() + orgSignupCourse.getTransferPurchaseMoney().doubleValue()) / 100));

        dto.setStudentPayPrice(NumberUtil.get2Double(orgSignupCourse.getStudentPayPrice().doubleValue() / 100));
        dto.setLessonCount(orgSignupCourse.getLessonCount());
        dto.setStatus(orgSignupCourse.getStatus());

        if (orgSignupInfo == null) {
            dto.setPayType(PayType.CASH.getCode());
            dto.setPayTypeStr("现金支付");
            dto.setPayTime(orgSignupCourse.getCreateTime());
            dto.setSignupTime(orgSignupCourse.getCreateTime());
        } else {
            dto.setPayType(orgSignupInfo.getPayType());
            dto.setPayTypeStr(PayType.getPayTypeByCode(orgSignupInfo.getPayType()).getNote());
            if (orgSignupCourse.getStudentPayPrice().longValue() > 0) {
                if (orgSignupCourse.getPayPrice().longValue() > 0) {
                    dto.setPayTypeStr("学员余额￥" + NumberUtil.get2FromDouble(dto.getStudentPayPrice()) + "+" + dto.getPayTypeStr() + "￥" + NumberUtil.get2FromDouble(dto.getPayPrice()));
                } else {
                    dto.setPayTypeStr("学生余额支付");
                }
            }
            dto.setPayTime(orgSignupInfo.getPayTime());
            dto.setSignupTime(orgSignupInfo.getCreateTime());
        }
        dto.setKexiaoTime(orgSignupCourse.getKexiaoTime());

        return dto;
    }

    /**
     * 把学生从课程的未上课节中删除
     *
     * @param orgId
     * @param classId
     */
    private void deleteStudentFromCourseLesson(Long orgId, Long classId, Long userId) {
        log.info("deleteStudentFromCourseLesson=={},{},{}", orgId, classId, userId);
        boolean delLessons = false;
        OrgCourse orgCourse = orgCourseDao.getByCourseId(classId);
        if (orgCourse != null && orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
            orgCourseDao.updateFinish(classId, 1);
            delLessons = true;
        }
        List<Integer> validateType = new ArrayList<>();
        validateType.add(LessonType.NORMAL.getCode());
        validateType.add(LessonType.FREE.getCode());
        List<OrgStudentLesson> studentLessons = this.orgStudentLessonDao.getByUserIdAndClassId(orgId, userId,
                classId, LessonStatus.UN_START.getStatus(), validateType, "id", "lessonId");
        List<Long> leftLessonIds = ListUtil.toKeyList(studentLessons, "lessonId", OrgStudentLesson.class);
        log.info("leftLessonIds = {}", leftLessonIds);
        this.orgStudentLessonDao.delStudentFromLesson(orgId, leftLessonIds, userId);
        // 签到记录也删除
        Map<String, Object> condition = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(leftLessonIds)) {
            condition.put("lessonId", leftLessonIds);
            condition.put("userId", userId);
            condition.put("orgId", orgId);
            this.orgLessonSignDao.delByCondition(condition);
        }

        if (delLessons) {
            orgClassLessonDao.updateDelByLessonIds(orgId, leftLessonIds);
            orgLessonConflictService.delByLessonIds(orgId, leftLessonIds);
        }

    }
}
