/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.service.impl;

import com.baijia.tianxiao.biz.service.StudentSignupCourseService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.constant.ChargeType;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.constant.SignupSupplementType;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.SignupErrorCode;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.StudentCourseApi;
import com.baijia.tianxiao.sal.common.dto.StudentCourseBase;
import com.baijia.tianxiao.sal.course.constant.ChargeUnit;
import com.baijia.tianxiao.sal.course.constant.CourseErrorCode;
import com.baijia.tianxiao.sal.course.dto.SupplementCourseInfoDto;
import com.baijia.tianxiao.sal.course.dto.request.StudentKexiaoInfoReq;
import com.baijia.tianxiao.sal.course.dto.response.AddInfoResponseDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseSignupInfoDto;
import com.baijia.tianxiao.sal.course.dto.response.StudentSignupInfoDto;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.kexiao.service.KexiaoChangeLogService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.dto.AddSignupInfoDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StudentSignupCourseServiceImpl
implements StudentSignupCourseService {
    private static final Logger log = LoggerFactory.getLogger(StudentSignupCourseServiceImpl.class);
    @Resource
    OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    OrgSignupCourseDao orgSignupCourseDao;
    @Resource
    OrgCourseDao orgCourseDao;
    @Resource
    OrgCourseService orgCourseService;
    @Resource
    OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;
    @Resource
    OrgStudentDao orgStudentDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private TxCascadeCredentialService txCascadeCredentialService;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private KexiaoChangeLogService changeLogService;
    @Resource
    private StudentCourseApi studentCourseApi;

    @Override
    public List<StudentSignupInfoDto> checkInfo(Long orgId, Long studentId, List<Long> courseIds) {
        log.debug("---------checkInfo courseIds={}", courseIds);
        Long userId = this.orgStudentDao.getUserId(studentId);
        List<StudentSignupInfoDto> result = this.getStudentSignupInfoDtoList(orgId, courseIds, Arrays.asList(userId), SignupSupplementType.OLD.getCode(), null);
        return result;
    }

    @Override
    public List<AddInfoResponseDto> saveOrUpdateSignupCourse(Long orgId, Long cascadeId, List<AddSignupInfoDto> list) {
        log.debug("-----saveOrUpdateSignupCourse list={}", list);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList courseIds = Lists.newArrayList();
        for (AddSignupInfoDto a : list) {
            courseIds.add(a.getCourseId());
        }
        this.updateSignupCourses(cascadeId, list);
        return this.signupInfoResult(courseIds);
    }

    private void updateSignupCourses(Long cascadeId, List<AddSignupInfoDto> updateList) {
        if (CollectionUtils.isEmpty(updateList)) {
            return;
        }
        for (AddSignupInfoDto a : updateList) {
            OrgSignupCourse o = (OrgSignupCourse)this.orgSignupCourseDao.getById((Serializable)a.getSignupCourseId(), new String[0]);
            log.debug("--------------OrgSignupCourse={}", (Object)o);
            if (o != null) {
                o.setPayPrice(a.getPayPrice());
                o.setLessonCount(a.getPayCount());
                o.setChargeUnit(ChargeUnit.BY_TIMES.getCode());
                o.setKexiaoTime(new Date());
                o.setUpdateTime(new Date());
                o.setKexiaoCascadeId(Integer.valueOf(cascadeId != null ? cascadeId.intValue() : 0));
                this.orgSignupCourseDao.update((Object)o, new String[]{"payPrice", "lessonCount", "chargeUnit", "updateTime", "kexiaoTime", "kexiaoCascadeId"});
                continue;
            }
            throw new BussinessException((UniverseErrorCode)SignupErrorCode.PURCHASE_ID_INVALIDATE);
        }
    }

    private List<AddInfoResponseDto> signupInfoResult(List<Long> courseIds) {
        List courseList = this.orgCourseDao.getCourseList(courseIds, null, null, null, null, null, new String[0]);
        ArrayList result = Lists.newArrayList();
        for (OrgCourse o : courseList) {
            AddInfoResponseDto dto = new AddInfoResponseDto();
            dto.setLessonCount(o.getFreq());
            dto.setPrice(o.getPrice());
            dto.setCourseName(o.getName());
            dto.setCourseId(o.getId());
            dto.setChargeType(o.getChargeType());
            dto.setChargeUnit(o.getChargeUnit());
            result.add(dto);
        }
        return result;
    }

    @Override
    public List<AddInfoResponseDto> addCourseInfo(Long orgId, Integer cascadeId, List<SupplementCourseInfoDto> courseInfos) {
        if (CollectionUtils.isEmpty(courseInfos)) {
            return Collections.EMPTY_LIST;
        }
        Long orgNumber = this.getOrgNumber(orgId);
        List<Long> orgCourseIds = this.getCourseIds(courseInfos);
        Map orgCourseMap = this.orgCourseDao.getOrgCourseMap(orgCourseIds, new String[0]);
        Map cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIds(Long.valueOf(orgId));
        String cascadeStr = (String)cascadeMap.get(cascadeId == null ? 0L : (long)cascadeId.intValue());
        log.debug("----------addCourseInfo:cascadeId={},cascadeStr={}", (Object)cascadeId, (Object)cascadeStr);
        this.updateCourseInfos(courseInfos, orgCourseMap, orgNumber, cascadeId, cascadeStr);
        List<AddInfoResponseDto> result = this.addCourseInfoResult(courseInfos, orgCourseMap);
        return result;
    }

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    private List<Long> getCourseIds(List<SupplementCourseInfoDto> courseInfos) {
        ArrayList courseIds = Lists.newArrayList();
        for (SupplementCourseInfoDto s : courseInfos) {
            courseIds.add(s.getCourseId());
        }
        return courseIds;
    }

    private void updateCourseInfos(List<SupplementCourseInfoDto> courseInfos, Map<Long, OrgCourse> orgCourseMap, Long orgNumber, Integer cascadeId, String cascadeStr) {
        for (SupplementCourseInfoDto s : courseInfos) {
            OrgCourse course = orgCourseMap.get(s.getCourseId());
            if (course == null || course.getOrgNumber().longValue() != orgNumber.longValue()) {
                log.debug("course not exist ,course id={}", (Object)s.getCourseId());
                throw new BussinessException((UniverseErrorCode)CourseErrorCode.COURSE_NOT_EXIST);
            }
            if (s.getChargeType() > 2) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6536\u8d39\u7c7b\u578b\u9519\u8bef");
            }
            course.setChargeType(s.getChargeType());
            if (s.getChargeType() != ChargeType.BY_PERIODS.getCode()) {
                course.setCourseType(CourseTypeEnum.COURSE_TYPE_NEW_CLASS.getCode());
            }
            if (s.getCoursePrice() != null) {
                if (s.getCoursePrice() < 0.01 || s.getCoursePrice() > 1000000.0) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4ef7\u683c\u9700\u662f0.01\u81f31000000\u4e4b\u95f4\u7684\u6570\u5b57");
                }
                course.setPrice(s.getCoursePrice());
            }
            if (s.getMaxStudent() != null && course.getCourseType() != CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                course.setMaxStudent(s.getMaxStudent());
            }
            if (s.getTotalLessons() != null && course.getCourseType() != CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                course.setFreq(s.getTotalLessons());
            }
            course.setChargeUnit(ChargeUnit.BY_TIMES.getCode());
            course.setKexiaoTime(new Date());
            course.setKexiaoCascadeId(Integer.valueOf(cascadeId != null ? cascadeId : 0));
            log.debug("----------------save course={}", (Object)course);
            this.orgCourseDao.update((Object)course, new String[0]);
        }
    }

    private List<AddInfoResponseDto> addCourseInfoResult(List<SupplementCourseInfoDto> courseInfos, Map<Long, OrgCourse> orgCourseMap) {
        ArrayList result = Lists.newArrayList();
        for (SupplementCourseInfoDto s : courseInfos) {
            OrgCourse course = orgCourseMap.get(s.getCourseId());
            AddInfoResponseDto responseDto = new AddInfoResponseDto();
            responseDto.setChargeType(s.getChargeType());
            responseDto.setChargeUnit(ChargeUnit.BY_TIMES.getCode());
            responseDto.setCourseId(s.getCourseId());
            responseDto.setPrice(s.getCoursePrice());
            responseDto.setCourseName(course.getName());
            responseDto.setLessonCount(s.getTotalLessons());
            result.add(responseDto);
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<StudentSignupInfoDto> getStudentSignupInfoDtoList(Long orgId, Collection<Long> classIds, Collection<Long> userIds, Integer supplement, PageDto pageDto) {
        List delUserIds = this.orgStudentDao.getDelUserIds(orgId);
        List orgSignupCourses = this.orgSignupCourseDao.getByCourseIdsAndStudentIds((Collection)delUserIds, orgId, classIds, userIds, supplement, pageDto, new String[0]);
        log.debug("getStudentSignupInfoDtoList find orgSignupCourses list size:{}", (Object)orgSignupCourses.size());
        HashSet resultClassIds = Sets.newHashSet();
        HashSet resultUserIds = Sets.newHashSet();
        for (OrgSignupCourse signupCourse : orgSignupCourses) {
            if (signupCourse.getClassId().longValue() == Flag.NULL.getLong()) {
                signupCourse.setClassId(signupCourse.getOrgCourseId());
            }
            resultClassIds.add(signupCourse.getClassId());
            resultUserIds.add(signupCourse.getUserId());
        }
        Map studentMap = CollectorUtil.collectMap((Collection)this.orgStudentDao.getStudentByUserIdsAndDelStatus(orgId, (Collection)resultUserIds, null, new String[]{"userId", "mobile", "name"}), (Function)new Function<OrgStudent, Long>(){

            public Long apply(OrgStudent input) {
                return input.getUserId();
            }
        });
        Map cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIds(Long.valueOf(orgId));
        Map courseMap = this.orgCourseDao.getOrgCourseMap((Collection)resultClassIds, new String[]{"id", "name", "price", "freq", "maxStudent", "courseType", "chargeType", "isClass", "isCourse"});
        HashMap baseMap = Maps.newHashMap();
        for (Long classId : resultClassIds) {
            baseMap.put(classId, this.studentCourseApi.getAllData(new ArrayList(resultUserIds), classId, orgId));
        }
        ArrayList result = Lists.newArrayList();
        for (OrgSignupCourse signupCourse : orgSignupCourses) {
            StudentCourseBase base = (StudentCourseBase)((Map)baseMap.get(signupCourse.getClassId())).get(signupCourse.getUserId());
            OrgCourse course = (OrgCourse)courseMap.get(signupCourse.getClassId());
            OrgStudent student = (OrgStudent)studentMap.get(signupCourse.getUserId());
            log.debug("signupCourse:{}, base:{}, course:{}, student:{}", new Object[]{signupCourse, base, course, student});
            StudentSignupInfoDto dto = new StudentSignupInfoDto();
            dto.setUserId(signupCourse.getUserId());
            dto.setStudentName(null != student ? student.getName() : "\u810f\u6570\u636e");
            dto.setMobile(null != student ? student.getMobile() : "\u810f\u6570\u636e");
            dto.setCourseId(signupCourse.getOrgCourseId());
            dto.setClassId(signupCourse.getClassId());
            dto.setCourseName(course.getName());
            dto.setOriginalPrice(Long.valueOf((long)(course.getPrice() * 100.0)));
            dto.setFreq(course.getFreq());
            dto.setMaxStudent(course.getMaxStudent());
            dto.setChargeType(course.getChargeType());
            dto.setArrangedLessonNum(Integer.valueOf(null == base ? 0 : base.getLessonCount()));
            dto.setFinishedLessonNum(Integer.valueOf(null == base ? 0 : base.getFinishCount()));
            dto.setSignupCourseId(Integer.valueOf(signupCourse.getId().intValue()));
            if (signupCourse.getLessonCount().intValue() == Flag.FALSE.getInt() && signupCourse.getKexiaoCascadeId().intValue() == Flag.NULL.getInt()) {
                dto.setSupplement(Integer.valueOf(SignupSupplementType.OLD.getCode()));
            } else if (signupCourse.getLessonCount() > Flag.FALSE.getInt() && signupCourse.getKexiaoCascadeId() > Flag.NULL.getInt()) {
                dto.setSupplement(Integer.valueOf(SignupSupplementType.OLD_FIXED.getCode()));
            } else if (signupCourse.getLessonCount() > Flag.FALSE.getInt() && signupCourse.getKexiaoCascadeId().intValue() == Flag.NULL.getInt()) {
                dto.setSupplement(Integer.valueOf(SignupSupplementType.NEW.getCode()));
            }
            dto.setTaskGen(Integer.valueOf(signupCourse.getStatus().intValue() == SignupCourseStatus.INIT.getCode() ? Flag.TRUE.getInt() : Flag.FALSE.getInt()));
            dto.setSignupTime(signupCourse.getCreateTime());
            dto.setPayPrice(signupCourse.getPayPrice());
            dto.setStudentPayPrice(signupCourse.getStudentPayPrice());
            Long remainingPay = 0L;
            if (signupCourse.getLessonCount() > 0) {
                remainingPay = (long)((signupCourse.getStudentPayPrice().doubleValue() + signupCourse.getPayPrice().doubleValue()) / (double)signupCourse.getLessonCount().intValue() * (double)(signupCourse.getLessonCount() - dto.getFinishedLessonNum()));
            }
            log.debug("PayPrice:{}, FinishedLessonNum:{}, LessonCount:{}, remainingPay:{}", new Object[]{signupCourse.getPayPrice().doubleValue(), dto.getFinishedLessonNum().doubleValue(), signupCourse.getLessonCount(), remainingPay});
            dto.setRemainingPay(Long.valueOf(remainingPay > 0L ? remainingPay : 0L));
            dto.setPaidLessonNum(signupCourse.getLessonCount());
            dto.setAddTime(signupCourse.getKexiaoTime());
            dto.setOperator((String)cascadeMap.get(signupCourse.getKexiaoCascadeId().longValue()));
            dto.setCourseType(course.getCourseType());
            result.add(dto);
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<CourseSignupInfoDto> getCourseSignupInfoDtoList(Long orgId, Collection<Long> courseNameClassIds, PageDto pageDto) {
        List delUserIds = this.orgStudentDao.getDelUserIds(orgId);
        List courseIds = this.orgSignupCourseDao.getClassIds((Collection)delUserIds, null, orgId, courseNameClassIds, Integer.valueOf(SignupSupplementType.NOT_NEW.getCode()), pageDto);
        List courseList = this.orgCourseDao.getByIds((Collection)courseIds, new String[0]);
        Collections.sort(courseList, Ordering.natural().reverse().onResultOf((Function)new Function<OrgCourse, Long>(){

            public Long apply(OrgCourse input) {
                return input.getId();
            }
        }));
        Map oldCourseStudentCountMap = this.orgSignupCourseDao.getCourseStudentCountMap((Collection)delUserIds, orgId, courseIds, Integer.valueOf(SignupSupplementType.OLD.getCode()));
        Map allCourseStudentCountMap = this.orgSignupCourseDao.getCourseStudentCountMap((Collection)delUserIds, orgId, courseIds, Integer.valueOf(SignupSupplementType.NOT_NEW.getCode()));
        log.info("course signup info: oldCourseStudentCountMap:{}, allCourseStudentCountMap:{}", (Object)oldCourseStudentCountMap, (Object)allCourseStudentCountMap);
        Map cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIds(Long.valueOf(orgId));
        ArrayList result = Lists.newArrayList();
        for (OrgCourse course : courseList) {
            Integer oldCourseStudentCount = (Integer)oldCourseStudentCountMap.get(course.getId());
            Integer allCourseStudentCount = (Integer)allCourseStudentCountMap.get(course.getId());
            oldCourseStudentCount = null == oldCourseStudentCount ? 0 : oldCourseStudentCount;
            allCourseStudentCount = null == allCourseStudentCount ? 0 : allCourseStudentCount;
            CourseSignupInfoDto dto = new CourseSignupInfoDto();
            dto.setCourseId(course.getId());
            dto.setCourseName(course.getName());
            dto.setStudentNum(allCourseStudentCount);
            dto.setNoKexiaoInfoStuNum(oldCourseStudentCount);
            dto.setCreateTime(course.getCreateTime());
            dto.setStartTime(course.getBeginTime());
            dto.setPrice(Long.valueOf((long)(course.getPrice() * 100.0)));
            dto.setChargeType(course.getChargeType());
            dto.setAddTime(course.getKexiaoTime());
            dto.setOperator((String)cascadeMap.get(course.getKexiaoCascadeId().longValue()));
            result.add(dto);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveKexiaoInfo(Long orgId, Integer cascadeId, List<StudentKexiaoInfoReq> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ArrayList updateList = Lists.newArrayList();
        for (StudentKexiaoInfoReq req : list) {
            if (req.getSupplement().intValue() != SignupSupplementType.OLD.getCode()) continue;
            updateList.add(req);
        }
        this.updateOldKexiaoInfo(orgId, cascadeId, updateList);
    }

    private void updateOldKexiaoInfo(Long orgId, Integer cascadeId, List<StudentKexiaoInfoReq> updateList) {
        if (CollectionUtils.isEmpty(updateList)) {
            return;
        }
        HashSet signupCourseIdSet = Sets.newHashSet();
        HashSet courseIdSet = Sets.newHashSet();
        HashSet classIdSet = Sets.newHashSet();
        HashSet userIdSet = Sets.newHashSet();
        HashMap reqMap = Maps.newHashMap();
        for (StudentKexiaoInfoReq kexiaoInfo : updateList) {
            signupCourseIdSet.add(kexiaoInfo.getSignupCourseId());
            courseIdSet.add(kexiaoInfo.getCourseId());
            classIdSet.add(kexiaoInfo.getClassId());
            userIdSet.add(kexiaoInfo.getUserId());
            String key = kexiaoInfo.getSignupCourseId() + "|" + kexiaoInfo.getCourseId() + "|" + kexiaoInfo.getUserId();
            reqMap.put(key, kexiaoInfo);
        }
        Map courseMap = this.orgCourseDao.getOrgCourseMap((Collection)courseIdSet, new String[]{"id", "name", "price", "freq", "maxStudent", "courseType", "chargeType", "isClass", "isCourse"});
        HashMap classIdUIdStatusWithdrawMap = Maps.newHashMap();
        for (Long classId : classIdSet) {
            Map uIdStatusWithdrawMap = this.orgStudentCourseDao.userMapByStatus(orgId, classId, (Collection)userIdSet, Arrays.asList(StudentCourseStatus.WITHDRAW.getCode(), StudentCourseStatus.TRANSFER.getCode()));
            classIdUIdStatusWithdrawMap.put(classId, uIdStatusWithdrawMap);
        }
        LinkedList orgSignupCourses = Lists.newLinkedList((Iterable)this.orgSignupCourseDao.getByCourseIdsAndStudentIds(orgId, (Collection)signupCourseIdSet, (Collection)courseIdSet, (Collection)userIdSet, new String[0]));
        Iterator iter = orgSignupCourses.iterator();
        while (iter.hasNext()) {
            OrgSignupCourse temp = (OrgSignupCourse)iter.next();
            if (temp.getLessonCount() > Flag.FALSE.getInt()) {
                iter.remove();
                continue;
            }
            String key = temp.getId() + "|" + temp.getOrgCourseId() + "|" + temp.getUserId();
            StudentKexiaoInfoReq kexiaoInfo = (StudentKexiaoInfoReq)reqMap.get(key);
            if (null != ((Map)classIdUIdStatusWithdrawMap.get(kexiaoInfo.getClassId())).get(kexiaoInfo.getUserId())) {
                iter.remove();
                continue;
            }
            Date now = new Date();
            OrgCourse course = (OrgCourse)courseMap.get(temp.getOrgCourseId());
            temp.setUpdateTime(now);
            temp.setKexiaoTime(now);
            temp.setKexiaoCascadeId(Integer.valueOf(null == cascadeId ? 0 : cascadeId));
            temp.setPayPrice(kexiaoInfo.getPayPrice());
            temp.setCount(kexiaoInfo.getPaidLessonNum());
            temp.setLessonCount(temp.getCount());
            temp.setStatus(Integer.valueOf(SignupCourseStatus.HAS_ADD.getCode()));
            temp.setCreateTime(kexiaoInfo.getTaskGen().intValue() == Flag.TRUE.getInt() ? now : temp.getCreateTime());
            temp.setSyncLessonCount(Integer.valueOf(Flag.FALSE.getInt()));
        }
        for (OrgSignupCourse course : orgSignupCourses) {
            this.orgSignupCourseDao.update((Object)course, new String[]{"updateTime", "kexiaoTime", "kexiaoCascadeId", "payPrice", "lessonCount", "count", "status", "createTime", "syncLessonCount"});
        }
        this.changeLogService.addSignUpInfoLog((List)orgSignupCourses);
    }
}

