/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.service.impl;

import com.baijia.tianxiao.biz.dto.request.QuitClassRequest;
import com.baijia.tianxiao.biz.dto.response.ApplyQuitClassDto;
import com.baijia.tianxiao.biz.dto.response.OrgSignupRefundDto;
import com.baijia.tianxiao.biz.dto.response.RefundSignupCourseDto;
import com.baijia.tianxiao.biz.dto.response.StudentFinanceAccountDto;
import com.baijia.tianxiao.biz.dto.response.StudentFinanceRecordDto;
import com.baijia.tianxiao.biz.dto.response.StudentSignupFinanceDto;
import com.baijia.tianxiao.biz.service.StudentPayService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceAccountDao;
import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceRecordDao;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceRecord;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseStudentOpDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dto.StudentCourseKexiaoDocument;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.constant.ChargeUnit;
import com.baijia.tianxiao.sal.course.service.OrgLessonConflictService;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.constants.SignupRefundType;
import com.baijia.tianxiao.sal.signup.service.OrgSignupRefundService;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StudentPayServiceImpl
implements StudentPayService {
    private static final Logger log = LoggerFactory.getLogger(StudentPayServiceImpl.class);
    @Resource
    private TxStudentFinanceAccountService txStudentFinanceAccountService;
    @Resource
    private TxStudentFinanceAccountDao txStudentFinanceAccountDao;
    @Resource
    private TxStudentFinanceRecordDao txStudentFinanceRecordDao;
    @Resource
    private OrgStudentDao orgStudentsDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;
    @Resource
    private OrgSignupRefundService orgSignupRefundService;
    @Resource
    private OrgSignupRefundDao orgSignupRefundDao;
    @Resource
    private TxCascadeCredentialService txCascadeCredentialService;
    @Resource
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private SignupService signupService;
    @Resource
    private OrgSignupCourseService orgSignupCourseService;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgCourseStudentOpDao orgCourseStudentOpDao;
    @Resource
    private OrgCourseSmsDao orgCourseSmsDao;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private OrgLessonConflictService orgLessonConflictService;

    @Override
    public OrgSignupInfo payByStudentFiannce(Long orgId, Integer cascadeId, Long signupPurchaseId, Integer opType, Double payMoney) throws BussinessException {
        Preconditions.checkNotNull((Object)(opType == StudentFiannceOpType.SIGNUP_PAY.getCode() || opType == StudentFiannceOpType.PAY_CANCEL.getCode() ? 1 : 0), (Object)"orgId may not be null");
        Preconditions.checkNotNull((Object)(payMoney != null && payMoney > 0.0 ? 1 : 0), (Object)"payMoney can not be null");
        payMoney = NumberUtil.get2Double((double)payMoney);
        OrgSignupInfo orgSignupInfo = this.signupService.getByPurchaseId(orgId, signupPurchaseId);
        if (orgSignupInfo == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u62a5\u540d\u8ba2\u5355\u53f7\u9519\u8bef" + signupPurchaseId);
        }
        if (orgSignupInfo.getStudentPayPrice() != 0L) {
            if (orgSignupInfo.getStudentPayPrice().doubleValue() / 100.0 != payMoney) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u62a5\u540d\u5b66\u751f\u4f59\u989d\u652f\u4ed8\u91d1\u989d\u9519\u8bef" + signupPurchaseId + "=" + payMoney);
            }
            return orgSignupInfo;
        }
        OrgStudent orgStudent = this.orgStudentDao.getStudent(orgId, orgSignupInfo.getUserId(), Integer.valueOf(DataStatus.NORMAL.getValue()), new String[0]);
        if (orgStudent == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u62a5\u540d\u5b66\u751f\u4e0d\u5b58\u5728" + orgSignupInfo.getUserId());
        }
        TxStudentFinanceAccount txStudentFinanceAccount = this.txStudentFinanceAccountDao.getFinanceAccount(orgId, orgStudent.getId());
        if (orgStudent == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751f\u50a8\u503c\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        if (opType == StudentFiannceOpType.SIGNUP_PAY.getCode() && payMoney > txStudentFinanceAccount.getBalance().doubleValue() / 100.0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u62a5\u540d\u652f\u4ed8\u91d1\u989d\u5927\u4e8e\u5b66\u751f\u50a8\u503c\u8d26\u53f7\u91d1\u989d");
        }
        if (opType == StudentFiannceOpType.PAY_CANCEL.getCode() && payMoney > txStudentFinanceAccount.getFreezeMoney().doubleValue() / 100.0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53d6\u6d88\u62a5\u540d\u652f\u4ed8\u91d1\u989d\u5927\u4e8e\u5b66\u751f\u51bb\u7ed3\u8d26\u53f7\u91d1\u989d");
        }
        OrgSignupInfo result = this.signupService.changeSignupStudentPrice(orgId, signupPurchaseId, opType, Long.valueOf((long)(payMoney * 100.0)));
        String opInfo = this.orgSignupCourseService.getSignupCourseName(result.getOrgId(), result.getSignupPurchaseId());
        this.txStudentFinanceAccountService.changeStudentFiannceAccount(orgId, cascadeId, orgStudent.getId(), StudentFiannceOpType.getByCode((Integer)opType), Long.valueOf((long)(payMoney * 100.0)), opInfo, "");
        return result;
    }

    @Override
    public StudentSignupFinanceDto getStudentFiannce(Long orgId, Long signupPurchaseId) throws BussinessException {
        StudentSignupFinanceDto result = new StudentSignupFinanceDto();
        OrgSignupInfo orgSignupInfo = this.signupService.getByPurchaseId(orgId, signupPurchaseId);
        log.debug("getStudentFiannce signupinfo={}", (Object)orgSignupInfo);
        if (orgSignupInfo != null) {
            OrgStudent orgStudent = this.orgStudentDao.getStudent(orgId, orgSignupInfo.getUserId(), Integer.valueOf(DataStatus.NORMAL.getValue()), new String[0]);
            log.debug("getStudentFiannce orgStudent={}", (Object)orgStudent);
            if (orgStudent != null) {
                TxStudentFinanceAccount txStudentFinanceAccount = this.txStudentFinanceAccountDao.getFinanceAccount(orgId, orgStudent.getId());
                log.debug("getStudentFiannce txStudentFinanceAccount={}", (Object)txStudentFinanceAccount);
                if (txStudentFinanceAccount != null) {
                    result.setStudentBalance(NumberUtil.get2Double((double)(txStudentFinanceAccount.getBalance().doubleValue() / 100.0)));
                }
            }
            result.setSignupFreezeMoney(NumberUtil.get2Double((double)(orgSignupInfo.getStudentPayPrice().doubleValue() / 100.0)));
        }
        return result;
    }

    @Override
    public void cancelSignupInfo(Long orgId, Integer cascadeId, Long signupPurchaseId) {
        OrgSignupInfo orgSignupInfo = this.signupService.getByPurchaseId(orgId, signupPurchaseId);
        if (orgSignupInfo == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u62a5\u540d\u8ba2\u5355\u53f7\u9519\u8bef" + signupPurchaseId);
        }
        OrgStudent orgStudent = this.orgStudentDao.getStudent(orgId, orgSignupInfo.getUserId(), Integer.valueOf(DataStatus.NORMAL.getValue()), new String[0]);
        if (orgStudent == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u62a5\u540d\u5b66\u751f\u4e0d\u5b58\u5728" + orgSignupInfo.getUserId());
        }
        this.signupService.cancelSignupInfo(signupPurchaseId, orgId);
        if (orgSignupInfo.getStudentPayPrice().intValue() > 0) {
            String opInfo = this.orgSignupCourseService.getSignupCourseName(orgId, signupPurchaseId);
            this.txStudentFinanceAccountService.changeStudentFiannceAccount(orgId, cascadeId, orgStudent.getId(), StudentFiannceOpType.PAY_CANCEL, orgSignupInfo.getStudentPayPrice(), opInfo, "");
        }
    }

    @Override
    public List<StudentFinanceAccountDto> getStudentAccoutByOrgId(Long orgId, String key, PageDto pageDto) {
        List studentFinanceAccounts = this.txStudentFinanceAccountDao.getFinanceAccount(orgId, pageDto);
        if (studentFinanceAccounts.isEmpty()) {
            return Collections.emptyList();
        }
        Map studentFinanceAccountMap = CollectorUtil.collectMap((Collection)studentFinanceAccounts, (Function)new Function<TxStudentFinanceAccount, Long>(){

            public Long apply(TxStudentFinanceAccount txStudentFinanceAccount) {
                return txStudentFinanceAccount.getStudentId();
            }
        });
        List students = this.orgStudentsDao.getByIds(studentFinanceAccountMap.keySet(), new String[]{"id", "name", "mobile"});
        Map studentMap = CollectorUtil.collectMap((Collection)students, (Function)new Function<OrgStudent, Long>(){

            public Long apply(OrgStudent orgStudent) {
                return orgStudent.getId();
            }
        });
        ArrayList result = Lists.newArrayList();
        for (TxStudentFinanceAccount txStudentFinanceAccount : studentFinanceAccounts) {
            result.add(this.buildStudentAccountDto(txStudentFinanceAccount, studentMap));
        }
        return result;
    }

    @Override
    public List<StudentFinanceRecordDto> getStudentRecordByStudentId(Long orgId, Long studentId, PageDto pageDto) {
        List studentFinanceRecords = this.txStudentFinanceRecordDao.findTxStudentFinanceRecords(orgId, studentId, pageDto);
        if (studentFinanceRecords.isEmpty()) {
            return Collections.emptyList();
        }
        Map cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIds(orgId);
        ArrayList result = Lists.newArrayList();
        for (TxStudentFinanceRecord txStudentFinanceRecord : studentFinanceRecords) {
            result.add(this.buildStudentRecordDto(txStudentFinanceRecord, cascadeMap));
        }
        return result;
    }

    @Override
    public ApplyQuitClassDto getSignupCourseByPurchase(Long orgId, Long signupPurchaseId, Long courseId) {
        return this.changeApplyQuitDto(orgId, signupPurchaseId, null, courseId, SignupCourseStatus.inClassStatus);
    }

    @Override
    public ApplyQuitClassDto getSignupCourseByStudent(Long orgId, Long userId, Long courseId) {
        return this.changeApplyQuitDto(orgId, null, userId, courseId, SignupCourseStatus.inClassStatus);
    }

    private ApplyQuitClassDto changeApplyQuitDto(Long orgId, Long signupPurchaseId, Long userId, Long courseId, List<Integer> status) {
        log.info("apply quit class params={},{},{},{}", new Object[]{orgId, signupPurchaseId, userId, courseId});
        ApplyQuitClassDto applyQuitClassDto = new ApplyQuitClassDto();
        applyQuitClassDto.setSignupPurchaseId(signupPurchaseId);
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId, new String[0]);
        if (orgCourse == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u4e0d\u5b58\u5728" + courseId);
        }
        if (orgCourse != null && orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode() && orgCourse.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode()) {
            orgCourse = this.orgCourseDao.getByCourseId(orgCourse.getParentId(), new String[0]);
        }
        if (orgCourse != null) {
            applyQuitClassDto.setCourseName(orgCourse.getName());
            applyQuitClassDto.setCourseType(orgCourse.getCourseType());
            applyQuitClassDto.setChargeType(orgCourse.getChargeType());
            applyQuitClassDto.setFreq(orgCourse.getFreq());
            applyQuitClassDto.setPrice(orgCourse.getPrice());
            applyQuitClassDto.setCourseId(orgCourse.getId());
        }
        applyQuitClassDto.setCourseId(orgCourse.getId());
        log.debug("apply quit class orgCourse={}", (Object)orgCourse);
        Long signupCourseId = null;
        List<OrgSignupCourse> signupCourseList = Lists.newArrayList();
        if (signupPurchaseId != null && signupPurchaseId > 0L) {
            OrgSignupCourse signupCourse = this.orgSignupCourseDao.getByCourseId(orgId, signupPurchaseId, courseId);
            userId = signupCourse.getUserId();
            signupCourseId = signupCourse.getId();
            signupCourseList.add(signupCourse);
        } else {
            ArrayList courseIds = Lists.newArrayList();
            courseIds.add(orgCourse.getId());
            signupCourseList = this.orgSignupCourseDao.getByCourseIdsAndStudentId(orgId, userId, (Collection)courseIds, status);
        }
        log.debug("apply quit class signupCourseList={}", (Object)signupCourseList);
        OrgStudent orgStudent = this.orgStudentDao.getStudentByUserId(orgId, userId, new String[0]);
        if (orgStudent == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b66\u5458\u4e0d\u5b58\u5728" + userId);
        }
        applyQuitClassDto.setUserId(userId);
        log.debug("apply quit class userId={}", (Object)userId);
        StudentCourseKexiaoDocument financed = this.orgStudentKexiaoRecordDao.finishCountMoney(orgId, orgCourse.getId(), userId, signupCourseId, SignupCourseStatus.inClassStatus);
        log.debug("apply quit class financed={}", (Object)financed);
        if (CollectionUtils.isNotEmpty(signupCourseList) && financed != null) {
            Integer allLessonCount = 0;
            Long allPayMoney = 0L;
            boolean canKexiao = true;
            int tempChargeUnit = -1;
            for (OrgSignupCourse orgSignupCourse : signupCourseList) {
                allLessonCount = allLessonCount + orgSignupCourse.getLessonCount();
                allPayMoney = allPayMoney + orgSignupCourse.getStudentPayPrice();
                allPayMoney = allPayMoney + orgSignupCourse.getPayPrice();
                applyQuitClassDto.setChargeUnit(orgSignupCourse.getChargeUnit());
                applyQuitClassDto.setStatus(orgSignupCourse.getStatus());
                applyQuitClassDto.setSignupTime(orgSignupCourse.getCreateTime());
                applyQuitClassDto.setCount(orgSignupCourse.getCount());
                if (orgSignupCourse.getLessonCount() == 0) {
                    canKexiao = false;
                }
                tempChargeUnit = orgSignupCourse.getChargeUnit();
            }
            applyQuitClassDto.setFinishLessonCount(financed.getFinishCount().intValue());
            if (tempChargeUnit == ChargeUnit.BY_HOUR.getCode()) {
                applyQuitClassDto.setFinishLessonCount(financed.getFinishTime().intValue());
                applyQuitClassDto.setLeftLessonCount(allLessonCount * 60 - financed.getFinishTime().intValue());
            } else if (tempChargeUnit == ChargeUnit.BY_HALF_HOUR.getCode()) {
                applyQuitClassDto.setFinishLessonCount(financed.getFinishTime().intValue());
                applyQuitClassDto.setLeftLessonCount(allLessonCount * 30 - financed.getFinishTime().intValue());
            } else if (tempChargeUnit == ChargeUnit.BY_TIMES.getCode()) {
                applyQuitClassDto.setFinishLessonCount(financed.getFinishCount().intValue());
                applyQuitClassDto.setLeftLessonCount(allLessonCount - financed.getFinishCount().intValue());
            } else {
                applyQuitClassDto.setFinishLessonCount(0);
                applyQuitClassDto.setLeftLessonCount(-1);
                applyQuitClassDto.setLeftLessonMoney(-1.0);
            }
            if (!canKexiao) {
                applyQuitClassDto.setFinishLessonCount(0);
                applyQuitClassDto.setLeftLessonMoney(-1.0);
                applyQuitClassDto.setLeftLessonCount(-1);
                if (allPayMoney.doubleValue() > 0.0) {
                    applyQuitClassDto.setCanRefundMoney(allPayMoney.doubleValue() / 100.0);
                } else {
                    applyQuitClassDto.setCanRefundMoney(1000000.0);
                }
            } else {
                applyQuitClassDto.setLeftLessonMoney(NumberUtil.get2Double((double)(allPayMoney.doubleValue() - (double)financed.getFinishMoney().longValue())) / 100.0);
                applyQuitClassDto.setCanRefundMoney(applyQuitClassDto.getLeftLessonMoney());
            }
            if (applyQuitClassDto.getCanRefundMoney() <= 0.0) {
                applyQuitClassDto.setCanRefundMoney(0.0);
            }
            if (applyQuitClassDto.getLeftLessonCount() < 0 || applyQuitClassDto.getLeftLessonMoney() < 0.0) {
                applyQuitClassDto.setLeftLessonCount(-1);
                applyQuitClassDto.setLeftLessonMoney(-1.0);
            }
        } else {
            applyQuitClassDto.setChargeType(orgCourse.getChargeType());
            applyQuitClassDto.setChargeUnit(orgCourse.getChargeUnit());
            applyQuitClassDto.setFinishLessonCount(0);
            applyQuitClassDto.setLeftLessonMoney(0.0);
            applyQuitClassDto.setLeftLessonCount(0);
            applyQuitClassDto.setCanRefundMoney(0.0);
        }
        applyQuitClassDto.setSignupCourseList(this.buildSignupCourseList(signupCourseList, orgCourse));
        log.debug("apply quit class result={}", (Object)applyQuitClassDto);
        return applyQuitClassDto;
    }

    @Override
    @Transactional
    public OrgSignupRefundDto confirmQuitClass(Long orgId, QuitClassRequest quitClassRequest) {
        log.info("confirmQuitClass={},{}", (Object)orgId, (Object)quitClassRequest);
        quitClassRequest.setRefundMoney(NumberUtil.get2Double((double)quitClassRequest.getRefundMoney()));
        if (SignupRefundType.getByCode((Integer)quitClassRequest.getRefundType()) == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9000\u6b3e\u7c7b\u578b\u9519\u8bef" + quitClassRequest.getRefundType());
        }
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(quitClassRequest.getCourseId(), new String[0]);
        if (orgCourse != null && orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode() && orgCourse.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode()) {
            orgCourse = this.orgCourseDao.getByCourseId(orgCourse.getParentId(), new String[0]);
        }
        if (orgCourse == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u4e0d\u5b58\u5728" + quitClassRequest.getCourseId());
        }
        Long realCourseId = orgCourse.getId();
        OrgStudent orgStudent = this.orgStudentDao.getStudentByUserId(orgId, quitClassRequest.getUserId(), new String[0]);
        if (orgStudent == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b66\u5458\u4e0d\u5b58\u5728" + quitClassRequest.getUserId());
        }
        ArrayList courseIds = Lists.newArrayList();
        courseIds.add(realCourseId);
        List signupCourses = this.orgSignupCourseDao.getByCourseIdsAndStudentId(orgId, orgStudent.getUserId(), (Collection)courseIds, (Collection)SignupCourseStatus.inClassStatus);
        Long signupPurchaseId = quitClassRequest.getSignupPurchaseId() == null ? 0L : quitClassRequest.getSignupPurchaseId();
        int quitType = this.changeQuitClassStatus(orgId, realCourseId, quitClassRequest.getCourseId(), orgStudent.getUserId(), quitClassRequest.getSignupPurchaseId(), signupCourses);
        List orgSignupRefundList = this.orgSignupRefundService.saveRefund(signupCourses, orgId, signupPurchaseId, realCourseId, orgStudent.getUserId(), Long.valueOf(new Double(quitClassRequest.getRefundMoney() * 100.0).longValue()), quitClassRequest.getRefundType(), quitClassRequest.getCascadeId());
        return this.buildSignupRefund(signupCourses, orgCourse, quitType, quitClassRequest, orgSignupRefundList);
    }

    @Override
    public OrgSignupRefundDto detailQuitClass(Long orgId, QuitClassRequest quitClassRequest) {
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(quitClassRequest.getCourseId(), new String[0]);
        if (orgCourse != null && orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode() && orgCourse.getIsClass() == CourseTypeEnum.IS_CLASS_TRUE.getCode()) {
            orgCourse = this.orgCourseDao.getByCourseId(orgCourse.getParentId(), new String[0]);
        }
        if (orgCourse == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u4e0d\u5b58\u5728" + quitClassRequest.getCourseId());
        }
        OrgStudent orgStudent = this.orgStudentDao.getStudentByUserId(orgId, quitClassRequest.getUserId(), new String[0]);
        if (orgStudent == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b66\u5458\u4e0d\u5b58\u5728" + quitClassRequest.getUserId());
        }
        List signupRefunds = this.orgSignupRefundDao.getOrgSignupRefundByStudent(orgId, quitClassRequest.getSignupPurchaseId(), orgStudent.getUserId(), orgCourse.getId());
        if (signupRefunds.isEmpty()) {
            signupRefunds = this.orgSignupRefundDao.getOrgSignupRefundByStudent(orgId, null, orgStudent.getUserId(), orgCourse.getId());
        }
        Map cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIds(orgId);
        OrgSignupRefundDto signupRefundDto = new OrgSignupRefundDto();
        if (!signupRefunds.isEmpty()) {
            OrgSignupRefund orgSignupRefund = (OrgSignupRefund)signupRefunds.get(0);
            signupRefundDto.setRefundType(orgSignupRefund.getRefundType());
            signupRefundDto.setRefundTypeStr(SignupRefundType.getByCode((Integer)orgSignupRefund.getRefundType()).getName());
            signupRefundDto.setRefundMoney(NumberUtil.get2Double((double)(orgSignupRefund.getRefundPrice().doubleValue() / 100.0)));
            signupRefundDto.setRefundTime(orgSignupRefund.getCreateTime());
            signupRefundDto.setCascadeIdStr((String)cascadeMap.get(orgSignupRefund.getCascadeId().longValue()));
        }
        ApplyQuitClassDto applyQuitClassDto = null;
        applyQuitClassDto = quitClassRequest.getSignupPurchaseId() != null && quitClassRequest.getSignupPurchaseId() > 0L ? this.changeApplyQuitDto((long)orgId, quitClassRequest.getSignupPurchaseId(), null, quitClassRequest.getCourseId(), SignupCourseStatus.inStudentCourseStatus) : this.changeApplyQuitDto((long)orgId, null, quitClassRequest.getUserId(), quitClassRequest.getCourseId(), SignupCourseStatus.inStudentCourseStatus);
        List<RefundSignupCourseDto> refundSignupCourseDtos = applyQuitClassDto.getSignupCourseList();
        Map signupRefundMap = CollectorUtil.collectMap((Collection)signupRefunds, (Function)new Function<OrgSignupRefund, Long>(){

            public Long apply(OrgSignupRefund orgSignupRefund) {
                return orgSignupRefund.getSignupPurchaseId();
            }
        });
        Long refundMoney = 0L;
        for (RefundSignupCourseDto refundSignupCourseDto : refundSignupCourseDtos) {
            OrgSignupRefund signupRefund = (OrgSignupRefund)signupRefundMap.get(refundSignupCourseDto.getSignupPurchaseId());
            if (signupRefund == null) continue;
            refundMoney = refundMoney + signupRefund.getRefundPrice();
            refundSignupCourseDto.setRefundMoney(signupRefund.getRefundPrice().doubleValue() / 100.0);
        }
        signupRefundDto.setRefundMoney(refundMoney.doubleValue() / 100.0);
        signupRefundDto.setSignupCourseList(refundSignupCourseDtos);
        return signupRefundDto;
    }

    private int changeQuitClassStatus(Long orgId, Long courseId, Long classId, Long userId, Long signPurchaseId, List<OrgSignupCourse> signupCourses) {
        log.info("studentPayServie  changeQuitClassStatus = {},{},{},{},{}", new Object[]{orgId, courseId, userId, signPurchaseId, signupCourses});
        int defaultStatus = SignupCourseStatus.QUIT_PURCHASE.getCode();
        if (signPurchaseId == null || signPurchaseId.intValue() == 0) {
            defaultStatus = SignupCourseStatus.QUIT_CLASS.getCode();
        } else {
            List leftSignCourse = this.orgSignupCourseDao.getLeftQuitClassSignupCourse(orgId, courseId, userId, signPurchaseId, new String[0]);
            if (CollectionUtils.isEmpty((Collection)leftSignCourse)) {
                defaultStatus = SignupCourseStatus.QUIT_CLASS.getCode();
            }
        }
        log.info("studentPayServie  changeQuitClassStatus defaultStatus= {}", (Object)defaultStatus);
        if (defaultStatus == SignupCourseStatus.QUIT_CLASS.getCode()) {
            OrgStudentCourse orgStudentCourse = this.orgStudentCourseDao.getStudentCourseByRealCourseId(orgId, courseId, userId);
            if (orgStudentCourse != null) {
                this.deleteStudentFromCourseLesson(orgId, classId, userId);
                this.orgStudentCourseDao.deleteOrgCourseStudent(orgId, classId, userId, Integer.valueOf(StudentCourseStatus.WITHDRAW.getCode()));
            }
            this.orgCourseSmsDao.delCourseSmsRecord(orgId, classId, Integer.valueOf(UserRole.STUDENT.getRole()), (Collection)Lists.newArrayList((Object[])new Long[]{userId}));
        }
        if (CollectionUtils.isNotEmpty(signupCourses)) {
            for (OrgSignupCourse orgSignupCourse : signupCourses) {
                int result;
                if (signPurchaseId != null && signPurchaseId > 0L) {
                    if (orgSignupCourse.getSignupPurchaseId().longValue() != signPurchaseId.longValue() || (result = this.orgSignupCourseDao.updateStatusByPurchaseId(signPurchaseId, courseId, userId, Integer.valueOf(defaultStatus))) != 0) continue;
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u7ecf\u9000\u8ba2\u5355");
                }
                result = this.orgSignupCourseDao.updateStatusByPurchaseId(null, courseId, userId, Integer.valueOf(defaultStatus));
                if (result == 0) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u7ecf\u9000\u73ed");
                }
                break;
            }
        } else {
            this.orgStudentCourseDao.deleteOrgCourseStudent(orgId, classId, userId, Integer.valueOf(StudentCourseStatus.WITHDRAW.getCode()));
        }
        return defaultStatus;
    }

    private OrgSignupRefundDto buildSignupRefund(List<OrgSignupCourse> signupCourses, OrgCourse orgCourse, Integer quitType, QuitClassRequest quitClassRequest, List<OrgSignupRefund> refundList) {
        OrgSignupRefundDto result = new OrgSignupRefundDto();
        result.setRefundType(quitClassRequest.getRefundType());
        result.setRefundTypeStr(SignupRefundType.getByCode((Integer)quitClassRequest.getRefundType()).getName());
        result.setRefundMoney(quitClassRequest.getRefundMoney());
        result.setRefundTime(refundList.isEmpty() ? new Date() : refundList.get(0).getCreateTime());
        ArrayList dtoList = Lists.newArrayList();
        if (quitType.intValue() == SignupCourseStatus.QUIT_PURCHASE.getCode()) {
            for (OrgSignupCourse signupCourse : signupCourses) {
                if (!SignupCourseStatus.statusInClass((int)signupCourse.getStatus()) || signupCourse.getSignupPurchaseId().longValue() == quitClassRequest.getSignupPurchaseId().longValue()) continue;
                dtoList.add(this.getSignupCourseByPurchase(signupCourse.getOrgId(), signupCourse.getSignupPurchaseId(), signupCourse.getOrgCourseId()));
            }
        }
        result.setOtherPurchase(dtoList);
        result.setSignupCourseList(this.buildSignupCourseList(signupCourses, orgCourse));
        return result;
    }

    private StudentFinanceAccountDto buildStudentAccountDto(TxStudentFinanceAccount txStudentFinanceAccount, Map<Long, OrgStudent> studentMap) {
        StudentFinanceAccountDto accountDto = new StudentFinanceAccountDto();
        accountDto.setStudentId(txStudentFinanceAccount.getStudentId());
        accountDto.setBanlance(NumberUtil.get2Double((double)(txStudentFinanceAccount.getBalance().doubleValue() / 100.0)));
        OrgStudent orgStudent = studentMap.get((long)txStudentFinanceAccount.getStudentId());
        if (orgStudent != null) {
            accountDto.setStudentName(orgStudent.getName());
            accountDto.setStudentMobile(orgStudent.getStudentMobile());
        }
        return accountDto;
    }

    private StudentFinanceRecordDto buildStudentRecordDto(TxStudentFinanceRecord txStudentFinanceRecord, Map<Long, String> cascadeMap) {
        StudentFinanceRecordDto recordDto = new StudentFinanceRecordDto();
        recordDto.setCreateTime(txStudentFinanceRecord.getCreateTime());
        recordDto.setOpInfo(txStudentFinanceRecord.getOpInfo());
        recordDto.setOpTo(txStudentFinanceRecord.getOpTo());
        recordDto.setOpMoney(NumberUtil.get2Double((double)(txStudentFinanceRecord.getOpMoney().doubleValue() / 100.0)));
        recordDto.setCurrentMoney(NumberUtil.get2Double((double)(txStudentFinanceRecord.getCurrBalance().doubleValue() / 100.0)));
        recordDto.setOpTypeStr(StudentFiannceOpType.getByCode((Integer)txStudentFinanceRecord.getOpType()).getName());
        String cascadeName = cascadeMap.get(txStudentFinanceRecord.getCascadeId().longValue());
        recordDto.setCascadeName(cascadeName == null ? "\u7cfb\u7edf\u8bbe\u7f6e" : cascadeName);
        return recordDto;
    }

    private List<RefundSignupCourseDto> buildSignupCourseList(List<OrgSignupCourse> orgSignupCourseList, OrgCourse orgCourse) {
        ArrayList result = Lists.newArrayList();
        for (OrgSignupCourse orgSignupCourse : orgSignupCourseList) {
            result.add(this.buildOrgSignupCourseDto(orgSignupCourse, orgCourse));
        }
        return result;
    }

    private RefundSignupCourseDto buildOrgSignupCourseDto(OrgSignupCourse orgSignupCourse, OrgCourse orgCourse) {
        OrgSignupInfo orgSignupInfo = this.signupService.getByPurchaseId(orgSignupCourse.getOrgId(), orgSignupCourse.getSignupPurchaseId());
        RefundSignupCourseDto dto = new RefundSignupCourseDto();
        dto.setSignupPurchaseId(orgSignupCourse.getSignupPurchaseId());
        dto.setFreq(orgCourse.getFreq());
        dto.setCount(orgSignupCourse.getCount());
        dto.setChargeUnit(orgSignupCourse.getChargeUnit());
        if (dto.getChargeUnit().intValue() != ChargeUnit.BY_OTHER.getCode().intValue()) {
            dto.setChargeType(orgCourse.getChargeType());
        }
        double preferential = ((100.0 - orgSignupCourse.getCourseDiscount().doubleValue()) / 100.0 * (double)orgSignupCourse.getOriginPrice().intValue() * (double)orgSignupCourse.getCount().intValue() + (double)orgSignupCourse.getPreferential().intValue()) / 100.0;
        dto.setPreferential(preferential);
        dto.setPayPrice(NumberUtil.get2Double((double)(orgSignupCourse.getPayPrice().doubleValue() / 100.0)));
        dto.setStudentPayPrice(NumberUtil.get2Double((double)(orgSignupCourse.getStudentPayPrice().doubleValue() / 100.0)));
        dto.setLessonCount(orgSignupCourse.getLessonCount());
        dto.setStatus(orgSignupCourse.getStatus());
        if (orgSignupInfo == null) {
            dto.setPayType(PayType.CASH.getCode());
            dto.setPayTypeStr("\u73b0\u91d1\u652f\u4ed8");
            dto.setPayTime(orgSignupCourse.getCreateTime());
            dto.setSignupTime(orgSignupCourse.getCreateTime());
        } else {
            dto.setPayType(orgSignupInfo.getPayType());
            dto.setPayTypeStr(PayType.getByCode((int)orgSignupInfo.getPayType()));
            if (orgSignupCourse.getStudentPayPrice() > 0L) {
                if (orgSignupCourse.getPayPrice() > 0L) {
                    dto.setPayTypeStr("\u5b66\u5458\u4f59\u989d\uffe5" + NumberUtil.get2FromDouble((double)dto.getStudentPayPrice()) + "+" + dto.getPayTypeStr() + "\uffe5" + NumberUtil.get2FromDouble((double)dto.getPayPrice()));
                } else {
                    dto.setPayTypeStr("\u5b66\u751f\u4f59\u989d\u652f\u4ed8");
                }
            }
            dto.setPayTime(orgSignupInfo.getPayTime());
            dto.setSignupTime(orgSignupInfo.getCreateTime());
        }
        dto.setKexiaoTime(orgSignupCourse.getKexiaoTime());
        return dto;
    }

    private void deleteStudentFromCourseLesson(Long orgId, Long classId, Long userId) {
        log.info("deleteStudentFromCourseLesson=={},{},{}", new Object[]{orgId, classId, userId});
        boolean delLessons = false;
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(classId, new String[0]);
        if (orgCourse != null && orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
            this.orgCourseDao.updateFinish(classId, Integer.valueOf(1));
            delLessons = true;
        }
        List leftLessonIds = this.orgClassLessonDao.getLeftLessonIds(orgId, classId);
        log.info("leftLessonIds = {}", (Object)leftLessonIds);
        this.orgStudentLessonDao.delStudentFromLesson(orgId, (Collection)leftLessonIds, userId);
        HashMap condition = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)leftLessonIds)) {
            condition.put("lessonId", leftLessonIds);
            condition.put("userId", userId);
            condition.put("orgId", orgId);
            this.orgLessonSignDao.delByCondition((Map)condition);
        }
        if (delLessons) {
            this.orgClassLessonDao.updateDelByLessonIds(orgId, (Collection)leftLessonIds);
            this.orgLessonConflictService.delByLessonIds(orgId, leftLessonIds);
        }
    }
}

