package com.baijia.tianxiao.biz.service.impl;

import com.baijia.tianxiao.biz.service.StudentSignupCourseService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.constant.ChargeType;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.*;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.constant.SignupSupplementType;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.SignupErrorCode;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.StudentCourseApi;
import com.baijia.tianxiao.sal.common.dto.StudentCourseBase;
import com.baijia.tianxiao.sal.course.constant.ChargeUnit;
import com.baijia.tianxiao.sal.course.constant.CourseErrorCode;
import com.baijia.tianxiao.sal.course.dto.SupplementCourseInfoDto;
import com.baijia.tianxiao.sal.course.dto.request.StudentKexiaoInfoReq;
import com.baijia.tianxiao.sal.course.dto.response.AddInfoResponseDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseSignupInfoDto;
import com.baijia.tianxiao.sal.course.dto.response.StudentSignupInfoDto;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.kexiao.service.KexiaoChangeLogService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.dto.AddSignupInfoDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.collection.CollectorUtil;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * Author: hanlaijin
 * Date: 16/12/6 下午4:05
 */
@Service
@Slf4j
public class StudentSignupCourseServiceImpl implements StudentSignupCourseService {

    @Resource
    OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    OrgSignupCourseDao orgSignupCourseDao;
    @Resource
    OrgCourseDao orgCourseDao;
    @Resource
    OrgCourseService orgCourseService;
    @Resource
    OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;
    @Resource
    OrgStudentDao orgStudentDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private TxCascadeCredentialService txCascadeCredentialService;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private KexiaoChangeLogService changeLogService;
    @Resource
    private StudentCourseApi studentCourseApi;

    @Override
    public List<StudentSignupInfoDto> checkInfo(Long orgId, Long studentId, List<Long> courseIds) {
        log.debug("---------checkInfo courseIds={}", courseIds);
        //根据studentId去org_students获得userId
        Long userId = orgStudentDao.getUserId(studentId);
        List<StudentSignupInfoDto> result = getStudentSignupInfoDtoList(orgId, courseIds, Arrays.asList(userId), SignupSupplementType.OLD.getCode(), null);
        return result;
    }

    @Override
    public List<AddInfoResponseDto> saveOrUpdateSignupCourse(Long orgId, Long cascadeId, List<AddSignupInfoDto> list) {
        log.debug("-----saveOrUpdateSignupCourse list={}", list);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.EMPTY_LIST;
        }
        List<Long> courseIds = Lists.newArrayList();
        for (AddSignupInfoDto a : list) {
            courseIds.add(a.getCourseId());
        }
        //报名入班的修改报名记录
        this.updateSignupCourses(cascadeId, list);
        //获得返回数据
        return signupInfoResult(courseIds);
    }

    private void updateSignupCourses(Long cascadeId, List<AddSignupInfoDto> updateList) {
        if (CollectionUtils.isEmpty(updateList)) {
            return;
        }
        for (AddSignupInfoDto a : updateList) {
            OrgSignupCourse o = orgSignupCourseDao.getById(a.getSignupCourseId());
            log.debug("--------------OrgSignupCourse={}", o);
            if (o != null) {
                o.setPayPrice(a.getPayPrice());
                o.setLessonCount(a.getPayCount());
                o.setChargeUnit(ChargeUnit.BY_TIMES.getCode());
                o.setKexiaoTime(new Date());
                o.setUpdateTime(new Date());
                o.setKexiaoCascadeId(cascadeId != null ? cascadeId.intValue() : 0);
                orgSignupCourseDao.update(o, "payPrice", "lessonCount", "chargeUnit", "updateTime", "kexiaoTime", "kexiaoCascadeId");
            } else {
                throw new BussinessException(SignupErrorCode.PURCHASE_ID_INVALIDATE);
            }
        }
    }

    private List<AddInfoResponseDto> signupInfoResult(List<Long> courseIds) {
        List<OrgCourse> courseList = orgCourseDao.getCourseList(courseIds, null, null, null, null, null);
        List<AddInfoResponseDto> result = Lists.newArrayList();
        for (OrgCourse o : courseList) {
            AddInfoResponseDto dto = new AddInfoResponseDto();
            dto.setLessonCount(o.getFreq());
            dto.setPrice(o.getPrice());
            dto.setCourseName(o.getName());
            dto.setCourseId(o.getId());
            dto.setChargeType(o.getChargeType());
            dto.setChargeUnit(o.getChargeUnit());
            result.add(dto);
        }
        return result;
    }


    @Override
    public List<AddInfoResponseDto> addCourseInfo(Long orgId, Integer cascadeId, List<SupplementCourseInfoDto> courseInfos) {
        if (CollectionUtils.isEmpty(courseInfos)) {
            return Collections.EMPTY_LIST;
        }
        Long orgNumber = getOrgNumber(orgId);
        List<Long> orgCourseIds = getCourseIds(courseInfos);
        Map<Long, OrgCourse> orgCourseMap = orgCourseDao.getOrgCourseMap(orgCourseIds);
        Map<Long, String> cascadeMap = txCascadeCredentialService.getByTxCasCadeIds(orgId.longValue());
        String cascadeStr = cascadeMap.get(cascadeId == null ? 0L : cascadeId);
        log.debug("----------addCourseInfo:cascadeId={},cascadeStr={}", cascadeId, cascadeStr);
        updateCourseInfos(courseInfos, orgCourseMap, orgNumber, cascadeId, cascadeStr);
        List<AddInfoResponseDto> result = addCourseInfoResult(courseInfos, orgCourseMap);
        return result;
    }

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), "number");
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? number.longValue() : null;
    }

    private List<Long> getCourseIds(List<SupplementCourseInfoDto> courseInfos) {
        List<Long> courseIds = Lists.newArrayList();
        for (SupplementCourseInfoDto s : courseInfos) {
            courseIds.add(s.getCourseId());
        }
        return courseIds;
    }

    private void updateCourseInfos(List<SupplementCourseInfoDto> courseInfos, Map<Long, OrgCourse> orgCourseMap, Long orgNumber, Integer cascadeId, String cascadeStr) {
        for (SupplementCourseInfoDto s : courseInfos) {
            OrgCourse course = orgCourseMap.get(s.getCourseId());
            if (course == null || course.getOrgNumber().longValue() != orgNumber) {
                log.debug("course not exist ,course id={}", s.getCourseId());
                throw new BussinessException(CourseErrorCode.COURSE_NOT_EXIST);
            }
            if(s.getChargeType().intValue()>2){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR,"收费类型错误");
            }
            course.setChargeType(s.getChargeType());
            if(s.getChargeType()!= ChargeType.BY_PERIODS.getCode()){
                course.setCourseType(CourseTypeEnum.COURSE_TYPE_NEW_CLASS.getCode());
            }
            if (s.getCoursePrice() != null) {
                if(s.getCoursePrice().doubleValue() < 0.01 || s.getCoursePrice().doubleValue() > 1000000 ){
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR,"价格需是0.01至1000000之间的数字");
                }
                course.setPrice(s.getCoursePrice());
            }
            if (s.getMaxStudent() != null && course.getCourseType() != CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                course.setMaxStudent(s.getMaxStudent());
            }
            if (s.getTotalLessons() != null && course.getCourseType() != CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                course.setFreq(s.getTotalLessons());
            }
            course.setChargeUnit(ChargeUnit.BY_TIMES.getCode());
            course.setKexiaoTime(new Date());
            course.setKexiaoCascadeId(cascadeId != null ? cascadeId : 0);
            log.debug("----------------save course={}", course);
            orgCourseDao.update(course);
        }
    }

    private List<AddInfoResponseDto> addCourseInfoResult(List<SupplementCourseInfoDto> courseInfos, Map<Long, OrgCourse> orgCourseMap) {
        List<AddInfoResponseDto> result = Lists.newArrayList();
        for (SupplementCourseInfoDto s : courseInfos) {
            OrgCourse course = orgCourseMap.get(s.getCourseId());
            AddInfoResponseDto responseDto = new AddInfoResponseDto();
            responseDto.setChargeType(s.getChargeType());
            responseDto.setChargeUnit(ChargeUnit.BY_TIMES.getCode());
            responseDto.setCourseId(s.getCourseId());
            responseDto.setPrice(s.getCoursePrice());
            responseDto.setCourseName(course.getName());
            responseDto.setLessonCount(s.getTotalLessons());
            result.add(responseDto);
        }
        return result;
    }

    @Override
    @Transactional(readOnly = true)
    public List<StudentSignupInfoDto> getStudentSignupInfoDtoList(Long orgId, Collection<Long> classIds,
                                                                  Collection<Long> userIds, Integer supplement, PageDto pageDto) {
        List<Long> delUserIds = orgStudentDao.getDelUserIds(orgId);
        
        // 所有报名列表
        List<OrgSignupCourse> orgSignupCourses =
                orgSignupCourseDao.getByCourseIdsAndStudentIds(delUserIds, orgId, classIds, userIds, supplement, pageDto);
        log.debug("getStudentSignupInfoDtoList find orgSignupCourses list size:{}", orgSignupCourses.size());
        Set<Long> resultClassIds = Sets.newHashSet();
        Set<Long> resultUserIds = Sets.newHashSet();
        for (OrgSignupCourse signupCourse : orgSignupCourses) {
            if(signupCourse.getClassId() == Flag.NULL.getLong()){// FIXME 脏逻辑 // 数据同步时间差异
                signupCourse.setClassId(signupCourse.getOrgCourseId());
            }
            resultClassIds.add(signupCourse.getClassId());
            resultUserIds.add(signupCourse.getUserId());
        }

        Map<Long, OrgStudent> studentMap = CollectorUtil.collectMap(
                orgStudentDao.getStudentByUserIdsAndDelStatus(orgId, resultUserIds, null, "userId", "mobile", "name"),
                new Function<OrgStudent, Long>() {
                    @Override
                    public Long apply(OrgStudent input) {
                        return input.getUserId();
                    }
                });

        // 机构子帐号姓名map
        Map<Long, String> cascadeMap = txCascadeCredentialService.getByTxCasCadeIds(orgId.longValue());
        // 课程名称map
        Map<Long, OrgCourse> courseMap = orgCourseDao.getOrgCourseMap(resultClassIds, "id", "name", "price", "freq",
            "maxStudent", "courseType", "chargeType", "isClass", "isCourse");
        Map<Long, Map<Long, StudentCourseBase>> baseMap = Maps.newHashMap();
        for (Long classId : resultClassIds) {
            baseMap.put(classId, studentCourseApi.getAllData(new ArrayList<Long>(resultUserIds), classId, orgId));
        }
        List<StudentSignupInfoDto> result = Lists.newArrayList();
        for (OrgSignupCourse signupCourse : orgSignupCourses) {
            StudentCourseBase base = baseMap.get(signupCourse.getClassId()).get(signupCourse.getUserId());
            OrgCourse course = courseMap.get(signupCourse.getClassId());
            OrgStudent student = studentMap.get(signupCourse.getUserId());
            log.debug("signupCourse:{}, base:{}, course:{}, student:{}", signupCourse, base, course, student);
            StudentSignupInfoDto dto = new StudentSignupInfoDto();
            dto.setUserId(signupCourse.getUserId());
            dto.setStudentName(null != student ? student.getName() : "脏数据");
            dto.setMobile(null != student ? student.getMobile() : "脏数据");
            dto.setCourseId(signupCourse.getOrgCourseId());
            dto.setClassId(signupCourse.getClassId());
            dto.setCourseName(course.getName());
            dto.setOriginalPrice((long) (course.getPrice() * 100));
            dto.setFreq(course.getFreq());
            dto.setMaxStudent(course.getMaxStudent());
            dto.setChargeType(course.getChargeType());

            dto.setArrangedLessonNum(null == base ? 0 : base.getLessonCount());
            dto.setFinishedLessonNum(null == base ? 0 : base.getFinishCount());

            dto.setSignupCourseId(signupCourse.getId().intValue());
            // 0:旧报名数据未补充,1:新报名数据无需补充, 2:旧报名数据已经补充
            if (signupCourse.getLessonCount() == Flag.FALSE.getInt()
                && signupCourse.getKexiaoCascadeId() == Flag.NULL.getInt()) {
                dto.setSupplement(SignupSupplementType.OLD.getCode());
            } else if (signupCourse.getLessonCount() > Flag.FALSE.getInt()
                && signupCourse.getKexiaoCascadeId() > Flag.NULL.getInt()) {
                dto.setSupplement(SignupSupplementType.OLD_FIXED.getCode());
            } else if (signupCourse.getLessonCount() > Flag.FALSE.getInt()
                && signupCourse.getKexiaoCascadeId() == Flag.NULL.getInt()) {
                dto.setSupplement(SignupSupplementType.NEW.getCode());
            }
            dto.setTaskGen(signupCourse.getStatus() == SignupCourseStatus.INIT.getCode() ? Flag.TRUE.getInt()
                : Flag.FALSE.getInt());
            dto.setSignupTime(signupCourse.getCreateTime());
            dto.setPayPrice(signupCourse.getPayPrice());
            dto.setStudentPayPrice(signupCourse.getStudentPayPrice());
            Long remainingPay = 0L;
            if (signupCourse.getLessonCount() > 0) {
                remainingPay =
                    (long) ((signupCourse.getStudentPayPrice().doubleValue() + signupCourse.getPayPrice().doubleValue())
                        / signupCourse.getLessonCount()// 剩余金钱
                        * (signupCourse.getLessonCount() - dto.getFinishedLessonNum()));
            }
            log.debug("PayPrice:{}, FinishedLessonNum:{}, LessonCount:{}, remainingPay:{}",signupCourse.getPayPrice().doubleValue(),
                dto.getFinishedLessonNum().doubleValue(), signupCourse.getLessonCount(), remainingPay);
            dto.setRemainingPay(remainingPay > 0 ? remainingPay : 0);
            dto.setPaidLessonNum(signupCourse.getLessonCount());
            dto.setAddTime(signupCourse.getKexiaoTime());
            dto.setOperator(cascadeMap.get(signupCourse.getKexiaoCascadeId().longValue()));
            dto.setCourseType(course.getCourseType());
            result.add(dto);
        }
        return result;
    }

    @Override
    @Transactional(readOnly = true)
    public List<CourseSignupInfoDto> getCourseSignupInfoDtoList(Long orgId, Collection<Long> courseNameClassIds, PageDto pageDto) {
        // FIXME 脏逻辑
//        List<Long> notInCourseIds = Lists
//                .transform(orgCourseDao.getCoursesByOrgNumber(orgAccountDao.getById(orgId, "number").getNumber().longValue(),
//                        DeleteStatus.DELETED.getValue(), "id", "courseType"), new Function<OrgCourse, Long>() {
//                    @Override
//                    public Long apply(OrgCourse input) {
//                        return input.getId();
//                    }
//                });
        List<Long> delUserIds = orgStudentDao.getDelUserIds(orgId);

        List<Long> courseIds = orgSignupCourseDao
                .getClassIds(delUserIds ,null , orgId, courseNameClassIds, SignupSupplementType.NOT_NEW.getCode(), pageDto);

        List<OrgCourse> courseList = orgCourseDao.getByIds(courseIds);
        // 排个序
        Collections.sort(courseList,
            Ordering.<Long> natural().<Long> reverse().onResultOf(new Function<OrgCourse, Long>() {
                @Override
                public Long apply(OrgCourse input) {
                    return input.getId();
                }
            }));
        Map<Long, Integer> oldCourseStudentCountMap =
                orgSignupCourseDao.getCourseStudentCountMap(delUserIds, orgId, courseIds, SignupSupplementType.OLD.getCode());
        Map<Long, Integer> allCourseStudentCountMap =
                orgSignupCourseDao.getCourseStudentCountMap(delUserIds, orgId, courseIds, SignupSupplementType.NOT_NEW.getCode());
        log.info("course signup info: oldCourseStudentCountMap:{}, allCourseStudentCountMap:{}",
                oldCourseStudentCountMap, allCourseStudentCountMap);
        // 机构子帐号姓名map
        Map<Long, String> cascadeMap = txCascadeCredentialService.getByTxCasCadeIds(orgId.longValue());

        List<CourseSignupInfoDto> result = Lists.newArrayList();
        for (OrgCourse course : courseList) {
            Integer oldCourseStudentCount = oldCourseStudentCountMap.get(course.getId());
            Integer allCourseStudentCount = allCourseStudentCountMap.get(course.getId());
            oldCourseStudentCount = null == oldCourseStudentCount ? 0 : oldCourseStudentCount;
            allCourseStudentCount = null == allCourseStudentCount ? 0 : allCourseStudentCount;

            CourseSignupInfoDto dto = new CourseSignupInfoDto();
            dto.setCourseId(course.getId());
            dto.setCourseName(course.getName());
            dto.setStudentNum(allCourseStudentCount);
            dto.setNoKexiaoInfoStuNum(oldCourseStudentCount);
            dto.setCreateTime(course.getCreateTime());
            dto.setStartTime(course.getBeginTime());
            dto.setPrice((long) (course.getPrice() * 100));
            dto.setChargeType(course.getChargeType());
            dto.setAddTime(course.getKexiaoTime());
            dto.setOperator(cascadeMap.get(course.getKexiaoCascadeId().longValue()));
            result.add(dto);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSaveKexiaoInfo(Long orgId, Integer cascadeId, List<StudentKexiaoInfoReq> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }

        List<StudentKexiaoInfoReq> updateList = Lists.newArrayList();
        for (StudentKexiaoInfoReq req : list) {//先过滤出旧的报名类型
            if (req.getSupplement() == SignupSupplementType.OLD.getCode()) {
                updateList.add(req);
            }
        }
        updateOldKexiaoInfo(orgId, cascadeId, updateList);
    }

    /**
     * @param orgId
     * @param cascadeId
     * @param updateList
     * @return 更新了的报名id列表
     */
    private void updateOldKexiaoInfo(Long orgId, Integer cascadeId, List<StudentKexiaoInfoReq> updateList) {
        if (CollectionUtils.isEmpty(updateList)) {
            return;
        }
        Set<Integer> signupCourseIdSet = Sets.newHashSet();
        Set<Long> courseIdSet = Sets.newHashSet();
        Set<Long> classIdSet = Sets.newHashSet();
        Set<Long> userIdSet = Sets.newHashSet();
        Map<String, StudentKexiaoInfoReq> reqMap = Maps.newHashMap();
        for (StudentKexiaoInfoReq kexiaoInfo : updateList) {
            signupCourseIdSet.add(kexiaoInfo.getSignupCourseId());
            courseIdSet.add(kexiaoInfo.getCourseId());
            classIdSet.add(kexiaoInfo.getClassId());
            userIdSet.add(kexiaoInfo.getUserId());
            String key =
                    kexiaoInfo.getSignupCourseId() + "|" + kexiaoInfo.getCourseId() + "|" + kexiaoInfo.getUserId();
            reqMap.put(key, kexiaoInfo);
        }

        Map<Long, OrgCourse> courseMap = orgCourseDao.getOrgCourseMap(courseIdSet, "id", "name", "price", "freq",
            "maxStudent", "courseType", "chargeType", "isClass", "isCourse");
        
        // 退转班的学员
        Map<Long, Map<Long, Integer>> classIdUIdStatusWithdrawMap = Maps.newHashMap();
        for(Long classId : classIdSet){
            Map<Long, Integer> uIdStatusWithdrawMap =
                orgStudentCourseDao.userMapByStatus(orgId, classId, userIdSet,
                    Arrays.asList(StudentCourseStatus.WITHDRAW.getCode(), StudentCourseStatus.TRANSFER.getCode()));
            classIdUIdStatusWithdrawMap.put(classId, uIdStatusWithdrawMap);
        }

        List<OrgSignupCourse> orgSignupCourses = Lists.newLinkedList(
                orgSignupCourseDao.getByCourseIdsAndStudentIds(orgId, signupCourseIdSet, courseIdSet, userIdSet));
        Iterator<OrgSignupCourse> iter = orgSignupCourses.iterator();
        while (iter.hasNext()) {
            OrgSignupCourse temp = iter.next();
            if (temp.getLessonCount() > Flag.FALSE.getInt()) {//保证一致性,只update未补充过的数据
                iter.remove();
            } else {
                String key = temp.getId() + "|" + temp.getOrgCourseId() + "|" + temp.getUserId();
                StudentKexiaoInfoReq kexiaoInfo = reqMap.get(key);
                if(null != classIdUIdStatusWithdrawMap.get(kexiaoInfo.getClassId()).get(kexiaoInfo.getUserId())){
                    // 退转班学员忽略
                    iter.remove();
                    continue;
                }
                Date now = new Date();
                OrgCourse course = courseMap.get(temp.getOrgCourseId());
//                temp.setChargeUnit(ChargeUnit.BY_TIMES.getCode());
                temp.setUpdateTime(now);
                temp.setKexiaoTime(now);
                temp.setKexiaoCascadeId(null == cascadeId ? 0 : cascadeId);
                temp.setPayPrice(kexiaoInfo.getPayPrice());
                temp.setCount(kexiaoInfo.getPaidLessonNum());
                temp.setLessonCount(temp.getCount());
                temp.setStatus(SignupCourseStatus.HAS_ADD.getCode());
                temp.setCreateTime(kexiaoInfo.getTaskGen() == Flag.TRUE.getInt() ? now : temp.getCreateTime());
                temp.setSyncLessonCount(Flag.FALSE.getInt());
            }
        }
        for (OrgSignupCourse course : orgSignupCourses) {// 如此批量更新太sb了
            orgSignupCourseDao.update(course, "updateTime", "kexiaoTime", "kexiaoCascadeId", "payPrice",
                    "lessonCount", "count", "status", "createTime", "syncLessonCount");
        }
        changeLogService.addSignUpInfoLog(orgSignupCourses);
    }
}
