/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.fee.sync.impl;

import com.baijia.tianxiao.biz.fee.sync.SyncFeeService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.fee.dao.TxFeeIncomeDayDao;
import com.baijia.tianxiao.dal.fee.po.TxFeeIncomeDay;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassInfoDao;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassRecordDao;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassInfo;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassRecord;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.sal.course.dto.response.OrgCourseGroupDto;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupService;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.signup.constants.SignupRefundType;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="feeTransferRefundService")
public class FeeTransferRefundServiceImpl
implements SyncFeeService {
    private static final Logger log = LoggerFactory.getLogger(FeeTransferRefundServiceImpl.class);
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private TxTransferClassRecordDao txTransferClassRecordDao;
    @Resource
    private TxTransferClassInfoDao txTransferClassInfoDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private OrgCourseGroupService courseGroupService;
    @Autowired
    private TxFeeIncomeDayDao txFeeIncomeDayDao;
    @Autowired
    private OrgCourseService orgCourseService;
    private AtomicBoolean transferRefundFlag = new AtomicBoolean(false);

    @Override
    public void sync() {
        TxMsgSyncTimestamp syncInfo = this.getSyncInfo(MsgSyncType.FEE_TRANSFER_REFUND);
        try {
            if (!this.transferRefundFlag.get()) {
                log.info("sync transferRefundFlag :{}", (Object)syncInfo);
                this.transferRefundFlag.set(true);
                this.syncTransferRefundDay(syncInfo);
                this.transferRefundFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", (Throwable)e);
        }
        finally {
            this.transferRefundFlag.set(false);
        }
        log.info("save sync transferRefundFlag info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncTransferRefundDay(TxMsgSyncTimestamp syncInfo) {
        List transferClassRecords = this.txTransferClassRecordDao.getOrgTransferRefundListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("save FeeTransferClassRecords:{} success", (Object)transferClassRecords.size());
        if (CollectionUtils.isNotEmpty((Collection)transferClassRecords)) {
            for (TxTransferClassRecord txTransferClassRecord : transferClassRecords) {
                try {
                    if (txTransferClassRecord.getUpdateTime().after(syncInfo.getSyncTime())) {
                        syncInfo.setSyncTime(txTransferClassRecord.getUpdateTime());
                    }
                    if (txTransferClassRecord.getSyncFee() == 1) continue;
                    TxTransferClassInfo txTransferClassInfo = this.txTransferClassInfoDao.getByTransferNumber(txTransferClassRecord.getTransferNumber());
                    if (txTransferClassInfo == null) {
                        return;
                    }
                    this.saveTxFeeIncomeDay(txTransferClassRecord);
                    txTransferClassRecord.setSyncFee(Integer.valueOf(DataStatus.DELETE.getValue()));
                    this.txTransferClassRecordDao.update((Object)txTransferClassRecord, new String[]{"syncFee"});
                }
                catch (Exception e) {
                    log.warn("sync finance record fail {}", (Throwable)e);
                }
            }
        }
    }

    private void saveTxFeeIncomeDay(TxTransferClassRecord txTransferClassRecord) {
        if (txTransferClassRecord.getRefundType().intValue() == SignupRefundType.BY_ORG_CASH.getCode().intValue() || txTransferClassRecord.getRefundType().intValue() == SignupRefundType.BY_OLD_PURCHASE_CASH.getCode().intValue()) {
            OrgSignupInfo orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(txTransferClassRecord.getOutPurchaseId(), new String[0]);
            if (orgSignupInfo == null) {
                return;
            }
            String mdate = DateUtil.getStrByDate((Date)txTransferClassRecord.getCreateTime());
            List courseGroupDtos = this.courseGroupService.getByCourseId(orgSignupInfo.getOrgId(), this.orgCourseService.getCourseByClassId(txTransferClassRecord.getTransferOutClassId()));
            if (CollectionUtils.isEmpty((Collection)courseGroupDtos)) {
                TxFeeIncomeDay txFeeIncomeDay = this.txFeeIncomeDayDao.getByDayType(orgSignupInfo.getOrgId(), mdate, 0, new String[0]);
                if (txFeeIncomeDay == null) {
                    txFeeIncomeDay = new TxFeeIncomeDay();
                    txFeeIncomeDay.setOrgId(orgSignupInfo.getOrgId());
                    txFeeIncomeDay.setCourseGroupId(Integer.valueOf(0));
                    txFeeIncomeDay.setCourseGroupName("\u672a\u5206\u7c7b");
                    txFeeIncomeDay.setPayDay(mdate);
                    txFeeIncomeDay.setSignupRefund(Long.valueOf(txTransferClassRecord.getRefundMoney().longValue()));
                } else {
                    txFeeIncomeDay.setSignupRefund(Long.valueOf(txFeeIncomeDay.getSignupRefund() + txTransferClassRecord.getRefundMoney().longValue()));
                }
                log.debug("saveFeeIncomeDay={}", (Object)txFeeIncomeDay);
                this.txFeeIncomeDayDao.saveOrUpdate((Object)txFeeIncomeDay, new String[0]);
            } else {
                for (OrgCourseGroupDto courseGroupDto : courseGroupDtos) {
                    TxFeeIncomeDay txFeeIncomeDay = this.txFeeIncomeDayDao.getByDayType(orgSignupInfo.getOrgId(), mdate, courseGroupDto.getGroupId().intValue(), new String[0]);
                    if (txFeeIncomeDay == null) {
                        txFeeIncomeDay = new TxFeeIncomeDay();
                        txFeeIncomeDay.setOrgId(orgSignupInfo.getOrgId());
                        txFeeIncomeDay.setCourseGroupId(courseGroupDto.getGroupId());
                        txFeeIncomeDay.setCourseGroupName(courseGroupDto.getGroupName());
                        txFeeIncomeDay.setPayDay(mdate);
                        txFeeIncomeDay.setSignupRefund(Long.valueOf(txTransferClassRecord.getRefundMoney().longValue()));
                    } else {
                        txFeeIncomeDay.setSignupRefund(Long.valueOf(txFeeIncomeDay.getSignupRefund() + txTransferClassRecord.getRefundMoney().longValue()));
                    }
                    log.debug("saveFeeIncomeDay={}", (Object)txFeeIncomeDay);
                    this.txFeeIncomeDayDao.saveOrUpdate((Object)txFeeIncomeDay, new String[0]);
                }
            }
        }
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }
}

