/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.fee.sync.impl;

import com.baijia.tianxiao.biz.fee.sync.SyncFeeService;
import com.baijia.tianxiao.dal.fee.dao.TxFeeIncomeDayDao;
import com.baijia.tianxiao.dal.fee.dao.TxFeeStudentDayDao;
import com.baijia.tianxiao.dal.fee.po.TxFeeIncomeDay;
import com.baijia.tianxiao.dal.fee.po.TxFeeStudentDay;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.sal.course.dto.response.OrgCourseGroupDto;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupService;
import com.baijia.tianxiao.sal.signup.constants.SignupRefundType;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="feeSignupRefundRecordService")
public class FeeSignupRefundRecordServiceImpl
implements SyncFeeService {
    private static final Logger log = LoggerFactory.getLogger(FeeSignupRefundRecordServiceImpl.class);
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgSignupRefundDao orgSignupRefundDao;
    @Autowired
    private TxFeeIncomeDayDao txFeeIncomeDayDao;
    @Autowired
    private TxFeeStudentDayDao txFeeStudentDayDao;
    @Autowired
    private OrgCourseGroupService courseGroupService;
    private AtomicBoolean signupRefundRecordFlag = new AtomicBoolean(false);

    @Override
    public void sync() {
        TxMsgSyncTimestamp syncInfo = this.getSyncInfo(MsgSyncType.FEE_SIGNUP_REFUND);
        try {
            if (!this.signupRefundRecordFlag.get()) {
                log.info("sync cw signuprecord refund info :{}", (Object)syncInfo);
                this.signupRefundRecordFlag.set(true);
                this.syncSignupRefundRecordDay(syncInfo);
                this.signupRefundRecordFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", (Throwable)e);
        }
        finally {
            this.signupRefundRecordFlag.set(false);
        }
        log.info("save sync signuprefund info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncSignupRefundRecordDay(TxMsgSyncTimestamp syncInfo) {
        List signupRefunds = this.orgSignupRefundDao.getOrgSignupRefundListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("save feeSignupRefundRecordDay:{} success", (Object)signupRefunds.size());
        if (CollectionUtils.isNotEmpty((Collection)signupRefunds)) {
            for (OrgSignupRefund orgSignupRefund : signupRefunds) {
                try {
                    OrgSignupInfo orgSignupInfo;
                    if ((long)orgSignupRefund.getId() > syncInfo.getSyncId()) {
                        syncInfo.setSyncId(Long.valueOf(orgSignupRefund.getId()));
                    }
                    if (orgSignupRefund.getSignupPurchaseId() == null || orgSignupRefund.getSignupPurchaseId() <= 0L || (orgSignupInfo = this.orgSignupInfoDao.searchByPurchaseId(orgSignupRefund.getSignupPurchaseId(), new String[0])) == null) continue;
                    this.saveTxFeeIncomeDay(orgSignupRefund);
                    this.saveTxFeeStudentDay(orgSignupRefund, orgSignupInfo);
                }
                catch (Exception e) {
                    log.warn("sync finance record fail {}", (Object)e.getMessage());
                }
            }
        }
    }

    private void saveTxFeeIncomeDay(OrgSignupRefund orgSignupRefund) {
        if (orgSignupRefund.getRefundType().intValue() == SignupRefundType.BY_ORG_CASH.getCode().intValue() || orgSignupRefund.getRefundType().intValue() == SignupRefundType.BY_OLD_PURCHASE_CASH.getCode().intValue()) {
            String mdate = DateUtil.getStrByDate((Date)orgSignupRefund.getCreateTime());
            List courseGroupDtos = this.courseGroupService.getByCourseId(orgSignupRefund.getOrgId(), orgSignupRefund.getCourseId());
            if (CollectionUtils.isEmpty((Collection)courseGroupDtos)) {
                TxFeeIncomeDay txFeeIncomeDay = this.txFeeIncomeDayDao.getByDayType(orgSignupRefund.getOrgId(), mdate, 0, new String[0]);
                if (txFeeIncomeDay == null) {
                    txFeeIncomeDay = new TxFeeIncomeDay();
                    txFeeIncomeDay.setOrgId(orgSignupRefund.getOrgId());
                    txFeeIncomeDay.setCourseGroupId(Integer.valueOf(0));
                    txFeeIncomeDay.setCourseGroupName("\u672a\u5206\u7c7b");
                    txFeeIncomeDay.setPayDay(mdate);
                    txFeeIncomeDay.setSignupRefund(orgSignupRefund.getRefundPrice());
                } else {
                    txFeeIncomeDay.setSignupRefund(Long.valueOf(txFeeIncomeDay.getSignupRefund() + orgSignupRefund.getRefundPrice()));
                }
                log.debug("saveFeeIncomeDay={}", (Object)txFeeIncomeDay);
                this.txFeeIncomeDayDao.saveOrUpdate((Object)txFeeIncomeDay, new String[0]);
            } else {
                for (OrgCourseGroupDto courseGroupDto : courseGroupDtos) {
                    TxFeeIncomeDay txFeeIncomeDay = this.txFeeIncomeDayDao.getByDayType(orgSignupRefund.getOrgId(), mdate, courseGroupDto.getGroupId().intValue(), new String[0]);
                    if (txFeeIncomeDay == null) {
                        txFeeIncomeDay = new TxFeeIncomeDay();
                        txFeeIncomeDay.setOrgId(orgSignupRefund.getOrgId());
                        txFeeIncomeDay.setCourseGroupId(courseGroupDto.getGroupId());
                        txFeeIncomeDay.setCourseGroupName(courseGroupDto.getGroupName());
                        txFeeIncomeDay.setPayDay(mdate);
                        txFeeIncomeDay.setSignupRefund(orgSignupRefund.getRefundPrice());
                    } else {
                        txFeeIncomeDay.setSignupRefund(Long.valueOf(txFeeIncomeDay.getSignupRefund() + orgSignupRefund.getRefundPrice()));
                    }
                    log.debug("saveFeeIncomeDay={}", (Object)txFeeIncomeDay);
                    this.txFeeIncomeDayDao.saveOrUpdate((Object)txFeeIncomeDay, new String[0]);
                }
            }
        }
    }

    private void saveTxFeeStudentDay(OrgSignupRefund orgSignupRefund, OrgSignupInfo orgSignupInfo) {
        if (orgSignupRefund.getRefundType().intValue() == SignupRefundType.BY_ORG_CASH.getCode().intValue() || orgSignupRefund.getRefundType().intValue() == SignupRefundType.BY_OLD_PURCHASE_CASH.getCode().intValue()) {
            String mdate = DateUtil.getStrByDate((Date)orgSignupInfo.getUpdateTime());
            TxFeeStudentDay txFeeStudentDay = this.txFeeStudentDayDao.getStudentByDay(orgSignupRefund.getOrgId(), orgSignupRefund.getUserId(), mdate, new String[0]);
            if (txFeeStudentDay == null) {
                txFeeStudentDay = new TxFeeStudentDay();
                txFeeStudentDay.setOrgId(orgSignupRefund.getOrgId());
                txFeeStudentDay.setUserId(orgSignupRefund.getUserId());
                txFeeStudentDay.setStudentCounts(Integer.valueOf(-1));
                txFeeStudentDay.setStudentimes(Integer.valueOf(-1));
                txFeeStudentDay.setCreateDay(mdate);
            } else {
                txFeeStudentDay.setStudentimes(Integer.valueOf(txFeeStudentDay.getStudentimes() - 1));
                txFeeStudentDay.setStudentCounts(Integer.valueOf(txFeeStudentDay.getStudentimes() > 0 ? 1 : (txFeeStudentDay.getStudentimes() < 0 ? -1 : 0)));
            }
            log.debug("txFeeStudentDayDao={}", (Object)txFeeStudentDay);
            this.txFeeStudentDayDao.saveOrUpdate((Object)txFeeStudentDay, new String[0]);
        }
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }
}

