/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.fee.sync.impl;

import com.baijia.tianxiao.biz.fee.sync.SyncFeeService;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.fee.dao.TxFeeIncomeDayDao;
import com.baijia.tianxiao.dal.fee.dao.TxFeeStudentDayDao;
import com.baijia.tianxiao.dal.fee.po.TxFeeIncomeDay;
import com.baijia.tianxiao.dal.fee.po.TxFeeStudentDay;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.sal.course.dto.response.OrgCourseGroupDto;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupService;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="feeSignupRecordService")
public class FeeSignupRecordServiceImpl
implements SyncFeeService {
    private static final Logger log = LoggerFactory.getLogger(FeeSignupRecordServiceImpl.class);
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;
    @Autowired
    private TxFeeIncomeDayDao txFeeIncomeDayDao;
    @Autowired
    private TxFeeStudentDayDao txFeeStudentDayDao;
    @Autowired
    private OrgCourseGroupService courseGroupService;
    private AtomicBoolean signupRecordFlag = new AtomicBoolean(false);

    @Override
    public void sync() {
        TxMsgSyncTimestamp syncInfo = this.getSyncInfo(MsgSyncType.FEE_SIGNUP_COURSE);
        try {
            if (!this.signupRecordFlag.get()) {
                log.info("sync fee signuprecord iosinfo :{}", (Object)syncInfo);
                this.signupRecordFlag.set(true);
                Thread.sleep(20000L);
                this.syncSignupRecordDay(syncInfo);
                this.signupRecordFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", (Throwable)e);
        }
        finally {
            this.signupRecordFlag.set(false);
        }
        log.info("save sync info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncSignupRecordDay(TxMsgSyncTimestamp syncInfo) {
        List signupInfos = this.orgSignupInfoDao.listFeeSignupBySmsSend(100, new String[0]);
        log.info("feeSignupRecordDay: result=={} success", (Object)signupInfos);
        if (CollectionUtils.isNotEmpty((Collection)signupInfos)) {
            for (OrgSignupInfo orgSignupInfo : signupInfos) {
                log.info("feeSignupRecordDay: before=={} success", (Object)orgSignupInfo);
                try {
                    Date tempSyncTime = syncInfo.getSyncTime();
                    if (orgSignupInfo.getUpdateTime().after(syncInfo.getSyncTime())) {
                        syncInfo.setSyncTime(orgSignupInfo.getUpdateTime());
                    }
                    if (orgSignupInfo.getSyncFee() == 1 || orgSignupInfo.getPayTime() == null || orgSignupInfo.getPurchaseStatus().intValue() != PayResult.SUCCESS.getCode() || orgSignupInfo.getSplitResult().intValue() != SplitCourseResult.SUCCESS.getCode()) continue;
                    List orgSignupCourses = this.orgSignupCourseDao.loadByPurchaseId(orgSignupInfo.getSignupPurchaseId(), new String[0]);
                    if (orgSignupInfo.getOrderType().intValue() == TransferClassOrder.NORMAL_ORDER.getCode() && CollectionUtils.isEmpty((Collection)orgSignupCourses)) {
                        syncInfo.setSyncTime(tempSyncTime);
                        break;
                    }
                    orgSignupInfo.setOrgSignupCourses(orgSignupCourses);
                    this.saveTxFeeIncomeDay(orgSignupInfo);
                    this.saveTxFeeStudentDay(orgSignupInfo);
                    orgSignupInfo.setSyncFee(Integer.valueOf(1));
                    this.orgSignupInfoDao.update((Object)orgSignupInfo, new String[]{"syncFee"});
                    log.info("syncSignupRecordDay:after=={} success", (Object)orgSignupInfo);
                }
                catch (Exception e) {
                    log.warn("sync finance record fail {}", (Throwable)e);
                }
            }
        }
    }

    private void saveTxFeeIncomeDay(OrgSignupInfo orgSignupInfo) {
        String mdate = DateUtil.getStrByDate((Date)orgSignupInfo.getUpdateTime());
        if (CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getOrgSignupCourses())) {
            for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                CoursePurchase coursePurchase = this.coursePurchaseDao.getByPurcahseIdCourse(orgSignupCourse.getSignupPurchaseId(), orgSignupCourse.getOrgCourseId());
                List courseGroupDtos = this.courseGroupService.getByCourseId(orgSignupCourse.getOrgId(), orgSignupCourse.getOrgCourseId());
                if (CollectionUtils.isEmpty((Collection)courseGroupDtos)) {
                    TxFeeIncomeDay txFeeIncomeDay = this.txFeeIncomeDayDao.getByDayType(orgSignupInfo.getOrgId(), mdate, 0, new String[0]);
                    if (txFeeIncomeDay == null) {
                        txFeeIncomeDay = new TxFeeIncomeDay();
                        txFeeIncomeDay.setOrgId(orgSignupInfo.getOrgId());
                        txFeeIncomeDay.setCourseGroupId(Integer.valueOf(0));
                        txFeeIncomeDay.setCourseGroupName("\u672a\u5206\u7c7b");
                        txFeeIncomeDay.setSignupPreferential(Long.valueOf(orgSignupCourse.getPreferential().longValue()));
                        txFeeIncomeDay.setPayDay(mdate);
                        txFeeIncomeDay.setSignupIncome(orgSignupCourse.getPayPrice());
                    } else {
                        txFeeIncomeDay.setSignupIncome(Long.valueOf(txFeeIncomeDay.getSignupIncome() + orgSignupCourse.getPayPrice()));
                        txFeeIncomeDay.setSignupPreferential(Long.valueOf(txFeeIncomeDay.getSignupPreferential() + orgSignupCourse.getPreferential().longValue()));
                    }
                    if (coursePurchase != null) {
                        txFeeIncomeDay.setSignupFee(Long.valueOf(txFeeIncomeDay.getSignupFee() + NumberUtil.doubleToLong((Double)coursePurchase.getPoundage())));
                    }
                    txFeeIncomeDay.setSignupAmount(Long.valueOf(txFeeIncomeDay.getSignupIncome() - txFeeIncomeDay.getSignupFee()));
                    log.debug("saveFeeIncomeDay={}", (Object)txFeeIncomeDay);
                    this.txFeeIncomeDayDao.saveOrUpdate((Object)txFeeIncomeDay, new String[0]);
                    continue;
                }
                for (OrgCourseGroupDto courseGroupDto : courseGroupDtos) {
                    TxFeeIncomeDay txFeeIncomeDay = this.txFeeIncomeDayDao.getByDayType(orgSignupInfo.getOrgId(), mdate, courseGroupDto.getGroupId().intValue(), new String[0]);
                    if (txFeeIncomeDay == null) {
                        txFeeIncomeDay = new TxFeeIncomeDay();
                        txFeeIncomeDay.setOrgId(orgSignupInfo.getOrgId());
                        txFeeIncomeDay.setCourseGroupId(courseGroupDto.getGroupId());
                        txFeeIncomeDay.setCourseGroupName(courseGroupDto.getGroupName());
                        txFeeIncomeDay.setPayDay(mdate);
                        txFeeIncomeDay.setSignupPreferential(Long.valueOf(orgSignupCourse.getPreferential().longValue()));
                        txFeeIncomeDay.setSignupIncome(orgSignupCourse.getPayPrice());
                    } else {
                        txFeeIncomeDay.setSignupIncome(Long.valueOf(txFeeIncomeDay.getSignupIncome() + orgSignupCourse.getPayPrice()));
                        txFeeIncomeDay.setSignupPreferential(Long.valueOf(txFeeIncomeDay.getSignupPreferential() + orgSignupCourse.getPreferential().longValue()));
                    }
                    if (coursePurchase != null) {
                        txFeeIncomeDay.setSignupFee(Long.valueOf(txFeeIncomeDay.getSignupFee() + NumberUtil.doubleToLong((Double)coursePurchase.getPoundage())));
                    }
                    txFeeIncomeDay.setSignupAmount(Long.valueOf(txFeeIncomeDay.getSignupIncome() - txFeeIncomeDay.getSignupFee()));
                    log.debug("saveFeeIncomeDay={}", (Object)txFeeIncomeDay);
                    this.txFeeIncomeDayDao.saveOrUpdate((Object)txFeeIncomeDay, new String[0]);
                }
            }
        } else {
            TxFeeIncomeDay txFeeIncomeDay = this.txFeeIncomeDayDao.getByDayType(orgSignupInfo.getOrgId(), mdate, 0, new String[0]);
            if (txFeeIncomeDay == null) {
                txFeeIncomeDay = new TxFeeIncomeDay();
                txFeeIncomeDay.setOrgId(orgSignupInfo.getOrgId());
                txFeeIncomeDay.setCourseGroupId(Integer.valueOf(0));
                txFeeIncomeDay.setCourseGroupName("\u672a\u5206\u7c7b");
                txFeeIncomeDay.setPayDay(mdate);
                txFeeIncomeDay.setSignupPreferential(Long.valueOf(0L));
                txFeeIncomeDay.setSignupIncome(orgSignupInfo.getTotalPrices());
            } else {
                txFeeIncomeDay.setSignupIncome(Long.valueOf(txFeeIncomeDay.getSignupIncome() + orgSignupInfo.getTotalPrices()));
                txFeeIncomeDay.setSignupPreferential(txFeeIncomeDay.getSignupPreferential());
            }
            txFeeIncomeDay.setSignupAmount(Long.valueOf(txFeeIncomeDay.getSignupIncome() - txFeeIncomeDay.getSignupFee()));
            log.debug("saveFeeIncomeDay={}", (Object)txFeeIncomeDay);
            this.txFeeIncomeDayDao.saveOrUpdate((Object)txFeeIncomeDay, new String[0]);
        }
    }

    private void saveTxFeeStudentDay(OrgSignupInfo orgSignupInfo) {
        String mdate = DateUtil.getStrByDate((Date)orgSignupInfo.getUpdateTime());
        if (orgSignupInfo.getOrderType().intValue() == TransferClassOrder.NORMAL_ORDER.getCode() && CollectionUtils.isNotEmpty((Collection)orgSignupInfo.getOrgSignupCourses())) {
            for (OrgSignupCourse orgSignupCourse : orgSignupInfo.getOrgSignupCourses()) {
                TxFeeStudentDay txFeeStudentDay = this.txFeeStudentDayDao.getStudentByDay(orgSignupInfo.getOrgId(), orgSignupCourse.getUserId(), mdate, new String[0]);
                if (txFeeStudentDay == null) {
                    txFeeStudentDay = new TxFeeStudentDay();
                    txFeeStudentDay.setOrgId(orgSignupInfo.getOrgId());
                    txFeeStudentDay.setUserId(orgSignupCourse.getUserId());
                    txFeeStudentDay.setCreateDay(mdate);
                    txFeeStudentDay.setStudentCounts(Integer.valueOf(1));
                    txFeeStudentDay.setStudentimes(Integer.valueOf(1));
                } else {
                    txFeeStudentDay.setStudentimes(Integer.valueOf(txFeeStudentDay.getStudentimes() + 1));
                    txFeeStudentDay.setStudentCounts(Integer.valueOf(txFeeStudentDay.getStudentCounts() == -1 ? 0 : 1));
                }
                log.debug("txFeeIncomeDayDao={}", (Object)txFeeStudentDay);
                this.txFeeStudentDayDao.saveOrUpdate((Object)txFeeStudentDay, new String[0]);
            }
        }
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }
}

