/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.fee.service.impl;

import com.baijia.tianxiao.biz.fee.contants.RankType;
import com.baijia.tianxiao.biz.fee.dto.request.IncomeDetailRequest;
import com.baijia.tianxiao.biz.fee.dto.request.IncomeRankRequest;
import com.baijia.tianxiao.biz.fee.dto.request.IncomeSummaryRequest;
import com.baijia.tianxiao.biz.fee.dto.response.IncomeDetailDto;
import com.baijia.tianxiao.biz.fee.dto.response.IncomeRankDto;
import com.baijia.tianxiao.biz.fee.dto.response.IncomeSummaryDto;
import com.baijia.tianxiao.biz.fee.service.ReportIncomeService;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.fee.dao.TxFeeIncomeDayDao;
import com.baijia.tianxiao.dal.fee.po.TxFeeIncomeDay;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.dal.signup.po.PurchaseDetailDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.constants.SignupRefundType;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.NumberUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportIncomeServiceImpl
implements ReportIncomeService {
    private static final Logger log = LoggerFactory.getLogger(ReportIncomeServiceImpl.class);
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private TxFeeIncomeDayDao txFeeIncomeDayDao;
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private CoursePurchaseDao coursePurchaseDao;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;
    @Autowired
    private OrgSignupRefundDao orgSignupRefundDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;

    @Override
    public List<IncomeRankDto> rankList(IncomeRankRequest rankRequest, PageDto pageDto) {
        List allOrgIds = this.orgSubAccountService.getAllOrgId(rankRequest.getOrgId());
        boolean isMasterAccount = this.orgSubAccountService.isMasterAccount(rankRequest.getOrgId());
        if (pageDto != null) {
            if (rankRequest.getRankType() != null && rankRequest.getRankType().intValue() == RankType.COURSETYPE.getType()) {
                pageDto.setCount(Integer.valueOf(this.txFeeIncomeDayDao.countTopIncomeByGroup(isMasterAccount ? null : rankRequest.getOrgId(), allOrgIds, rankRequest.getCourseTypeNames(), rankRequest.getStartTime(), rankRequest.getEndTime())));
            } else {
                pageDto.setCount(Integer.valueOf(this.txFeeIncomeDayDao.countTopIncomeByOrg(allOrgIds, null, null, rankRequest.getStartTime(), rankRequest.getEndTime())));
            }
        }
        List txFeeIncomeDays = Lists.newArrayList();
        txFeeIncomeDays = rankRequest.getRankType() != null && rankRequest.getRankType().intValue() == RankType.COURSETYPE.getType() ? this.txFeeIncomeDayDao.listTopIncomeByGroup(isMasterAccount ? null : rankRequest.getOrgId(), allOrgIds, rankRequest.getCourseTypeNames(), rankRequest.getStartTime(), rankRequest.getEndTime(), rankRequest.getIsTopRank(), null, null, pageDto) : this.txFeeIncomeDayDao.listTopIncomeByOrg(allOrgIds, null, null, rankRequest.getStartTime(), rankRequest.getEndTime(), rankRequest.getIsTopRank(), null, null, pageDto);
        log.info("rankList={},{},{}", new Object[]{rankRequest, txFeeIncomeDays, pageDto});
        ArrayList result = Lists.newArrayList();
        int index = 0;
        int currentAccountIndex = 0;
        for (TxFeeIncomeDay txFeeIncomeDay : txFeeIncomeDays) {
            IncomeRankDto incomeRankingDto = new IncomeRankDto();
            incomeRankingDto.setId(txFeeIncomeDay.getId());
            if (rankRequest.getRankType().intValue() == RankType.CAMPUS.getType()) {
                incomeRankingDto.setName(txFeeIncomeDay.getOrgName());
            } else {
                incomeRankingDto.setName(txFeeIncomeDay.getCourseGroupName());
            }
            incomeRankingDto.setAmount(txFeeIncomeDay.getSignupAmount());
            if (rankRequest.getOrgId().longValue() == txFeeIncomeDay.getOrgId().longValue()) {
                currentAccountIndex = index;
            }
            incomeRankingDto.setIndex(++index);
            result.add(incomeRankingDto);
        }
        if (!isMasterAccount) {
            for (int i = 0; i < result.size(); ++i) {
                if (i == currentAccountIndex - 1 || i == currentAccountIndex || i == currentAccountIndex + 1) continue;
                ((IncomeRankDto)((Object)result.get(i))).setAmount(-1L);
            }
        }
        return result;
    }

    @Override
    public List<IncomeSummaryDto> summaryList(IncomeSummaryRequest summaryRequest, PageDto pageDto) {
        List allOrgIds = this.orgSubAccountService.getAllOrgId(summaryRequest.getOrgId());
        boolean isMasterAccount = this.orgSubAccountService.isMasterAccount(summaryRequest.getOrgId());
        if (pageDto != null) {
            if (summaryRequest.getRankType() != null && summaryRequest.getRankType().intValue() == RankType.COURSETYPE.getType()) {
                pageDto.setCount(Integer.valueOf(this.txFeeIncomeDayDao.countTopIncomeByGroup(isMasterAccount ? null : summaryRequest.getOrgId(), allOrgIds, summaryRequest.getCourseTypeNames(), summaryRequest.getStartTime(), summaryRequest.getEndTime())));
            } else {
                pageDto.setCount(Integer.valueOf(this.txFeeIncomeDayDao.countTopIncomeByOrg(allOrgIds, summaryRequest.getOrgIds(), summaryRequest.getCourseTypeNames(), summaryRequest.getStartTime(), summaryRequest.getEndTime())));
            }
        }
        List txFeeIncomeDays = Lists.newArrayList();
        List selectFeeIncomeDays = Lists.newArrayList();
        if (summaryRequest.getRankType() != null && summaryRequest.getRankType().intValue() == RankType.COURSETYPE.getType()) {
            txFeeIncomeDays = this.txFeeIncomeDayDao.listTopIncomeByGroup(isMasterAccount ? null : summaryRequest.getOrgId(), allOrgIds, summaryRequest.getCourseTypeNames(), summaryRequest.getStartTime(), summaryRequest.getEndTime(), null, summaryRequest.getOrderKey(), summaryRequest.getOrderType(), pageDto);
        } else {
            txFeeIncomeDays = this.txFeeIncomeDayDao.listTopIncomeByOrg(allOrgIds, summaryRequest.getOrgIds(), null, summaryRequest.getStartTime(), summaryRequest.getEndTime(), null, summaryRequest.getOrderKey(), summaryRequest.getOrderType(), pageDto);
            if (CollectionUtils.isNotEmpty(summaryRequest.getCourseTypeNames())) {
                selectFeeIncomeDays = this.txFeeIncomeDayDao.listTopIncomeByOrg(allOrgIds, summaryRequest.getOrgIds(), summaryRequest.getCourseTypeNames(), summaryRequest.getStartTime(), summaryRequest.getEndTime(), null, summaryRequest.getOrderKey(), summaryRequest.getOrderType(), pageDto);
            }
        }
        Map<Long, TxFeeIncomeDay> selectFeeIncomeDayMap = selectFeeIncomeDays.stream().collect(Collectors.toMap(o -> o.getOrgId(), o -> o, (u, u2) -> u2));
        log.debug("summaryList={},{},{}", new Object[]{summaryRequest, txFeeIncomeDays, pageDto});
        ArrayList result = Lists.newArrayList();
        int index = 0;
        int currentAccountIndex = 0;
        for (TxFeeIncomeDay txFeeIncomeDay : txFeeIncomeDays) {
            IncomeSummaryDto incomeSummaryDto = new IncomeSummaryDto();
            incomeSummaryDto.setId(txFeeIncomeDay.getId());
            if (summaryRequest.getRankType().intValue() == RankType.CAMPUS.getType()) {
                incomeSummaryDto.setName(txFeeIncomeDay.getOrgName());
            } else {
                incomeSummaryDto.setName(txFeeIncomeDay.getCourseGroupName());
            }
            incomeSummaryDto.setIncomeAmount(txFeeIncomeDay.getSignupAmount());
            incomeSummaryDto.setSelectedAmount(txFeeIncomeDay.getSignupAmount());
            incomeSummaryDto.setSelectAmountrate(100.0);
            incomeSummaryDto.setRefundAmount(txFeeIncomeDay.getSignupRefund());
            incomeSummaryDto.setDiscountAmount(txFeeIncomeDay.getSignupPreferential());
            if (pageDto != null) {
                incomeSummaryDto.setIndex((pageDto.getPageNum() - 1) * pageDto.getPageSize() + ++index);
            } else {
                incomeSummaryDto.setIndex(++index);
            }
            if (summaryRequest.getOrgId().longValue() == txFeeIncomeDay.getOrgId().longValue()) {
                currentAccountIndex = incomeSummaryDto.getIndex();
            }
            TxFeeIncomeDay selectFeeIncomeDay = null;
            if (CollectionUtils.isNotEmpty(summaryRequest.getCourseTypeNames()) && (selectFeeIncomeDay = selectFeeIncomeDayMap.get(txFeeIncomeDay.getOrgId())) != null) {
                incomeSummaryDto.setSelectedAmount(selectFeeIncomeDay.getSignupAmount());
                if (incomeSummaryDto.getIncomeAmount() == 0L) {
                    incomeSummaryDto.setSelectAmountrate(100.0);
                } else {
                    incomeSummaryDto.setSelectAmountrate(NumberUtil.get2Double((double)((double)incomeSummaryDto.getSelectedAmount() * 100.0 / (double)incomeSummaryDto.getIncomeAmount())));
                }
            }
            result.add(incomeSummaryDto);
        }
        log.debug("summaryList ismaster={},{}", (Object)isMasterAccount, (Object)result);
        if (!isMasterAccount && summaryRequest.getRankType().intValue() == RankType.CAMPUS.getType()) {
            for (int i = 0; i < result.size(); ++i) {
                if (((IncomeSummaryDto)((Object)result.get(i))).getIndex() == currentAccountIndex - 1 || ((IncomeSummaryDto)((Object)result.get(i))).getIndex() == currentAccountIndex || ((IncomeSummaryDto)((Object)result.get(i))).getIndex() == currentAccountIndex + 1) continue;
                ((IncomeSummaryDto)((Object)result.get(i))).setIncomeAmount(-1L);
                ((IncomeSummaryDto)((Object)result.get(i))).setDiscountAmount(-1L);
                ((IncomeSummaryDto)((Object)result.get(i))).setRefundAmount(-1L);
                ((IncomeSummaryDto)((Object)result.get(i))).setSelectedAmount(-1L);
                ((IncomeSummaryDto)((Object)result.get(i))).setSelectAmountrate(-1.0);
            }
        }
        return result;
    }

    @Override
    public List<IncomeDetailDto> detailList(IncomeDetailRequest incomeDetailRequest, PageDto pageDto) {
        List allOrgIds = null;
        boolean isMasterAccount = this.orgSubAccountService.isMasterAccount(incomeDetailRequest.getOrgId());
        allOrgIds = !isMasterAccount ? Lists.newArrayList((Object[])new Long[]{incomeDetailRequest.getOrgId()}) : this.orgSubAccountService.getAllOrgId(incomeDetailRequest.getOrgId());
        List orgCourseIds = null;
        if (CollectionUtils.isNotEmpty(incomeDetailRequest.getCourseTypeNames())) {
            orgCourseIds = this.orgCourseGroupRelateDao.getCourseIdByGroupName(allOrgIds, incomeDetailRequest.getCourseTypeNames());
        }
        if (pageDto != null) {
            if (incomeDetailRequest.getPurchaseType().intValue() == TransferClassOrder.RECHARGE_ORDER.getCode()) {
                pageDto.setCount(Integer.valueOf(this.orgSignupInfoDao.countRechargeIncome(allOrgIds, incomeDetailRequest.getOrgIds(), incomeDetailRequest.getPurchaseType(), orgCourseIds, incomeDetailRequest.getStartTime(), incomeDetailRequest.getEndTime())));
            } else {
                pageDto.setCount(Integer.valueOf(this.orgSignupInfoDao.countIncome(allOrgIds, incomeDetailRequest.getOrgIds(), incomeDetailRequest.getPurchaseType(), orgCourseIds, incomeDetailRequest.getStartTime(), incomeDetailRequest.getEndTime())));
            }
        }
        Map orgInfoMap = this.orgInfoService.getOrgInfoMap(ListUtil.longListToInt((List)allOrgIds));
        List purchaseDetailDtos = null;
        purchaseDetailDtos = incomeDetailRequest.getPurchaseType().intValue() == TransferClassOrder.RECHARGE_ORDER.getCode() ? this.orgSignupInfoDao.listRechargeIncome(allOrgIds, incomeDetailRequest.getOrgIds(), incomeDetailRequest.getPurchaseType(), orgCourseIds, incomeDetailRequest.getStartTime(), incomeDetailRequest.getEndTime(), pageDto) : this.orgSignupInfoDao.listIncome(allOrgIds, incomeDetailRequest.getOrgIds(), incomeDetailRequest.getPurchaseType(), orgCourseIds, incomeDetailRequest.getStartTime(), incomeDetailRequest.getEndTime(), pageDto);
        if (CollectionUtils.isEmpty((Collection)purchaseDetailDtos)) {
            return Collections.EMPTY_LIST;
        }
        Map longOrgCourseMap = this.orgCourseDao.getOrgCourseMap((Collection)purchaseDetailDtos.stream().map(tempPurchase -> tempPurchase.getOrgCourseId()).collect(Collectors.toList()), new String[0]);
        Map allCourseGroupMap = this.orgCourseGroupRelateDao.getCourseGroupName(allOrgIds);
        ArrayList result = Lists.newArrayList();
        for (PurchaseDetailDto dto : purchaseDetailDtos) {
            List orgSignupRefunds;
            OrgCourse tempOrgCourse;
            CoursePurchase coursePurchase;
            IncomeDetailDto one = new IncomeDetailDto();
            one.setId(dto.getId());
            one.setSerialNumber(dto.getSignupPurchaseId() + "");
            if (orgInfoMap.get(dto.getOrgId().intValue()) != null) {
                one.setSchoolName(((OrgInfo)orgInfoMap.get(dto.getOrgId().intValue())).getShortName());
            }
            one.setNormalAmount(dto.getStandarPayPrice());
            one.setDiscountAmount(dto.getPreferential());
            if (one.getDiscountAmount() > 0L) {
                if (dto.getRealDiscount() != -1) {
                    one.setDiscountTypeStr("\u6298\u6263");
                } else {
                    one.setDiscountTypeStr("\u76f4\u51cf");
                }
            } else {
                one.setDiscountTypeStr("/");
            }
            one.setStudentMobile(dto.getStudentMobile());
            one.setStudentName(dto.getStudentName());
            one.setTransferAmount(dto.getTransferPurchaseMoney());
            if (dto.getTransferClassOrder().intValue() == TransferClassOrder.RECHARGE_ORDER.getCode()) {
                one.setRealAmount(dto.getTotalPrices());
                one.setBalanceAmount(dto.getAllStudentPayPrice());
            } else {
                one.setRealAmount(dto.getPayPrice());
                one.setBalanceAmount(dto.getStudentPayPrice());
            }
            if (!PayType.isNoFeePay((int)dto.getPayType()) && (coursePurchase = this.coursePurchaseDao.getByPurcahseIdCourse(dto.getSignupPurchaseId(), Long.valueOf(dto.getOrgCourseId()))) != null) {
                one.setFee(NumberUtil.doubleToLong((Double)coursePurchase.getPoundage()));
            }
            one.setRealCashAmount(one.getRealAmount() - one.getFee());
            one.setTransferRefundAmount(dto.getTransferRefundMoney());
            one.setSignupTypeStr(TransferClassOrder.getNameByCode((int)dto.getTransferClassOrder()));
            one.setChargeTime(dto.getPayTime());
            Map cascadeMap = this.txCascadeCredentialService.getByTxCasCadeIdWithDelete(dto.getOrgId());
            String cascadeIdStr = (String)cascadeMap.get(dto.getCascadeId() == null ? 0L : dto.getCascadeId().longValue());
            one.setChargeTypeStr(dto.getTotalPrices() > 0L ? PayType.getByCode((int)dto.getPayType()) : "/");
            one.setChargeUsername(cascadeIdStr == null ? "" : cascadeIdStr);
            one.setSignupTime(dto.getUpdateTime());
            if (dto.getTransferClassOrder().intValue() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
                one.setTransferRefundTime(dto.getUpdateTime());
                one.setTransferUsername(one.getChargeUsername());
            }
            if ((tempOrgCourse = (OrgCourse)longOrgCourseMap.get((long)dto.getOrgCourseId())) != null) {
                one.setClassName(tempOrgCourse.getName());
                one.setCourseStartTime(tempOrgCourse.getBeginTime());
                one.setCourseEndTime(tempOrgCourse.getEndTime());
            }
            if (SignupCourseStatus.statusInQuitCourse((int)dto.getStatus()) && CollectionUtils.isNotEmpty((Collection)(orgSignupRefunds = this.orgSignupRefundDao.getOrgSignupRefundListByPurchaseId(dto.getOrgId(), dto.getSignupPurchaseId(), dto.getOrgCourseId()))) && ((OrgSignupRefund)orgSignupRefunds.get(0)).getRefundType() == SignupRefundType.BY_ORG_CASH.getCode()) {
                one.setRefundAmount(((OrgSignupRefund)orgSignupRefunds.get(0)).getRefundPrice());
                one.setRefundTime(((OrgSignupRefund)orgSignupRefunds.get(0)).getCreateTime());
                String refundCascadeIdStr = (String)cascadeMap.get(((OrgSignupRefund)orgSignupRefunds.get(0)).getCascadeId() == null ? 0L : ((OrgSignupRefund)orgSignupRefunds.get(0)).getCascadeId().longValue());
                one.setRefundUsername(refundCascadeIdStr == null ? "" : refundCascadeIdStr);
            }
            one.setCourseTypeStr(allCourseGroupMap.get((long)dto.getOrgCourseId()) == null ? "/" : ListUtil.listToString((List)((List)allCourseGroupMap.get((long)dto.getOrgCourseId()))));
            result.add(one);
        }
        return result;
    }
}

