
package com.baijia.tianxiao.biz.erp.service.impl;

import java.util.*;

import javax.annotation.Resource;

import com.baijia.tianxiao.enums.StudentCourseStatus;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.biz.erp.service.ErpStudentService;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseStudentOpDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dto.PersonBaseDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.course.util.StudentNameUtil;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.push.dto.ConsultAvatarUrlAndNameDto;
import com.baijia.tianxiao.sal.push.service.ConsultAvatarUrlService;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.request.StudentListRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoListReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoReponseDto;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
public class ErpStudentServiceImpl implements ErpStudentService {

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;

    @Resource
    private SignupService signupService;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgCourseStudentOpDao orgCourseStudentStatusDao;

    @Resource
    private OrgCourseService orgCourseService;

    @Resource
    private CourseStudentService courseStudentService;

    @Resource
    private OrgStudentService orgStudentService;

    @Resource
    private OrgLessonSignService orgLessonSignService;

    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    
    @Resource
    private StudentDao studentDao;
    
    @Resource
    private StorageDao storageDao;
    
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    
    @Resource
    private OrgAccountDao orgAccountDao;
    
    @Resource
    private ConsultAvatarUrlService consultAvatarUrlService;
    
    @Resource
    private TxCascadeCredentialService txCascadeCredentialService;
    
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;

    @Override
    public StudentInfoListReponseDto getStudentListWithAttendanceRate(StudentListRequestDto studentListRequestDto,
        Long orgId, PageDto pageDto) {
        boolean needFilter = false;
        List<Long> tempcourseIds = null;
        List<Long> tempstudentIds = null;
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
            if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                tempcourseIds = orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(),null,CourseTypeEnum.IS_CLASS_TRUE.getCode(),null);
                tempstudentIds = orgStudentService.getStudentidsByCourseIds(orgId, tempcourseIds);
                if (CollectionUtils.isEmpty(tempstudentIds)) {
                    return new StudentInfoListReponseDto();
                }
                needFilter = true;
            }
        }
        log.debug("tempcourseIds={}", tempcourseIds);
        log.debug("tempstudentIds={}", tempstudentIds);

        StudentInfoListReponseDto studentInfoListReponseDto = null;
        if (needFilter) {
            studentInfoListReponseDto =
                orgStudentService.getStudentList(studentListRequestDto, tempstudentIds, orgId, pageDto);
        } else {
            studentInfoListReponseDto = orgStudentService.getStudentList(studentListRequestDto, orgId, pageDto);
        }

        log.debug("studentInfoListReponseDto={}", studentInfoListReponseDto);
        List<Long> studentIds = Lists.newArrayList();
        for (StudentInfoReponseDto stu : studentInfoListReponseDto.getList()) {
            studentIds.add(stu.getStudentId());
        }
        Map<Long, Double> map = orgLessonSignService.getAttendanceRateOfStudents(orgId, studentIds);
        log.debug("map={}", map);
        for (StudentInfoReponseDto stu : studentInfoListReponseDto.getList()) {
            Double rate = map.get(stu.getStudentId());
            stu.setAttendanceRate(rate == null ? 0.00 : rate);
        }
        return studentInfoListReponseDto;
    }

    /**
     * 添加学生到课程
     * 
     * @param orgId
     * @param courseId
     * @param studentIds
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addOrgCourseStudent(Long orgId, Long courseId, Collection<Long> studentIds, Collection<Header> headers,
        boolean doSignup) {
        if (CollectionUtils.isEmpty(studentIds)) {
            log.info("studentIds is empty");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生ID为空");
        }

        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId);

        if(orgCourse == null){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "班级不存在");
        }
        if(orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "1对1课程不能添加学生");
        }
        List<OrgStudent> orgStudents = this.orgStudentDao.getStudentByIds(orgId, studentIds);

        for (OrgStudent orgStudent : orgStudents) {

            OrgStudentCourse osc = orgStudentCourseDao.getStudentCourse(orgId, courseId, orgStudent.getUserId());

            if (osc == null) {
                OrgStudentCourse orgStudentCourse = new OrgStudentCourse();
                buildOrgStudentCourse(orgStudentCourse, orgStudent, courseId);
                orgStudentCourse.setStatus(0);
                this.orgStudentCourseDao.save(orgStudentCourse);
                if (doSignup) {
                    signUp(orgId, orgCourse, orgStudent.getId());
                }
            } else {
                osc.setStatus(0);
                this.orgStudentCourseDao.update(osc, "status");
                if (doSignup) {
                    signUp(orgId, orgCourse, orgStudent.getId());
                }
            }
        }
    }

    /**
     * 添加到课程的学生报名
     * 
     * @param orgId
     * @param orgCourse
     * @param studentId
     */
    private void signUp(Long orgId, OrgCourse orgCourse, Long studentId) {
        List<SignupCourseInfoDto> courseInfos = Lists.newArrayList();
        FillCourseInfoRequestDto signUpDto = new FillCourseInfoRequestDto();
        SignupCourseInfoDto courseInfo = new SignupCourseInfoDto();
        courseInfo.setCount(1);
        courseInfo.setDiscount(100);
        courseInfo.setOrgCourseName(orgCourse.getName());
        courseInfo.setOrgCourseId(orgCourse.getId());
        courseInfo.setOrgCourseNumber(orgCourse.getNumber());
        courseInfo.setOriginPrice(orgCourse.getPrice());
        courseInfo.setPayPrice(orgCourse.getPrice());
        courseInfo.setPreferential(0);
        courseInfos.add(courseInfo);
        signUpDto.setCourseInfos(courseInfos);
        signUpDto.setOrgId(orgId);
        signUpDto.setSignupType(SignupType.FRONTED.getCode());
        OrgStudent student = this.orgStudentDao.getById(studentId);
        if (student != null && student.getDelStatus() == DeleteStatus.NORMAL.getValue()) {
            signUpDto.setStudentMobile(student.getMobile());
            signUpDto.setStudentName(StudentNameUtil.buildStudentName(student));
            log.debug("signUpDto = {}", signUpDto);
            signupService.signUp(signUpDto);
        } else {
            log.warn("student = null, orgId = {}, studentId = {}", orgId, studentId);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "studentId = " + studentId + " not found!");
        }
    }

    private void buildOrgStudentCourse(OrgStudentCourse orgStudentCourse, OrgStudent ttsStudent,
        @NonNull Long courseId) {
        orgStudentCourse.setCourseId(courseId);
        orgStudentCourse.setOrgId(ttsStudent.getOrgId());
        orgStudentCourse.setUserId(ttsStudent.getUserId());
        orgStudentCourse.setStudentMobile(MaskUtil.maskMobile(ttsStudent.getMobile()));
        if (StringUtils.isEmpty(ttsStudent.getName())) {
            orgStudentCourse.setStudentName(StringUtils.EMPTY);
        } else {
            orgStudentCourse.setStudentName(ttsStudent.getName());
        }
        orgStudentCourse.setDelStatus(DeleteStatus.NORMAL.getValue());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void transferOrgCourseStudent(@NonNull Long orgId, @NonNull Long studentId, @NonNull Long fromCourseId,
        @NonNull Long toCourseId, String cause, @NonNull Collection<Header> headers) {

        // 从班级退出
        courseStudentService.transferOrgCourseStudent(orgId, studentId, fromCourseId, toCourseId, cause);
        // 转入到班级
        List<Long> studentIds = Lists.newArrayList();
        studentIds.add(studentId);
        // 被转入学生不添加报名
        addOrgCourseStudent(orgId, toCourseId, studentIds, headers, false);
    }
    
    @Override
    @Transactional(readOnly = true)
    public List<PersonBaseDto> searchOrgStudents(Long orgId, String param, PageDto page) throws Exception {
        Preconditions.checkArgument(orgId != null, "orgId can not be null");
        OrgAccount account = this.orgAccountDao.getById(orgId);
        if (account == null) {
            throw new BussinessException(StudentErrorCode.ORG_NOT_EXIST);
        }
        List<OrgStudent> students = this.orgStudentDao.fuzzySearchStudents(orgId, param, page, "id", "userId", "name", "mobile");
        List<PersonBaseDto> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(students)) {
            boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
            Map<Long, OrgStudent> studentMap = BaseUtils.listToMap(students, "userId");
            Map<Long, ConsultAvatarUrlAndNameDto> avatarMap = this.consultAvatarUrlService.batchStudentAvatarUrlAndNameDMap(studentMap.keySet(), orgId);
            for (Long userId : studentMap.keySet()) {
                OrgStudent orgStudent = studentMap.get(userId);
                PersonBaseDto dto = new PersonBaseDto();
                dto.setId(orgStudent.getId());
                dto.setName(orgStudent.getName());
                dto.setPinyinName(HanZiPinYinUtils.getLowerCasePinYin(orgStudent.getName()));
                dto.setAvatarUrl(avatarMap.get(userId).getAvatarUrl());
                if (!isShowMobile) {
                    dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
                } else {
                    dto.setMobile(orgStudent.getMobile());
                }
                list.add(dto);
            }
        }
        return list;
    }

//    @Override
//    public List<CourseStudentInfoDto> getCourseStudentByCourseId(Long orgId, Long courseId, PageDto pageDto) {
//        List<CourseStudentInfoDto> data = Lists.newArrayList();
//        List<OrgStudentCourse> students = this.orgStudentCourseDao.getStudentListByCourseId(orgId, courseId, pageDto);
//        if (CollectionUtils.isNotEmpty(students)) {
//            Set<Long> studentIds = BaseUtils.getPropertiesList(students, "userId");
//            //学生头像缓存
//            Map<Long, String> avatarCache = getAndCacheStudentAvatar(studentIds);
//            Map<Long, Integer> signCache = this.getAndCachedStudentSignInfo(courseId, studentIds);
//            
//            CourseStudentInfoDto item = null;
//            for (OrgStudentCourse student : students) {
//                item = new CourseStudentInfoDto();
//                Long studentId = student.getUserId();
//                //设置学生头像
//                if (avatarCache.containsKey(studentId)) {
//                    item.setHeadImg(avatarCache.get(student.getUserId()));
//                }
//                item.setStudentId(studentId);
//                item.setStudentName(student.getStudentName());
//                
//                //学生在courseId这个课程中已签到次数
//                if (signCache.containsKey(studentId)) {
//                    item.setSignLessons(signCache.get(studentId));
//                }
//                
//                //tod
//                item.setTotalLessons(0);
//                item.setLeftLessons(0);
//                data.add(item);
//            }
//        }
//        return data;
//    }
    
    /**
     * 批量获取学生头像并缓存
     * @param usrIds
     * @return
     */
    private Map<Long, String> getAndCacheStudentAvatar(Collection<Long> usrIds) {
        Map<Long, String> map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(usrIds)) {
            return map;
        }

        List<Student> students = studentDao.getByUserIds(usrIds, "userId", "avatar");
        // log.debug("students = {}", students);
        Map<Long, Integer> userIdStorageIdMap = Maps.newHashMap();// 学生id到头像id的map

        Set<Integer> avatarIds = Sets.newHashSet();
        for (Student student : students) {
            if (student.getAvatar() != null) {
                avatarIds.add(student.getAvatar());
            }
            userIdStorageIdMap.put(student.getUserId(), student.getAvatar());
        }
        // log.debug("userIdStorageIdMap={}", userIdStorageIdMap);
        Map<Long, String> storageIdUrlMap = Maps.newHashMap();// 头像id到url的map
        // log.debug("avatarIds = {}", avatarIds);
        List<Storage> storages = storageDao.getByIds(avatarIds);
        for (Storage storage : storages) {
            storageIdUrlMap.put(storage.getId(),
                    StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn()));
        }
        // log.debug("storageIdUrlMap = {}", storageIdUrlMap);

        for (Student student : students) {
            if (student.getAvatar() != null) {
                // log.debug("{} -> {} -> {}", student.getUserId(), userIdStorageIdMap.get(student.getUserId()),
                // storageIdUrlMap.get(userIdStorageIdMap.get(student.getUserId().longValue())));
                map.put(student.getUserId(),
                        storageIdUrlMap.get(userIdStorageIdMap.get(student.getUserId()).longValue()));
            }
        }
        return map;
    }
    
    /**
     * 批量查询学生在某个课程下签到情况
     * @param courseId 班级ID
     * @param userIds 学生ID集合
     * @return Map<Long, Integer> key=userId, value=在courseId这个课程中已签到的次数
     */
    private Map<Long, Integer> getAndCachedStudentSignInfo(Long courseId, Collection<Long> userIds) {
        Map<Long, Integer> cache = this.orgLessonSignDao.getOrgCourseStudentSignCount(userIds, courseId);
        return cache;
    }
    
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveCourseStudents(Long orgId, Long courseId, Collection<Long> studentIds) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(courseId != null && courseId > 0, "courseId is illegal");
        List<Long> studentUserIds = Lists.newArrayList();
        Map<Long, Long> userIdAndIdMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(studentIds)) {
            //<userId,id>
            userIdAndIdMap = this.orgStudentDao.getStudentUserIdAndIdMap(studentIds);
            studentUserIds.addAll(userIdAndIdMap.keySet());
        }
        // 当前班级的学生,排除已转班/退班的学生
        Set<Long> existStudents = Sets.newHashSet();
        List<OrgStudentCourse> courseStudents = this.orgStudentCourseDao.getStudentListByCourseId(orgId, courseId);
        for (OrgStudentCourse orgStudentCourse : courseStudents) {
            if (orgStudentCourse.getStatus().intValue() == 0) {
                existStudents.add(orgStudentCourse.getUserId());
            }
        }
     // existStudents的学生本身可能已在OrgStudent中删除，需要过滤
        Map<Long, Long> existStudentMap = this.orgStudentDao.getUserIdStudentIdMap(existStudents, orgId, true);
        existStudents = existStudentMap.keySet();
        
        Set<Long> tempStudents = Sets.newHashSet(existStudents);
        Set<Long> toDelStudents = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(studentUserIds)) {
            tempStudents.removeAll(studentUserIds);
        }
        toDelStudents.addAll(tempStudents);
        
        // 已排课的学生
        List<OrgStudentLesson> lessonStudents = this.orgStudentLessonDao.getOrgStudentLessonsByCourseIds(Arrays.asList(courseId));
        Set<Long> arrangeStudents = BaseUtils.getPropertiesList(lessonStudents, "userId");
        for (Long studentId : toDelStudents) {
            if (arrangeStudents.contains(studentId)) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "已排课的学生无法删除");
            }
        }
        
        // 与app端处理保持一致，简单的退班操作，后面根据pm需求优化.20160907.wangsixia
        if (CollectionUtils.isNotEmpty(toDelStudents)) {
            this.orgStudentCourseDao.batchDeleteOrgCourseStudent(orgId, courseId, toDelStudents, StudentCourseStatus.WITHDRAW.getCode());
        }
        
        studentUserIds.removeAll(existStudents);
        if (CollectionUtils.isNotEmpty(studentUserIds)) {
            Set<Long> toAddStudents = Sets.newHashSet();
            for (Long userId : studentUserIds) {
                toAddStudents.add(userIdAndIdMap.get(userId));
            }
            this.addOrgCourseStudent(orgId, courseId, toAddStudents, null, false);
        }
    }
}
