package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.tianxiao.biz.erp.service.ErpSignupService;
import com.baijia.tianxiao.biz.erp.teacherCenter.service.ExcelCourseExportService;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.excel.dto.ExportField;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSignupListDto;
import com.baijia.tianxiao.sal.signup.dto.response.OrgSingupInfoDto;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/6/3
 * Time: 下午4:00
 * To change this template use File | Settings | File Templates.
 */
@Service
@Slf4j
public class ErpSignupServiceImpl implements ErpSignupService {

    @Override
    public void export(HttpServletResponse response, Long orgId, OrgSignupListDto datas, String fileName) {
        Preconditions.checkArgument(datas.getList() != null, "数据不能为空");

        List<OrgSingupInfoDto> list = datas.getList();
        try {
            log.debug("signuplistDto={}", JacksonUtil.obj2Str(list));
        } catch (Exception e) {
            log.debug("" + e);
        }

        SXSSFWorkbook workbook = null;

        try {
            workbook = new SXSSFWorkbook(1000);
            HashMap cellStyleMap = new HashMap();
            List summaryFields = Lists.newArrayList();
            summaryFields.add(new ExportField("姓名", "@", 5120));
            summaryFields.add(new ExportField("手机号", "@", 5120));
            summaryFields.add(new ExportField("订单总价", "@", 5120));
            summaryFields.add(new ExportField("收费项目", "@", 5120));
            summaryFields.add(new ExportField("单价", "@", 5120));
            summaryFields.add(new ExportField("数量", "@", 5120));
            summaryFields.add(new ExportField("优惠金额", "@", 5120));
            summaryFields.add(new ExportField("应收合计", "@", 5120));
            summaryFields.add(new ExportField("实收金额", "@", 5120));
            summaryFields.add(new ExportField("业务日期", "@", 5120));
            summaryFields.add(new ExportField("报名状态", "@", 5120));

            List titles = Lists.newArrayList();
            titles.add("报名记录");

            log.debug("signupload download titile={},size={}", titles, list.size());
            ExcelCourseExportService.createSignupSheet(workbook, "报名记录", titles, cellStyleMap, summaryFields, list);
            ExcelCourseExportService.exportExcel(response, workbook, fileName);
        } catch (Exception var20) {
            log.warn("export catch exception:", var20);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "导出数据处理异常");
        } finally {
            try {
                workbook.close();
            } catch (IOException var19) {
                log.warn("close workbook catch error:", var19);
            }
        }
    }


    public static void main(String[] args) throws IOException {
        String json = FileUtils.readFileToString(new File("/Users/wengshengli/Downloads/response1.json"));
        List dtoList = JacksonUtil.str2List(json, OrgSingupInfoDto.class);
        SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
        HashMap cellStyleMap = new HashMap();
        List summaryFields = Lists.newArrayList();
        summaryFields.add(new ExportField("姓名", "@", 5120));
        summaryFields.add(new ExportField("手机号", "@", 5120));
        summaryFields.add(new ExportField("总价", "@", 5120));
        summaryFields.add(new ExportField("收费项目", "@", 5120));
        summaryFields.add(new ExportField("应收金额", "@", 5120));
        summaryFields.add(new ExportField("实收金额", "@", 5120));
        summaryFields.add(new ExportField("业务日期", "@", 5120));
        List titles = Lists.newArrayList();
        titles.add("报名记录");
        System.out.println(dtoList.size());
        ExcelCourseExportService.createSignupSheet(workbook, "报名记录", titles, cellStyleMap, summaryFields, dtoList);
        File excelFile = new File("/Users/wengshengli/Documents/test1.xlsx");
        workbook.write(new FileOutputStream(excelFile));
    }
}
