/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.response.AppCourseListInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.ClassListInfoDtoForVip;
import com.baijia.tianxiao.biz.erp.dto.response.CourseListInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.WeiKeListInfoDto;
import com.baijia.tianxiao.biz.erp.service.ErpCourseListService;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao.OrgCourseListParam;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dto.FieldShow;
import com.baijia.tianxiao.dto.query.QueryCondition;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.course.dto.request.CourseListRequestDto;
import com.baijia.tianxiao.sal.course.dto.request.WeikeRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseConsumeRuleService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.HanZiPinYinUtils;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @author bjhl
 * @version 1.0
 * @title ErpCourseListServiceImpl
 * @desc TODO
 * @date 2015年12月25日
 */
@Slf4j
@Service
public class ErpCourseListServiceImpl implements ErpCourseListService {

    @Resource
    private OrgAccountDao orgAccountDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;

    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;

    @Resource
    private OrgCourseListService orgCourseListService;

    @Resource
    private OrgLessonSignService orgLessonSignService;

    @Resource
    private CourseTeacherService courseTeacherService;

    @Resource
    private OrgCourseConsumeRuleService orgCourseConsumeRuleService;

    @Resource
    private CourseStudentService courseStudentService;

    @Resource
    private TxCascadeCredentialService txCascadeCredentialService;
    
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), "number");
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? number.longValue() : null;
    }

    private Map<Long, List<String>> getTeachersOfCourses(Long orgId, Collection<Long> courseIds) {
        log.info("orgId={},courseIds={}", orgId, courseIds);
        Map<Long, List<String>> resultMap = Maps.newHashMap();
        Map<Long, List<Long>> courseTeachersMap = orgCourseTeacherDao.getTeacherMap(courseIds);
        Set<Long> teacherIdsSet = Sets.newHashSet();
        for (Long key : courseTeachersMap.keySet()) {
            teacherIdsSet.addAll(courseTeachersMap.get(key));
        }

        List<TeacherResponseDto> teacherDtoList = this.courseTeacherService.getTeachers(teacherIdsSet, orgId);
        Map<Long, String> teacherMap =
            CollectorUtil.collectMap(teacherDtoList, new Function<TeacherResponseDto, Long>() {
                @Override
                public Long apply(TeacherResponseDto from) {
                    return from.getTeacherId();
                }
            }, new Function<TeacherResponseDto, String>() {
                @Override
                public String apply(TeacherResponseDto from) {
                    return from.getTeacherName();
                }
            });

        for (Long courseId : courseIds) {
            List<Long> teacherIds = courseTeachersMap.get(courseId);
            List<String> teacherList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(teacherIds)) {
                for (Long tid : teacherIds) {
                    teacherList.add(teacherMap.get(tid));
                }
                resultMap.put(courseId, teacherList);
            }
        }

        log.debug("resultMap={}", resultMap);
        return resultMap;
    }

    @Override
    public List<WeiKeListInfoDto> getWeikeList(Long orgId, WeikeRequestDto requestDto) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "illegal orgId");
        long l = System.currentTimeMillis();
        List<CourseListReponseDto> dtos = this.orgCourseListService.getWeikeList(orgId, requestDto);
        log.debug("************getWeikeList cost={}",System.currentTimeMillis()-l);
        if (CollectionUtils.isEmpty(dtos)) {
            return Collections.emptyList();
        }

        Collection<Long> courseIds = CollectorUtil.collect(dtos, new Function<CourseListReponseDto, Long>() {

            @Override
            public Long apply(CourseListReponseDto input) {
                return input.getOrgCourseId();
            }
        });

        Map<Long, Integer> stuCntMap = queryStuCntMap(orgId,dtos);

        log.debug("org_id={},courseIds={},studentCntMap = {}", orgId, courseIds, stuCntMap);
        //Map<Long,Integer> courseConsumeRuleMap = orgCourseConsumeRuleService.queryCourseRuleMapByCourseIds(orgId, courseIds);
        
        List<WeiKeListInfoDto> responseDto = Lists.newArrayList();
        Set<Long> courseId = Sets.newHashSet();
        for (CourseListReponseDto courseListReponseDto : dtos) {
            WeiKeListInfoDto dto = new WeiKeListInfoDto();
            buildWeiKeListInfoDto(courseListReponseDto, dto, stuCntMap);
            courseId.add(courseListReponseDto.getOrgCourseId());
            responseDto.add(dto);
        }

        //查询课消规则
        Map<Long,Integer> rulemap = orgCourseConsumeRuleService.queryCourseRuleMapByCourseIds(orgId,courseId);
        for(WeiKeListInfoDto dto:responseDto){
            dto.setConsumerRule(CourseConsumeRuleEnum.getRuleDescByValue(rulemap.get(dto.getOrgCourseId())));
        }
        return responseDto;
    }
    
    private Map<Long, Integer> queryStuCntMap(Long orgId,List<CourseListReponseDto> dtos){
        
        List<Long> classCourseIds = Lists.newArrayList();
        List<Long> oneoneCourseIds = Lists.newArrayList();
        for(CourseListReponseDto courseDto:dtos){
            Long courseId = courseDto.getOrgCourseId();
            if(courseDto.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()){
                oneoneCourseIds.add(courseId);
            }else{
                classCourseIds.add(courseId);
            }
        }
        Map<Long, Integer> coursestuCntMap  = Maps.newHashMap();
        if(classCourseIds.size()>0){
           
            Map<Long, Integer> classCoursestuCntMap =  this.orgStudentCourseDao.getStudentCountNoStatus(orgId, classCourseIds, null);
            coursestuCntMap.putAll(classCoursestuCntMap);
        }
        if(oneoneCourseIds.size()>0){
            Map<String,Object> countCondition = Maps.newHashMap();
            countCondition.put("parentId", oneoneCourseIds);
        
            Map<Long, Integer> oneoneStuCntMap = orgCourseDao.groupCount(countCondition, "id","parentId",true,Long.class);
        
            coursestuCntMap.putAll(oneoneStuCntMap);
        }
        
        return coursestuCntMap;
    }

    private void buildWeiKeListInfoDto(CourseListReponseDto courseListReponseDto, WeiKeListInfoDto weiKeListInfoDto,
        Map<Long, Integer> stuCntMap) {
        weiKeListInfoDto.setCourseType(courseListReponseDto.getCourseType());
        weiKeListInfoDto.setCourseName(courseListReponseDto.getCourseName());
        weiKeListInfoDto.setCourseUrl(courseListReponseDto.getCourseUrl());
        weiKeListInfoDto.setCoverUrl(courseListReponseDto.getCoverUrl());
        weiKeListInfoDto.setMaxStudent(courseListReponseDto.getMaxStudent());
        weiKeListInfoDto.setOrgCourseId(courseListReponseDto.getOrgCourseId());
        weiKeListInfoDto.setStudentCount(stuCntMap.get(courseListReponseDto.getOrgCourseId()) == null ? 0
            : stuCntMap.get(courseListReponseDto.getOrgCourseId()));
        weiKeListInfoDto.setPrice(courseListReponseDto.getPrice());
        weiKeListInfoDto.setStatus(courseListReponseDto.getStatus());
        weiKeListInfoDto.setCourseCount(courseListReponseDto.getFreq());
        weiKeListInfoDto.setIntroduction(courseListReponseDto.getIntroduction());
        weiKeListInfoDto.setBeginTime(courseListReponseDto.getStartTime());
        weiKeListInfoDto.setEndTime(courseListReponseDto.getEndTime());
        weiKeListInfoDto.setCreateTime(courseListReponseDto.getCreateTime());
        weiKeListInfoDto.setIsCourse(courseListReponseDto.getIsCourse());
        weiKeListInfoDto.setTeacherNames(courseListReponseDto.getTeacherNames());
    }

    @Override
    public <E> List<E> getCourseList(Long orgId, Date startTime, Date endTime, CourseListRequestDto params,PageDto pageDto,Class<E> clazz) {
        
        //这么写让别人怎么传参数
//        if(params !=null && params.getIsClass() ==null){
//            params.setIsClass(CourseTypeEnum.IS_CLASS_TRUE.getCode());
//        }
        Long orgNumber = getOrgNumber(orgId);
        Integer courseType = params.getCourseType();
        String searchKey = params.getSearchKey();
        String teacherIds = params.getTeacherIds();
        String roomIds = params.getRoomIds();
        /**
         * 按教室筛选
         */
        List<Long> roomCourseIds = null;
        Set<Long> roomIdSet = Sets.newHashSet();
        if (StringUtils.isNoneBlank(roomIds)) {
            String[] arr = roomIds.split(",");
            for (String str : arr) {
                roomIdSet.add(Long.parseLong(str));
            }
            roomCourseIds = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(roomIdSet)) {
                roomCourseIds = this.orgCourseRoomDao.getcoursIdsByRoomIds(roomIdSet);
            }
        }

        /**
         * 按老师筛选
         */
        List<Long> teacherCourseIds = null;
        Set<Long> teacherIdSet = Sets.newHashSet();
        if (StringUtils.isNoneBlank(teacherIds)) {
            String[] arr = teacherIds.split(",");
            for (String str : arr) {
                teacherIdSet.add(Long.parseLong(str));
            }
            teacherCourseIds = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(teacherIdSet)) {
                teacherCourseIds = this.orgCourseTeacherDao.getCourseIdsByteacherIds(teacherIdSet);
            }
        }

        List<Long> courseIds = null;
        if (roomCourseIds == null && teacherCourseIds != null) {
            courseIds = new ArrayList<Long>();
            courseIds.addAll(teacherCourseIds);
        }
        if (teacherCourseIds == null && roomCourseIds != null) {
            courseIds = new ArrayList<Long>();
            courseIds.addAll(roomCourseIds);
        }
        if (teacherCourseIds != null && roomCourseIds != null) {
            courseIds = new ArrayList<Long>();
            for (Long tcId : teacherCourseIds) {
                for (Long rcid : roomCourseIds) {
                    if (tcId.longValue() == rcid.longValue()) {
                        courseIds.add(tcId);
                    }
                }
            }
        }

        OrgCourseListParam param = new OrgCourseListParam();
        param.setCourseType(courseType);
        param.setIsCourse(params.getIsCourse());
        param.setIsClass(params.getIsClass());
        param.setKey(searchKey);
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        param.setPage(pageDto);
        param.setStatus(params.getStatus());
        param.setCascadeId(params.getCascadeId());

        Map<String, FieldShow> fieldShowMap = FieldShow.getColumnShowMap(clazz);
        if (StringUtils.isNotBlank(params.getOrderField())) {
            FieldShow fieldShow = fieldShowMap.get(params.getOrderField());
            String orderField = fieldShow != null ? fieldShow.getPoName() : null;
            param.setOrderField(orderField);
            param.setOrderType(params.getOrderType());
        }

        if (StringUtils.isBlank(params.getOrderField())) {
            param.setOrderField("createTime");
            param.setOrderType("DESC");
        }

        param.setQueryCondition(QueryCondition.andCondtions(params.getQueryConditions(), fieldShowMap));
        param.setIsDel(params.getIsDel());
        List<OrgCourse> courses = this.orgCourseDao.getCourseList(orgNumber, courseIds, param);
        List<CourseListReponseDto> dtos =
            this.orgCourseListService.getCourseList(courses, orgId, true, false, true, true, true, true, true);

        log.debug("course List==={}", dtos);

        // 获取课程的老师列表：
        Map<Long, List<String>> courseTeachersMap = null;
        if (params.getLoadTeacherList() != null && params.getLoadTeacherList() == true) {
            courseIds = Lists.newArrayList();
            for (OrgCourse course : courses) {
                courseIds.add(course.getId());
            }
            courseTeachersMap = getTeachersOfCourses(orgId, courseIds);
        }

        Map<Long, String> cascadeMap = txCascadeCredentialService.getByTxCasCadeIds(orgId);
        Set<Long> courseIdSet = Sets.newHashSet();
        List responseDto = Lists.newArrayList();
        for (CourseListReponseDto courseListReponseDto : dtos) {
            CourseListInfoDto dto = new CourseListInfoDto();
            buildCourseListInfoDto(courseListReponseDto, dto);
            if (courseTeachersMap != null) {
                List<String> teachers = courseTeachersMap.get(courseListReponseDto.getOrgCourseId());
                if (CollectionUtils.isNotEmpty(teachers)) {
//                    dto.setTeacherNames(StringUtils.join(teachers, ","));
                	String teacherNames = parseTeacherNamesToString(teachers);
                	dto.setTeacherNames(teacherNames == null ? "" : teacherNames );
                }
            }
            String pinyin= HanZiPinYinUtils.getLowerCasePinYin(courseListReponseDto.getCourseName());
            String str = "#";
            if (StringUtils.isNotBlank(pinyin)) {
                char init = pinyin.charAt(0);
                str = String.valueOf(init);
            }
            if (!com.baijia.tianxiao.util.StringUtils.letterValidate(str)) {
                str = "#";
            }
            dto.setCourseNamePinYin(str.toUpperCase());
            dto.setCascadeIdStr(cascadeMap.get(dto.getCascadeId().longValue()));
            courseIdSet.add(dto.getCourseId());
            responseDto.add(dto);
        }

        log.debug("start find all consume rule, orgId={},courseIds ={}",orgId,courseIdSet);
        //查询课消规则
        Map<Long,Integer> rulemap = orgCourseConsumeRuleService.queryCourseRuleMapByCourseIds(orgId,courseIdSet);
        log.debug("find all consume rule, orgId={},courseIds ={},result={}",orgId,courseIdSet,rulemap);
        for(Object obj:responseDto){
            CourseListInfoDto dto = (CourseListInfoDto)obj;
            dto.setConsumerRule(CourseConsumeRuleEnum.getRuleDescByValue(rulemap.get(dto.getCourseId())));
        }


        if(clazz.equals(CourseListInfoDto.class)){
            return responseDto;
        }else if(clazz.equals(ClassListInfoDtoForVip.class)){
            return transformToVipClass(orgId,responseDto);
        }
        return Lists.newArrayList();

    }

    private String parseTeacherNamesToString(List<String> teachers) {
    	StringBuilder builder = new StringBuilder();
    	for(int i = 0; i < teachers.size(); i++) {
    		if(teachers.get(i) != null && teachers.get(i) != "") {
    			builder.append(teachers.get(i));
    			if(i < teachers.size() -1) {
    				builder.append(",");
        		}
    		}
    	}
    	if(builder.toString().endsWith(",")) {
    		builder.deleteCharAt(builder.length() - 1);
    	}
    	return builder.toString();
    }
    
    private List transformToVipClass(Long orgId,List<CourseListInfoDto> dtoList) {
        List result = Lists.newArrayList();
        for(CourseListInfoDto course:dtoList){
            ClassListInfoDtoForVip classVip = new ClassListInfoDtoForVip();
            try {
                BeanUtils.copyProperties(classVip,course);
                classVip.setClassName(course.getCourseName());//班级名称
                classVip.setBuyLessonCount(course.getFreq()==null?0:course.getFreq());//购买课次
                classVip.setOneLessonPrice(course.getPrice()==null?0:course.getPrice());//课次单价
//                获取报名是的缴费总额
//                Double price = orgStudentCourseDao.getVipClassTotalPrice(orgId,course.getCourseId());
//                classVip.setTotalPrice(0);//缴费总额
                result.add(classVip);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public List<CourseListInfoDto> getCourseListWithAttendanceRate(Long orgId, String searchKey, PageDto pageDto) {
        Long orgNumber = getOrgNumber(orgId);

        List<OrgCourse> courses = null;
        if (TianxiaoMContext.getTXCascadeId() == null) {
            courses = this.orgCourseDao.getCourseList(orgNumber, null, searchKey, null, null, null, null,CourseTypeEnum.IS_CLASS_TRUE.getCode(),null,pageDto);
        }else{
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
            if(txCascadeAccount == null){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "子帐号不存在");
            }
            if(txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()){
                courses = this.orgCourseDao.getCourseList(txCascadeAccount.getId(), orgNumber, null, searchKey, null, null, null,null,CourseTypeEnum.IS_CLASS_TRUE.getCode(),null, pageDto);
            }else{
                courses = this.orgCourseDao.getCourseList(orgNumber, null, searchKey, null, null, null,null,CourseTypeEnum.IS_CLASS_TRUE.getCode(),null, pageDto);
            }
        }
        List<CourseListReponseDto> dtos = getCourseListWithAttendanceRate(courses, orgId);
        List<CourseListInfoDto> responseDto = Lists.newArrayList();
        Map<Long, String> cascadeMap = txCascadeCredentialService.getByTxCasCadeIds(orgId);
        for (CourseListReponseDto courseListReponseDto : dtos) {
            CourseListInfoDto dto = new CourseListInfoDto();
            buildCourseListInfoDto(courseListReponseDto, dto);
            dto.setCascadeIdStr(cascadeMap.get(dto.getCascadeId()));
            responseDto.add(dto);
        }
        return responseDto;
    }

    private List<CourseListReponseDto> getCourseListWithAttendanceRate(List<OrgCourse> courses, Long orgId) {
        log.info("courses={},orgId={}", courses, orgId);
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId not valid!");
        if (CollectionUtils.isEmpty(courses)) {
            return Collections.emptyList();
        }
        
        List<CourseListReponseDto> dtos = Lists.newArrayList();
        
        List<Long> courseIds = Lists.newArrayList();
        for(OrgCourse course:courses){
           
            courseIds.add(course.getId());
        }
        
        Map<Long, Integer> courseLessonMap = this.orgClassLessonDao.getCourseLessonCount(orgId, courseIds, null, null, null);
       
        Map<Long, List<Long>> studentIdMap = null;
        
        studentIdMap = this.orgStudentCourseDao.getStudentIdMapBycourseIdsNoStatus(courseIds, orgId);
       
        Map<Long, Double> rateMap = this.orgLessonSignService.getAttendanceRateOfCourses(orgId, courseIds);
        
        
        for(OrgCourse course:courses){
            Long courseId = course.getId();
            CourseListReponseDto dto = new CourseListReponseDto();
            dtos.add(dto);
            buildCourseListResponseDto(course,dto);
            
            Integer lessonCount = courseLessonMap.get(courseId);
            if(lessonCount == null){
                lessonCount = 0;
            }
            
            dto.setLessonCount(lessonCount);
            
            Integer studentCount = 0;
            List<Long> studentIdList = studentIdMap.get(courseId);
            if(studentIdList!=null){
                studentCount= studentIdList.size();
            }
            
            dto.setStudentCount(studentCount);
            
            Double attendanceRate = rateMap.get(courseId);
            if (attendanceRate != null) {
                dto.setAttendanceRate(attendanceRate);
            } else {
                dto.setAttendanceRate(0.00);
            }
        }
        return dtos;
    }
    
    /**
     * 构造返回数据
     *
     * @param po
     * @param dto
     */
    private void buildCourseListResponseDto(OrgCourse po, CourseListReponseDto dto) {
        dto.setOrgCourseId(po.getId());
        dto.setOrgCourseNumber(po.getNumber());
        dto.setColor(po.getColor());
        dto.setCourseName(po.getName());
        dto.setMaxStudent(po.getMaxStudent());
        dto.setFreq(po.getFreq());
        dto.setStartTime(po.getBeginTime());
        dto.setEndTime(po.getEndTime());
        dto.setPrice(po.getPrice());
        dto.setStatus(po.getStatus());
        String intro = BaseUtils.blobToString(po.getIntroduction(), "UTF-8");
        dto.setIntroduction(intro);
        dto.setIsCourse(po.getIsCourse());
        dto.setIsClass(po.getIsClass());
        dto.setCourseType(po.getCourseType());
        dto.setIsFinish(po.getIsFinish());
    }

    private void buildCourseListInfoDto(CourseListReponseDto courseListReponseDto, CourseListInfoDto dto) {
        dto.setColor(courseListReponseDto.getColor());
        dto.setCourseName(courseListReponseDto.getCourseName());
        dto.setCourseUrl(courseListReponseDto.getCourseUrl());
        dto.setCoverUrl(courseListReponseDto.getCoverUrl());
        dto.setEndTime(courseListReponseDto.getEndTime());
        dto.setFreq(courseListReponseDto.getFreq());
        dto.setLessonCount(courseListReponseDto.getLessonCount());
        dto.setLessonFinish(courseListReponseDto.getLessonFinish());
        dto.setMaxStudent(courseListReponseDto.getMaxStudent());
        dto.setOrgCourseId(courseListReponseDto.getOrgCourseId());
        dto.setOrgCourseNumber(courseListReponseDto.getOrgCourseNumber());
        dto.setRoomCount(courseListReponseDto.getRoomCount());
        dto.setRoomNames(courseListReponseDto.getRoomNames());
        dto.setStudentNames(courseListReponseDto.getStudentNames());
        dto.setTeacherNames(courseListReponseDto.getTeacherNames());
        dto.setStartTime(courseListReponseDto.getStartTime());
        dto.setStudentCount(courseListReponseDto.getStudentCount());
        dto.setTeacherCount(courseListReponseDto.getTeacherCount());
        dto.setAttendanceRate(courseListReponseDto.getAttendanceRate());
        dto.setPrice(courseListReponseDto.getPrice());
        dto.setStatus(courseListReponseDto.getStatus());
        dto.setAddress(courseListReponseDto.getAddress());
        dto.setCreateTime(courseListReponseDto.getCreateTime());
        dto.setCascadeId(courseListReponseDto.getCascadeId());
        dto.setCourseType(courseListReponseDto.getCourseType());
        dto.setIsFinish(courseListReponseDto.getIsFinish());
        
    }

    @Override
    public CourseListInfoDto getCourseDetail(Long orgId, Long orgCourseId) {
        CourseListReponseDto dto = this.orgCourseListService.getCourseDetail(orgId, orgCourseId);
        CourseListInfoDto courseListInfoDto = new CourseListInfoDto();
        buildCourseListInfoDto(dto, courseListInfoDto);
        return courseListInfoDto;
    }

    @Override
    public List<AppCourseListInfoDto> getOnlyCourseList(Long orgId, Date startTime, Date endTime, CourseListRequestDto params,
                                                 PageDto pageDto) {

        Long orgNumber = getOrgNumber(orgId);
        Integer courseType = params.getCourseType();
        String searchKey = params.getSearchKey();

        List<Long> courseIds = null;

        OrgCourseListParam param = new OrgCourseListParam();
        param.setCourseType(courseType);
        param.setIsCourse(params.getIsCourse());
        param.setIsClass(params.getIsClass());
        param.setKey(searchKey);
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        param.setPage(pageDto);
        param.setStatus(params.getStatus());
        param.setCascadeId(params.getCascadeId());

        Map<String, FieldShow> fieldShowMap = FieldShow.getColumnShowMap(CourseListInfoDto.class);
        if (StringUtils.isNotBlank(params.getOrderField())) {
            FieldShow fieldShow = fieldShowMap.get(params.getOrderField());
            String orderField = fieldShow != null ? fieldShow.getPoName() : null;
            param.setOrderField(orderField);
            param.setOrderType(params.getOrderType());
        }

        if (StringUtils.isBlank(params.getOrderField())) {
            param.setOrderField("createTime");
            param.setOrderType("DESC");
        }

        param.setQueryCondition(QueryCondition.andCondtions(params.getQueryConditions(), fieldShowMap));
        param.setIsDel(params.getIsDel());
        List<OrgCourse> courses = this.orgCourseDao.getCourseList(orgNumber, null, param);
        List<CourseListReponseDto> dtos =
                this.orgCourseListService.getCourseList(courses, orgId, false, false, false, false, false, false, false);


        List<AppCourseListInfoDto> responseDto = Lists.newArrayList();
        for (CourseListReponseDto courseListReponseDto : dtos) {
            AppCourseListInfoDto dto = new AppCourseListInfoDto();

            String pinyin= HanZiPinYinUtils.getLowerCasePinYin(courseListReponseDto.getCourseName());
            String str = "#";
            if (StringUtils.isNotBlank(pinyin)) {
                char init = pinyin.charAt(0);
                str = String.valueOf(init);
            }
            if (!com.baijia.tianxiao.util.StringUtils.letterValidate(str)) {
                str = "#";
            }
            dto.setCourseNamePinYin(str.toUpperCase());
            dto.setOrgCourseNumber(courseListReponseDto.getOrgCourseNumber());
            dto.setCourseName(courseListReponseDto.getCourseName());
            dto.setCourseType(courseListReponseDto.getCourseType());
            dto.setOrgCourseId(courseListReponseDto.getOrgCourseId());
            dto.setPrice(courseListReponseDto.getPrice());

            responseDto.add(dto);
        }
        return responseDto;
    }

}
